/*
 * Decompiled with CFR 0.152.
 */
package com.trs.service.impl;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.domain.RoleMgr;
import com.trs.cms.auth.domain.RoleUserIdsMan;
import com.trs.cms.auth.persistent.Role;
import com.trs.cms.auth.persistent.Roles;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.cms.content.CMSObj;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.log.LogServer;
import com.trs.infra.util.CMyString;
import com.trs.service.IRoleService;
import com.trs.service.IUserService;

public class RoleService
implements IRoleService {
    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    public Role save(Role role) throws WCMException {
        if (role == null) {
            throw new WCMException(10, I18NMessage.get(RoleService.class, "RoleService.label1", "\u89d2\u8272\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fdd\u5b58\uff01"));
        }
        User user = this.getLoginUser();
        Role role2 = role;
        IUserService iUserService = (IUserService)DreamFactory.createObjectById("IUserService");
        if (!AuthServer.hasRight(user, (CMSObj)role2, 11) && !iUserService.isManagerOfRole(user)) {
            throw new WCMException(1002, I18NMessage.get(RoleService.class, "RoleService.label2", "\u5bf9\u4e0d\u8d77,\u60a8\u65e0\u6743\u4fdd\u5b58\u89d2\u8272!"));
        }
        String string = I18NMessage.get(RoleService.class, "RoleService.label3", "\u4fdd\u5b58") + "[" + role2 + "]";
        String string2 = "ROLE_EDIT";
        if (role2.isAddMode()) {
            string2 = "ROLE_ADD";
        }
        long l = LogServer.startRecord(user.getName(), string2, string, role2);
        try {
            role2 = this.getRoleMgr().save(role2);
        }
        catch (Throwable throwable) {
            LogServer.endRecordFailedOperation(l, throwable);
            throw new WCMException(1100, I18NMessage.get(RoleService.class, "RoleService.label4", "\u4fdd\u5b58\u89d2\u8272\u5931\u8d25!"), throwable);
        }
        LogServer.endRecordSucceedOperation(l);
        return role2;
    }

    public Users getUsers(Role role, WCMFilter wCMFilter) throws WCMException {
        return this.getRoleMgr().getUsers(role, wCMFilter);
    }

    public boolean delete(int n) throws WCMException {
        if (n <= 0) {
            throw new WCMException(10, I18NMessage.get(RoleService.class, "RoleService.label5", "\u65e0\u6548\u7684\u89d2\u8272Id[") + n + I18NMessage.get(RoleService.class, "RoleService.label6", "],\u65e0\u6cd5\u5b8c\u6210\u5220\u9664!"));
        }
        Role role = Role.findById(n);
        if (role == null) {
            throw new WCMException(200006, I18NMessage.get(RoleService.class, "RoleService.label7", "\u6ca1\u6709\u627e\u5230\u6307\u5b9aid\u7684\u89d2\u8272,\u65e0\u6cd5\u5220\u9664!"));
        }
        return this.delete(role);
    }

    public boolean delete(String string) throws WCMException {
        if (string == null || string.length() == 0) {
            throw new WCMException(10, I18NMessage.get(RoleService.class, "RoleService.label8", "\u65e0\u6548\u7684id\u5e8f\u5217!"));
        }
        Roles roles = Roles.findByIds(this.getLoginUser(), string);
        if (roles.isEmpty()) {
            throw new WCMException(200006, I18NMessage.get(RoleService.class, "RoleService.label9", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u89d2\u8272,\u65e0\u6cd5\u5b8c\u6210\u5220\u9664!"));
        }
        return this.delete(roles);
    }

    public boolean delete(Roles roles) throws WCMException {
        if (roles == null) {
            throw new WCMException(10, I18NMessage.get(RoleService.class, "RoleService.label10", "\u89d2\u8272\u96c6\u5408\u4e3a\u7a7a\uff01"));
        }
        if (roles.isEmpty()) {
            return true;
        }
        for (int i = 0; i < roles.size(); ++i) {
            this.delete((Role)roles.getAt(i));
        }
        return true;
    }

    public boolean delete(Role role) throws WCMException {
        if (!AuthServer.hasRight(this.getLoginUser(), (CMSObj)role, 12)) {
            throw new WCMException(1002, I18NMessage.get(RoleService.class, "RoleService.label11", "\u5bf9\u4e0d\u8d77,\u60a8\u65e0\u6743\u5220\u9664\u89d2\u8272!"));
        }
        String string = I18NMessage.get(RoleService.class, "RoleService.label12", "\u5220\u9664") + "[" + role + "]";
        long l = LogServer.startRecord(this.getLoginUser().getName(), "ROLE_DEL", string, role);
        try {
            this.getRoleMgr().delete(role, true);
        }
        catch (Throwable throwable) {
            LogServer.endRecordFailedOperation(l, throwable);
            throw new WCMException(1100, I18NMessage.get(RoleService.class, "RoleService.label13", "\u5220\u9664\u89d2\u8272\u5931\u8d25!"), throwable);
        }
        LogServer.endRecordSucceedOperation(l);
        return true;
    }

    public User addUser(User user, Role role) throws WCMException {
        User user2 = user;
        String string = CMyString.format(I18NMessage.get(RoleService.class, "RoleService.label21", "\u6dfb\u52a0{0}\u62c5\u4efb\u7684\u89d2\u8272:{1}"), new Object[]{user, role});
        long l = LogServer.startRecord(this.getLoginUser().getName(), "ROLEUSER_ADD", string, role);
        try {
            this.getRoleMgr().addUser(user, role);
        }
        catch (Throwable throwable) {
            LogServer.endRecordFailedOperation(l, throwable);
            throw new WCMException(1100, I18NMessage.get(RoleService.class, "RoleService.label16", "\u6dfb\u52a0\u7528\u6237\u62c5\u4efb\u7684\u89d2\u8272\u5931\u8d25!"), throwable);
        }
        LogServer.endRecordSucceedOperation(l);
        return user2;
    }

    public boolean removeUser(User user, Role role) throws WCMException {
        IUserService iUserService = (IUserService)DreamFactory.createObjectById("IUserService");
        User user2 = this.getLoginUser();
        if (!user2.isAdministrator() && !iUserService.isManagerOfRole(user2)) {
            throw new WCMException(1002, I18NMessage.get(RoleService.class, "RoleService.label17", "\u5bf9\u4e0d\u8d77,\u60a8\u65e0\u6743\u4ece\u89d2\u8272\u4e2d\u5220\u9664\u7528\u6237!"));
        }
        String string = CMyString.format(I18NMessage.get(RoleService.class, "RoleService.label22", "\u53d6\u6d88{0}\u62c5\u4efb\u7684\u89d2\u8272:{1}"), new Object[]{user, role});
        long l = LogServer.startRecord(user2.getName(), "ROLEUSER_DEL", string, user);
        try {
            this.getRoleMgr().removeUser(user, role);
        }
        catch (Throwable throwable) {
            LogServer.endRecordFailedOperation(l, throwable);
            throw new WCMException(1100, I18NMessage.get(RoleService.class, "RoleService.label20", "\u53d6\u6d88\u7528\u6237\u7684\u89d2\u8272\u5931\u8d25!"), throwable);
        }
        LogServer.endRecordSucceedOperation(l);
        return true;
    }

    private RoleMgr getRoleMgr() {
        return (RoleMgr)DreamFactory.createObjectById("RoleMgr");
    }

    public void setRoleUsers(int n, String string) throws WCMException {
        RoleUserIdsMan roleUserIdsMan = new RoleUserIdsMan(n);
        roleUserIdsMan.dowithIds(string);
    }
}

