/*
 * Decompiled with CFR 0.152.
 */
package com.trs.service.impl;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.components.common.calendar.Event;
import com.trs.components.common.calendar.EventMgr;
import com.trs.components.common.calendar.EventShareIdsMan;
import com.trs.components.common.calendar.Events;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyDateTime;
import com.trs.service.IEventService;

public class EventService
implements IEventService {
    EventMgr currMgr = null;

    private EventMgr getEventMgr() throws WCMException {
        if (this.currMgr != null) {
            return this.currMgr;
        }
        this.currMgr = (EventMgr)DreamFactory.createObjectById("EventMgr");
        if (this.currMgr == null) {
            throw new WCMException(10, I18NMessage.get(EventService.class, "EventService.label1", "EventMgr\u5728\u5de5\u5382\u4e2d\u914d\u7f6e\u7684\u4e0d\u6b63\u786e\uff01"));
        }
        return this.currMgr;
    }

    public Events getSharedEvents(User user, CMyDateTime cMyDateTime, boolean bl) throws WCMException {
        if (user.getId() != this.getLoginUser().getId()) {
            throw new WCMException("\u60a8\u53ea\u80fd\u67e5\u770b\u81ea\u5df1\u7684\u65e5\u7a0b\uff01");
        }
        return this.getEventMgr().getEvents(user, cMyDateTime, bl, null);
    }

    public Events getSharedEvents(User user, CMyDateTime cMyDateTime) throws WCMException {
        return this.getSharedEvents(user, cMyDateTime, true);
    }

    public Events getSharedEvents(User user, CMyDateTime cMyDateTime, boolean bl, WCMFilter wCMFilter) throws WCMException {
        return this.getEventMgr().getEvents(user, cMyDateTime, bl, wCMFilter);
    }

    public Groups getSharedGroups(Event event) throws WCMException {
        return this.getEventMgr().getGroups(event);
    }

    public Users getSharedUsers(Event event) throws WCMException {
        return this.getEventMgr().getUsers(event);
    }

    public Event save(Event event) throws WCMException {
        this.validRight(event);
        return this.getEventMgr().save(event);
    }

    public boolean delete(int n) throws WCMException {
        Event event = Event.findById(n);
        if (event == null) {
            return true;
        }
        this.validRight(event);
        return this.delete(event);
    }

    public boolean delete(Event event) throws WCMException {
        if (event == null) {
            throw new WCMException(10, I18NMessage.get(EventService.class, "EventService.label2", "\u65e0\u6548\u7684\u7ad9\u70b9/\u9891\u9053\u5bf9\u8c61"));
        }
        this.validRight(event);
        return this.getEventMgr().delete(event);
    }

    public boolean delete(String string) throws WCMException {
        Events events = Events.findByIds(this.getLoginUser(), string);
        for (int i = 0; i < events.size(); ++i) {
            Event event = (Event)events.getAt(i);
            this.validRight(event);
        }
        return this.delete(events);
    }

    public boolean delete(Events events) throws WCMException {
        if (events == null || events.isEmpty()) {
            return true;
        }
        Event event = null;
        for (int i = 0; i < events.size(); ++i) {
            event = (Event)events.getAt(i);
            this.validRight(event);
            this.delete(event);
        }
        return true;
    }

    public Events getEvents(WCMFilter wCMFilter) throws WCMException {
        return this.getEventMgr().getEvents(wCMFilter);
    }

    public void shareTo(Event event, User user) throws WCMException {
        if (event == null) {
            throw new WCMException(10, I18NMessage.get(EventService.class, "EventService.label3", "\u4f20\u5165Event\u4e3a\u7a7a\uff01"));
        }
        if (user == null) {
            throw new WCMException(10, I18NMessage.get(EventService.class, "EventService.label4", "\u4f20\u5165\u7528\u6237\u4e3a\u7a7a\uff01"));
        }
        this.validRight(event);
        this.shareEventTo(event, "" + user.getId(), user.getWCMType());
    }

    public void shareTo(Event event, Groups groups) throws WCMException {
        if (event == null) {
            throw new WCMException(10, I18NMessage.get(EventService.class, "EventService.label3", "\u4f20\u5165Event\u4e3a\u7a7a\uff01"));
        }
        if (groups == null || groups.isEmpty()) {
            throw new WCMException(10, I18NMessage.get(EventService.class, "EventService.label5", "\u4f20\u5165\u7528\u6237\u96c6\u5408\u4e3a\u7a7a\uff01"));
        }
        this.validRight(event);
        this.shareEventTo(event, groups.getIdListAsString(), 201);
    }

    public void cancelShare(Event event, User user) throws WCMException {
        this.validRight(event);
        this.getEventMgr().cancelShare(event, user);
    }

    public User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    public void shareTo(Event event, Group group) throws WCMException {
        if (event == null) {
            throw new WCMException(10, I18NMessage.get(EventService.class, "EventService.label3", "\u4f20\u5165Event\u4e3a\u7a7a\uff01"));
        }
        if (group == null) {
            throw new WCMException(10, I18NMessage.get(EventService.class, "EventService.label6", "\u4f20\u5165\u7ec4\u7ec7\u4e3a\u7a7a\uff01"));
        }
        this.validRight(event);
        this.shareEventTo(event, "" + group.getId(), group.getWCMType());
    }

    public void shareTo(Event event, Users users) throws WCMException {
        if (event == null) {
            throw new WCMException(10, I18NMessage.get(EventService.class, "EventService.label3", "\u4f20\u5165Event\u4e3a\u7a7a\uff01"));
        }
        if (users == null || users.isEmpty()) {
            throw new WCMException(10, I18NMessage.get(EventService.class, "EventService.label5", "\u4f20\u5165\u7528\u6237\u96c6\u5408\u4e3a\u7a7a\uff01"));
        }
        this.validRight(event);
        this.shareTo(event, users.getIdListAsString());
    }

    public void shareTo(Event event, String string) throws WCMException {
        if (string == null || string.trim().length() <= 0) {
            throw new WCMException(10, I18NMessage.get(EventService.class, "EventService.label7", "\u4f20\u5165\u7528\u6237ID\u5e8f\u5217\u4e3a\u7a7a\uff01"));
        }
        this.validRight(event);
        this.shareEventTo(event, string, 204);
    }

    public void cancelShare(Event event, Users users) throws WCMException {
        if (users == null || users.isEmpty()) {
            return;
        }
        this.validRight(event);
        for (int i = 0; i < users.size(); ++i) {
            this.getEventMgr().cancelShare(event, (User)users.getAt(i));
        }
    }

    public void cancelShare(Event event, Group group) throws WCMException {
        this.validRight(event);
        this.getEventMgr().cancelShare(event, group);
    }

    public void cancelShares(Event event) throws WCMException {
        if (event == null) {
            return;
        }
        this.validRight(event);
        this.getEventMgr().cancelShares(event);
    }

    public void shareEventTo(Event event, String string, int n) throws WCMException {
        this.validRight(event);
        EventShareIdsMan eventShareIdsMan = new EventShareIdsMan(event.getId(), n);
        eventShareIdsMan.dowithIds(string);
    }

    private boolean validRight(Event event) throws WCMException {
        Object object;
        User user = event.getOwner();
        boolean bl = false;
        if (event.isChangeProperty("OWNER")) {
            object = event.getNewPropertyAsString("OWNER");
            user = User.findByName((String)object);
            bl = true;
        }
        object = this.getLoginUser();
        if (user == null || user.getId() != ((BaseObj)object).getId()) {
            throw new WCMException(event.isAddMode() ? "\u60a8\u4e0d\u80fd\u4e3a\u4ed6\u4eba\u521b\u5efa\u65e5\u7a0b\uff01" : (bl ? "\u4e0d\u80fd\u5c06\u81ea\u5df1\u7684\u65e5\u7a0b\u4fee\u6539\u4e3a\u4ed6\u4eba\u7684\uff01" : "\u60a8\u53ea\u80fd\u64cd\u4f5c\u81ea\u5df1\u7684\u65e5\u7a0b\uff01"));
        }
        return true;
    }
}

