/*
 * Decompiled with CFR 0.152.
 */
package com.trs.service.impl;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.address.Contact;
import com.trs.components.common.address.ContactGrp;
import com.trs.components.common.address.ContactGrps;
import com.trs.components.common.address.ContactMgr;
import com.trs.components.common.address.Contacts;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.service.IContactService;

public class ContactService
implements IContactService {
    public Contact addContactFromSystemUser(int n) throws WCMException {
        User user = User.findById(n);
        if (user == null) {
            throw new WCMException(200006, I18NMessage.get(ContactService.class, "ContactService.label1", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u7528\u6237[id=") + n + "]!");
        }
        return this.getContactMgr().addContactFromSystemUser(user);
    }

    public Contact addContactFromSystemUser(User user) throws WCMException {
        return this.getContactMgr().addContactFromSystemUser(user);
    }

    public void addContact(String string, int n) throws WCMException {
        Contacts contacts = Contacts.findByIds(this.getLoginUser(), string);
        ContactGrp contactGrp = this.findContactGroup(n);
        Contact contact = null;
        for (int i = 0; i < contacts.size(); ++i) {
            contact = (Contact)contacts.getAt(i);
            if (contact == null) continue;
            this.addContact(contact, contactGrp);
        }
    }

    public Contact addContact(int n, int n2) throws WCMException {
        Contact contact = this.findContact(n);
        ContactGrp contactGrp = this.findContactGroup(n2);
        return this.getContactMgr().addContact(contact, contactGrp);
    }

    public Contact addContact(Contact contact, ContactGrp contactGrp) throws WCMException {
        return this.getContactMgr().addContact(contact, contactGrp);
    }

    public Contact saveContact(Contact contact) throws WCMException {
        return this.getContactMgr().saveContact(contact);
    }

    public void deleteContacts(String string) throws WCMException {
        Contacts contacts = Contacts.findByIds(this.getLoginUser(), string);
        if (contacts == null || contacts.isEmpty()) {
            return;
        }
        this.deleteContacts(contacts);
    }

    public void deleteContacts(Contacts contacts) throws WCMException {
        if (contacts == null || contacts.isEmpty()) {
            throw new WCMException(10, I18NMessage.get(ContactService.class, "ContactService.label2", "\u65e0\u6548\u7684\u96c6\u5408!"));
        }
        Contact contact = null;
        for (int i = 0; i < contacts.size(); ++i) {
            contact = (Contact)contacts.getAt(i);
            if (contact == null) continue;
            this.deleteContact(contact);
        }
    }

    public void deleteContact(int n) throws WCMException {
        Contact contact = this.findContact(n);
        this.deleteContact(contact);
    }

    public void deleteContact(Contact contact) throws WCMException {
        if (contact == null) {
            throw new WCMException(10, I18NMessage.get(ContactService.class, "ContactService.label3", "\u65e0\u6548\u7684\u8054\u7cfb\u4eba\u5bf9\u8c61[null]!"));
        }
        this.assertNoRight(contact.getCrUserName());
        this.getContactMgr().deleteContact(contact);
    }

    public ContactGrp saveContactGroup(ContactGrp contactGrp) throws WCMException {
        return this.getContactMgr().saveContactGroup(contactGrp);
    }

    public void deleteContactGroups(String string) throws WCMException {
        ContactGrps contactGrps = ContactGrps.findByIds(this.getLoginUser(), string);
        if (contactGrps == null || contactGrps.isEmpty()) {
            return;
        }
        this.deleteContactGroups(contactGrps);
    }

    public void deleteContactGroups(ContactGrps contactGrps) throws WCMException {
        if (contactGrps == null || contactGrps.isEmpty()) {
            throw new WCMException(10, I18NMessage.get(ContactService.class, "ContactService.label2", "\u65e0\u6548\u7684\u96c6\u5408!"));
        }
        ContactGrp contactGrp = null;
        for (int i = 0; i < contactGrps.size(); ++i) {
            contactGrp = (ContactGrp)contactGrps.getAt(i);
            if (contactGrp == null) continue;
            this.deleteContactGroup(contactGrp);
        }
    }

    public void deleteContactGroup(int n) throws WCMException {
        ContactGrp contactGrp = this.findContactGroup(n);
        this.deleteContactGroup(contactGrp);
    }

    public void deleteContactGroup(ContactGrp contactGrp) throws WCMException {
        if (contactGrp == null) {
            throw new WCMException(10, I18NMessage.get(ContactService.class, "ContactService.label3", "\u65e0\u6548\u7684\u8054\u7cfb\u4eba\u5bf9\u8c61[null]!"));
        }
        this.assertNoRight(contactGrp.getCrUserName());
        this.getContactMgr().deleteContactGroup(contactGrp);
    }

    public ContactGrps getGroups(Contact contact) throws WCMException {
        return this.getContactMgr().getGroups(contact);
    }

    public ContactGrps getContactGroups(WCMFilter wCMFilter) throws WCMException {
        return this.getContactMgr().getContactGroups(wCMFilter);
    }

    public Contacts getContacts(WCMFilter wCMFilter, ContactGrp contactGrp) throws WCMException {
        return this.getContactMgr().getContacts(wCMFilter, contactGrp);
    }

    public Contacts getContacts(WCMFilter wCMFilter) throws WCMException {
        return this.getContactMgr().getContacts(wCMFilter);
    }

    public void removeContacts(String string, int n) throws WCMException {
        Contacts contacts = Contacts.findByIds(this.getLoginUser(), string);
        ContactGrp contactGrp = this.findContactGroup(n);
        Contact contact = null;
        for (int i = 0; i < contacts.size(); ++i) {
            contact = (Contact)contacts.getAt(i);
            if (contact == null) continue;
            this.removeContact(contact, contactGrp);
        }
    }

    public void removeContact(int n, int n2) throws WCMException {
        Contact contact = Contact.findById(n);
        ContactGrp contactGrp = ContactGrp.findById(n2);
        this.removeContact(contact, contactGrp);
    }

    public void removeContact(Contact contact, ContactGrp contactGrp) throws WCMException {
        this.assertNoRight(contact.getCrUserName());
        this.getContactMgr().removeContact(contact, contactGrp);
    }

    public void changeGroup(int n, int n2, int n3) throws WCMException {
        Contact contact = this.findContact(n);
        ContactGrp contactGrp = this.findContactGroup(n2);
        ContactGrp contactGrp2 = this.findContactGroup(n3);
        this.changeGroup(contact, contactGrp, contactGrp2);
    }

    public void changeGroup(Contact contact, ContactGrp contactGrp, ContactGrp contactGrp2) throws WCMException {
        this.getContactMgr().changeGroup(contact, contactGrp, contactGrp2);
    }

    private ContactMgr getContactMgr() {
        return (ContactMgr)DreamFactory.createObjectById("ContactMgr");
    }

    private Contact findContact(int n) throws WCMException {
        Contact contact = Contact.findById(n);
        if (contact == null) {
            throw new WCMException(200006, I18NMessage.get(ContactService.class, "ContactService.label4", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u8054\u7cfb\u4eba\u5bf9\u8c61[id=") + n + "]!");
        }
        return contact;
    }

    private ContactGrp findContactGroup(int n) throws WCMException {
        ContactGrp contactGrp = ContactGrp.findById(n);
        if (contactGrp == null) {
            throw new WCMException(200006, I18NMessage.get(ContactService.class, "ContactService.label5", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u8054\u7cfb\u4eba\u5206\u7ec4\u5bf9\u8c61[id=") + n + "]!");
        }
        return contactGrp;
    }

    private void assertNoRight(String string) throws WCMException {
        String string2 = this.getLoginUser().getName();
        if (!string2.equals(string)) {
            throw new WCMException(1002, I18NMessage.get(ContactService.class, "ContactService.label6", "\u5bf9\u4e0d\u8d77,\u60a8\u65e0\u6743\u8fdb\u884c\u8be5\u64cd\u4f5c\t"));
        }
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }
}

