/*
 * Decompiled with CFR 0.152.
 */
package com.trs.presentation.nav;

import com.trs.cms.auth.persistent.User;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.content.persistent.WebSites;
import com.trs.infra.I18NMessage;
import java.util.ArrayList;

public class TreeNodeCalctor {
    private Channels m_srcChannels = null;
    private User m_oLoginUser = null;
    private String m_sChannelIds = null;
    private WebSites m_oSites = null;
    private WebSite m_oRoot = null;
    private int m_nChannelId = 0;
    private TreeNodeCalctor[] m_pNeedExpandTreeNodes = null;
    private int[] m_pNeedExpandTreeNodeIds = null;
    private int m_nNeedExpandTreeNodeCount = 0;
    private int m_nMaxChildCount = 0;

    public TreeNodeCalctor(String string, User user) {
        this.m_oLoginUser = user;
        this.m_sChannelIds = string;
        try {
            this.initRoot();
        }
        catch (Exception exception) {
            throw new RuntimeException(I18NMessage.get(TreeNodeCalctor.class, "TreeNodeCalctor.label1", "\u521d\u59cb\u5316\u5bf9\u8c61\u5931\u8d25\uff01"), exception);
        }
    }

    public TreeNodeCalctor(WebSite webSite, Channels channels) {
        this.m_oRoot = webSite;
        this.m_srcChannels = channels;
        this.m_nMaxChildCount = channels.size();
        this.m_pNeedExpandTreeNodeIds = new int[this.m_nMaxChildCount];
        this.m_pNeedExpandTreeNodes = new TreeNodeCalctor[this.m_nMaxChildCount];
        try {
            this.initSiteChildren();
        }
        catch (Exception exception) {
            throw new RuntimeException(I18NMessage.get(TreeNodeCalctor.class, "TreeNodeCalctor.label2", "\u521d\u59cb\u5316\u7ad9\u70b9\u5b50\u5bf9\u8c61\u5931\u8d25\uff01"), exception);
        }
    }

    public TreeNodeCalctor(int n, int n2) {
        this.m_nChannelId = n;
        this.m_nMaxChildCount = n2;
        this.m_pNeedExpandTreeNodeIds = new int[n2];
        this.m_pNeedExpandTreeNodes = new TreeNodeCalctor[n2];
    }

    private TreeNodeCalctor addNeedExpandNode(int n) {
        for (int i = 0; i < this.m_nNeedExpandTreeNodeCount; ++i) {
            if (this.m_pNeedExpandTreeNodeIds[i] != n) continue;
            return this.m_pNeedExpandTreeNodes[i];
        }
        this.m_pNeedExpandTreeNodeIds[this.m_nNeedExpandTreeNodeCount] = n;
        this.m_pNeedExpandTreeNodes[this.m_nNeedExpandTreeNodeCount] = new TreeNodeCalctor(n, this.m_nMaxChildCount);
        ++this.m_nNeedExpandTreeNodeCount;
        return this.m_pNeedExpandTreeNodes[this.m_nNeedExpandTreeNodeCount - 1];
    }

    private int[] extractPathIds(Channel channel) throws Exception {
        int[] nArray = new int[100];
        int n = 0;
        for (Channel channel2 = channel.getParent(); channel2 != null; channel2 = channel2.getParent()) {
            nArray[n] = channel2.getId();
            ++n;
        }
        int[] nArray2 = new int[n];
        for (int i = n - 1; i >= 0; --i) {
            nArray2[n - i - 1] = nArray[i];
        }
        return nArray2;
    }

    private void initSiteChildren() throws Exception {
        for (int i = this.m_srcChannels.size() - 1; i >= 0; --i) {
            Channel channel = (Channel)this.m_srcChannels.getAt(i);
            if (channel == null || channel.getSiteId() != this.m_oRoot.getId()) continue;
            int[] nArray = this.extractPathIds(channel);
            TreeNodeCalctor treeNodeCalctor = this;
            for (int j = 0; j < nArray.length; ++j) {
                treeNodeCalctor = treeNodeCalctor.addNeedExpandNode(nArray[j]);
            }
            this.m_srcChannels.removeAt(i, false);
        }
    }

    private void initRoot() throws Exception {
        BaseChannel baseChannel;
        int n;
        this.m_srcChannels = Channels.findByIds(this.m_oLoginUser, this.m_sChannelIds);
        ArrayList<Object> arrayList = new ArrayList<Object>(this.m_srcChannels.size());
        this.m_oSites = new WebSites(this.m_oLoginUser, this.m_srcChannels.size(), 1);
        for (n = this.m_srcChannels.size() - 1; n >= 0; --n) {
            baseChannel = (Channel)this.m_srcChannels.getAt(n);
            if (baseChannel == null) continue;
            if (this.m_oSites.indexOf(((Channel)baseChannel).getSiteId()) < 0) {
                this.m_oSites.addElement(((Channel)baseChannel).getSiteId());
            }
            if (((Channel)baseChannel).getParentId() == 0) {
                this.m_srcChannels.removeAt(n, false);
                continue;
            }
            Object object = baseChannel.getProperty("PARENTID");
            if (arrayList.contains(object)) {
                this.m_srcChannels.removeAt(n, false);
                continue;
            }
            arrayList.add(object);
        }
        arrayList.clear();
        this.m_nNeedExpandTreeNodeCount = this.m_oSites.size();
        this.m_pNeedExpandTreeNodes = new TreeNodeCalctor[this.m_nNeedExpandTreeNodeCount];
        this.m_pNeedExpandTreeNodeIds = new int[this.m_nNeedExpandTreeNodeCount];
        for (n = 0; n < this.m_nNeedExpandTreeNodeCount; ++n) {
            baseChannel = (WebSite)this.m_oSites.getAt(n);
            if (baseChannel == null) continue;
            this.m_pNeedExpandTreeNodeIds[n] = baseChannel.getId();
            this.m_pNeedExpandTreeNodes[n] = new TreeNodeCalctor((WebSite)baseChannel, this.m_srcChannels);
        }
    }

    public int getChannelId() {
        return this.m_nChannelId;
    }

    public WebSites getSites() {
        return this.m_oSites;
    }

    public TreeNodeCalctor[] getNeedExpandTreeNodes() {
        return this.m_pNeedExpandTreeNodes;
    }

    public WebSite getRoot() {
        return this.m_oRoot;
    }

    public TreeNodeCalctor getExpandNodeById(int n) {
        if (this.m_nNeedExpandTreeNodeCount <= 0) {
            return null;
        }
        for (int i = 0; i < this.m_nNeedExpandTreeNodeCount; ++i) {
            if (this.m_pNeedExpandTreeNodeIds[i] != n) continue;
            return this.m_pNeedExpandTreeNodes[i];
        }
        return null;
    }
}

