/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.upgrade.dbcompare;

import com.trs.infra.util.upgrade.dbcompare.Column;
import com.trs.infra.util.upgrade.dbcompare.Table;
import com.trs.infra.util.upgrade.dbcompare.TypeInfoMap;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MetaDataLoader {
    private Map tables;
    private List indexes;
    private String schema;
    private Connection conn;
    private boolean loaded;

    public MetaDataLoader(Connection connection, String string) {
        this.schema = string;
        this.conn = connection;
        this.tables = new HashMap(160, 0.1f);
    }

    public Map getTables() {
        return this.tables;
    }

    public void setTables(Map map) {
        this.tables = map;
    }

    public List getIndexes() {
        return this.indexes;
    }

    public void setIndexes(List list) {
        this.indexes = list;
    }

    public void load() throws SQLException {
        if (!this.loaded) {
            this.loadTypeInfos();
            this.loadTables();
            this.loaded = true;
        }
    }

    protected void loadTypeInfos() throws SQLException {
        String string = this.conn.getMetaData().getDatabaseProductName();
        string = (string = string.toLowerCase()).indexOf("microsoft") != -1 ? "mssql" : (string.indexOf("oracle") != -1 ? "oracle" : (string.indexOf("db2") != -1 ? "db2" : "sybase"));
        TypeInfoMap.load(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void loadTables() throws SQLException {
        DatabaseMetaData databaseMetaData = this.conn.getMetaData();
        ResultSet resultSet = null;
        try {
            resultSet = databaseMetaData.getTables(null, this.schema, null, new String[]{"TABLE"});
            int n = 1;
            while (resultSet.next()) {
                CharSequence charSequence;
                Object object;
                String string = resultSet.getString(3).toUpperCase();
                Table table = new Table(string);
                ResultSet resultSet2 = databaseMetaData.getColumns(null, this.schema, string, null);
                while (resultSet2.next()) {
                    object = resultSet2.getString("COLUMN_NAME");
                    charSequence = resultSet2.getString("TYPE_NAME");
                    int n2 = resultSet2.getInt("DATA_TYPE");
                    Column column = new Column((String)object, n2, (String)charSequence);
                    column.length = resultSet2.getInt("COLUMN_SIZE");
                    if (1 == resultSet2.getInt("NULLABLE")) {
                        column.nullAble = true;
                    }
                    column.defaultValue = resultSet2.getString("COLUMN_DEF");
                    column.scale = resultSet2.getInt("DECIMAL_DIGITS");
                    column.order = n++;
                    table.addColumn(column);
                }
                resultSet2.close();
                object = databaseMetaData.getPrimaryKeys(null, this.schema, string);
                charSequence = new StringBuffer(128);
                while (object.next()) {
                    ((StringBuffer)charSequence).append(',');
                    ((StringBuffer)charSequence).append(object.getString("COLUMN_NAME"));
                }
                if (((StringBuffer)charSequence).length() > 1) {
                    table.setPrimaryKey(((StringBuffer)charSequence).substring(1).split(","));
                }
                this.tables.put(string, table);
            }
            Object var12_11 = null;
            if (resultSet == null) return;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            if (resultSet == null) throw throwable;
            resultSet.close();
            throw throwable;
        }
        resultSet.close();
    }
}

