/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.upgrade;

import com.trs.infra.util.upgrade.DbConfig;
import com.trs.infra.util.upgrade.dbcompare.MetaDataLoader;
import com.trs.infra.util.upgrade.dbcompare.SchemaCompare;
import com.trs.infra.util.upgrade.dbcompare.TableDiff;
import com.trs.infra.util.upgrade.sql.SchemaUpdSqlMaker;
import com.trs.infra.util.upgrade.sql.SchemaUpdSqlMakerFactory;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class Main {
    private static final String CONF = "/database.conf";

    public static void main(String[] stringArray) {
        Connection connection = null;
        Connection connection2 = null;
        try {
            System.setOut(new PrintStream(new FileOutputStream("/e:/testdiff.txt")));
            DbConfig dbConfig = new DbConfig();
            dbConfig.load(CONF);
            Class.forName(dbConfig.getJdbcDriver());
            connection = DriverManager.getConnection(dbConfig.getOldUrl(), dbConfig.getOldUser(), dbConfig.getOldPasswd());
            connection2 = DriverManager.getConnection(dbConfig.getNewUrl(), dbConfig.getNewUser(), dbConfig.getNewPasswd());
            MetaDataLoader metaDataLoader = new MetaDataLoader(connection, dbConfig.getOldSchema());
            MetaDataLoader metaDataLoader2 = new MetaDataLoader(connection2, dbConfig.getNewSchema());
            SchemaCompare schemaCompare = new SchemaCompare(metaDataLoader, metaDataLoader2);
            Comparator comparator = new Comparator(){

                public int compare(Object object, Object object2) {
                    TableDiff tableDiff = (TableDiff)object;
                    TableDiff tableDiff2 = (TableDiff)object2;
                    return tableDiff.getTableName().compareTo(tableDiff2.getTableName());
                }
            };
            List list = schemaCompare.getDiff4Source();
            Collections.sort(list, comparator);
            SchemaUpdSqlMaker schemaUpdSqlMaker = SchemaUpdSqlMakerFactory.makeSqlMaker(dbConfig.getDbtype());
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                Main.printMsg(schemaUpdSqlMaker.getSql((TableDiff)list.get(i)));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void printMsg(String[] stringArray) {
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            Main.printMsg(stringArray[i]);
        }
    }

    private static void printMsg(String string) {
        if (string == null || string.trim().length() == 0) {
            return;
        }
        System.out.println(string);
    }
}

