/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.html;

import com.trs.infra.I18NMessage;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.html.HtmlElement;

public class HtmlElementFinder {
    private char[] srcBuffer = null;
    private int nCurrPos = 0;
    public StringBuffer conBuffer = null;

    public HtmlElementFinder() {
    }

    public HtmlElementFinder(String string) {
        this.setHtmlSrc(string);
    }

    public HtmlElementFinder(char[] cArray) {
        this.setHtmlSrc(cArray);
    }

    public void setPosition(int n) {
        this.nCurrPos = n;
    }

    public HtmlElementFinder setHtmlSrc(String string) {
        if (string == null) {
            string = "";
        }
        return this.setHtmlSrc(string.toCharArray());
    }

    public HtmlElementFinder setHtmlSrc(char[] cArray) {
        this.srcBuffer = cArray;
        this.conBuffer = new StringBuffer();
        return this;
    }

    public String getContent() {
        if (this.conBuffer == null) {
            return "";
        }
        return this.conBuffer.toString();
    }

    public HtmlElement findNextElement(String string) {
        return this.findNextElement(string, false);
    }

    public HtmlElement findNextElement(String string, boolean bl, String string2) {
        string = "<" + string.trim().toLowerCase();
        char[] cArray = string.toCharArray();
        int n = this.srcBuffer.length;
        while (this.nCurrPos < n) {
            char c = this.srcBuffer[this.nCurrPos];
            if (c == '<') {
                int n2;
                for (n2 = 1; n2 < cArray.length && this.nCurrPos + n2 < n && Character.toLowerCase(this.srcBuffer[this.nCurrPos + n2]) == cArray[n2]; ++n2) {
                }
                if (n2 == cArray.length && (n2 += this.nCurrPos) < n && (Character.isWhitespace(this.srcBuffer[n2]) || this.srcBuffer[n2] == '>')) {
                    HtmlElement htmlElement = new HtmlElement();
                    htmlElement.ONLY_SEARCH_SELF = bl;
                    try {
                        int n3 = htmlElement.fromString(this.srcBuffer, this.nCurrPos, string2);
                        if (n3 > 0) {
                            this.nCurrPos = n3;
                            return htmlElement;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            this.conBuffer.append(c);
            ++this.nCurrPos;
        }
        return null;
    }

    public HtmlElement findNextElement(String string, boolean bl) {
        return this.findNextElement(string, bl, null);
    }

    public HtmlElementFinder putElement(HtmlElement htmlElement) {
        if (htmlElement != null) {
            this.conBuffer.append(htmlElement.toString(true, false));
        }
        return this;
    }

    public HtmlElementFinder putHTML(String string) {
        if (string != null) {
            this.conBuffer.append(string);
        }
        return this;
    }

    public static void main(String[] stringArray) {
        try {
            String string = "c:\\test.html";
            String string2 = CMyFile.readFile(string);
            System.out.println("\n\n*****************  Result *********************");
            String[] stringArray2 = new String[7];
            stringArray2[0] = "TABLE";
            String[] stringArray3 = new String[]{"SRC", "BACKGROUND", "BACKGROUND", "BACKGROUND", "SRC", "HREF", "SRC"};
            String string3 = "p,div,form";
            for (int i = 0; i < stringArray2.length; ++i) {
                if (stringArray2[i] == null) continue;
                HtmlElementFinder htmlElementFinder = new HtmlElementFinder();
                htmlElementFinder.setHtmlSrc(string2);
                HtmlElement htmlElement = htmlElementFinder.findNextElement(stringArray2[i], false, string3);
                int n = 0;
                while (htmlElement != null) {
                    if (n <= 1) {
                        System.out.println("[FOUND]" + htmlElement.toString(true, false, string3));
                    }
                    String string4 = "";
                    htmlElementFinder.putHTML(htmlElement.toString(true, false, string3) + string4);
                    ++n;
                    htmlElement = htmlElementFinder.findNextElement(stringArray2[i], false, string3);
                }
                string2 = htmlElementFinder.getContent();
                System.out.println(I18NMessage.get(HtmlElementFinder.class, "HtmlElementFinder.label1", "\u5904\u7406\u8282\u70b9[") + stringArray2[i] + I18NMessage.get(HtmlElementFinder.class, "HtmlElementFinder.label2", "]\u53d1\u73b0[") + n + I18NMessage.get(HtmlElementFinder.class, "HtmlElementFinder.label3", "]\u4e2a"));
            }
            System.out.println("\n\n*****************  Result *********************");
            CMyFile.writeFile("d:\\result.html", string2);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }
}

