/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.html;

import com.trs.infra.I18NMessage;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.html.HtmlComment;
import com.trs.infra.util.html.HtmlElement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class HtmlDocument {
    private static final int INITIAL_ARRAY_SIZE = 5;
    protected List content = new ArrayList(5);

    public HtmlDocument() {
    }

    public HtmlDocument(HtmlElement htmlElement) {
        this.setRootElement(htmlElement);
    }

    public List getContent() {
        return this.content;
    }

    public HtmlDocument setContent(List list) throws CMyException {
        if (list == null) {
            return this;
        }
        boolean bl = false;
        Iterator iterator = list.iterator();
        this.content = new ArrayList(5);
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof HtmlElement) {
                if (!bl) {
                    this.setRootElement((HtmlElement)e);
                    bl = true;
                    continue;
                }
                throw new CMyException(1, I18NMessage.get(HtmlDocument.class, "HtmlDocument.label1", "\u6587\u5f53\u4e2d\u53ea\u80fd\u5b58\u5728\u4e00\u4e2a\u6839\u5143\u7d20(HtmlDocument.setContent)"));
            }
            if (e instanceof HtmlComment) {
                this.addContent((HtmlComment)e);
                continue;
            }
            throw new CMyException(1, I18NMessage.get(HtmlDocument.class, "HtmlDocument.label2", "\u65e0\u6548\u7684\u6587\u6863\u5185\u5bb9(HtmlDocument.setContent)"));
        }
        if (!bl) {
            throw new CMyException(1, I18NMessage.get(HtmlDocument.class, "HtmlDocument.label3", "\u6587\u6863\u7f3a\u5c11\u6839\u5143\u7d20\uff08HtmlDocument.setContent\uff09"));
        }
        return this;
    }

    public HtmlElement getRootElement() {
        for (Object e : this.content) {
            if (!(e instanceof HtmlElement)) continue;
            return (HtmlElement)e;
        }
        return null;
    }

    public HtmlDocument setRootElement(HtmlElement htmlElement) {
        if (htmlElement == null) {
            return this;
        }
        boolean bl = false;
        ListIterator<HtmlElement> listIterator = this.content.listIterator();
        while (listIterator.hasNext()) {
            Object e = listIterator.next();
            if (!(e instanceof HtmlElement)) continue;
            HtmlElement htmlElement2 = (HtmlElement)e;
            htmlElement2.setDocument(null);
            listIterator.set(htmlElement);
            bl = true;
            break;
        }
        if (!bl) {
            listIterator.add(htmlElement);
        }
        htmlElement.setDocument(null);
        return this;
    }

    public HtmlDocument addContent(HtmlComment htmlComment) throws CMyException {
        if (htmlComment == null) {
            return this;
        }
        if (htmlComment.getParent() != null || htmlComment.getDocument() != null) {
            throw new CMyException(1, I18NMessage.get(HtmlDocument.class, "HtmlDocument.label4", "\u6dfb\u52a0\u7684\u5185\u5bb9\u5df2\u7ecf\u5b58\u5728Parent\uff08HtmlDocument.addContent\uff09"));
        }
        this.content.add(htmlComment);
        return this;
    }

    public List getElementsByName(String string) {
        HtmlElement htmlElement = this.getRootElement();
        if (htmlElement == null) {
            return new ArrayList(1);
        }
        return htmlElement.getElementsByName(string);
    }

    public String toString() {
        if (this.content == null || this.content.size() < 1) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (Object e : this.content) {
            if (e instanceof HtmlComment) {
                stringBuffer.append(((HtmlComment)e).toString());
            } else if (e instanceof HtmlElement) {
                stringBuffer.append(((HtmlElement)e).toString());
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public boolean fromString(String string) throws CMyException {
        if (this.content != null) {
            this.content.clear();
        }
        if ((string = string.trim()).length() < 1) {
            return false;
        }
        HtmlElement htmlElement = new HtmlElement();
        if (htmlElement.fromString("<_DOM>" + string + "</_DOM>") < 1) {
            return false;
        }
        List list = htmlElement.getContent();
        if (list == null) {
            return false;
        }
        for (Object e : list) {
            if (e == null) continue;
            if (e instanceof HtmlComment) {
                ((HtmlComment)e).setParent(null);
                this.addContent((HtmlComment)e);
                continue;
            }
            if (!(e instanceof HtmlElement)) continue;
            ((HtmlElement)e).setParent(null);
            this.setRootElement((HtmlElement)e);
        }
        return true;
    }

    public boolean loadFromFile(String string) throws CMyException {
        String string2 = CMyFile.readFile(string);
        return this.fromString(string2);
    }

    public void saveToFile(String string) throws CMyException {
        String string2 = this.toString();
        CMyFile.writeFile(string, string2);
    }

    public static void main(String[] stringArray) {
        HtmlDocument htmlDocument = new HtmlDocument();
        HtmlElement htmlElement = null;
        List list = null;
        try {
            String string = "d:\\temp\\test1.htm";
            if (!htmlDocument.loadFromFile(string)) {
                System.out.println("Failed to analyze Html Document.");
            } else {
                System.out.println("OK to analyze Html Document.");
                System.out.println(htmlDocument.toString());
                System.out.println("\nTest for getElementsByName...");
                list = htmlDocument.getElementsByName("FORM");
                for (int i = 0; i < list.size(); ++i) {
                    htmlElement = (HtmlElement)list.get(i);
                    System.out.println("\n" + htmlElement.toString());
                }
                list.clear();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }
}

