/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.html;

import com.trs.infra.util.html.HtmlDocument;
import com.trs.infra.util.html.HtmlElement;

public class HtmlComment
implements Cloneable {
    public static final String TAG_START = "<!--";
    public static final String TAG_END = "-->";
    protected String text;
    protected Object parent = null;

    protected HtmlComment() {
    }

    public HtmlComment(String string) {
        this.setText(string);
    }

    public HtmlDocument getDocument() {
        if (this.parent == null) {
            return null;
        }
        if (this.parent instanceof HtmlDocument) {
            return (HtmlDocument)this.parent;
        }
        if (this.parent instanceof HtmlElement) {
            return ((HtmlElement)this.parent).getDocument();
        }
        return null;
    }

    public HtmlComment setDocument(HtmlDocument htmlDocument) {
        this.parent = htmlDocument;
        return this;
    }

    public HtmlElement getParent() {
        if (this.parent instanceof HtmlElement) {
            return (HtmlElement)this.parent;
        }
        return null;
    }

    public HtmlComment setParent(HtmlElement htmlElement) {
        this.parent = htmlElement;
        return this;
    }

    public String getText() {
        return this.text;
    }

    public HtmlComment setText(String string) {
        this.text = string;
        return this;
    }

    public boolean isRootComment() {
        return this.parent instanceof HtmlDocument;
    }

    public Object clone() {
        HtmlComment htmlComment = new HtmlComment(this.text);
        htmlComment.setParent(null);
        return htmlComment;
    }

    public String toString() {
        return new StringBuffer().append(TAG_START).append(this.text).append(TAG_END).toString();
    }

    public boolean fromString(String string) {
        if (!(string = string.trim()).startsWith(TAG_START) || !string.endsWith(TAG_END)) {
            return false;
        }
        this.text = string.substring(4, string.length() - 3);
        return true;
    }

    public static void main(String[] stringArray) {
        String string = " <!-- this is a comment -->  ";
        HtmlComment htmlComment = new HtmlComment();
        htmlComment.fromString(string);
        System.out.println(htmlComment.toString());
    }
}

