/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.file;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;

public class JavaScriptEscape {
    private static char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static String encoding = System.getProperty("file.encoding");
    private static File dirTarget;

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.out.println("JavaScriptEscape [-encoding <encoding>] [-d <out dir>] file ...");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if ("-encoding".equals(stringArray[i])) {
                if (++i < stringArray.length) {
                    encoding = stringArray[i];
                    continue;
                }
                System.err.println("encoding parameter not present.");
                continue;
            }
            if ("-d".equals(stringArray[i])) {
                if (++i < stringArray.length) {
                    JavaScriptEscape.ensureTarget(stringArray[i]);
                    continue;
                }
                System.err.println("target directory parameter not present.");
                continue;
            }
            File file = new File(stringArray[i]);
            if (file.exists()) {
                JavaScriptEscape.escapePath(file);
                continue;
            }
            System.err.println('\'' + stringArray[i] + "' not exists.");
        }
    }

    private static void ensureTarget(String string) {
        File file = new File(string);
        if (!file.exists()) {
            file.mkdirs();
        }
        if (!file.exists()) {
            System.err.println("create directory '" + string + "' failed.");
            System.exit(1);
        }
        if (!file.isDirectory()) {
            System.err.println("'" + string + "' not directory.");
            System.exit(2);
        }
        dirTarget = file;
    }

    private static void escapePath(File file) {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                JavaScriptEscape.escapePath(fileArray[i]);
            }
        } else {
            JavaScriptEscape.escapeFile(file);
        }
    }

    public static String char2hex(int n) {
        char[] cArray = new char[6];
        for (int i = cArray.length - 1; i >= 0; --i) {
            cArray[i] = DIGITS[n & 0xF];
            n >>>= 4;
        }
        cArray[0] = 92;
        cArray[1] = 117;
        return new String(cArray);
    }

    private static boolean isJavaScriptFile(File file) {
        String string = file.getName();
        if (string.length() <= 3) {
            return false;
        }
        String string2 = string.substring(string.length() - 3);
        return string2.equalsIgnoreCase(".JS");
    }

    private static void escapeFile(File file) {
        if (!JavaScriptEscape.isJavaScriptFile(file)) {
            return;
        }
        JavaScriptEscape.log("From File:" + file.getAbsolutePath());
        try {
            int n = 0;
            StringBuffer stringBuffer = new StringBuffer((int)file.length() * 2);
            FileInputStream fileInputStream = new FileInputStream(file);
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, encoding);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            while ((n = bufferedReader.read()) != -1) {
                if (n < 128) {
                    stringBuffer.append((char)n);
                    continue;
                }
                stringBuffer.append(JavaScriptEscape.char2hex(n));
            }
            bufferedReader.close();
            JavaScriptEscape.outResult(stringBuffer.toString(), file);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            System.exit(3);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private static void outResult(String string, File file) throws IOException {
        File file2 = null;
        file2 = dirTarget == null ? file : new File(dirTarget, file.getName());
        JavaScriptEscape.log("  To File:" + file2.getAbsolutePath());
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        fileOutputStream.write(string.getBytes("ISO8859-1"));
        fileOutputStream.close();
    }

    public static final void log(String string) {
        System.out.println(string);
    }
}

