/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.email;

import com.trs.infra.I18NMessage;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.email.CMyEmail;
import com.trs.infra.util.email.CMyMailException;
import com.trs.infra.util.email.CMyMailLog;
import com.trs.infra.util.email.CMySMTPServer;
import com.trs.infra.util.email.MIMEBase64;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.apache.soap.encoding.soapenc.Base64;

public class TRSMailer {
    private static Logger s_logger = Logger.getLogger(TRSMailer.class);
    private static final int DISABLE_SOCKET_TIME_OUT = -1;
    private int m_nSocketTimeOut = -1;
    private CMyMailLog mailLog = new CMyMailLog();

    public TRSMailer() {
        this.disableSocketTimeOut();
    }

    public void setSocketTimeOut(int n) {
        this.m_nSocketTimeOut = n;
    }

    public void disableSocketTimeOut() {
        this.setSocketTimeOut(-1);
    }

    public int getSocketTimeOut() {
        return this.m_nSocketTimeOut;
    }

    public CMyMailLog getMailLog() {
        return this.mailLog;
    }

    public String getMailLogString() {
        return this.mailLog.getLog();
    }

    public boolean send(CMyEmail cMyEmail) throws CMyMailException {
        return this.send(cMyEmail, CMySMTPServer.getDefaultSMTPServer());
    }

    public boolean send(final CMyEmail cMyEmail, final CMySMTPServer cMySMTPServer) {
        new Thread(){

            public void run() {
                try {
                    TRSMailer.this.send0(cMyEmail, cMySMTPServer);
                }
                catch (CMyMailException cMyMailException) {
                    cMyMailException.printStackTrace();
                }
            }
        }.start();
        return true;
    }

    public boolean send0(CMyEmail cMyEmail, CMySMTPServer cMySMTPServer) throws CMyMailException {
        Object object;
        if (cMySMTPServer == null) {
            throw new CMyMailException(I18NMessage.get(TRSMailer.class, "TRSMailer.label1", "\u90ae\u4ef6\u670d\u52a1\u5668\u6ca1\u6709\u8bbe\u7f6e\uff08\u4e3a\u7a7a\uff09\uff0c\u65e0\u6cd5\u53d1\u9001\u90ae\u4ef6\uff01"));
        }
        cMySMTPServer.validate();
        if (cMyEmail == null) {
            throw new CMyMailException(I18NMessage.get(TRSMailer.class, "TRSMailer.label2", "\u90ae\u4ef6\u6ca1\u6709\u8bbe\u7f6e\uff08\u4e3a\u7a7a\uff09\uff0c\u65e0\u6cd5\u53d1\u9001\uff01"));
        }
        cMyEmail.validate();
        this.mailLog.appendSendLogs("---- TRS Mailer: send begin@" + CMyDateTime.now().toString() + " ----");
        Socket socket = null;
        BufferedWriter bufferedWriter = null;
        BufferedReader bufferedReader = null;
        this.mailLog.appendSendLogs(I18NMessage.get(TRSMailer.class, "TRSMailer.label3", "---- \u5f00\u59cb\u5efa\u7acb\u8fde\u63a5 ----"));
        try {
            socket = cMySMTPServer.createSocket();
            bufferedWriter = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream(), "GBK"));
            bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream(), "GBK"));
            this.mailLog.recordSendLogs(this.getResponse(bufferedReader), 2);
        }
        catch (Exception exception) {
            this.mailLog.appendSendLogs(I18NMessage.get(TRSMailer.class, "TRSMailer.label4", "\u8fde\u63a5\u90ae\u4ef6\u670d\u52a1\u5668") + cMySMTPServer.toString() + I18NMessage.get(TRSMailer.class, "TRSMailer.label5", "\u65f6\u53d1\u751f\u9519\u8bef\uff01") + exception.toString());
            this.closeSocket(socket, bufferedWriter, bufferedReader);
            throw new CMyMailException(I18NMessage.get(TRSMailer.class, "TRSMailer.label4", "\u8fde\u63a5\u90ae\u4ef6\u670d\u52a1\u5668") + cMySMTPServer.toString() + I18NMessage.get(TRSMailer.class, "TRSMailer.label5", "\u65f6\u53d1\u751f\u9519\u8bef\uff01") + exception.toString());
        }
        this.mailLog.appendSendLogs(I18NMessage.get(TRSMailer.class, "TRSMailer.label6", "---- \u8fde\u63a5\u6210\u529f ----"));
        this.setSocketTimeOut(socket, this.getSocketTimeOut());
        this.mailLog.appendSendLogs(I18NMessage.get(TRSMailer.class, "TRSMailer.label7", "---- \u5f00\u59cb\u9a8c\u8bc1\u90ae\u4ef6\u670d\u52a1\u5668 ----"));
        try {
            if (cMySMTPServer.needAuth()) {
                if (!cMySMTPServer.canAuth()) {
                    this.mailLog.appendSendLogs(I18NMessage.get(TRSMailer.class, "TRSMailer.label8", "\u90ae\u4ef6\u670d\u52a1\u5668\u9700\u8981\u8eab\u4efd\u9a8c\u8bc1\uff0c\u4f46\u662f\u9a8c\u8bc1\u53c2\u6570\u4e0d\u8db3\uff0c\u65e0\u6cd5\u9a8c\u8bc1\uff01"));
                    return false;
                }
                this.sendMailBuffer(bufferedReader, bufferedWriter, "EHLO " + cMySMTPServer.getServerName(), I18NMessage.get(TRSMailer.class, "TRSMailer.label9", "\u9a8c\u8bc1\u670d\u52a1\u5668EHLO\u63e1\u624b\u65f6\u5931\u8d25\uff01"));
                this.sendMailBuffer(bufferedReader, bufferedWriter, "AUTH LOGIN", I18NMessage.get(TRSMailer.class, "TRSMailer.label10", "\u9a8c\u8bc1\u670d\u52a1\u5668\u53d1\u9001\u8ba4\u8bc1\u8bf7\u6c42AUTH LOGIN\u547d\u4ee4\u65f6\u5931\u8d25\uff01"));
                this.sendMailBuffer(bufferedReader, bufferedWriter, new String(Base64.encode((byte[])cMySMTPServer.getUserName().getBytes())), I18NMessage.get(TRSMailer.class, "TRSMailer.label11", "\u9a8c\u8bc1\u670d\u52a1\u5668\u53d1\u9001\u9a8c\u8bc1\u7528\u6237\u540d\u65f6\u5931\u8d25\uff01"));
                this.sendMailBuffer(bufferedReader, bufferedWriter, new String(Base64.encode((byte[])cMySMTPServer.getPassword().getBytes())), I18NMessage.get(TRSMailer.class, "TRSMailer.label12", "\u9a8c\u8bc1\u7528\u6237\u5bc6\u7801\u65f6\u5931\u8d25\uff01"));
            } else {
                this.sendMailBuffer(bufferedReader, bufferedWriter, "HELO " + cMySMTPServer.getServerName(), I18NMessage.get(TRSMailer.class, "TRSMailer.label13", "\u9a8c\u8bc1\u670d\u52a1\u5668HELO\u63e1\u624b\u65f6\u5931\u8d25"));
            }
        }
        catch (Exception exception) {
            this.mailLog.appendSendLogs(I18NMessage.get(TRSMailer.class, "TRSMailer.label14", "\u9a8c\u8bc1\u90ae\u4ef6\u670d\u52a1\u5668") + cMySMTPServer.toString() + I18NMessage.get(TRSMailer.class, "TRSMailer.label5", "\u65f6\u53d1\u751f\u9519\u8bef\uff01") + exception.toString());
            this.closeSocket(socket, bufferedWriter, bufferedReader);
            throw new CMyMailException(I18NMessage.get(TRSMailer.class, "TRSMailer.label14", "\u9a8c\u8bc1\u90ae\u4ef6\u670d\u52a1\u5668") + cMySMTPServer.toString() + I18NMessage.get(TRSMailer.class, "TRSMailer.label5", "\u65f6\u53d1\u751f\u9519\u8bef\uff01") + exception.toString());
        }
        this.mailLog.appendSendLogs(I18NMessage.get(TRSMailer.class, "TRSMailer.label15", "---- \u9a8c\u8bc1\u90ae\u4ef6\u670d\u52a1\u5668\u6210\u529f ----"));
        this.mailLog.appendSendLogs(I18NMessage.get(TRSMailer.class, "TRSMailer.label16", "---- \u5f00\u59cb\u53d1\u9001\u90ae\u4ef6\u53d1\u4ef6\u4eba\u548c\u6536\u4ef6\u4eba\u4fe1\u606f ----"));
        try {
            String string;
            Iterator iterator;
            try {
                this.sendMailBuffer(bufferedReader, bufferedWriter, "MAIL FROM: <" + cMyEmail.getFrom() + ">", I18NMessage.get(TRSMailer.class, "TRSMailer.label17", "\u53d1\u9001\u90ae\u4ef6\u65f6\u53d1\u4ef6\u4eba\uff08") + cMyEmail.getFrom() + I18NMessage.get(TRSMailer.class, "TRSMailer.label18", "\uff09\u65e0\u6548\uff01"));
            }
            catch (CMyMailException cMyMailException) {
                s_logger.debug((Object)I18NMessage.get(TRSMailer.class, "TRSMailer.label19", "\u53d1\u9001\u90ae\u4ef6\u65f6\u53d1\u4ef6\u4eba\u65e0\u6548\uff0c\u5c1d\u8bd5\u91c7\u7528\u7cfb\u7edf\u7528\u6237\u53d1\u9001\uff01"));
                iterator = cMySMTPServer.getUserName() + "@" + cMySMTPServer.getServerName();
                try {
                    this.sendMailBuffer(bufferedReader, bufferedWriter, "MAIL FROM: <" + (String)((Object)iterator) + ">", I18NMessage.get(TRSMailer.class, "TRSMailer.label20", "\u53d1\u9001\u90ae\u4ef6\u65f6\u7cfb\u7edf\u9ed8\u8ba4\u53d1\u4ef6\u4eba\uff08") + (String)((Object)iterator) + I18NMessage.get(TRSMailer.class, "TRSMailer.label18", "\uff09\u65e0\u6548\uff01"));
                }
                catch (CMyMailException cMyMailException2) {
                    s_logger.debug((Object)I18NMessage.get(TRSMailer.class, "TRSMailer.label21", "\u5c1d\u8bd5\u7b2c\u4e00\u79cd\u7cfb\u7edf\u9ed8\u8ba4\u53d1\u4ef6\u4eba\u65e0\u6548\uff0c\u5c1d\u8bd5\u91c7\u7528\u7b2c\u4e8c\u79cd\u7cfb\u7edf\u9ed8\u8ba4\u53d1\u4ef6\u4eba\u53d1\u9001\uff01"));
                    iterator = cMySMTPServer.getUserName();
                    this.sendMailBuffer(bufferedReader, bufferedWriter, "MAIL FROM: <" + (String)((Object)iterator) + ">", I18NMessage.get(TRSMailer.class, "TRSMailer.label22", "\u518d\u6b21\u53d1\u9001\u90ae\u4ef6\u65f6\u7cfb\u7edf\u9ed8\u8ba4\u53d1\u4ef6\u4eba\uff08") + (String)((Object)iterator) + I18NMessage.get(TRSMailer.class, "TRSMailer.label18", "\uff09\u65e0\u6548\uff01"));
                }
            }
            object = cMyEmail.getTo();
            iterator = new StringTokenizer((String)object, ";");
            while (((StringTokenizer)((Object)iterator)).hasMoreTokens()) {
                string = ((StringTokenizer)((Object)iterator)).nextToken();
                try {
                    this.sendMailBuffer(bufferedReader, bufferedWriter, "RCPT TO: <" + string + ">", I18NMessage.get(TRSMailer.class, "TRSMailer.label23", "\u53d1\u9001\u4eba\u3010") + string + I18NMessage.get(TRSMailer.class, "TRSMailer.label24", "\u3011\u65e0\u6548"));
                }
                catch (CMyMailException cMyMailException) {
                    s_logger.error((Object)(I18NMessage.get(TRSMailer.class, "TRSMailer.label25", "\u53d1\u9001\u90ae\u4ef6\u65f6\uff0c\u6709\u4e00\u4e2a\u53d1\u9001\u4eba\u3010") + string + I18NMessage.get(TRSMailer.class, "TRSMailer.label24", "\u3011\u65e0\u6548")));
                }
            }
            object = cMyEmail.getCc();
            if (object != null && ((String)object).trim().length() > 0) {
                iterator = new StringTokenizer((String)object, ";");
                while (((StringTokenizer)((Object)iterator)).hasMoreTokens()) {
                    string = ((StringTokenizer)((Object)iterator)).nextToken();
                    try {
                        this.sendMailBuffer(bufferedReader, bufferedWriter, "RCPT TO: <" + string + ">", I18NMessage.get(TRSMailer.class, "TRSMailer.label26", "\u8f6c\u53d1\u4eba\u3010") + string + I18NMessage.get(TRSMailer.class, "TRSMailer.label24", "\u3011\u65e0\u6548"));
                    }
                    catch (CMyMailException cMyMailException) {
                        cMyMailException.printStackTrace();
                        s_logger.error((Object)(I18NMessage.get(TRSMailer.class, "TRSMailer.label27", "\u53d1\u9001\u90ae\u4ef6\u65f6\uff0c\u6709\u4e00\u4e2a\u8f6c\u53d1\u4eba\u3010") + string + I18NMessage.get(TRSMailer.class, "TRSMailer.label24", "\u3011\u65e0\u6548")));
                    }
                }
            }
            if ((object = cMyEmail.getBcc()) != null && ((String)object).length() > 0) {
                iterator = new StringTokenizer((String)object, ";");
                while (((StringTokenizer)((Object)iterator)).hasMoreTokens()) {
                    string = ((StringTokenizer)((Object)iterator)).nextToken();
                    try {
                        this.sendMailBuffer(bufferedReader, bufferedWriter, "RCPT TO: <" + string + ">", I18NMessage.get(TRSMailer.class, "TRSMailer.label28", "\u5bc6\u9001\u4eba\u3010") + string + I18NMessage.get(TRSMailer.class, "TRSMailer.label24", "\u3011\u65e0\u6548"));
                    }
                    catch (CMyMailException cMyMailException) {
                        s_logger.error((Object)I18NMessage.get(TRSMailer.class, "TRSMailer.label29", "\u53d1\u9001\u90ae\u4ef6\u65f6\uff0c\u6709\u4e00\u4e2a\u5bc6\u9001\u4eba\u65e0\u6548"));
                    }
                }
            }
        }
        catch (Exception exception) {
            this.mailLog.appendSendLogs(I18NMessage.get(TRSMailer.class, "TRSMailer.label30", "\u53d1\u9001\u90ae\u4ef6\u53d1\u4ef6\u4eba\u548c\u6536\u4ef6\u4eba\u4fe1\u606f\u65f6\u53d1\u751f\u9519\u8bef\uff01") + exception.toString());
            this.closeSocket(socket, bufferedWriter, bufferedReader);
            throw new CMyMailException(I18NMessage.get(TRSMailer.class, "TRSMailer.label30", "\u53d1\u9001\u90ae\u4ef6\u53d1\u4ef6\u4eba\u548c\u6536\u4ef6\u4eba\u4fe1\u606f\u65f6\u53d1\u751f\u9519\u8bef\uff01") + exception.toString());
        }
        this.mailLog.appendSendLogs(I18NMessage.get(TRSMailer.class, "TRSMailer.label31", "---- \u53d1\u9001\u90ae\u4ef6\u53d1\u4ef6\u4eba\u548c\u6536\u4ef6\u4eba\u4fe1\u606f\u6210\u529f ----"));
        this.mailLog.appendSendLogs(I18NMessage.get(TRSMailer.class, "TRSMailer.label32", "---- \u5f00\u59cb\u53d1\u9001\u90ae\u4ef6\u6b63\u6587 ----"));
        try {
            this.sendMailBuffer(bufferedReader, bufferedWriter, "DATA", I18NMessage.get(TRSMailer.class, "TRSMailer.label33", "\u53d1\u9001\u90ae\u4ef6\u6b63\u6587\u65f6\uff0c\u547d\u4ee4DATA\u65e0\u6548\uff01"));
            this.setSocketTimeOut(socket, 0);
            this.sendBuffer(bufferedWriter, cMyEmail.composeMail());
            object = cMyEmail.getAttatchedFileList();
            if (object != null && ((HashMap)object).size() > 0) {
                for (String string : ((HashMap)object).keySet()) {
                    this.sendFiles(string, (String)((HashMap)object).get(string), bufferedWriter);
                }
                this.sendBuffer(bufferedWriter, CMyEmail.getMailEnd());
            }
        }
        catch (CMyMailException cMyMailException) {
            this.mailLog.appendSendLogs(I18NMessage.get(TRSMailer.class, "TRSMailer.label34", "\u53d1\u9001\u90ae\u4ef6\u6b63\u6587\u65f6\u53d1\u751f\u9519\u8bef\uff01") + cMyMailException.toString());
            this.closeSocket(socket, bufferedWriter, bufferedReader);
            throw new CMyMailException(I18NMessage.get(TRSMailer.class, "TRSMailer.label34", "\u53d1\u9001\u90ae\u4ef6\u6b63\u6587\u65f6\u53d1\u751f\u9519\u8bef\uff01") + cMyMailException.toString());
        }
        this.mailLog.appendSendLogs(I18NMessage.get(TRSMailer.class, "TRSMailer.label35", "---- \u53d1\u9001\u90ae\u4ef6\u6b63\u6587\u6210\u529f ----"));
        this.mailLog.appendSendLogs(I18NMessage.get(TRSMailer.class, "TRSMailer.label36", "---- \u5f00\u59cb\u53d1\u9001\u90ae\u4ef6\u7ed3\u675f\u6807\u5fd7 ----"));
        try {
            this.setSocketTimeOut(this.getSocketTimeOut());
            this.sendBuffer(bufferedWriter, "");
            this.sendMailBuffer(bufferedReader, bufferedWriter, ".", I18NMessage.get(TRSMailer.class, "TRSMailer.label37", "\u53d1\u9001\u6b63\u6587\u7ed3\u675f\u7b26.\u65f6\u53d1\u751f\u9519\u8bef\uff01"));
            this.sendMailBuffer(bufferedReader, bufferedWriter, "QUIT", I18NMessage.get(TRSMailer.class, "TRSMailer.label38", "\u53d1\u9001\u90ae\u4ef6\u7ed3\u675f\u6807\u5fd7\u547d\u4ee4QUIT\u65f6\u53d1\u751f\u9519\u8bef\uff01"));
        }
        catch (CMyMailException cMyMailException) {
            cMyMailException.printStackTrace();
            this.mailLog.appendSendLogs(I18NMessage.get(TRSMailer.class, "TRSMailer.label39", "\u53d1\u9001\u90ae\u4ef6\u7ed3\u675f\u6807\u5fd7\u65f6\u53d1\u751f\u9519\u8bef\uff01") + cMyMailException.toString());
            this.closeSocket(socket, bufferedWriter, bufferedReader);
            throw new CMyMailException(I18NMessage.get(TRSMailer.class, "TRSMailer.label39", "\u53d1\u9001\u90ae\u4ef6\u7ed3\u675f\u6807\u5fd7\u65f6\u53d1\u751f\u9519\u8bef\uff01") + cMyMailException.toString());
        }
        this.mailLog.appendSendLogs(I18NMessage.get(TRSMailer.class, "TRSMailer.label40", "---- \u53d1\u9001\u90ae\u4ef6\u7ed3\u675f\u6807\u5fd7\u6210\u529f----"));
        this.mailLog.appendSendLogs(I18NMessage.get(TRSMailer.class, "TRSMailer.label41", "---- \u5f00\u59cb\u5173\u95ed\u8fde\u63a5 ----"));
        this.closeSocket(socket, bufferedWriter, bufferedReader);
        this.mailLog.appendSendLogs(I18NMessage.get(TRSMailer.class, "TRSMailer.label42", "---- \u5173\u95ed\u8fde\u63a5\u6210\u529f ----"));
        this.mailLog.appendSendLogs("---- TRS Mailer: send end@" + CMyDateTime.now().toString() + " ----");
        return true;
    }

    private String getResponse(BufferedReader bufferedReader) {
        String string = "";
        try {
            String string2 = bufferedReader.readLine();
            while (!this.isResponseEof(string2)) {
                string = string + string2 + "\r\n";
                string2 = bufferedReader.readLine();
            }
            string = string + string2;
        }
        catch (Exception exception) {
            string = string + I18NMessage.get(TRSMailer.class, "TRSMailer.label43", "\u8bfb\u8d85\u65f6...\u3010") + exception.toString() + "\u3011\r\n";
        }
        return string;
    }

    private boolean isResponseEof(String string) {
        if (string == null || string.trim().length() < 4) {
            s_logger.debug((Object)I18NMessage.get(TRSMailer.class, "TRSMailer.label44", "\u63a5\u6536\u5230\u672a\u77e5\u7684\u56de\u7b54\uff0c\u7ed3\u675f\u5904\u7406\u3002"));
            return true;
        }
        String string2 = string.substring(0, 3);
        int n = this.parseCode(string2);
        String string3 = string.substring(3, 4);
        if (n == 0) {
            s_logger.debug((Object)(I18NMessage.get(TRSMailer.class, "TRSMailer.label44", "\u63a5\u6536\u5230\u672a\u77e5\u7684\u56de\u7b54\uff0c\u7ed3\u675f\u5904\u7406\u3002") + string));
            return true;
        }
        if (string3.equals("-")) {
            return false;
        }
        if (string3.equals(" ")) {
            return true;
        }
        s_logger.debug((Object)(I18NMessage.get(TRSMailer.class, "TRSMailer.label44", "\u63a5\u6536\u5230\u672a\u77e5\u7684\u56de\u7b54\uff0c\u7ed3\u675f\u5904\u7406\u3002") + string));
        return true;
    }

    private int parseCode(String string) {
        try {
            int n = Integer.parseInt(string);
            return n;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    private void setSocketTimeOut(Socket socket, int n) {
        if (this.getSocketTimeOut() != -1) {
            try {
                socket.setSoTimeout(n);
                this.mailLog.appendSendLogs(I18NMessage.get(TRSMailer.class, "TRSMailer.label45", "---- Socket\u8fde\u63a5\u8d85\u65f6\u4e3a\uff1a") + n);
                s_logger.debug((Object)("Server Timeout: " + n));
            }
            catch (Exception exception) {
                this.mailLog.appendSendLogs(I18NMessage.get(TRSMailer.class, "TRSMailer.label46", "---- \u670d\u52a1\u5668\u8bbe\u7f6e\u8d85\u65f6(") + n + I18NMessage.get(TRSMailer.class, "TRSMailer.label47", ")\u5931\u8d25\uff01 ----"));
                s_logger.error((Object)I18NMessage.get(TRSMailer.class, "TRSMailer.label48", "---- \u670d\u52a1\u5668\u8bbe\u7f6e\u8d85\u65f6\u5931\u8d25\uff01 ----"));
            }
        }
    }

    private String sendBuffer(BufferedReader bufferedReader, BufferedWriter bufferedWriter, String string) throws CMyMailException {
        try {
            bufferedWriter.write(string + "\r\n");
            bufferedWriter.flush();
            this.mailLog.recordSendLogs(string, 1);
            String string2 = this.getResponse(bufferedReader);
            this.mailLog.recordSendLogs(string2, 2);
            return string2;
        }
        catch (Exception exception) {
            throw new CMyMailException(I18NMessage.get(TRSMailer.class, "TRSMailer.label49", "\u4ece\u90ae\u4ef6\u670d\u52a1\u5668\u8bfb\u5199\u6570\u636e\u65f6\u53d1\u751f\u9519\u8bef\uff01") + exception.toString());
        }
    }

    private void sendFiles(String string, String string2, BufferedWriter bufferedWriter) {
        if (string2 == null || string2.length() <= 0) {
            return;
        }
        if (!CMyFile.fileExists(string2)) {
            s_logger.info((Object)("not file[" + string2 + "]"));
            return;
        }
        String string3 = "------TRS_Email_Maker\r\n";
        string3 = string3 + "Content-Type: application/octet-stream; name=\"" + string + "\"" + "\r\n";
        string3 = string3 + "Content-Disposition: attachment; filename=\"" + string + "\"" + "\r\n";
        string3 = string3 + "Content-Transfer-Encoding: base64\r\n";
        string3 = string3 + "\r\n";
        try {
            bufferedWriter.write(string3);
            bufferedWriter.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
        MIMEBase64.encode(string2, bufferedWriter);
        string3 = "\r\n";
        try {
            bufferedWriter.write(string3);
            bufferedWriter.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void sendBuffer(BufferedWriter bufferedWriter, String string) throws CMyMailException {
        try {
            int n = 2048;
            int n2 = string.length() / n;
            String string2 = "";
            for (int i = 0; i < n2; ++i) {
                string2 = string.substring(i * n, (i + 1) * n);
                bufferedWriter.write(string2);
                bufferedWriter.flush();
            }
            string2 = string.substring(n2 * n, string.length());
            bufferedWriter.write(string2 + "\r\n");
            bufferedWriter.flush();
            this.mailLog.recordSendLogs(string, 1);
        }
        catch (Exception exception) {
            throw new CMyMailException(I18NMessage.get(TRSMailer.class, "TRSMailer.label50", "\u4ece\u90ae\u4ef6\u670d\u52a1\u5668\u8bfb\u5199\u6570\u636e\u65f6\u53d1\u751f\u9519\u8bef\u3002") + exception.toString());
        }
    }

    private void sendMailBuffer(BufferedReader bufferedReader, BufferedWriter bufferedWriter, String string, String string2) throws CMyMailException {
        String string3 = this.sendBuffer(bufferedReader, bufferedWriter, string);
        if (this.isResponseError(string3)) {
            throw new CMyMailException(string2 + "\uff08" + string3 + "\uff09");
        }
    }

    private boolean isResponseError(String string) {
        if (string == null || string.trim().length() < 3) {
            s_logger.error((Object)I18NMessage.get(TRSMailer.class, "TRSMailer.label51", "\u65e0\u6cd5\u8bc6\u522b\u90ae\u4ef6\u670d\u52a1\u5668\u7684\u54cd\u5e94\uff0c\u8ba4\u4e3a\u662f\u9519\u8bef\u3002"));
            return true;
        }
        String string2 = string.substring(0, 3);
        int n = this.parseCode(string2);
        return n >= 500 && n < 600;
    }

    private void closeSocket(Socket socket, BufferedWriter bufferedWriter, BufferedReader bufferedReader) {
        try {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            if (bufferedWriter != null) {
                bufferedWriter.close();
            }
            if (socket != null) {
                socket.close();
            }
        }
        catch (Exception exception) {
            this.mailLog.appendSendLogs(I18NMessage.get(TRSMailer.class, "TRSMailer.label52", "---- \u5173\u95ed\u8fde\u63a5\u5931\u8d25\uff01 ----"));
        }
    }
}

