/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.email;

import com.trs.infra.I18NMessage;
import com.trs.infra.util.CMyClassConfig;
import com.trs.infra.util.email.CMyMailException;
import com.trs.infra.util.email.SMTPServerConfig;
import com.trs.infra.util.email.SMTPServerConfigMapper;
import java.io.IOException;
import java.net.Socket;
import javax.net.ssl.SSLSocketFactory;

public class CMySMTPServer
extends CMyClassConfig {
    private static final int DEFAULT_PORT = 25;
    private static final boolean DEFAULT_AUTH = true;
    private String m_sServerName;
    private int m_sServerPort = 25;
    private boolean m_bAuth = true;
    private String m_sUserName;
    private String m_sPassword;
    private boolean m_bSSLServer = false;

    public void setServerName(String string) {
        this.m_sServerName = string;
    }

    public String getServerName() {
        return this.m_sServerName;
    }

    public void setServerPort(int n) {
        this.m_sServerPort = n;
    }

    public int getServerPort() {
        return this.m_sServerPort;
    }

    public void setAuth(boolean bl) {
        this.m_bAuth = bl;
    }

    public boolean needAuth() {
        return this.m_bAuth;
    }

    public void setUserName(String string) {
        this.m_sUserName = string;
    }

    public String getUserName() {
        return this.m_sUserName;
    }

    public void setPassword(String string) {
        this.m_sPassword = string;
    }

    public String getPassword() {
        return this.m_sPassword;
    }

    public void setSMTPConfig(SMTPServerConfig sMTPServerConfig) {
        this.setServerName(sMTPServerConfig.getName());
        this.setServerPort(sMTPServerConfig.getPort());
        this.setAuth(sMTPServerConfig.isAuth());
        this.setUserName(sMTPServerConfig.getUserName());
        this.setPassword(sMTPServerConfig.getPassword());
    }

    public static CMySMTPServer getDefaultSMTPServer() {
        CMySMTPServer cMySMTPServer = new CMySMTPServer();
        SMTPServerConfig sMTPServerConfig = SMTPServerConfigMapper.getInstance().getDefaultSMTPServerConfig();
        cMySMTPServer.setSMTPConfig(sMTPServerConfig);
        return cMySMTPServer;
    }

    public static CMySMTPServer getSMTPServerByName(String string) {
        CMySMTPServer cMySMTPServer = new CMySMTPServer();
        SMTPServerConfig sMTPServerConfig = SMTPServerConfigMapper.getInstance().getSMTPServerConfigByName(string);
        cMySMTPServer.setSMTPConfig(sMTPServerConfig);
        return cMySMTPServer;
    }

    public void validate() throws CMyMailException {
        if (this.getServerName() == null || this.getServerName().length() == 0) {
            throw new CMyMailException(I18NMessage.get(CMySMTPServer.class, "CMySMTPServer.label1", "\u90ae\u4ef6\u670d\u52a1\u5668\u540d\u79f0\u65e0\u6548\uff01"));
        }
        if (this.getServerPort() == 0) {
            throw new CMyMailException(I18NMessage.get(CMySMTPServer.class, "CMySMTPServer.label2", "\u90ae\u4ef6\u670d\u52a1\u5668\u7aef\u53e3\u4e0d\u80fd\u4e3a0\uff01"));
        }
    }

    public boolean canAuth() {
        return this.getUserName() != null && this.getPassword() != null;
    }

    public boolean isSSLServer() {
        return this.m_bSSLServer;
    }

    public void setSSLServer(boolean bl) {
        this.m_bSSLServer = bl;
    }

    public Socket createSocket() throws IOException {
        if (this.isSSLServer()) {
            SSLSocketFactory sSLSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
            return sSLSocketFactory.createSocket(this.getServerName(), this.getServerPort());
        }
        return new Socket(this.getServerName(), this.getServerPort());
    }

    public String toString() {
        String string = "SMTP Server: " + this.getServerName() + ":" + this.getServerPort() + "\r\n";
        string = this.needAuth() ? string + "need auth, username: " + this.getUserName() + "" : string + "do not need auth.";
        return string;
    }
}

