/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util;

import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyString;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public final class Report {
    public static final int TYPE_ERROR = 5;
    public static final int TYPE_WARN = 4;
    public static final int TYPE_INFO = 3;
    public static final int TYPE_DEBUG = 2;
    private int m_nType = 3;
    private String m_sRportTitle;
    private String m_sRportDetail;
    private Object m_oRelateObject = null;

    public Report(String string, Throwable throwable) {
        this.m_sRportTitle = string;
        if (throwable != null) {
            this.setType(5);
            this.m_sRportDetail = CMyException.getStackTraceText(throwable);
        }
    }

    public Report(String string) {
        this.m_sRportTitle = string;
    }

    public String getRportDetail() {
        return this.m_sRportDetail;
    }

    public String getRportTitle() {
        return this.m_sRportTitle;
    }

    public String toString() {
        return this.m_sRportTitle + "\n Detail: " + CMyString.showNull(this.m_sRportDetail);
    }

    public Element toXMLElement(boolean bl) {
        Element element = DocumentHelper.createElement((String)"REPORT");
        element.addElement("IS" + (bl ? "_" : "-") + "SUCCESS").addText(this.getType() != 5 ? "true" : "false");
        if (CMyString.containsCDATAStr(this.m_sRportTitle)) {
            element.addElement("TITLE").addText(this.m_sRportTitle);
        } else {
            element.addElement("TITLE").addCDATA(this.m_sRportTitle);
        }
        element.addElement("TYPE").addText(String.valueOf(this.getType()));
        if (this.m_sRportDetail != null) {
            if (CMyString.containsCDATAStr(this.m_sRportDetail)) {
                element.addElement("ERROR" + (bl ? "_" : "-") + "INFO").addText(this.m_sRportDetail);
            } else {
                element.addElement("ERROR" + (bl ? "_" : "-") + "INFO").addCDATA(this.m_sRportDetail);
            }
        }
        return element;
    }

    public String toXML() {
        return this.toXMLElement(false).asXML();
    }

    public String toJSONXML() {
        return this.toXMLElement(true).asXML();
    }

    public int getType() {
        return this.m_nType;
    }

    public void setType(int n) {
        this.m_nType = n;
    }

    public void setRportDetail(String string) {
        this.m_sRportDetail = string;
    }

    public void setRportTitle(String string) {
        this.m_sRportTitle = string;
    }

    public Object getRelateObject() {
        return this.m_oRelateObject;
    }

    public void setRelateObject(Object object) {
        this.m_oRelateObject = object;
    }
}

