/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.update;

import com.trs.infra.BaseServer;
import com.trs.infra.I18NMessage;
import com.trs.infra.config.ConfigConstants;
import com.trs.infra.config.XMLConfigServer;
import com.trs.infra.update.UpdateCommanderConfig;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import java.util.List;
import org.apache.log4j.Logger;

public class UpdateServer
extends BaseServer {
    private static Logger s_logger = Logger.getLogger(UpdateServer.class);
    private static String FILE_UPDATE_LOG = ConfigConstants.DIR_APPROOT + "update.log";

    protected void doShutdown() {
    }

    protected boolean doStart() {
        String string = FILE_UPDATE_LOG;
        if (CMyFile.fileExists(string)) {
            try {
                s_logger.info((Object)(I18NMessage.get(UpdateServer.class, "UpdateServer.label1", "\u5df2\u7ecf\u4e8e[") + CMyFile.readFile(string) + I18NMessage.get(UpdateServer.class, "UpdateServer.label2", "]\u5347\u7ea7\u8fc7\u7cfb\u7edf\uff01")));
            }
            catch (CMyException cMyException) {
                // empty catch block
            }
            return true;
        }
        List list = XMLConfigServer.getInstance().getConfigObjects(UpdateCommanderConfig.class);
        if (list == null) {
            return true;
        }
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            UpdateCommanderConfig updateCommanderConfig = (UpdateCommanderConfig)list.get(i);
            if (updateCommanderConfig == null) continue;
            updateCommanderConfig.getCommander().doUpdate();
            s_logger.info((Object)("[" + updateCommanderConfig.getName() + I18NMessage.get(UpdateServer.class, "UpdateServer.label3", "]\u6267\u884c\u6210\u529f!")));
        }
        try {
            CMyFile.writeFile(string, CMyDateTime.now().toString());
        }
        catch (Exception exception) {
            s_logger.error((Object)I18NMessage.get(UpdateServer.class, "UpdateServer.label4", "\u8bb0\u5f55\u5347\u7ea7\u4fe1\u606f\u5931\u8d25\uff01"), (Throwable)exception);
        }
        return true;
    }

    static {
        s_logger.info((Object)("file:" + FILE_UPDATE_LOG));
    }
}

