/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.support.log;

import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.common.WCMTypes;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.support.log.ILog;
import com.trs.infra.support.log.Log;
import com.trs.infra.support.log.LogType;
import com.trs.infra.support.log.OperType;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;

public abstract class BaseDBLog
extends BaseObj
implements ILog {
    public boolean isValid() throws WCMException {
        if (this.isAddMode()) {
            if (this.getProperty("LOGTYPE") == null) {
                throw new WCMException(1106, I18NMessage.get(BaseDBLog.class, "BaseDBLog.label1", "\u5c5e\u6027Type\u6ca1\u6709\u8bbe\u7f6e(Log.isValid)"));
            }
            if (this.getProperty("LOGOBJTYPE") == null) {
                throw new WCMException(1106, I18NMessage.get(BaseDBLog.class, "BaseDBLog.label2", "\u5c5e\u6027ObjType\u6ca1\u6709\u8bbe\u7f6e(Log.isValid)"));
            }
            if (this.getProperty("LOGOBJID") == null) {
                throw new WCMException(1106, I18NMessage.get(BaseDBLog.class, "BaseDBLog.label3", "\u5c5e\u6027ObjId\u6ca1\u6709\u8bbe\u7f6e(Log.isValid)"));
            }
            if (this.getProperty("LOGRESULT") == null) {
                throw new WCMException(1106, I18NMessage.get(BaseDBLog.class, "BaseDBLog.label4", "\u5c5e\u6027Result\u6ca1\u6709\u8bbe\u7f6e(Log.isValid)"));
            }
        } else if (!this.isModified()) {
            throw new WCMException(1107, I18NMessage.get(BaseDBLog.class, "BaseDBLog.label5", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(Log.isValid)"));
        }
        return true;
    }

    public LogType getLogType() throws WCMException {
        int n = this.getPropertyAsInt("LOGTYPE", 0);
        return LogType.findById(n);
    }

    public boolean setLogType(int n) throws WCMException {
        return this.setProperty("LOGTYPE", n);
    }

    public boolean setLogType(LogType logType) throws WCMException {
        if (logType == null) {
            throw new WCMException(10, I18NMessage.get(BaseDBLog.class, "BaseDBLog.label6", "\u65e0\u6548\u7684\u65e5\u5fd7\u7c7b\u578b\u5bf9\u8c61(Log.setLogType)"));
        }
        return this.setLogType(logType.getId());
    }

    public int getOpType() {
        return this.getPropertyAsInt("LOGOPTYPE", 0);
    }

    public boolean setOpType(int n) throws WCMException {
        return this.setProperty("LOGOPTYPE", n);
    }

    public String getDesc() {
        return (String)this.getProperty("LOGDESC");
    }

    public boolean setDesc(String string) throws WCMException {
        return this.setProperty("LOGDESC", string);
    }

    public String getUserName() {
        return (String)this.getProperty("LOGUSER");
    }

    public boolean setUser(String string) throws WCMException {
        return this.setProperty("LOGUSER", string == null ? "" : string);
    }

    public int getObjType() {
        return this.getPropertyAsInt("LOGOBJTYPE", 0);
    }

    public boolean setObjType(int n) throws WCMException {
        return this.setProperty("LOGOBJTYPE", n);
    }

    public int getObjId() {
        return this.getPropertyAsInt("LOGOBJID", 0);
    }

    public boolean setObj(BaseObj baseObj) throws WCMException {
        this.setObjType(baseObj.getWCMType());
        this.setObjId(baseObj.getId());
        String string = baseObj.getPropertyAsString("NAME");
        if (string == null) {
            string = baseObj.toString();
        }
        if (string.indexOf(91) == -1) {
            String string2 = WCMTypes.getObjName(baseObj.getWCMType(), true);
            if ("Unknown".equalsIgnoreCase(string2)) {
                string2 = baseObj.getClassName(false);
            }
            string = string + " [" + string2 + "-" + baseObj.getId() + "]";
        }
        this.setObjName(string);
        return true;
    }

    public boolean setObjId(int n) throws WCMException {
        return this.setProperty("LOGOBJID", n);
    }

    public String getObjName() {
        return (String)this.getProperty("LOGOBJNAME");
    }

    public boolean setObjName(String string) throws WCMException {
        string = CMyString.truncateStr(string, 450);
        return this.setProperty("LOGOBJNAME", string);
    }

    public int getOpTypeId() {
        return this.getPropertyAsInt("LOGOPTYPE", 0);
    }

    public boolean setObjTypeId(int n) throws WCMException {
        return this.setProperty("LOGOPTYPE", n);
    }

    public String getOpArgs() {
        return (String)this.getProperty("LOGOPARGS");
    }

    public boolean setOpArgs(String string) throws WCMException {
        return this.setProperty("LOGOPARGS", string);
    }

    public int getResult() {
        return this.getPropertyAsInt("LOGRESULT", 0);
    }

    public boolean setResult(int n) throws WCMException {
        return this.setProperty("LOGRESULT", n);
    }

    public CMyDateTime getOpTime() {
        return (CMyDateTime)this.getProperty("LOGOPTIME");
    }

    public boolean setOpTime(CMyDateTime cMyDateTime) throws WCMException {
        return this.setProperty("LOGOPTIME", cMyDateTime);
    }

    public boolean setOpTime() throws WCMException {
        CMyDateTime cMyDateTime = new CMyDateTime();
        cMyDateTime.setDateTimeWithCurrentTime();
        return this.setProperty("LOGOPTIME", cMyDateTime);
    }

    public int getTopLogId() {
        return this.getPropertyAsInt("TOPID", 0);
    }

    public boolean setTopLogId(int n) throws WCMException {
        return this.setProperty("TOPID", n);
    }

    public String getLogUserIP() {
        return this.getPropertyAsString("LOGUSERIP");
    }

    public boolean setLogUserIP(String string) throws WCMException {
        return this.setProperty("LOGUSERIP", string);
    }

    protected ILog save(String string, int n, String string2, int n2, BaseObj baseObj) throws WCMException {
        Log log = new Log();
        log.setDesc(string2);
        log.setLogType(n2);
        log.setOpType(n);
        log.setUser(string);
        log.setObjName(baseObj.toString());
        log.setObjId(baseObj.getId());
        log.setObjType(baseObj.getWCMType());
        log.setResult(1);
        log.insert();
        return log;
    }

    public void saveLog() throws WCMException {
        super.save();
    }

    public boolean deleteLog() throws WCMException {
        return super.delete() == 1;
    }

    public boolean setStartTimeMillis(long l) throws WCMException {
        return this.setProperty("STimeMillis", l);
    }

    public long getStartTimeMillis() {
        return this.getPropertyAsLong("STimeMillis", System.currentTimeMillis());
    }

    public boolean setEndTimeMillis(long l) throws WCMException {
        return this.setProperty("ETimeMillis", l);
    }

    public boolean setExecTime(long l) throws WCMException {
        return this.setProperty("ExecTime", l);
    }

    public long getExecTime() {
        return this.getPropertyAsLong("ExecTime", 0L);
    }

    public void loadByStartId(long l) throws WCMException {
        this.loadById((int)l, "LOGID,TOPID,LOGDESC,STIMEMILLIS,LOGOBJTYPE,LOGOBJID,LOGOBJNAME");
    }

    public String getOperTypeDesc() throws WCMException {
        int n = this.getOpType();
        OperType operType = OperType.findById(n);
        return operType != null ? operType.getDesc() : I18NMessage.get(BaseDBLog.class, "BaseDBLog.label9", "\u672a\u77e5");
    }

    public long getStartId() {
        return this.getId();
    }
}

