/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.persistent.listener;

import com.trs.DreamFactory;
import com.trs.infra.BaseServer;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.config.XMLConfigServer;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.listener.IObjectLCListener;
import com.trs.infra.persistent.listener.IObjectLCListenerOnAdd;
import com.trs.infra.persistent.listener.IObjectLCListenerOnBeforeAdd;
import com.trs.infra.persistent.listener.IObjectLCListenerOnDel;
import com.trs.infra.persistent.listener.IObjectLCListenerOnModify;
import com.trs.infra.persistent.listener.MonitorHostConfig;
import com.trs.infra.persistent.listener.ObjectLCListenerConfig;
import com.trs.infra.util.CMyString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ObjectLCMonitorServer
extends BaseServer
implements IObjectLCListenerOnBeforeAdd,
IObjectLCListenerOnAdd,
IObjectLCListenerOnDel,
IObjectLCListenerOnModify {
    public static final int EVENT_TYPE_ADD_BEFORE = -1;
    public static final int EVENT_TYPE_ADD = 1;
    public static final int EVENT_TYPE_EDIT_AFTER = 2;
    public static final int EVENT_TYPE_DELETE_BEFORE = 3;
    public static final int EVENT_TYPE_DELETE_AFTER = 4;
    public static final int EVENT_TYPE_EDIT_BEFORE = 5;
    public static final int[] EVENT_TYPES = new int[]{-1, 1, 2, 3, 4, 5};
    public static final int[] EVENT_TYPES_DEFAULT = new int[]{1, 2, 3};
    private Map m_hmListenersIndexs = null;

    public static ObjectLCMonitorServer getMonitorServer() {
        return (ObjectLCMonitorServer)DreamFactory.createObjectById("ObjectLCMonitorServer");
    }

    public IObjectLCListener[] getListeners(int n, BaseObj baseObj) {
        return (IObjectLCListener[])this.getListenersIndexs().get(this.makeKey(n, baseObj.getClass().getName()));
    }

    public IObjectLCListener[] getListeners(int n, Class clazz) {
        return (IObjectLCListener[])this.getListenersIndexs().get(this.makeKey(n, clazz.getName()));
    }

    public boolean isDoNotify(int n, BaseObj baseObj) {
        return this.getListenersIndexs().containsKey(this.makeKey(n, baseObj.getClass().getName()));
    }

    private String makeKey(int n, String string) {
        return string + "_" + n;
    }

    public void notifyOnBeforeAddObj(BaseObj baseObj) throws WCMException {
        IObjectLCListener[] iObjectLCListenerArray = this.getListeners(-1, baseObj);
        for (int i = 0; i < iObjectLCListenerArray.length; ++i) {
            try {
                ((IObjectLCListenerOnBeforeAdd)iObjectLCListenerArray[i]).notifyOnBeforeAddObj(baseObj);
                continue;
            }
            catch (ClassCastException classCastException) {
                throw new WCMException(I18NMessage.get(ObjectLCMonitorServer.class, "ObjectLCMonitorServer.label1", "\u6307\u5b9a\u7684Listener[") + iObjectLCListenerArray[i].getClass().getName() + I18NMessage.get(ObjectLCMonitorServer.class, "ObjectLCMonitorServer.label2", "]\u4e0d\u662f[") + IObjectLCListenerOnBeforeAdd.class + I18NMessage.get(ObjectLCMonitorServer.class, "ObjectLCMonitorServer.label3", "]\u7684\u5b9e\u73b0\uff01"));
            }
        }
    }

    public void notifyOnAddObj(BaseObj baseObj) throws WCMException {
        IObjectLCListener[] iObjectLCListenerArray = this.getListeners(1, baseObj);
        for (int i = 0; i < iObjectLCListenerArray.length; ++i) {
            try {
                ((IObjectLCListenerOnAdd)iObjectLCListenerArray[i]).notifyOnAddObj(baseObj);
                continue;
            }
            catch (ClassCastException classCastException) {
                throw new WCMException(I18NMessage.get(ObjectLCMonitorServer.class, "ObjectLCMonitorServer.label1", "\u6307\u5b9a\u7684Listener[") + iObjectLCListenerArray[i].getClass().getName() + I18NMessage.get(ObjectLCMonitorServer.class, "ObjectLCMonitorServer.label2", "]\u4e0d\u662f[") + IObjectLCListenerOnAdd.class + I18NMessage.get(ObjectLCMonitorServer.class, "ObjectLCMonitorServer.label3", "]\u7684\u5b9e\u73b0\uff01"));
            }
        }
    }

    public void notifyOnDelObj(BaseObj baseObj, int n) throws WCMException {
        IObjectLCListener[] iObjectLCListenerArray = this.getListeners(n, baseObj);
        for (int i = 0; i < iObjectLCListenerArray.length; ++i) {
            try {
                ((IObjectLCListenerOnDel)iObjectLCListenerArray[i]).notifyOnDelObj(baseObj, n);
                continue;
            }
            catch (ClassCastException classCastException) {
                throw new WCMException(I18NMessage.get(ObjectLCMonitorServer.class, "ObjectLCMonitorServer.label1", "\u6307\u5b9a\u7684Listener[") + iObjectLCListenerArray[i].getClass().getName() + I18NMessage.get(ObjectLCMonitorServer.class, "ObjectLCMonitorServer.label2", "]\u4e0d\u662f[") + IObjectLCListenerOnDel.class + I18NMessage.get(ObjectLCMonitorServer.class, "ObjectLCMonitorServer.label3", "]\u7684\u5b9e\u73b0\uff01"));
            }
        }
    }

    public void notifyOnModifyObj(BaseObj baseObj, int n) throws WCMException {
        IObjectLCListener[] iObjectLCListenerArray = this.getListeners(n, baseObj);
        for (int i = 0; i < iObjectLCListenerArray.length; ++i) {
            try {
                ((IObjectLCListenerOnModify)iObjectLCListenerArray[i]).notifyOnModifyObj(baseObj, n);
                continue;
            }
            catch (ClassCastException classCastException) {
                throw new WCMException(I18NMessage.get(ObjectLCMonitorServer.class, "ObjectLCMonitorServer.label1", "\u6307\u5b9a\u7684Listener[") + iObjectLCListenerArray[i].getClass().getName() + I18NMessage.get(ObjectLCMonitorServer.class, "ObjectLCMonitorServer.label2", "]\u4e0d\u662f[") + IObjectLCListenerOnModify.class + I18NMessage.get(ObjectLCMonitorServer.class, "ObjectLCMonitorServer.label3", "]\u7684\u5b9e\u73b0\uff01"), classCastException);
            }
        }
    }

    private Map getListenersIndexs() {
        if (this.m_hmListenersIndexs == null) {
            this.loadConfig();
        }
        return this.m_hmListenersIndexs;
    }

    private void clear() {
        this.m_hmListenersIndexs.clear();
        this.m_hmListenersIndexs = null;
    }

    private void loadConfig() {
        if (this.m_hmListenersIndexs != null) {
            return;
        }
        List list = XMLConfigServer.getInstance().getConfigObjects(MonitorHostConfig.class);
        this.m_hmListenersIndexs = new HashMap(list.size());
        for (int i = 0; i < list.size(); ++i) {
            this.loadListeners((MonitorHostConfig)list.get(i));
        }
    }

    private void loadListeners(MonitorHostConfig monitorHostConfig) {
        if (monitorHostConfig.getListeners().size() <= 0) {
            return;
        }
        for (int i = 0; i < EVENT_TYPES.length; ++i) {
            List list = this.findListenerConfigsByEventType(EVENT_TYPES[i], monitorHostConfig.getListeners());
            this.loadListeners(list, this.makeKey(EVENT_TYPES[i], monitorHostConfig.getClassName()));
        }
    }

    private List findListenerConfigsByEventType(int n, List list) {
        if (list.size() <= 0) {
            return null;
        }
        ArrayList<ObjectLCListenerConfig> arrayList = new ArrayList<ObjectLCListenerConfig>();
        block0: for (int i = 0; i < list.size(); ++i) {
            ObjectLCListenerConfig objectLCListenerConfig = (ObjectLCListenerConfig)list.get(i);
            int[] nArray = null;
            String string = objectLCListenerConfig.getEventType();
            nArray = string == null || string.trim().length() == 0 ? EVENT_TYPES_DEFAULT : CMyString.splitToInt(string, ",");
            for (int j = 0; j < nArray.length; ++j) {
                if (nArray[j] != n) continue;
                arrayList.add(objectLCListenerConfig);
                continue block0;
            }
        }
        return arrayList;
    }

    private void loadListeners(List list, String string) {
        int n;
        int n2 = list.size();
        if (n2 <= 0) {
            return;
        }
        IObjectLCListener[] iObjectLCListenerArray = (IObjectLCListener[])this.m_hmListenersIndexs.get(string);
        if (iObjectLCListenerArray == null) {
            iObjectLCListenerArray = new IObjectLCListener[]{};
        }
        IObjectLCListener[] iObjectLCListenerArray2 = new IObjectLCListener[n2 + iObjectLCListenerArray.length];
        for (n = 0; n < iObjectLCListenerArray.length; ++n) {
            iObjectLCListenerArray2[n] = iObjectLCListenerArray[n];
        }
        for (n = 0; n < n2; ++n) {
            ObjectLCListenerConfig objectLCListenerConfig = (ObjectLCListenerConfig)list.get(n);
            iObjectLCListenerArray2[n + iObjectLCListenerArray.length] = objectLCListenerConfig.getBean();
        }
        this.m_hmListenersIndexs.put(string, iObjectLCListenerArray2);
        iObjectLCListenerArray = null;
    }

    public Map getListenersMap() {
        return this.m_hmListenersIndexs;
    }

    protected void doShutdown() {
        this.clear();
    }

    protected boolean doStart() {
        this.loadConfig();
        return true;
    }
}

