/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra;

import com.trs.DreamFactory;
import com.trs.infra.I18NMessage;
import com.trs.infra.IServer;
import com.trs.infra.ServerConfig;
import com.trs.infra.common.WCMException;
import com.trs.infra.config.XMLConfigServer;
import com.trs.infra.persistent.db.DBManager;
import java.util.List;
import org.apache.log4j.Logger;

public class ServerControl {
    private static Logger s_logger = Logger.getLogger(ServerControl.class);
    private IServer[] m_arServers = null;
    private boolean m_bStarted;
    public static final String APP_VERSION = "6.0";
    private DBManager dbMgr = null;

    public static ServerControl createInstance() {
        return (ServerControl)DreamFactory.createObjectById("ServerControl");
    }

    public int getServerCount() {
        return this.getServers().length;
    }

    public IServer[] getServers() {
        if (this.m_arServers == null) {
            this.loadConfig();
        }
        return this.m_arServers;
    }

    private void loadConfig() {
        ServerConfig serverConfig;
        int n;
        List list = XMLConfigServer.getInstance().getConfigObjects(ServerConfig.class);
        if (list == null || list.size() == 0) {
            return;
        }
        this.m_arServers = new IServer[list.size()];
        int n2 = 0;
        for (n = 0; n < list.size(); ++n) {
            serverConfig = (ServerConfig)list.get(n);
            try {
                if (serverConfig.getBean().getClass().getName().indexOf("com.trs.infra") < 0) continue;
                if (s_logger.isDebugEnabled()) {
                    s_logger.debug((Object)("begin to load '" + serverConfig.getName() + "' [id=" + serverConfig.getBeanId() + "] from config"));
                }
                this.m_arServers[n2] = serverConfig.getBean();
                ++n2;
                continue;
            }
            catch (ClassCastException classCastException) {
                s_logger.error((Object)(I18NMessage.get(ServerControl.class, "ServerControl.label1", "\u670d\u52a1[") + serverConfig.getName() + "][" + serverConfig.getBeanId() + I18NMessage.get(ServerControl.class, "ServerControl.label2", "]\u6ca1\u6709\u5b9e\u73b0IServer")), (Throwable)classCastException);
            }
        }
        for (n = 0; n < list.size(); ++n) {
            serverConfig = (ServerConfig)list.get(n);
            try {
                if (serverConfig.getBean().getClass().getName().indexOf("com.trs.infra.") >= 0) continue;
                if (s_logger.isDebugEnabled()) {
                    s_logger.debug((Object)("begin to load '" + serverConfig.getName() + "' [id=" + serverConfig.getBeanId() + "] from config"));
                }
                this.m_arServers[n2] = serverConfig.getBean();
                ++n2;
                continue;
            }
            catch (ClassCastException classCastException) {
                s_logger.error((Object)(I18NMessage.get(ServerControl.class, "ServerControl.label1", "\u670d\u52a1[") + serverConfig.getName() + "][" + serverConfig.getBeanId() + I18NMessage.get(ServerControl.class, "ServerControl.label2", "]\u6ca1\u6709\u5b9e\u73b0IServer")), (Throwable)classCastException);
            }
        }
    }

    protected void doShutdown() {
        if (this.m_arServers == null || this.dbMgr == null) {
            if (this.dbMgr != null) {
                this.dbMgr.shutdown();
            }
            this.m_arServers = null;
            this.m_bStarted = false;
            return;
        }
        for (int i = this.m_arServers.length - 1; i >= 0; --i) {
            if (this.getServers()[i] == null) continue;
            try {
                s_logger.info((Object)(I18NMessage.get(ServerControl.class, "ServerControl.label3", "\u6b63\u5728\u5173\u95ed\u670d\u52a1\u5668[") + this.m_arServers[i].getServerName() + "]"));
                this.m_arServers[i].shutdown();
            }
            catch (Exception exception) {
                s_logger.error((Object)(I18NMessage.get(ServerControl.class, "ServerControl.label4", "\u5173\u95ed\u670d\u52a1\u5668[") + this.m_arServers[i].getServerName() + I18NMessage.get(ServerControl.class, "ServerControl.label5", "]\u65f6\u53d1\u751f\u5f02\u5e38!")), (Throwable)exception);
            }
            s_logger.info((Object)(I18NMessage.get(ServerControl.class, "ServerControl.label6", "\u670d\u52a1\u5668[") + this.m_arServers[i].getServerName() + I18NMessage.get(ServerControl.class, "ServerControl.label7", "]\u5df2\u6210\u529f\u5173\u95ed!")));
        }
        this.m_arServers = null;
        this.m_bStarted = false;
        this.dbMgr.shutdown();
        s_logger.info((Object)I18NMessage.get(ServerControl.class, "ServerControl.label8", "\u6570\u636e\u5e93\u670d\u52a1\u5668\u5173\u95ed!"));
    }

    protected boolean doStart() throws WCMException {
        if (this.m_bStarted) {
            return true;
        }
        this.dbMgr = DBManager.getDBManager();
        int n = this.getServerCount();
        for (int i = 0; i < n; ++i) {
            IServer iServer = this.getServers()[i];
            if (iServer == null) continue;
            s_logger.info((Object)(I18NMessage.get(ServerControl.class, "ServerControl.label1", "\u670d\u52a1[") + iServer.getServerName() + I18NMessage.get(ServerControl.class, "ServerControl.label10", "]\u6b63\u5728\u542f\u52a8\uff01")));
            if (!iServer.startup()) {
                s_logger.info((Object)(I18NMessage.get(ServerControl.class, "ServerControl.label1", "\u670d\u52a1[") + iServer.getServerName() + I18NMessage.get(ServerControl.class, "ServerControl.label9", "]\u542f\u52a8\u5931\u8d25\uff01")));
            } else {
                s_logger.info((Object)(I18NMessage.get(ServerControl.class, "ServerControl.label1", "\u670d\u52a1[") + iServer.getServerName() + I18NMessage.get(ServerControl.class, "ServerControl.label10", "]\u542f\u52a8\u6210\u529f\uff01")));
            }
            if (iServer.getErrors().isEmpty()) continue;
            s_logger.error((Object)(I18NMessage.get(ServerControl.class, "ServerControl.label1", "\u670d\u52a1[") + iServer.getServerName() + I18NMessage.get(ServerControl.class, "ServerControl.label11", "]\u542f\u52a8\u51fa\u73b0\u9519\u8bef\uff1a\n") + iServer.getErrors()));
        }
        s_logger.info((Object)I18NMessage.get(ServerControl.class, "ServerControl.label12", "\u5e94\u7528\u542f\u52a8\u5b8c\u6210!"));
        this.m_bStarted = true;
        return true;
    }

    public boolean restart() {
        try {
            this.doShutdown();
            this.doStart();
        }
        catch (Exception exception) {
            s_logger.error((Object)I18NMessage.get(ServerControl.class, "ServerControl.label13", "\u65e0\u6cd5\u91cd\u65b0\u542f\u52a8\u670d\u52a1\u5668"), (Throwable)exception);
            return false;
        }
        return true;
    }

    public void startup() {
        try {
            if (!this.m_bStarted) {
                this.doStart();
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(I18NMessage.get(ServerControl.class, "ServerControl.label14", "\u65e0\u6cd5\u542f\u52a8\u670d\u52a1\u5668"), exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        try {
            try {
                ServerControl.createInstance().restart();
            }
            catch (Exception exception) {
                s_logger.error((Object)exception);
                Object var3_2 = null;
            }
            Object var3_1 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            throw throwable;
        }
    }

    public void shutdown() {
        this.doShutdown();
    }
}

