/*
 * Decompiled with CFR 0.152.
 */
package com.trs.devhelper;

import com.trs.infra.util.CMyFile;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class JsCombineFilter
implements Filter {
    private Logger logger = Logger.getLogger(JsCombineFilter.class);
    private HashMap resourceMap = new HashMap();
    private String m_sJsEncoding = "UTF-8";

    public void init(FilterConfig filterConfig) throws ServletException {
        Enumeration enumeration = filterConfig.getInitParameterNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = filterConfig.getInitParameter(string);
            String[] stringArray = string2.split(",");
            this.resourceMap.put(string, stringArray);
            this.logger.debug((Object)"put jscombinefilter parameters");
            this.logger.debug((Object)(string + ":" + string2));
        }
    }

    private void outContent(String string, StringBuffer stringBuffer) throws Exception {
        File file = new File(string);
        if (!file.exists()) {
            return;
        }
        if (file.isFile()) {
            String string2 = file.getAbsolutePath();
            if (string2.endsWith(".js")) {
                stringBuffer.append("/**--");
                stringBuffer.append(string2.replaceAll("\\\\", "/").replaceAll(".*/([^/]*.js)", "$1"));
                stringBuffer.append("--**/\n");
                stringBuffer.append(CMyFile.readFile(string2, this.m_sJsEncoding));
                stringBuffer.append("\n");
            }
        } else {
            File[] fileArray = file.listFiles();
            if (fileArray != null && fileArray.length > 0) {
                for (int i = 0; i < fileArray.length; ++i) {
                    this.outContent(fileArray[i].getAbsolutePath(), stringBuffer);
                }
            }
        }
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
        String string = httpServletRequest.getRequestURI();
        String string2 = string.replaceAll("/[^/]*(/.*/)[^/]*.js", "$1");
        ServletContext servletContext = httpServletRequest.getSession().getServletContext();
        int n = string.lastIndexOf("/");
        String string3 = servletContext.getRealPath(string2);
        String string4 = string.substring(n + 1);
        String string5 = string4.replaceFirst("\\.[^\\.]*", "");
        String string6 = string4.replaceAll(".*\\.([^\\.]*)$", "$1");
        if (!string6.equals("js")) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        if (string2.endsWith("/app/js/data/opers/")) {
            this.doWithOpers(servletResponse, httpServletResponse, string3, string4, string5);
            return;
        }
        if (this.doWithResouceMapping(httpServletRequest, httpServletResponse)) {
            return;
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    private boolean doWithResouceMapping(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String string = httpServletRequest.getRequestURI();
        String string2 = httpServletRequest.getContextPath();
        String[] stringArray = (String[])this.resourceMap.get(string = string.substring(string2.length()));
        if (stringArray == null || stringArray.length <= 0) {
            return false;
        }
        ServletContext servletContext = httpServletRequest.getSession().getServletContext();
        int n = string.lastIndexOf("/");
        String string3 = string.substring(n + 1);
        String string4 = servletContext.getRealPath(string.substring(0, n));
        httpServletResponse.setContentType("text/javascript;charset=UTF-8");
        StringBuffer stringBuffer = new StringBuffer();
        try {
            String string5;
            for (int i = 0; i < stringArray.length; ++i) {
                string5 = string4 + File.separator + stringArray[i].trim();
                this.logger.debug((Object)("merge file:" + string5));
                this.outContent(string5, stringBuffer);
            }
            String string6 = new File(string4 + "/../../../runtime/".replace('/', File.separatorChar) + string3).getAbsolutePath();
            this.logger.debug((Object)("write merged file:" + string6));
            CMyFile.writeFile(string6, stringBuffer.toString(), this.m_sJsEncoding);
            string5 = httpServletResponse.getOutputStream();
            string5.println(stringBuffer.toString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return true;
    }

    private void doWithAbsList(ServletResponse servletResponse, HttpServletResponse httpServletResponse, String string, String string2, String string3) {
        servletResponse.setContentType("text/javascript;charset=UTF-8");
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = new String[]{"PageContext.js", "BubblePannel.js", "PageLayout.js", "PageFilter.js", "PageGrid.js", "PageOper.js", "PageNav.js", "PageTab.js", "PageLiterator.js", "KeyProvider.js"};
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                this.outContent(string + File.separator + stringArray[i], stringBuffer);
            }
            String string4 = new File(string + "/../../../runtime/".replace('/', File.separatorChar) + string2).getAbsolutePath();
            CMyFile.writeFile(string4, stringBuffer.toString(), this.m_sJsEncoding);
            ServletOutputStream servletOutputStream = servletResponse.getOutputStream();
            servletOutputStream.println(stringBuffer.toString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void doWithOpers(ServletResponse servletResponse, HttpServletResponse httpServletResponse, String string, String string2, String string3) {
        servletResponse.setContentType("text/javascript;charset=UTF-8");
        StringBuffer stringBuffer = new StringBuffer();
        try {
            this.outContent(string + File.separator + "../locale/" + string2, stringBuffer);
            this.outContent(string + File.separator + string2, stringBuffer);
            this.outContent(string + File.separator + string3, stringBuffer);
            String string4 = new File(string + "/../../runtime/opers/".replace('/', File.separatorChar) + string2).getAbsolutePath();
            CMyFile.writeFile(string4, stringBuffer.toString(), this.m_sJsEncoding);
            httpServletResponse.sendRedirect("../../runtime/opers/" + string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void destroy() {
    }
}

