/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.wcmx.media;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.wcmx.media.MediaRemindedAgent;
import com.trs.components.wcm.wcmx.media.MediaRemindedInfos;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;

public class MediaRemindedInfo
extends CMSObj {
    public static final int OBJ_TYPE = 4001;
    public static final String DB_TABLE_NAME = "XWCMMEDIAREMINDEDINFO";
    public static final String DB_ID_NAME = "MEDIAREMINDEDINFOID";

    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    public int getWCMType() {
        return 4001;
    }

    public int getUserID() {
        return this.getPropertyAsInt("USERID", 0);
    }

    public boolean setUserID(int n) throws WCMException {
        return this.setProperty("USERID", n);
    }

    public int getSourceId() {
        return this.getPropertyAsInt("SOURCEID", 0);
    }

    public boolean setSourceId(int n) throws WCMException {
        return this.setProperty("SOURCEID", n);
    }

    public int getFreqReminded() {
        return this.getPropertyAsInt("FREQREMINDED", 0);
    }

    public boolean setFreqReminded(int n) throws WCMException {
        return this.setProperty("FREQREMINDED", n);
    }

    public int getCurrMediaCount() {
        return this.getPropertyAsInt("CURRMEDIACOUNT", 0);
    }

    public boolean setCurrMediaCount(int n) throws WCMException {
        return this.setProperty("CURRMEDIACOUNT", n);
    }

    public boolean isValid() throws WCMException {
        if (this.isAddMode()) {
            if (this.getAllProperty().get("USERID") == null) {
                throw new WCMException(1106, I18NMessage.get(MediaRemindedInfo.class, "MediaRemindedInfo.label1", "\u5c5e\u6027UserID\u6ca1\u6709\u8bbe\u7f6e(MediaRemindedInfo.isValid)"));
            }
            if (this.getAllProperty().get("SOURCEID") == null) {
                throw new WCMException(1106, I18NMessage.get(MediaRemindedInfo.class, "MediaRemindedInfo.label2", "\u5c5e\u6027SourceId\u6ca1\u6709\u8bbe\u7f6e(MediaRemindedInfo.isValid)"));
            }
            if (this.getAllProperty().get("FREQREMINDED") == null) {
                throw new WCMException(1106, I18NMessage.get(MediaRemindedInfo.class, "MediaRemindedInfo.label3", "\u5c5e\u6027FreqReminded\u6ca1\u6709\u8bbe\u7f6e(MediaRemindedInfo.isValid)"));
            }
            if (this.getAllProperty().get("CURRMEDIACOUNT") == null) {
                this.setCurrMediaCount(0);
            }
        } else if (!this.isModified()) {
            throw new WCMException(1107, I18NMessage.get(MediaRemindedInfo.class, "MediaRemindedInfo.label4", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(MediaRemindedInfo.isValid)"));
        }
        return true;
    }

    public void insert(User user) throws WCMException {
        if (this.isAddMode() && this.getAllProperty() != null) {
            if (this.getAllProperty().get("CRUSER") == null) {
                this.setCrUser(user);
            }
            if (this.getAllProperty().get("CRTIME") == null) {
                this.setCrTime();
            }
            super.insert(user);
            MediaRemindedAgent.getInstance().putMediaRemindedInfoInCache(this);
        }
    }

    public int delete(User user) throws WCMException {
        int n = this.getUserID();
        int n2 = this.getSourceId();
        int n3 = super.delete(user);
        if (n3 > 0) {
            MediaRemindedAgent.getInstance().removeMediaRemindedInfoFromCache(n, n2);
        }
        return n3;
    }

    public synchronized void update(User user) throws WCMException {
        super.update(user);
        MediaRemindedAgent.getInstance().updateMediaRemindedCache(this);
    }

    public static final MediaRemindedInfo findById(User user, int n, String string) throws WCMException {
        MediaRemindedInfo mediaRemindedInfo;
        block6: {
            if (n <= 0) {
                throw new WCMException(10, I18NMessage.get(MediaRemindedInfo.class, "MediaRemindedInfo.label5", "\u6307\u5b9a\u5bf9\u8c61ID(") + n + I18NMessage.get(MediaRemindedInfo.class, "MediaRemindedInfo.label6", ")\u65e0\u6548\uff01"));
            }
            MediaRemindedInfos mediaRemindedInfos = null;
            MediaRemindedInfo mediaRemindedInfo2 = null;
            try {
                mediaRemindedInfos = new MediaRemindedInfos(user, 1, 1);
                mediaRemindedInfos.setMaxSize(1);
                mediaRemindedInfos.open(new WCMFilter("", "MEDIAREMINDEDINFOID=" + n, "", string));
                if (!mediaRemindedInfos.isEmpty()) {
                    mediaRemindedInfo2 = (MediaRemindedInfo)mediaRemindedInfos.getAt(0);
                }
                mediaRemindedInfo = mediaRemindedInfo2;
                Object var7_7 = null;
                if (mediaRemindedInfos == null) break block6;
            }
            catch (Exception exception) {
                try {
                    throw new WCMException(1100, I18NMessage.get(MediaRemindedInfo.class, "MediaRemindedInfo.label7", "\u63d0\u53d6ID=") + n + I18NMessage.get(MediaRemindedInfo.class, "MediaRemindedInfo.label8", "\u7684MediaRemindedInfo\u5bf9\u8c61\u5931\u8d25\uff01"), exception);
                }
                catch (Throwable throwable) {
                    block7: {
                        Object var7_8 = null;
                        if (mediaRemindedInfos == null) break block7;
                        mediaRemindedInfos.clear();
                    }
                    throw throwable;
                }
            }
            mediaRemindedInfos.clear();
        }
        return mediaRemindedInfo;
    }

    public static final MediaRemindedInfo findByUserAndSrc(User user, int n, int n2) throws WCMException {
        MediaRemindedInfo mediaRemindedInfo;
        block7: {
            if (n <= 0) {
                throw new WCMException(10, "UserID(" + n + I18NMessage.get(MediaRemindedInfo.class, "MediaRemindedInfo.label6", ")\u65e0\u6548\uff01"));
            }
            if (n2 <= 0) {
                throw new WCMException(10, "SourceId(" + n2 + I18NMessage.get(MediaRemindedInfo.class, "MediaRemindedInfo.label6", ")\u65e0\u6548\uff01"));
            }
            MediaRemindedInfos mediaRemindedInfos = null;
            MediaRemindedInfo mediaRemindedInfo2 = null;
            try {
                mediaRemindedInfos = new MediaRemindedInfos(user, 1, 1);
                mediaRemindedInfos.setMaxSize(1);
                mediaRemindedInfos.open(new WCMFilter("", "SourceId=" + n2 + " and UserId=" + n, ""));
                if (!mediaRemindedInfos.isEmpty()) {
                    mediaRemindedInfo2 = (MediaRemindedInfo)mediaRemindedInfos.getAt(0);
                }
                mediaRemindedInfo = mediaRemindedInfo2;
                Object var7_7 = null;
                if (mediaRemindedInfos == null) break block7;
            }
            catch (Exception exception) {
                try {
                    throw new WCMException(1100, I18NMessage.get(MediaRemindedInfo.class, "MediaRemindedInfo.label9", "\u63d0\u53d6\u6307\u5b9a\u7684MediaRemindedInfo\u5bf9\u8c61\u5931\u8d25\uff01"), exception);
                }
                catch (Throwable throwable) {
                    block8: {
                        Object var7_8 = null;
                        if (mediaRemindedInfos == null) break block8;
                        mediaRemindedInfos.clear();
                    }
                    throw throwable;
                }
            }
            mediaRemindedInfos.clear();
        }
        return mediaRemindedInfo;
    }

    public static final MediaRemindedInfo findById(int n) throws WCMException {
        if (n <= 0) {
            return null;
        }
        return (MediaRemindedInfo)BaseObj.findById(MediaRemindedInfo.class, n);
    }

    public static final MediaRemindedInfo createNewInstance() throws WCMException {
        return (MediaRemindedInfo)BaseObj.createNewInstance(MediaRemindedInfo.class);
    }

    public static final MediaRemindedInfo findByKey(Object object) throws WCMException {
        return (MediaRemindedInfo)BaseObj.findByKey(MediaRemindedInfo.class, object);
    }

    public static final MediaRemindedInfo addRemindedSource(User user, int n, int n2, int n3) throws Exception {
        boolean bl;
        MediaRemindedInfo mediaRemindedInfo = MediaRemindedInfo.findByUserAndSrc(user, n, n2);
        boolean bl2 = bl = mediaRemindedInfo == null;
        if (mediaRemindedInfo != null && mediaRemindedInfo.getFreqReminded() == n3) {
            return null;
        }
        try {
            MediaRemindedInfos mediaRemindedInfos = new MediaRemindedInfos(user);
            if (bl) {
                mediaRemindedInfo = (MediaRemindedInfo)mediaRemindedInfos.addNew();
            }
            mediaRemindedInfo.setUserID(n);
            mediaRemindedInfo.setSourceId(n2);
            mediaRemindedInfo.setFreqReminded(n3);
            if (bl) {
                mediaRemindedInfos.update();
            } else {
                mediaRemindedInfo.update(user);
            }
        }
        catch (Exception exception) {
            throw new WCMException(1105, I18NMessage.get(MediaRemindedInfo.class, "MediaRemindedInfo.label10", "\u6dfb\u52a0\u65b0\u7684\u63d0\u9192\u8bbe\u7f6e\u5931\u8d25\uff01(MediaRemindedInfo.addRemindedSource)"), exception);
        }
        return mediaRemindedInfo;
    }
}

