/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.publish.tagparser;

import com.trs.DreamFactory;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.config.PublishServerConfigMapper;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.publisher.PublishTaskContext;
import com.trs.components.common.publish.domain.tagparser.TagBeanAttrInfo;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfo;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfoHelper;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.components.common.publish.domain.tagparser.TagParseHelper;
import com.trs.components.common.publish.persistent.element.IPublishElements;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementsCMSObjsImpl;
import com.trs.components.wcm.content.domain.DocumentMgr;
import com.trs.components.wcm.content.domain.DocumentsGetHelper;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.components.wcm.publish.IFolderPubStatusCacheMgr;
import com.trs.components.wcm.publish.element.PublishContentDocumentImpl;
import com.trs.components.wcm.publish.tagparser.IPublishTaskDocumentsCacheMgr;
import com.trs.components.wcm.publish.tagparser.PublishTaskDocumentsCacheMgr;
import com.trs.components.wcm.publish.tagparser.WCMTagParser4ObjsInChannelBase;
import com.trs.components.wcm.resource.Status;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.DebugTimer;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class WCMTagParserDocuments
extends WCMTagParser4ObjsInChannelBase {
    private static Logger logger = Logger.getLogger(WCMTagParserDocuments.class);
    private PublishTagContext m_oContent = null;
    private static ArrayList FIELDS_DEFAULT_LIST = new ArrayList(16);
    private static HashMap FIELDS_MAP;
    protected static TagBeanInfo s_TagBeanInfo;

    public TagBeanInfo getBeanInfo() {
        if (s_TagBeanInfo == null) {
            TagBeanAttrInfo tagBeanAttrInfo = null;
            TBI tBI = new TBI();
            tBI.setName("TRS_DOCUMENTS");
            tBI.setDesc("TRS_DOCUMENTS");
            tBI.setType(TagBeanInfo.BodyType.TAMPLATE);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("ID");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanAttrInfo.setDefaultValue("OWNER");
            tBI.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("CHILDINDEX");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.INTEGER);
            tagBeanAttrInfo.setDefaultValue("-1");
            tBI.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("CHANNELTYPE");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.INTEGER);
            tagBeanAttrInfo.setEnumValue(new String[]{"0", "1", "2"});
            tagBeanAttrInfo.setDefaultValue("0");
            tBI.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("STARTPOS");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.INTEGER);
            tagBeanAttrInfo.setDefaultValue("0");
            tBI.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("NUM");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.INTEGER);
            tBI.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("PAGESIZE");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.INTEGER);
            tBI.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("WHERE");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tBI.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("ORDER");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tBI.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("TARGET");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tBI.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("AUTOMORE");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanAttrInfo.setEnumValue(new String[]{"true", "false"});
            tagBeanAttrInfo.setDefaultValue("false");
            tBI.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("BEGINMORE");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tBI.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("ENDMORE");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tBI.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("MORETEXT");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanAttrInfo.setDefaultValue(I18NMessage.get(WCMTagParserDocuments.class, "WCMTagParserDocuments.label1", "\u66f4\u591a\u5185\u5bb9"));
            tBI.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("MOREEXTRA");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tBI.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("MORETARGET");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanAttrInfo.setDefaultValue("_self");
            tBI.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("TRUNCATEDFLAG");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanAttrInfo.setDefaultValue("...");
            tBI.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("ALINK");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tBI.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("SELECT");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tBI.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("EnableLimit");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanAttrInfo.setEnumValue(new String[]{"true", "false"});
            tagBeanAttrInfo.setDefaultValue("false");
            tBI.addAttrInfo(tagBeanAttrInfo);
            s_TagBeanInfo = tBI;
        }
        return s_TagBeanInfo;
    }

    private static CMyDateTime getPublishStartDate(PublishTagContext publishTagContext, IPublishFolder iPublishFolder) throws Exception {
        boolean bl = "true".equalsIgnoreCase(ConfigServer.getServer().getSysConfigValue("ENABLE_LIMIT_PUBLISH_DATE", "false").trim());
        if (!bl) {
            return null;
        }
        bl = publishTagContext.getAttribute("EnableLimit", true);
        if (!bl) {
            return null;
        }
        CMSObj cMSObj = iPublishFolder.getSubstance();
        CMyDateTime cMyDateTime = WCMTagParserDocuments.makePublishStartDate(cMSObj);
        if (cMyDateTime != null) {
            return cMyDateTime;
        }
        if (iPublishFolder.isRoot()) {
            return null;
        }
        Channel channel = (Channel)cMSObj;
        for (BaseChannel baseChannel = channel.getHost(); baseChannel != null; baseChannel = baseChannel.getHost()) {
            cMyDateTime = WCMTagParserDocuments.makePublishStartDate(baseChannel);
            if (cMyDateTime != null) {
                return cMyDateTime;
            }
            if (!baseChannel.isSite()) continue;
            return null;
        }
        return null;
    }

    private static CMyDateTime makePublishStartDate(CMSObj cMSObj) throws CMyException {
        boolean bl = "1".equals(cMSObj.getAttributeValue("PublishLimit"));
        if (!bl) {
            return null;
        }
        CMyDateTime cMyDateTime = new CMyDateTime();
        cMyDateTime.setDateTimeWithString(cMSObj.getAttributeValue("PubStartDate"));
        return cMyDateTime;
    }

    protected IPublishElements getPublishedContentsInCurrentFolder(PublishTagContext publishTagContext, WCMFilter wCMFilter) throws WCMException {
        try {
            String string;
            boolean bl;
            IPublishFolder iPublishFolder = this.getCurrFolder(publishTagContext);
            if (iPublishFolder == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Warn, current folder is null. Check the template and data plz.");
                }
                return null;
            }
            boolean bl2 = publishTagContext.getUpperHost() instanceof PublishContentDocumentImpl;
            boolean bl3 = bl = iPublishFolder != null && iPublishFolder.canDoDetailPageTask();
            if (!bl2 && !bl) {
                return null;
            }
            WCMFilter wCMFilter2 = this.makeFilterWithTimeLimit(publishTagContext, iPublishFolder, wCMFilter);
            PublishTaskContext publishTaskContext = publishTagContext.getPageContext().getTaskContext();
            IPublishTaskDocumentsCacheMgr iPublishTaskDocumentsCacheMgr = (IPublishTaskDocumentsCacheMgr)publishTaskContext.getCachObject(string = "IPublishTaskDocumentsCacheMgr");
            if (iPublishTaskDocumentsCacheMgr == null) {
                iPublishTaskDocumentsCacheMgr = new PublishTaskDocumentsCacheMgr();
                iPublishTaskDocumentsCacheMgr = (IPublishTaskDocumentsCacheMgr)publishTaskContext.putInCache(string, iPublishTaskDocumentsCacheMgr);
            }
            this.m_oContent = publishTagContext;
            return this.getPublishedContents(iPublishFolder, wCMFilter2, bl2);
        }
        catch (WCMException wCMException) {
            throw wCMException;
        }
        catch (Exception exception) {
            throw new WCMException(I18NMessage.get(WCMTagParserDocuments.class, "WCMTagParserDocuments.label2", "\u83b7\u53d6[") + this.getCurrFolder(publishTagContext).getInfo() + I18NMessage.get(WCMTagParserDocuments.class, "WCMTagParserDocuments.label3", "]\u7684\u6570\u636e\u5931\u8d25!"), exception);
        }
    }

    private WCMFilter makeFilterWithTimeLimit(PublishTagContext publishTagContext, IPublishFolder iPublishFolder, WCMFilter wCMFilter) throws Exception, WCMException {
        CMyDateTime cMyDateTime = WCMTagParserDocuments.getPublishStartDate(publishTagContext, iPublishFolder);
        WCMFilter wCMFilter2 = null;
        if (cMyDateTime != null) {
            String string = ConfigServer.getServer().getSysConfigValue("PUBLISH_DATE_FIELD", "CrTime");
            String string2 = "WCMChnlDoc." + string + ">=" + DBManager.getDBManager().getDBType().sqlDate(cMyDateTime.toString());
            wCMFilter2 = new WCMFilter("", string2, "");
            wCMFilter2.mergeWith(wCMFilter);
        } else {
            wCMFilter2 = wCMFilter;
        }
        return wCMFilter2;
    }

    protected IPublishElements getAllContentsInCurrentFolder(PublishTagContext publishTagContext, WCMFilter wCMFilter) throws WCMException {
        try {
            IPublishFolder iPublishFolder = this.getCurrFolder(publishTagContext);
            if (iPublishFolder == null) {
                return null;
            }
            WCMFilter wCMFilter2 = this.makeFilterWithTimeLimit(publishTagContext, iPublishFolder, wCMFilter);
            if (!publishTagContext.isPreview() && !iPublishFolder.canDoDetailPageTask()) {
                return null;
            }
            this.m_oContent = publishTagContext;
            return this.getPreviewContents(iPublishFolder, wCMFilter2);
        }
        catch (Exception exception) {
            throw new WCMException(I18NMessage.get(WCMTagParserDocuments.class, "WCMTagParserDocuments.label2", "\u83b7\u53d6[") + this.getCurrFolder(publishTagContext).getInfo() + I18NMessage.get(WCMTagParserDocuments.class, "WCMTagParserDocuments.label3", "]\u7684\u6570\u636e\u5931\u8d25!"), exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getSelectFields(PublishTagContext publishTagContext) {
        String string = this.m_tagItem.getExtraAttributeValue("SELECT");
        if (string == null) {
            TagItem tagItem = this.m_tagItem;
            synchronized (tagItem) {
                string = this.m_tagItem.getExtraAttributeValue("SELECT");
                if (string == null) {
                    string = this.makeSelectFields(publishTagContext);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("SelectFields:" + string));
                    }
                    this.m_tagItem.setExtraAttribute("SELECT", string);
                }
            }
        }
        return string;
    }

    private String makeSelectFields(PublishTagContext publishTagContext) {
        String string = (String)FIELDS_DEFAULT_LIST.get(0);
        int n = FIELDS_DEFAULT_LIST.size();
        for (int i = 1; i < n; ++i) {
            string = string + "," + FIELDS_DEFAULT_LIST.get(i);
        }
        ArrayList arrayList = TagParseHelper.makeSelectFields(this.m_tagItem, "TRS_DOCUMENT");
        DBManager dBManager = DBManager.getDBManager();
        int n2 = arrayList.size();
        for (int i = 0; i < n2; ++i) {
            String string2 = (String)arrayList.get(i);
            if (FIELDS_DEFAULT_LIST.indexOf(string2) >= 0) continue;
            String string3 = (String)FIELDS_MAP.get(string2);
            if (string3 != null) {
                string2 = string3;
            }
            try {
                if (dBManager.getFieldInfo("WCMDOCUMENT", string2) == null) {
                    publishTagContext.addWarning(I18NMessage.get(WCMTagParserDocuments.class, "WCMTagParserDocuments.label4", "TRS_DOCUMENT\u7f6e\u6807\u6307\u5b9a\u7684Field[") + string2 + I18NMessage.get(WCMTagParserDocuments.class, "WCMTagParserDocuments.label5", "]\u5728WCMDocument\u8868\u4e2d\u4e0d\u5b58\u5728\uff01"));
                    continue;
                }
            }
            catch (WCMException wCMException) {
                wCMException.printStackTrace();
                try {
                    publishTagContext.addWarning(I18NMessage.get(WCMTagParserDocuments.class, "WCMTagParserDocuments.label6", "\u83b7\u53d6\u6307\u5b9a\u7684Field[") + string2 + I18NMessage.get(WCMTagParserDocuments.class, "WCMTagParserDocuments.label7", "]\u4eceWCMDocument\u8868\u4e2d\u53d1\u751f\u5f02\u5e38\uff01") + CMyException.getStackTraceText(wCMException));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            string = string + "," + string2;
        }
        return string;
    }

    private int[] getPreviewStatus(IPublishFolder iPublishFolder) throws WCMException {
        IPublishFolder iPublishFolder2 = iPublishFolder.getRoot();
        IFolderPubStatusCacheMgr iFolderPubStatusCacheMgr = (IFolderPubStatusCacheMgr)DreamFactory.createObjectById("IFolderPubStatusCacheMgr");
        int[] nArray = iFolderPubStatusCacheMgr.findStatusesCanDoIncreasePub(iPublishFolder2.getType(), iPublishFolder2.getId());
        int[] nArray2 = Status.getStatusCanDoPubInOutline();
        if (nArray == null) {
            return nArray2;
        }
        int[] nArray3 = new int[nArray.length + nArray2.length];
        System.arraycopy(nArray, 0, nArray3, 0, nArray.length);
        System.arraycopy(nArray2, 0, nArray3, nArray.length, nArray2.length);
        return nArray3;
    }

    private int[] getPublishStatus(IPublishFolder iPublishFolder, boolean bl) throws WCMException {
        if (bl) {
            IPublishFolder iPublishFolder2 = iPublishFolder.getRoot();
            IFolderPubStatusCacheMgr iFolderPubStatusCacheMgr = (IFolderPubStatusCacheMgr)DreamFactory.createObjectById("IFolderPubStatusCacheMgr");
            int[] nArray = iFolderPubStatusCacheMgr.findStatusesCanDoIncreasePub(iPublishFolder2.getType(), iPublishFolder2.getId());
            int[] nArray2 = Status.getStatusCanDoPubInOutline();
            if (nArray == null) {
                return nArray2;
            }
            int[] nArray3 = new int[nArray.length + nArray2.length];
            System.arraycopy(nArray, 0, nArray3, 0, nArray.length);
            System.arraycopy(nArray2, 0, nArray3, nArray.length, nArray2.length);
            return nArray3;
        }
        return Status.getStatusCanDoPubInOutline();
    }

    private IPublishElements getPreviewContents(IPublishFolder iPublishFolder, WCMFilter wCMFilter) throws WCMException {
        return this.getContents(iPublishFolder, this.getPreviewStatus(iPublishFolder), wCMFilter);
    }

    private IPublishElements getPublishedContents(IPublishFolder iPublishFolder, WCMFilter wCMFilter, boolean bl) throws WCMException {
        if (bl) {
            return this.getContents(iPublishFolder, this.getPublishStatus(iPublishFolder, true), wCMFilter);
        }
        return this.getContents(iPublishFolder, this.getPublishStatus(iPublishFolder, false), wCMFilter);
    }

    private IPublishElements getContents(IPublishFolder iPublishFolder, int[] nArray, WCMFilter wCMFilter) throws WCMException {
        Object object;
        if (nArray == null || nArray.length <= 0) {
            return null;
        }
        DebugTimer debugTimer = new DebugTimer();
        debugTimer.start();
        WCMFilter wCMFilter2 = new WCMFilter("", "", "");
        wCMFilter2.setMaxRowNumber(PublishServerConfigMapper.getTemplateParseConfig().getWcmOutlineContentsMaxNum());
        String string = "WCMCHNLDOC.DOCSTATUS in(?";
        wCMFilter2.addSearchValues(0, nArray[0]);
        int n = nArray.length;
        for (int i = 1; i < n; ++i) {
            string = string + ",?";
            wCMFilter2.addSearchValues(i, nArray[i]);
        }
        string = string + ")";
        wCMFilter2.setWhere(string);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("getContents: Where=" + string));
        }
        if (wCMFilter != null) {
            wCMFilter2.mergeWith(wCMFilter);
        }
        Channel channel = (Channel)iPublishFolder.getSubstance();
        Documents documents = null;
        if (Document.DOCUMENTS_GET_OPTIMIZE) {
            documents = DocumentsGetHelper.getDocuments(channel, wCMFilter2);
        } else {
            object = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
            documents = ((DocumentMgr)object).getDocuments(channel, wCMFilter2);
        }
        object = new WCMFilter("WCMCHNLDOC", " ChnlId=? ", "");
        ((WCMFilter)object).addSearchValues(0, channel.getId());
        ((WCMFilter)object).mergeWith(wCMFilter2);
        ((WCMFilter)object).setSelect("DOCID");
        this.m_oContent.getPageContext().setExtraAttribute("TOTAL_COUNT", String.valueOf(DBManager.getDBManager().sqlExecuteCountQuery((WCMFilter)object)));
        debugTimer.stop();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("getContents use [" + debugTimer.getTime() + "]ms\nSQL:" + documents.getFilter().toSQL()));
        }
        if (documents == null || documents.isEmpty()) {
            return null;
        }
        return new PublishElementsCMSObjsImpl(documents);
    }

    static {
        FIELDS_DEFAULT_LIST.add("DOCID");
        FIELDS_DEFAULT_LIST.add("DOCCHANNEL");
        FIELDS_DEFAULT_LIST.add("DOCSTATUS");
        FIELDS_DEFAULT_LIST.add("DOCTYPE");
        FIELDS_DEFAULT_LIST.add("DOCTITLE");
        FIELDS_DEFAULT_LIST.add("DOCKEYWORDS");
        FIELDS_DEFAULT_LIST.add("DOCRELWORDS");
        FIELDS_DEFAULT_LIST.add("CRUSER");
        FIELDS_DEFAULT_LIST.add("CRTIME");
        FIELDS_DEFAULT_LIST.add("DocFlag");
        FIELDS_DEFAULT_LIST.add("TITLECOLOR");
        FIELDS_DEFAULT_LIST.add("DOCLINK");
        FIELDS_DEFAULT_LIST.add("DOCFILENAME");
        FIELDS_DEFAULT_LIST.add("DOCVERSION");
        FIELDS_DEFAULT_LIST.add("DOCRELTIME");
        FIELDS_DEFAULT_LIST.add("DOCPUBTIME");
        FIELDS_DEFAULT_LIST.add("DOCSOURCENAME");
        FIELDS_MAP = new HashMap(3);
        FIELDS_MAP.put("DOCFROM", "DOCSOURCE");
        FIELDS_MAP.put("DOCHTMLCON", "DOCPUBHTMLCON");
        FIELDS_MAP.put("DOCHTMLCONTENT", "DOCPUBHTMLCON");
        s_TagBeanInfo = null;
    }

    protected class TBI
    extends TagBeanInfo {
        protected TBI() {
        }

        public void checkSemantic(IPublishFolder iPublishFolder, TagItem tagItem, StringBuffer stringBuffer) {
            TagBeanInfoHelper.checkChannelName(iPublishFolder, tagItem, stringBuffer);
        }
    }
}

