/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.publish.domain.job;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.job.BaseStatefulScheduleWorker;
import com.trs.components.common.job.JobWorkerType;
import com.trs.components.common.job.Schedule;
import com.trs.components.common.publish.domain.PublishServer;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishElements;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.infra.common.ContextParameters;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.log.LogServer;
import org.apache.log4j.Logger;

public class WithDrawJobWorker
extends BaseStatefulScheduleWorker {
    private static final Logger logger = Logger.getLogger(WithDrawJobWorker.class);
    private static int m_nWorkerId = 0;
    private int m_nSenderType;
    private int m_nSenderId;
    private User m_oScheduleUser;

    protected boolean analyzeParams() {
        try {
            this.m_nSenderType = Integer.parseInt(this.getArgAsString("SenderType"));
            this.m_nSenderId = Integer.parseInt(this.getArgAsString("SenderId"));
            String string = this.getArgAsString("CrUser");
            ContextHelper.initContext(User.getSystem());
            this.m_oScheduleUser = User.findByName(string);
            if (this.m_oScheduleUser == null) {
                this.m_oScheduleUser = User.getSystem();
            }
            ContextHelper.setLoginUser(this.m_oScheduleUser);
            return true;
        }
        catch (Exception exception) {
            logger.error((Object)"excute schedule publish failed", (Throwable)exception);
            return false;
        }
    }

    protected void execute() throws WCMException {
        if (!this.analyzeParams()) {
            throw new WCMException(1100, "analyze fail");
        }
        ContextParameters.set(7, Boolean.TRUE);
        ContextHelper.setArg(LogServer.CONTEXT_INDEX_IP, "127.0.0.1");
        PublishServer publishServer = PublishServer.getInstance();
        IPublishElement iPublishElement = PublishElementFactory.lookupElement(this.m_nSenderType, this.m_nSenderId);
        if (iPublishElement == null) {
            logger.error((Object)"publish failed,no element to publish!");
            return;
        }
        logger.info((Object)("auto withdraw[" + iPublishElement.getInfo() + "] begin...."));
        if (iPublishElement instanceof IPublishContent) {
            try {
                IPublishContent iPublishContent = (IPublishContent)iPublishElement;
                IPublishElements iPublishElements = PublishElementFactory.lookupElements(this.m_nSenderType, String.valueOf(this.m_nSenderId));
                IPublishFolder iPublishFolder = iPublishContent.getOriginalHome();
                publishServer.deleteContents(iPublishElements, iPublishFolder, this.getQuotedFolders());
            }
            catch (Exception exception) {
                logger.error((Object)("schedule publish[" + iPublishElement.getInfo() + "] failed!"), (Throwable)exception);
                throw new WCMException(1100, "Failed to revoke on schedule", exception);
            }
        } else if (iPublishElement instanceof IPublishFolder) {
            IPublishFolder iPublishFolder = (IPublishFolder)iPublishElement;
            if (iPublishFolder.isDeleted()) {
                return;
            }
            try {
                publishServer.publishFolder(iPublishFolder, 7);
                publishServer.deleteFolder(iPublishFolder, true);
            }
            catch (Exception exception) {
                logger.error((Object)("schedule publish[" + iPublishElement.getInfo() + "] failed!"), (Throwable)exception);
                throw new WCMException(1100, "Failed to revoke on schedule", exception);
            }
        } else {
            logger.error((Object)("schedule publish[" + iPublishElement.getInfo() + "] failed,not a valid element!"));
        }
        logger.info((Object)("auto withdraw[" + iPublishElement.getInfo() + "] end."));
        this.clearSchedule(iPublishElement.getSubstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IPublishElements getQuotedFolders() {
        block38: {
            block37: {
                block29: {
                    block36: {
                        block30: {
                            var1_1 = "select chnlid from wcmchnldoc where docid=? and modal>=2";
                            var2_2 = new StringBuffer(32);
                            var2_2.append(',');
                            var3_3 = null;
                            var4_4 = null;
                            var5_5 = null;
                            var6_6 = DBManager.getDBManager();
                            try {
                                try {
                                    var4_4 = var6_6.getConnection();
                                    var3_3 = var4_4.prepareStatement(var1_1);
                                    var3_3.setInt(1, this.m_nSenderId);
                                    var5_5 = var3_3.executeQuery();
                                    while (var5_5.next()) {
                                        var2_2.append(var5_5.getInt(1)).append(',');
                                    }
                                    if (var2_2.length() <= 1) break block29;
                                    var7_7 = Channels.findByIds(this.m_oScheduleUser, var2_2.substring(1));
                                    var8_9 = PublishElementFactory.makeElementsFrom(var7_7);
                                    var10_10 = null;
                                    if (var5_5 == null) break block30;
                                }
                                catch (Exception var7_8) {
                                    WithDrawJobWorker.logger.warn((Object)"get quoted folders fail.", (Throwable)var7_8);
                                    var10_12 = null;
                                    if (var5_5 != null) {
                                        try {
                                            var5_5.close();
                                        }
                                        catch (Exception var11_16) {
                                            // empty catch block
                                        }
                                    }
                                    if (var3_3 != null) {
                                        try {
                                            var3_3.close();
                                        }
                                        catch (Exception var11_16) {
                                            // empty catch block
                                        }
                                    }
                                    if (var4_4 == null) return null;
                                    try {
                                        var6_6.freeConnection(var4_4);
                                        return null;
                                    }
                                    catch (Exception var11_16) {
                                        return null;
                                    }
                                }
                            }
                            catch (Throwable var9_18) {
                                block35: {
                                    block34: {
                                        var10_13 = null;
                                        if (var5_5 != null) {
                                            ** try [egrp 2[TRYBLOCK] [5 : 173->183)] { 
lbl55:
                                            // 1 sources

                                            var5_5.close();
                                            break block34;
lbl57:
                                            // 1 sources

                                            catch (Exception var11_17) {
                                                // empty catch block
                                            }
                                        }
                                    }
                                    if (var3_3 != null) {
                                        ** try [egrp 3[TRYBLOCK] [6 : 189->198)] { 
lbl62:
                                        // 1 sources

                                        var3_3.close();
                                        break block35;
lbl64:
                                        // 1 sources

                                        catch (Exception var11_17) {
                                            // empty catch block
                                        }
                                    }
                                }
                                if (var4_4 == null) throw var9_18;
                                ** try [egrp 4[TRYBLOCK] [7 : 205->215)] { 
lbl69:
                                // 1 sources

                                var6_6.freeConnection(var4_4);
                                throw var9_18;
lbl71:
                                // 1 sources

                                catch (Exception var11_17) {
                                    // empty catch block
                                }
                                throw var9_18;
                            }
                            ** try [egrp 2[TRYBLOCK] [5 : 173->183)] { 
lbl76:
                            // 1 sources

                            var5_5.close();
                            break block30;
lbl78:
                            // 1 sources

                            catch (Exception var11_14) {
                                // empty catch block
                            }
                        }
                        if (var3_3 != null) {
                            ** try [egrp 3[TRYBLOCK] [6 : 189->198)] { 
lbl83:
                            // 1 sources

                            var3_3.close();
                            break block36;
lbl85:
                            // 1 sources

                            catch (Exception var11_14) {
                                // empty catch block
                            }
                        }
                    }
                    if (var4_4 == null) return var8_9;
                    try {}
                    catch (Exception var11_14) {
                        // empty catch block
                        return var8_9;
                    }
                    var6_6.freeConnection(var4_4);
                    return var8_9;
                }
                var10_11 = null;
                if (var5_5 != null) {
                    ** try [egrp 2[TRYBLOCK] [5 : 173->183)] { 
lbl99:
                    // 1 sources

                    var5_5.close();
                    break block37;
lbl101:
                    // 1 sources

                    catch (Exception var11_15) {
                        // empty catch block
                    }
                }
            }
            if (var3_3 != null) {
                ** try [egrp 3[TRYBLOCK] [6 : 189->198)] { 
lbl106:
                // 1 sources

                var3_3.close();
                break block38;
lbl108:
                // 1 sources

                catch (Exception var11_15) {
                    // empty catch block
                }
            }
        }
        if (var4_4 == null) return null;
        try {}
        catch (Exception var11_15) {}
        var6_6.freeConnection(var4_4);
        return null;
        return null;
    }

    private void clearSchedule(BaseObj baseObj) {
        try {
            CMSObj cMSObj;
            if (baseObj == null) {
                return;
            }
            if (m_nWorkerId == 0) {
                cMSObj = JobWorkerType.findByClassName(WithDrawJobWorker.class.getName());
                if (cMSObj == null) {
                    return;
                }
                m_nWorkerId = cMSObj.getId();
            }
            if ((cMSObj = Schedule.findBySender(m_nWorkerId, baseObj)) != null) {
                cMSObj.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

