/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.process.service.flowexporter;

import com.trs.cms.ContextHelper;
import com.trs.cms.process.definition.Flow;
import com.trs.cms.process.definition.FlowEmploy;
import com.trs.cms.process.definition.FlowEmploys;
import com.trs.cms.process.definition.Flows;
import com.trs.cms.process.xml.FlowImporter;
import com.trs.cms.process.xml.FlowXmlConverter;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.content.service.portervisitors.IPorterVisitor;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.BaseObjToXmlConverter;
import com.trs.infra.persistent.ObjToXmlConverter;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.XmlObject;
import java.util.HashMap;
import org.dom4j.Element;

public class SiteExporterForFlow
implements IPorterVisitor {
    private HashMap m_hHashMapFlowId = new HashMap();

    public void doExport(BaseObj baseObj, Object object) throws Exception {
        if (!(baseObj instanceof WebSite) && !(baseObj instanceof Channel)) {
            return;
        }
        if (baseObj instanceof WebSite) {
            WebSite webSite = (WebSite)baseObj;
            this.exportFlowsOfSite(webSite, object);
        } else {
            Channel channel = (Channel)baseObj;
            this.exportFlowEmployOfChannel(channel, object);
        }
    }

    public void doImport(BaseObj baseObj, XmlObject xmlObject, Object object) throws Exception {
        BaseChannel baseChannel;
        if (!(baseObj instanceof WebSite) && !(baseObj instanceof Channel)) {
            return;
        }
        if (baseObj instanceof WebSite) {
            baseChannel = (WebSite)baseObj;
            this.importFlowsOfSite((WebSite)baseChannel, xmlObject);
        }
        if (baseObj instanceof Channel) {
            baseChannel = (Channel)baseObj;
            this.importFlowsEmploysOfChannel((Channel)baseChannel, xmlObject);
        }
    }

    public String[] registerTargetClassName() {
        return new String[]{WebSite.class.getName(), Channel.class.getName()};
    }

    public void exportFlowsOfSite(WebSite webSite, Object object) throws WCMException {
        Flows flows = new Flows(null);
        WCMFilter wCMFilter = new WCMFilter();
        StringBuffer stringBuffer = new StringBuffer(500);
        stringBuffer.append("(OwnerId=? and OwnerType=?)");
        wCMFilter.addSearchValues(0, webSite.getId());
        wCMFilter.addSearchValues(1, webSite.getWCMType());
        wCMFilter.setWhere(stringBuffer.toString());
        flows = Flows.openWCMObjs(null, wCMFilter);
        if (flows == null || flows.size() <= 0) {
            return;
        }
        Element[] elementArray = new Element[]{new FlowXmlConverter().toXmlElement(flows, null)};
        Object[] objectArray = (Object[])object;
        BaseObjToXmlConverter baseObjToXmlConverter = (BaseObjToXmlConverter)objectArray[0];
        baseObjToXmlConverter.addChildElements((Element)objectArray[1], elementArray);
    }

    private void exportFlowEmployOfChannel(Channel channel, Object object) throws WCMException {
        FlowEmploys flowEmploys = new FlowEmploys(null);
        WCMFilter wCMFilter = new WCMFilter();
        StringBuffer stringBuffer = new StringBuffer(500);
        stringBuffer.append("(EmployerType=? and EmployerId=?)");
        wCMFilter.addSearchValues(0, channel.getWCMType());
        wCMFilter.addSearchValues(1, channel.getId());
        wCMFilter.setWhere(stringBuffer.toString());
        flowEmploys = FlowEmploys.openWCMObjs(null, wCMFilter);
        Element[] elementArray = new Element[]{new ObjToXmlConverter().toXmlElement(flowEmploys, null)};
        Object[] objectArray = (Object[])object;
        BaseObjToXmlConverter baseObjToXmlConverter = (BaseObjToXmlConverter)objectArray[0];
        baseObjToXmlConverter.addChildElements((Element)objectArray[1], elementArray);
    }

    private void importFlowsOfSite(WebSite webSite, XmlObject xmlObject) throws WCMException {
        XmlObject[] xmlObjectArray = xmlObject.getChild("WCMFLOWS");
        if (xmlObjectArray == null || xmlObjectArray.length <= 0) {
            return;
        }
        FlowImporter flowImporter = new FlowImporter(ContextHelper.getLoginUser(), 1);
        flowImporter.setImportWithInfoviewId(false);
        flowImporter.setOwner(webSite);
        int n = 0;
        Flow flow = null;
        for (int i = 0; i < xmlObjectArray.length; ++i) {
            flow = (Flow)xmlObjectArray[i].getCurrentObj();
            n = flow.getPropertyAsInt("FlowId", 0);
            flowImporter.importFromXMLObj(xmlObjectArray[i]);
            this.m_hHashMapFlowId.put(String.valueOf(n), String.valueOf(flowImporter.m_nCurrFlowId));
        }
    }

    private void importFlowsEmploysOfChannel(Channel channel, XmlObject xmlObject) throws WCMException {
        XmlObject[] xmlObjectArray = xmlObject.getChild("WCMFLOWEMPLOYS");
        if (xmlObjectArray == null || xmlObjectArray.length <= 0) {
            return;
        }
        FlowEmploy flowEmploy = (FlowEmploy)xmlObjectArray[0].getCurrentObj();
        int n = flowEmploy.getPropertyAsInt("FLOWID", 0);
        flowEmploy.setProperty("EMPLOYERID", channel.getId());
        if (this.m_hHashMapFlowId.get(String.valueOf(n)) == null) {
            return;
        }
        flowEmploy.setProperty("FLOWID", Integer.parseInt(this.m_hHashMapFlowId.get(String.valueOf(n)).toString()));
        flowEmploy.setProperty("EMPLOYERTYPE", channel.getWCMType());
        flowEmploy.save();
    }
}

