/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.filter;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.filter.Filter;
import com.trs.components.wcm.filter.FilterMgr;
import com.trs.components.wcm.filter.FilterOption;
import com.trs.components.wcm.filter.FilterOptionGroup;
import com.trs.components.wcm.filter.FilterOptions;
import com.trs.components.wcm.filter.FilterXmlToObjConverter;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.XmlObject;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CMyUnZipFile;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class FilterImporter {
    private static Logger logger = Logger.getLogger(FilterImporter.class);
    private String m_sImportFile;
    private Channel m_oCurrChannel;
    private boolean m_bToCurrChnl = false;
    private FilterXmlToObjConverter m_converter = null;
    private Map m_mOptionIdMapping = new HashMap();
    private FilterMgr m_oFilterMgr = null;

    public FilterImporter(int n, Channel channel) throws WCMException {
        this.m_oCurrChannel = channel;
        this.m_converter = new FilterXmlToObjConverter(n, channel);
        this.m_oFilterMgr = (FilterMgr)DreamFactory.createObjectById("FilterMgr");
    }

    public void setImportToCurrChnl(boolean bl) {
        this.m_bToCurrChnl = bl;
    }

    public void importFromZip(String string) throws WCMException {
        Object object;
        if (!CMyFile.fileExists(string)) {
            object = FilesMan.getFilesMan();
            string = ((FilesMan)object).mapFilePath(string, 0) + CMyFile.extractFileName(string);
        }
        object = CMyFile.extractFilePath(string);
        this.m_sImportFile = object = (String)object + CMyFile.extractMainFileName(string) + File.separator;
        CMyUnZipFile cMyUnZipFile = new CMyUnZipFile(string, (String)object);
        try {
            cMyUnZipFile.addFileExtFilters("xml");
            cMyUnZipFile.doUnZipAnd();
            CMyFile.deleteFile(string);
        }
        catch (CMyException cMyException) {
            throw new WCMException(200, "Zip\u6587\u4ef6\u89e3\u538b\u5931\u8d25!", cMyException);
        }
        ArrayList arrayList = cMyUnZipFile.getFilteredFiles();
        XmlObject[] xmlObjectArray = null;
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            String string2 = (String)arrayList.get(i);
            xmlObjectArray = this.m_converter.convertXml(string2, null, null);
            this.importFilters(xmlObjectArray, this.m_oCurrChannel);
        }
        CMyFile.deleteDir(this.m_sImportFile);
    }

    private void importFilters(XmlObject[] xmlObjectArray, Channel channel) throws WCMException {
        for (int i = 0; i < xmlObjectArray.length; ++i) {
            this.importFilter(xmlObjectArray[i], channel);
        }
    }

    private Filter importFilter(XmlObject xmlObject, Channel channel) throws WCMException {
        Filter filter = (Filter)xmlObject.getCurrentObj();
        if (this.m_bToCurrChnl) {
            filter.setChannelId(channel.getId());
        }
        filter.save(ContextHelper.getLoginUser());
        XmlObject[] xmlObjectArray = xmlObject.getChild("XWCMFILTEROPTIONGROUPS");
        this.importOptionGroups(xmlObjectArray, filter);
        this.afterFilterSave(filter);
        return filter;
    }

    private void afterFilterSave(Filter filter) throws WCMException {
        FilterOptions filterOptions = this.m_oFilterMgr.queryOptionsByFilter(filter, null);
        int n = filterOptions.size();
        for (int i = 0; i < n; ++i) {
            FilterOption filterOption = (FilterOption)filterOptions.getAt(i);
            if (filterOption == null) continue;
            boolean bl = false;
            String string = filterOption.getNotAllowedSelectOptions();
            if (!CMyString.isEmpty(string)) {
                String string2 = this.getNewOptionIds(string);
                filterOption.setNotAllowedSelectOptions(string2);
                bl = true;
            }
            if (!bl) continue;
            filterOption.save(ContextHelper.getLoginUser());
        }
        String string = filter.getPropertyAsString("disabledoptions");
        if (!CMyString.isEmpty(string)) {
            String string3 = this.getNewOptionIds(string);
            filter.setPropertyWithString("disabledoptions", string3);
            filter.save(ContextHelper.getLoginUser());
        }
    }

    private String getNewOptionIds(String string) {
        if (CMyString.isEmpty(string)) {
            return "";
        }
        int[] nArray = CMyString.splitToInt(string, ",");
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < nArray.length; ++i) {
            Integer n = (Integer)this.m_mOptionIdMapping.get(new Integer(nArray[i]));
            if (n == null) continue;
            stringBuffer.append(n).append(",");
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }

    private void importOptionGroups(XmlObject[] xmlObjectArray, Filter filter) throws WCMException {
        for (int i = 0; i < xmlObjectArray.length; ++i) {
            this.importOptionGroup(xmlObjectArray[i], filter);
        }
    }

    private FilterOptionGroup importOptionGroup(XmlObject xmlObject, Filter filter) throws WCMException {
        FilterOptionGroup filterOptionGroup = (FilterOptionGroup)xmlObject.getCurrentObj();
        filterOptionGroup.setFilterId(filter.getId());
        filterOptionGroup.save(ContextHelper.getLoginUser());
        XmlObject[] xmlObjectArray = xmlObject.getChild("XWCMFILTEROPTIONS");
        this.importOptions(xmlObjectArray, filterOptionGroup);
        return filterOptionGroup;
    }

    private void importOptions(XmlObject[] xmlObjectArray, FilterOptionGroup filterOptionGroup) throws WCMException {
        for (int i = 0; i < xmlObjectArray.length; ++i) {
            this.importOption(xmlObjectArray[i], filterOptionGroup);
        }
    }

    private FilterOption importOption(XmlObject xmlObject, FilterOptionGroup filterOptionGroup) throws WCMException {
        FilterOption filterOption = (FilterOption)xmlObject.getCurrentObj();
        filterOption.setGroupId(filterOptionGroup.getId());
        String[] stringArray = new String[]{"FIRSTPIC", "SECONDPIC", "THIRDPIC"};
        for (int i = 0; i < stringArray.length; ++i) {
            String string = filterOption.getPropertyAsString(stringArray[i]);
            if (CMyString.isEmpty(string)) continue;
            if (!CMyFile.fileExists(this.m_sImportFile + string)) {
                logger.error((Object)CMyString.format("\u5bfc\u5165\u7b5b\u9009\u5668\u56fe\u7247\u65f6\u56fe\u7247\u4e0d\u5b58\u5728[{0}]", new String[]{this.m_sImportFile + string}));
                continue;
            }
            FilesMan filesMan = FilesMan.getFilesMan();
            String string2 = filesMan.getNextFilePathName("P0", CMyFile.extractFileExt(string));
            try {
                CMyFile.copyFile(this.m_sImportFile + string, string2);
            }
            catch (CMyException cMyException) {
                throw new WCMException("\u590d\u5236\u6587\u4ef6\u5931\u8d25", cMyException);
            }
            filterOption.setPropertyWithString(stringArray[i], CMyFile.extractFileName(string2));
        }
        Integer n = (Integer)this.m_converter.getObjIdMapping().get(filterOption);
        filterOption.save(ContextHelper.getLoginUser());
        this.m_mOptionIdMapping.put(n, filterOption.getKey());
        return filterOption;
    }
}

