/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.epress;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.epress.EPressChannelWrapper;
import com.trs.components.wcm.epress.EPressConf;
import com.trs.components.wcm.epress.EPressHistoryGenerator;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.ISelfDefinedServiceProvider;

public class EPressServiceProvider
implements ISelfDefinedServiceProvider {
    public boolean existsSimilarName(MethodContext methodContext) throws Throwable {
        String string;
        int n = methodContext.getValue("siteid", 0);
        return Channel.findByName(n, string = methodContext.getValue("ChannelName")) != null;
    }

    public boolean checkUUID(MethodContext methodContext) throws Throwable {
        String string = methodContext.getValue("UUID");
        if (!CMyString.isEmpty(string)) {
            return EPressConf.instance().existsEPress(string);
        }
        return true;
    }

    public int createEPress(MethodContext methodContext) throws Throwable {
        User user = ContextHelper.getLoginUser();
        int n = methodContext.getValue("SiteId", 0);
        int n2 = methodContext.getValue("ParentId", 0);
        String string = methodContext.getValue("CoverPageName");
        if (n == 0 && n2 == 0) {
            throw new WCMException(10, "\u6ca1\u6709\u6307\u5b9a\u7ad9\u70b9,\u4e5f\u6ca1\u6709\u6307\u5b9a\u7236\u680f\u76ee;\u56e0\u6b64\u65e0\u6cd5\u521b\u5efa\u680f\u76ee!");
        }
        WebSite webSite = null;
        if (n > 0) {
            webSite = WebSite.findById(n);
            if (webSite == null) {
                throw new WCMException(200006, "\u6ca1\u6709\u627e\u5230[Id=" + n + "]\u7684\u7ad9\u70b9!");
            }
            if (webSite.isDeleted()) {
                throw new WCMException(200006, webSite + "\u5df2\u5220\u9664!");
            }
        }
        Channel channel = null;
        if (n2 > 0) {
            channel = Channel.findById(n2);
            this.assertValid(n2, channel);
            n = channel.getSiteId();
        }
        boolean bl = false;
        bl = channel == null ? AuthServer.hasRight(user, (CMSObj)webSite, 11) : AuthServer.hasRight(user, (CMSObj)channel, 11);
        if (!bl) {
            throw new WCMException(1002, "\u5bf9\u4e0d\u8d77,\u60a8\u6ca1\u6709\u65b0\u5efa\u680f\u76ee\u7684\u6743\u9650!\u8bf7\u4e0e\u7cfb\u7edf\u7ba1\u7406\u5458\u8054\u7cfb");
        }
        Channel channel2 = new Channel();
        channel2.setName(methodContext.getValue("ChnlName"));
        channel2.setDesc(methodContext.getValue("ChnlDesc"));
        channel2.setParent(n2);
        channel2.setSite(n);
        channel2.setType(0);
        channel2.setOrder(methodContext.getValue("ChnlOrder", 0));
        int n3 = methodContext.getValue("PageCount", 0);
        String string2 = methodContext.getValue("EPressUUID");
        EPressChannelWrapper ePressChannelWrapper = new EPressChannelWrapper(n3, string2);
        ePressChannelWrapper.setCoverPageName(string);
        channel2 = ePressChannelWrapper.save(user, channel2);
        return channel2.getId();
    }

    public boolean publishHistoryIndex(MethodContext methodContext) throws Throwable {
        int n = methodContext.getValue("ChannelId", 0);
        if (!EPressConf.instance().existsEPress(n)) {
            return true;
        }
        Channel channel = Channel.findById(n);
        this.assertValid(n, channel);
        String string = methodContext.getValue("PublishDate");
        CMyDateTime cMyDateTime = CMyDateTime.now();
        if (!CMyString.isEmpty(string)) {
            cMyDateTime.setDateTimeWithString(string);
        }
        EPressHistoryGenerator ePressHistoryGenerator = new EPressHistoryGenerator(channel);
        ePressHistoryGenerator.generate(cMyDateTime);
        return true;
    }

    private void assertValid(int n, Channel channel) throws WCMException {
        if (channel == null) {
            throw new WCMException(200006, "\u6ca1\u6709\u627e\u5230[Id=" + n + "]\u7684\u680f\u76ee!");
        }
        if (channel.isDeleted()) {
            throw new WCMException(200006, channel + "\u5df2\u88ab\u5220\u9664!");
        }
    }
}

