/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.trsserver;

import com.trs.cms.auth.persistent.User;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.infra.I18NMessage;
import com.trs.infra.persistent.BaseObj;
import java.util.HashMap;

public class TreeNode {
    private Channels m_srcChannels = null;
    private User m_oLoginUser = null;
    private int m_nDocumentsCount = 0;
    private Channel m_oChannel = null;
    private TreeNode[] m_pChildrenNodes = null;
    private int[] m_pChildrenIds = null;
    private int m_nChildrenCount = 0;
    private int m_nMaxChildCount = 30;
    private int[] m_pClassInfos = null;
    private HashMap m_hDocumentsCountCache = null;

    public TreeNode(User user, int[] nArray) {
        this.m_oLoginUser = user;
        this.m_pClassInfos = nArray;
        if (nArray != null) {
            this.m_nMaxChildCount = nArray.length;
        }
        try {
            this.init();
        }
        catch (Exception exception) {
            throw new RuntimeException(I18NMessage.get(TreeNode.class, "TreeNode.label1", "\u521d\u59cb\u5316\u5bf9\u8c61\u5931\u8d25\uff01"), exception);
        }
    }

    public TreeNode(User user, String string) {
        String[] stringArray = string.split(",");
        this.m_pClassInfos = new int[stringArray.length];
        if (stringArray != null) {
            this.m_nMaxChildCount = stringArray.length;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            this.m_pClassInfos[i] = Integer.parseInt(stringArray[i]);
        }
        this.m_oLoginUser = user;
        try {
            this.init();
        }
        catch (Exception exception) {
            throw new RuntimeException(I18NMessage.get(TreeNode.class, "TreeNode.label1", "\u521d\u59cb\u5316\u5bf9\u8c61\u5931\u8d25\uff01"), exception);
        }
    }

    public TreeNode(Channel channel, int n) {
        this.m_oChannel = channel;
        this.m_nMaxChildCount = n;
        this.m_pChildrenIds = new int[n];
        this.m_pChildrenNodes = new TreeNode[n];
    }

    private TreeNode addNeedExpandNode(Channel channel) {
        for (int i = 0; i < this.m_nChildrenCount; ++i) {
            if (this.m_pChildrenIds[i] != channel.getId()) continue;
            return this.m_pChildrenNodes[i];
        }
        this.m_pChildrenIds[this.m_nChildrenCount] = channel.getId();
        this.m_pChildrenNodes[this.m_nChildrenCount] = new TreeNode(channel, this.m_nMaxChildCount);
        ++this.m_nChildrenCount;
        return this.m_pChildrenNodes[this.m_nChildrenCount - 1];
    }

    private Channel[] extractPathIds(Channel channel) throws Exception {
        Channel[] channelArray = new Channel[100];
        int n = 0;
        for (Channel channel2 = channel; channel2 != null; channel2 = channel2.getParent()) {
            channelArray[n] = channel2;
            ++n;
        }
        Channel[] channelArray2 = new Channel[n];
        for (int i = n - 1; i >= 0; --i) {
            channelArray2[n - i - 1] = channelArray[i];
        }
        return channelArray2;
    }

    private void init() throws Exception {
        Object object;
        int n;
        if (this.m_srcChannels == null) {
            this.m_pChildrenIds = new int[this.m_nMaxChildCount];
            this.m_pChildrenNodes = new TreeNode[this.m_nMaxChildCount];
            this.m_hDocumentsCountCache = new HashMap(this.m_pClassInfos.length / 2);
            this.m_srcChannels = new Channels(this.m_oLoginUser, this.m_pClassInfos.length / 2, 1);
            for (n = 0; n < this.m_pClassInfos.length; ++n) {
                int n2;
                if ((object = Channel.findById(n2 = this.m_pClassInfos[n++])) == null) continue;
                this.m_srcChannels.addElement((BaseObj)object);
                this.m_hDocumentsCountCache.put(new Integer(n2), new Integer(this.m_pClassInfos[n]));
            }
        }
        for (n = 0; n < this.m_srcChannels.size(); ++n) {
            Channel channel = (Channel)this.m_srcChannels.getAt(n);
            if (channel == null) continue;
            object = this.extractPathIds(channel);
            TreeNode treeNode = this;
            for (int i = 0; i < ((Channel[])object).length; ++i) {
                treeNode = treeNode.addNeedExpandNode(object[i]);
            }
        }
        this.caculateAndSetNodesCount(this.getChildrenCount(), this.getChildrenNodes());
    }

    private void caculateAndSetNodesCount(int n, TreeNode[] treeNodeArray) {
        for (int i = 0; i < n; ++i) {
            TreeNode treeNode = treeNodeArray[i];
            treeNode.setDocumentsCount(this.caculateDocumentsCount(treeNode));
            this.caculateAndSetNodesCount(treeNode.getChildrenCount(), treeNode.getChildrenNodes());
        }
    }

    private int caculateDocumentsCount(TreeNode treeNode) {
        Integer n = (Integer)this.m_hDocumentsCountCache.get(new Integer(treeNode.getChannel().getId()));
        int n2 = 0;
        if (n != null) {
            n2 = n;
        }
        int n3 = treeNode.getChildrenCount();
        TreeNode[] treeNodeArray = treeNode.getChildrenNodes();
        for (int i = 0; i < n3; ++i) {
            n2 += this.caculateDocumentsCount(treeNodeArray[i]);
        }
        return n2;
    }

    public Channel getChannel() {
        return this.m_oChannel;
    }

    public TreeNode[] getChildrenNodes() {
        return this.m_pChildrenNodes;
    }

    public String getAllChildrenNodeIds() {
        if (this.m_nChildrenCount <= 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(this.m_nChildrenCount * 6);
        for (int i = 0; i < this.m_nChildrenCount; ++i) {
            if (i > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(this.m_pChildrenIds[i]);
            String string = this.m_pChildrenNodes[i].getAllChildrenNodeIds();
            if (string == null) continue;
            stringBuffer.append(",");
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public String getChildrenNodeIds() {
        if (this.m_nChildrenCount <= 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(this.m_nChildrenCount * 6);
        stringBuffer.append(this.m_pChildrenIds[0]);
        for (int i = 1; i < this.m_nChildrenCount; ++i) {
            stringBuffer.append(",");
            stringBuffer.append(this.m_pChildrenIds[i]);
        }
        return stringBuffer.toString();
    }

    public TreeNode getExpandNodeById(int n) {
        if (this.m_nChildrenCount <= 0) {
            return null;
        }
        for (int i = 0; i < this.m_nChildrenCount; ++i) {
            if (this.m_pChildrenIds[i] != n) continue;
            return this.m_pChildrenNodes[i];
        }
        return null;
    }

    public int getDocumentsCount() {
        return this.m_nDocumentsCount;
    }

    public void setDocumentsCount(int n) {
        this.m_nDocumentsCount = n;
    }

    public int getChildrenCount() {
        return this.m_nChildrenCount;
    }
}

