/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.trsserver;

import com.trs.cms.auth.persistent.User;
import com.trs.components.wcm.content.trsserver.ChannelsWithRightMaker;
import com.trs.components.wcm.content.trsserver.TRSSearchUtil;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyString;
import com.trs.presentation.util.RequestHelper;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TRSSearcher {
    public static final int SEARCHSCOPE_CONTAINSCHILDREN = 1;
    public static final int SEARCHSCOPE_SINGLE = 0;
    private String m_SearchWord = null;
    private RequestHelper m_RequestHelper = null;
    private String m_Option = null;
    private String m_Extension = null;
    private String m_SearchType = null;
    private String m_LastSearch = null;
    private String m_CurrSearch = null;
    private String m_StartTime = null;
    private String m_EndTime = null;
    private int m_PageSize = 10;
    private int m_PageIndex = 1;
    private int m_DetailOpenType = -1;
    private String m_OrderBy = null;
    private String m_Where = null;
    private String m_DateType = null;
    private String m_ChannelIds = null;
    private String m_SiteIds = null;
    private int m_SearchScope = 1;
    private User m_LoginUser = null;

    private TRSSearcher() {
    }

    public static TRSSearcher getTRSSearcher(RequestHelper requestHelper, User user) {
        TRSSearcher tRSSearcher = new TRSSearcher();
        tRSSearcher.m_RequestHelper = requestHelper;
        tRSSearcher.m_LoginUser = user;
        return tRSSearcher;
    }

    public String getSearchWord() {
        return this.m_SearchWord;
    }

    public String getOption() {
        return this.m_Option;
    }

    public String getExtension() {
        return this.m_Extension;
    }

    public String getSearchType() {
        return this.m_SearchType;
    }

    public String getLastSearch() {
        return this.m_LastSearch;
    }

    public String getStartTime() {
        return this.m_StartTime;
    }

    public String getEndTime() {
        return this.m_EndTime;
    }

    public int getPageSize() {
        return this.m_PageSize;
    }

    public int getPageIndex() {
        return this.m_PageIndex;
    }

    public int getDetailOpenType() {
        return this.m_DetailOpenType;
    }

    public String getOrderBy() {
        return this.m_OrderBy;
    }

    public String getWhere() {
        return this.m_Where;
    }

    public String getDateType() {
        return this.m_DateType;
    }

    public String getChannelIds() {
        return this.m_ChannelIds;
    }

    public String getCurrSearch() {
        return this.m_CurrSearch;
    }

    public void buildSearcher() throws WCMException {
        HashMap hashMap;
        try {
            hashMap = TRSSearchUtil.getFavorite(this.m_RequestHelper.getRequest());
        }
        catch (Exception exception) {
            throw new WCMException(I18NMessage.get(TRSSearcher.class, "TRSSearcher.label1", "\u83b7\u53d6\u7528\u6237\u7684\u5b58\u50a8\u504f\u597d\u65f6\u53d1\u751f\u9519\u8bef\u3002"), exception);
        }
        if (this.m_RequestHelper == null) {
            throw new WCMException(I18NMessage.get(TRSSearcher.class, "TRSSearcher.label2", "\u4f20\u5165\u7684requestHelper\u65e0\u6548"));
        }
        this.m_Option = this.m_RequestHelper.getString("Option");
        this.m_Extension = this.m_RequestHelper.getString("Extension");
        this.m_DateType = CMyString.showNull(this.m_RequestHelper.getString("DateType"), "");
        this.m_StartTime = CMyString.showNull(this.m_RequestHelper.getString("StartTime"), "");
        this.m_EndTime = CMyString.showNull(this.m_RequestHelper.getString("EndTime"), "");
        String string = this.m_RequestHelper.getString("SearchType");
        if (string == null) {
            string = (String)hashMap.get("SearchType");
        }
        if (string == null) {
            string = "";
        }
        this.m_SearchType = string;
        String string2 = this.m_RequestHelper.getString("SearchScope");
        int n = 1;
        try {
            n = Integer.parseInt(string2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_SearchScope = n;
        int n2 = this.m_RequestHelper.getInt("PageSize", -1);
        if (n2 < 0) {
            try {
                n2 = Integer.parseInt((String)hashMap.get("PageSize"));
            }
            catch (Exception exception) {
                n2 = 20;
            }
        }
        this.m_PageSize = n2;
        this.m_PageIndex = this.m_RequestHelper.getInt("PageIndex", 1);
        int n3 = this.m_RequestHelper.getInt("DetailOpenType", -1);
        if (n3 < 0) {
            try {
                n3 = Integer.parseInt((String)hashMap.get("DetailOpenType"));
            }
            catch (Exception exception) {
                n3 = 1;
            }
        }
        this.m_DetailOpenType = n3;
        String string3 = this.m_RequestHelper.getString("OrderBy");
        if (string3 == null) {
            string3 = "RELEVANCE";
        }
        this.m_OrderBy = string3;
        String string4 = "";
        this.m_SearchWord = CMyString.showNull(this.m_RequestHelper.getString("SearchWord"), "").trim();
        this.m_LastSearch = CMyString.showNull(this.m_RequestHelper.getString("LastSearch"), "").trim();
        if (this.m_LastSearch != null && this.m_LastSearch.length() > 0) {
            string4 = this.m_LastSearch;
        }
        if (this.m_SearchWord != null && this.m_SearchWord.trim().length() > 0) {
            string4 = string4.length() > 0 ? "(" + string4 + ") and (" + this.dowithBlank(this.m_SearchWord) + ")" : this.dowithBlank(this.m_SearchWord);
        }
        this.m_CurrSearch = string4;
        if (this.m_CurrSearch.trim().length() <= 0) {
            throw new WCMException(I18NMessage.get(TRSSearcher.class, "TRSSearcher.label3", "\u6ca1\u6709\u4f20\u5165\u6709\u6548\u7684\u68c0\u7d22\u6761\u4ef6"));
        }
        String string5 = this.m_RequestHelper.getString("ChannelId");
        if (string5 == null || string5.trim().equals("")) {
            string5 = (String)hashMap.get("ChannelId");
        }
        if (string5 == null || string5.trim().equals("0")) {
            string5 = "";
        }
        this.m_ChannelIds = string5;
        String string6 = this.m_RequestHelper.getString("SiteId");
        if (string6 == null || string6.trim().equals("0")) {
            string6 = "";
        }
        this.m_SiteIds = string6;
        ChannelsWithRightMaker channelsWithRightMaker = new ChannelsWithRightMaker(this.m_LoginUser, 30);
        if (string5 == null || string5.trim().equals("")) {
            if (string6 == null || string6.trim().equals("")) {
                string5 = channelsWithRightMaker.getChannelIdsWithRight();
            }
        } else if (n == 1) {
            string5 = channelsWithRightMaker.getChannelIdsWithRight(string5);
        }
        if (string5 == null) {
            throw new WCMException(I18NMessage.get(TRSSearcher.class, "TRSSearcher.label4", "\u60a8\u6ca1\u6709\u6743\u9650\u8fdb\u884c\u68c0\u7d22\uff01"));
        }
        if (string5 != null && !string5.trim().equals("") && string5.length() < 500) {
            string4 = "(" + string4 + ") and docchannel=" + string5;
        }
        if (string6 != null && !string6.trim().equals("")) {
            string4 = "(" + string4 + ") and siteid=" + string6;
        }
        if (!this.m_DateType.equals("")) {
            String string7 = "";
            try {
                String string8;
                if (this.m_DateType.equals("lastweek")) {
                    string8 = CMyDateTime.now().dateAdd(12, -1).toString("yyyy-MM-dd HH:mm");
                    string7 = string7 + "crtime>='" + string8 + "'";
                }
                if (this.m_DateType.equals("lastmonth")) {
                    string8 = CMyDateTime.now().dateAdd(2, -1).toString("yyyy-MM-dd HH:mm");
                    string7 = string7 + "crtime>='" + string8 + "'";
                }
                if (this.m_DateType.equals("lastyear")) {
                    string8 = CMyDateTime.now().dateAdd(1, -1).toString("yyyy-MM-dd HH:mm");
                    string7 = string7 + "crtime>='" + string8 + "'";
                }
            }
            catch (CMyException cMyException) {
                throw new WCMException(I18NMessage.get(TRSSearcher.class, "TRSSearcher.label5", "\u6784\u9020\u65e5\u671f\u68c0\u7d22\u6761\u4ef6\u65f6\u53d1\u751f\u9519\u8bef"), cMyException);
            }
            if (this.m_DateType.equals("special")) {
                if (this.m_StartTime != null && !this.m_StartTime.trim().equals("")) {
                    string7 = string7 + "crtime>='" + this.m_StartTime + "'";
                }
                if (this.m_EndTime != null && !this.m_EndTime.trim().equals("")) {
                    string7 = string7.trim().equals("") ? string7 + "crtime<='" + this.m_EndTime + "'" : string7 + "and crtime<='" + this.m_EndTime + "'";
                }
            }
            string4 = string4.equals("") ? string7 : "(" + string4 + ") and (" + string7 + ")";
        }
        if (this.m_SearchType.equalsIgnoreCase("docparent")) {
            string4 = string4.trim().equals("") ? "(docparentid=0 or docparentid =DATA())" : "(" + string4 + ") and (docparentid=0 or docparentid =DATA())";
        }
        this.m_Where = string4;
    }

    private String dowithBlank(String string) {
        String string2 = string;
        if (string2 == null || string.length() == 0) {
            return string2;
        }
        String string3 = "([()\\[\\],/@=><!&\\*\\^\\-\\+]+)";
        Pattern pattern = Pattern.compile(string3);
        Matcher matcher = pattern.matcher(string2);
        if (matcher.find()) {
            return string2;
        }
        string2 = string2.replaceAll("(\\s+)", "\\*");
        return string2;
    }

    public String getDefaultCols() {
        String string = "doctitle;doccontent;cruser;doctags";
        String string2 = this.m_SearchType;
        if (string2.trim().equalsIgnoreCase("TITLE")) {
            string = "doctitle";
        } else if (string2.trim().equalsIgnoreCase("content")) {
            string = "doccontent";
        } else if (string2.trim().equalsIgnoreCase("author")) {
            string = "cruser";
        }
        return string;
    }

    public int getSearchScope() {
        return this.m_SearchScope;
    }

    public String getSiteIds() {
        return this.m_SiteIds;
    }
}

