/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.persistent;

import com.trs.cms.auth.persistent.User;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.WebSites;
import com.trs.components.wcm.resource.Status;
import com.trs.components.wcm.resource.Statuses;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyBitsValue;
import com.trs.infra.util.CMyString;
import com.trs.key.wcm.BaseWCMKeyUtil;
import java.io.File;
import java.sql.Connection;
import java.util.StringTokenizer;

public class WebSite
extends BaseChannel {
    public static final int OBJ_TYPE = 103;
    public static final String DB_TABLE_NAME = "WCMWEBSITE";
    public static final String DB_ID_NAME = "SITEID";
    public static final String SAVE_STATUS_KEY = "SITE_SAVE_STATUS";
    public static final String AUTO_SAVE_KEY = "SITE_AUTO_SAVE";
    public static final int AUTO_SAVE_EDIT = 0;
    public static final int AUTO_SAVE_CHG_STATUS = 1;
    public static final int AUTO_SAVE_PUBLISH = 2;
    public static final int COMMON_SITE = 0;
    public static final int PHOTO_SITE = 1;
    public static final int VIDEO_SITE = 2;
    public static final int METADATA_SITE = 4;
    public static final int PROP_INDEX_UPLOAD = 0;
    private static final int DIRECTION_MOVE_FORWARD = 1;
    private static final int DIRECTION_MOVE_BACK = -1;
    private static final int DIRECTION_MOVE_NO = 0;

    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    public int getWCMType() {
        return 103;
    }

    public String getName() {
        return (String)this.getProperty("SITENAME");
    }

    public boolean setName(String string) throws WCMException {
        return this.setProperty("SITENAME", string);
    }

    public String getDesc() {
        String string = (String)this.getProperty("SITEDESC");
        if (CMyString.isEmpty(string)) {
            string = this.getName();
        }
        return string;
    }

    public boolean setDesc(String string) throws WCMException {
        return this.setProperty("SITEDESC", string);
    }

    public String getFtpServer() {
        return (String)this.getProperty("FTPSERVER");
    }

    public boolean setFtpServer(String string) throws WCMException {
        return this.setProperty("FTPSERVER", string);
    }

    public String getFtpUser() {
        return (String)this.getProperty("FTPUSER");
    }

    public boolean setFtpUser(String string) throws WCMException {
        return this.setProperty("FTPUSER", string);
    }

    public String getFtpPassword() {
        return (String)this.getProperty("FTPPASSWORD");
    }

    public boolean setFtpPassword(String string) throws WCMException {
        return this.setProperty("FTPPASSWORD", string);
    }

    public String getFtpFolder() {
        return (String)this.getProperty("FTPFOLDER");
    }

    public boolean setFtpFolder(String string) throws WCMException {
        return this.setProperty("FTPFOLDER", string);
    }

    public String getDataPath() {
        return (String)this.getProperty("DATAPATH");
    }

    public boolean setDataPath(String string) throws WCMException {
        return this.setProperty("DATAPATH", string);
    }

    public String getWebHttp() {
        return (String)this.getProperty("WEBHTTP");
    }

    public boolean setWebHttp(String string) throws WCMException {
        return this.setProperty("WEBHTTP", string);
    }

    public int getParentId() {
        return this.getPropertyAsInt("PARENTID", 0);
    }

    public WebSite getParent() throws WCMException {
        return WebSite.findById(this.getParentId());
    }

    public boolean setParent(int n) throws WCMException {
        return this.setProperty("PARENTID", n);
    }

    public boolean setParent(WebSite webSite) throws WCMException {
        if (webSite == null) {
            return this.setParent(0);
        }
        if (!webSite.isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(WebSite.class, "WebSite.label1", "\u65e0\u6548\u7684\u7236\u7ad9\u70b9\u5bf9\u8c61(WebSite.setParent)"));
        }
        return this.setParent(webSite.getId());
    }

    public int getOrder() {
        return this.getPropertyAsInt("SITEORDER", -1);
    }

    public boolean setOrder(int n) throws WCMException {
        return this.setProperty("SITEORDER", n);
    }

    private void changeOrder() throws WCMException {
        int n;
        int n2;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        if (this.isAddMode()) {
            n2 = this.getOrder();
            n = this.getMaxOrder();
            if (n2 == -1) {
                n2 = n + 1;
            } else {
                n5 = 1;
                n4 = n;
                n3 = n2;
            }
        } else {
            if (!this.isChangeProperty("SITEORDER")) {
                return;
            }
            n2 = this.getNewPropertyAsInt("SITEORDER", -1);
            if (n2 == -1) {
                n = this.getMaxOrder();
                if (n == this.getOrder()) {
                    n2 = this.getOrder();
                } else {
                    n5 = -1;
                    n4 = n;
                    n3 = this.getOrder() + 1;
                    n2 = n;
                }
            } else if (n2 > this.getOrder()) {
                n5 = -1;
                n4 = --n2;
                n3 = this.getOrder() + 1;
            } else {
                n5 = 1;
                n4 = this.getOrder() - 1;
                n3 = n2;
            }
        }
        String string = "SITEORDER>=" + n3 + " AND SITEORDER <= " + n4;
        String string2 = "UPDATE WCMWebSite SET SITEORDER = SITEORDER+(" + n5 + ") WHERE " + string;
        WCMFilter wCMFilter = new WCMFilter("", string, "SiteOrder desc");
        WebSites webSites = WebSites.openWCMObjs(null, wCMFilter);
        DBManager.getDBManager().sqlExecuteUpdate(string2);
        for (int i = 0; i < webSites.size(); ++i) {
            WebSite webSite = (WebSite)webSites.getAt(i);
            if (webSite == null) continue;
            webSite.refreshProperty("SiteOrder", webSite.getOrder() + n5);
        }
        this.setOrder(n2);
    }

    private synchronized int getMaxOrder() throws WCMException {
        StringBuffer stringBuffer = new StringBuffer("SELECT max(SiteOrder) FROM ");
        stringBuffer.append(DB_TABLE_NAME);
        return DBManager.getDBManager().sqlExecuteIntQuery(stringBuffer.toString());
    }

    public String getOrderBy() {
        return (String)this.getProperty("SITEORDERBY");
    }

    public boolean setOrderBy(String string) throws WCMException {
        return this.setProperty("SITEORDERBY", string);
    }

    public boolean setMainFileName(String string) throws WCMException {
        return this.setAttribute("MainFileName", string);
    }

    public String getMainFileName() {
        return this.getAttributeValue("MainFileName");
    }

    public boolean setMainFileExt(String string) throws WCMException {
        return this.setAttribute("MainFileExt", string);
    }

    public String getMainFileExt() {
        return this.getAttributeValue("MainFileExt");
    }

    public boolean setOutlineName(String string) throws WCMException {
        return this.setAttribute("OutlineName", string);
    }

    public String getOutlineName() {
        return this.getAttributeValue("OutlineName");
    }

    public boolean setOutlineExt(String string) throws WCMException {
        return this.setAttribute("OutlineExt", string);
    }

    public String getOutlineExt() {
        return this.getAttributeValue("OutlineExt");
    }

    public boolean setDetailExt(String string) throws WCMException {
        return this.setAttribute("DetailExt", string);
    }

    public String getDetailExt() {
        return this.getAttributeValue("DetailExt");
    }

    public String getPubStatusIds() {
        String string = this.getPropertyAsString("PUBSTATUSES");
        return string == null ? "" : string;
    }

    public Statuses getPubStatuses(User user) throws WCMException {
        Statuses statuses = null;
        try {
            String string = this.getPubStatusIds();
            statuses = Statuses.createNewInstance(user);
            if (string == null || string.length() == 0) {
                return statuses;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            Status status = null;
            while (stringTokenizer.hasMoreElements()) {
                int n = Integer.parseInt((String)stringTokenizer.nextElement());
                status = Status.findById(n);
                if (status == null) continue;
                statuses.addElement(status);
            }
            return statuses;
        }
        catch (Exception exception) {
            throw new WCMException(1100, I18NMessage.get(WebSite.class, "WebSite.label2", "\u53d6\u7ad9\u70b9\u5141\u8bb8\u53d1\u5e03\u7684\u6587\u6863\u72b6\u6001\u96c6\u5408\u5931\u8d25\uff08WebSite.getPubStatuses\uff09"), exception);
        }
    }

    public boolean setPubStatus(String string) throws WCMException {
        if (string == null) {
            string = "";
        } else if ((string = string.trim()).length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreElements()) {
                String string2 = (String)stringTokenizer.nextElement();
                try {
                    Integer.parseInt(string2);
                }
                catch (Exception exception) {
                    throw new WCMException(10, I18NMessage.get(WebSite.class, "WebSite.label3", "\u65e0\u6548\u7684\u6587\u6863\u72b6\u6001\uff1a") + string2 + "\uff08WebSite.setPubStatus\uff09");
                }
            }
        }
        return this.setProperty("PUBSTATUSES", string);
    }

    public boolean addPubStatus(int n) throws WCMException {
        Status status = Status.findById(n);
        return this.addPubStatus(status);
    }

    public boolean addPubStatus(Status status) throws WCMException {
        if (status == null) {
            throw new WCMException(10, I18NMessage.get(WebSite.class, "WebSite.label4", "\u6307\u5b9a\u7684\u6587\u6863\u72b6\u6001\u5bf9\u8c61\u4e3a\u7a7a\uff08WebSite.addPubStatus\uff09"));
        }
        try {
            String string = String.valueOf(status.getId());
            String string2 = (String)this.getNewProperty("PUBSTATUSES");
            if (string2 == null) {
                string2 = this.getPubStatusIds();
            }
            if (("," + string2 + ",").indexOf("," + string + ",") >= 0) {
                return false;
            }
            return this.setProperty("PUBSTATUSES", (string2.length() == 0 ? "" : string2 + ",") + string);
        }
        catch (WCMException wCMException) {
            throw wCMException;
        }
        catch (Exception exception) {
            throw new WCMException(1100, I18NMessage.get(WebSite.class, "WebSite.label5", "\u6dfb\u52a0\u5141\u8bb8\u53d1\u5e03\u7684\u6587\u6863\u72b6\u6001\u5931\u8d25\uff08WebSite.addPubStatus\uff09"), exception);
        }
    }

    public boolean setFtpUpload(boolean bl) throws WCMException {
        return this.setSiteProp(0, bl);
    }

    public boolean canFtpUpload() {
        return this.getSiteProp(0);
    }

    public boolean setSiteProp(int n, boolean bl) throws WCMException {
        int n2 = this.getPropertyAsInt("SITEPROP", 0);
        if (this.isAddMode()) {
            n2 = this.getPropertyAsInt("SITEPROP", 0);
        } else if (this.isModified() && this.getNewProperty("SITEPROP") != null) {
            n2 = ((Number)this.getNewProperty("SITEPROP")).intValue();
        }
        CMyBitsValue cMyBitsValue = new CMyBitsValue(n2);
        cMyBitsValue.setBit(n, bl);
        return this.setProperty("SITEPROP", new Integer(cMyBitsValue.getValueAsInt()));
    }

    public boolean getSiteProp(int n) {
        CMyBitsValue cMyBitsValue = new CMyBitsValue(this.getPropertyAsInt("SITEPROP", 0));
        return cMyBitsValue.getBit(n);
    }

    public boolean isValid() throws WCMException {
        Object object;
        String string = null;
        if (this.isAddMode()) {
            string = (String)this.getAllProperty().get("SITENAME");
            if (string == null) {
                throw new WCMException(1106, I18NMessage.get(WebSite.class, "WebSite.label6", "\u5c5e\u6027Name\u6ca1\u6709\u8bbe\u7f6e(WebSite.isValid)"));
            }
            if (this.getProperty("PARENTID") == null) {
                throw new WCMException(1106, I18NMessage.get(WebSite.class, "WebSite.label7", "\u5c5e\u6027ParentId\u6ca1\u6709\u8bbe\u7f6e(WebSite.isValid)"));
            }
            object = null;
            try {
                object = BaseWCMKeyUtil.getInstance();
            }
            catch (Exception exception) {
                System.err.println(exception.getMessage());
                return false;
            }
            int n = object.func2();
            if (n < 0) {
                return false;
            }
            if (n > 0) {
                int n2 = -1;
                try {
                    String string2 = "select count(*) num from WCMWebSite";
                    n2 = DBManager.getDBManager().sqlExecuteIntQuery(string2);
                }
                catch (Throwable throwable) {
                    System.err.println(I18NMessage.get(WebSite.class, "WebSite.label8", "\u6ce8\u518c\u7801\u6709\u95ee\u9898\uff0c\u83b7\u53d6\u7ad9\u70b9\u6570\u4e0d\u901a\u8fc7\uff01\n"));
                    return false;
                }
                if (n2 > 0 && n2 >= n) {
                    System.err.println(I18NMessage.get(WebSite.class, "WebSite.label9", "\u65b0\u5efa\u7ad9\u70b9\u8d85\u51fa\u5f53\u524d\u6ce8\u518c\u7801\u9650\u5236\uff0c\u5982\u9700\u589e\u52a0\uff0c\u8bf7\u4e0eTRS\u516c\u53f8\u8054\u7cfb\uff0c\u611f\u8c22\u60a8\u4f7f\u7528TRS\u4ea7\u54c1\uff01\n"));
                    throw new Error(I18NMessage.get(WebSite.class, "WebSite.label10", "\u65b0\u5efa\u7ad9\u70b9\u8d85\u51fa\u5f53\u524d\u6ce8\u518c\u7801\u9650\u5236\uff0c\u5982\u9700\u589e\u52a0\uff0c\u8bf7\u4e0eTRS\u516c\u53f8\u8054\u7cfb\uff0c\u611f\u8c22\u60a8\u4f7f\u7528TRS\u4ea7\u54c1\uff01"));
                }
            }
        } else {
            if (!this.isModified()) {
                throw new WCMException(1107, I18NMessage.get(WebSite.class, "WebSite.label11", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(WebSite.isValid)"));
            }
            string = (String)this.getNewProperty("SITENAME");
        }
        if (string != null) {
            object = "ParentId=" + this.getParentId() + " and SiteName='" + CMyString.filterForSQL(string) + "'";
            if (!this.isAddMode()) {
                object = (String)object + " and " + this.getIdFieldName() + "<>" + this.getId();
            }
            if (this.checkExists((String)object)) {
                throw new WCMException(1108, I18NMessage.get(WebSite.class, "WebSite.label12", "\u7ad9\u70b9\u552f\u4e00\u6807\u8bc6[") + string + I18NMessage.get(WebSite.class, "WebSite.label13", "]\u5df2\u7ecf\u5b58\u5728\uff08WebSite.isValid\uff09"));
            }
        }
        this.changeOrder();
        return true;
    }

    protected synchronized int getNextId(Connection connection) throws WCMException {
        int n = super.getNextId(connection);
        if (this.getAllProperty().get("SITEORDER") == null) {
            this.setOrder(-1);
        }
        return n;
    }

    private String getLocalPubPath(int n) throws WCMException {
        try {
            String string = FilesMan.getFilesMan().getPathConfigValue("LP", n);
            if (string == null) {
                return null;
            }
            String string2 = this.getDataPath();
            if (string2 == null) {
                return null;
            }
            string2 = CMyString.setStrEndWith(string2, File.separatorChar);
            if (n != 0 && File.separatorChar != '/') {
                string2 = CMyString.replaceStr(string2, File.separator, "/");
            }
            return string + string2;
        }
        catch (Exception exception) {
            throw new WCMException(1100, I18NMessage.get(WebSite.class, "WebSite.label14", "\u83b7\u53d6\u7ad9\u70b9\u6587\u6863\u5b58\u653e\u7684\u672c\u5730\u8def\u5f84\u65f6\u5931\u8d25\uff08WebSite.getLocalPubPath\uff09"), exception);
        }
    }

    public String getLocalPath() throws WCMException {
        return this.getLocalPubPath(0);
    }

    public String getLocalHttpPath() throws WCMException {
        return this.getLocalPubPath(1);
    }

    public String getLocalFtpPath() throws WCMException {
        return this.getLocalPubPath(2);
    }

    public String getSaveStatusIds() {
        return "";
    }

    public Statuses getSaveStatuses(User user) throws WCMException {
        Statuses statuses = null;
        try {
            String string = this.getSaveStatusIds();
            statuses = new Statuses(user);
            if (string == null || string.length() == 0) {
                return statuses;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            Status status = null;
            while (stringTokenizer.hasMoreElements()) {
                int n = Integer.parseInt((String)stringTokenizer.nextElement());
                status = Status.findById(n);
                if (status == null) continue;
                statuses.addElement(status);
            }
            return statuses;
        }
        catch (Exception exception) {
            throw new WCMException(1100, I18NMessage.get(WebSite.class, "WebSite.label15", "\u53d6\u7ad9\u70b9\u5141\u8bb8\u4fdd\u5b58\u7684\u6587\u6863\u72b6\u6001\u96c6\u5408\u5931\u8d25\uff08WebSite.getSaveStatuses\uff09"), exception);
        }
    }

    public WebSite getSite() {
        return this;
    }

    public int getSiteId() {
        return this.id;
    }

    public boolean isSite() {
        return true;
    }

    public static final WebSite findById(int n) throws WCMException {
        if (n <= 0) {
            return null;
        }
        return (WebSite)BaseObj.findById(WebSite.class, n);
    }

    public static final WebSite createNewInstance() throws WCMException {
        return (WebSite)BaseObj.createNewInstance(WebSite.class);
    }

    public static final WebSite findByKey(Object object) throws WCMException {
        return (WebSite)BaseObj.findByKey(WebSite.class, object);
    }

    public BaseChannel getHost() {
        return null;
    }

    public String toString() {
        if (this.IS_ENGVERSION) {
            return this.getDesc();
        }
        return this.getDesc() + I18NMessage.get(WebSite.class, "WebSite.label16", "[\u7ad9\u70b9-") + this.getId() + "]";
    }

    public String getInfo() {
        return this.toString();
    }

    public int getType() {
        return this.getPropertyAsInt("SiteType", 0);
    }

    public boolean setType(int n) throws WCMException {
        return this.setProperty("SiteType", n);
    }

    public boolean isMobile() {
        return this.getPropertyAsBoolean("ISMOBILE", false);
    }

    public boolean setMobile(boolean bl) throws WCMException {
        return this.setProperty("ISMOBILE", bl);
    }
}

