/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.domain.auth;

import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.domain.IRightHost;
import com.trs.cms.auth.domain.RightHostFactory;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.ChannelSubstanceImplBase;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyString;
import java.util.List;

public class ChannelRightHostImpl
extends ChannelSubstanceImplBase
implements IRightHost {
    private static final String[] RIGHT_TYPE_IDS = new String[]{"channel", "document", "template"};
    private static final String[] RIGHT_TYPE_NAMES = new String[]{I18NMessage.get(ChannelRightHostImpl.class, "ChannelRightHostImpl.label1", "\u680f\u76ee\u7c7b"), I18NMessage.get(ChannelRightHostImpl.class, "ChannelRightHostImpl.label2", "\u6587\u6863\u7c7b"), I18NMessage.get(ChannelRightHostImpl.class, "ChannelRightHostImpl.label3", "\u6a21\u677f\u7c7b")};

    public ChannelRightHostImpl() {
    }

    public ChannelRightHostImpl(int n) throws WCMException {
        super(n);
    }

    public ChannelRightHostImpl(CMSObj cMSObj) {
        super(cMSObj);
    }

    public void validateCanDoSetRight(User user) throws WCMException {
        if (this.m_oCurrChannel == null) {
            throw new WCMException(I18NMessage.get(ChannelRightHostImpl.class, "ChannelRightHostImpl.label4", "\u6ca1\u6709\u6307\u5b9a\u9891\u9053\uff01"));
        }
        if (this.m_oCurrChannel.isDeleted()) {
            throw new WCMException(I18NMessage.get(ChannelRightHostImpl.class, "ChannelRightHostImpl.label5", "\u6307\u5b9a\u9891\u9053[") + this.m_oCurrChannel.getName() + "][ID=" + this.m_oCurrChannel.getId() + I18NMessage.get(ChannelRightHostImpl.class, "ChannelRightHostImpl.label6", "]\u5df2\u7ecf\u88ab\u5220\u9664\uff01"));
        }
        int n = 55;
        if (!AuthServer.hasRightOnSelf(user, this.m_oCurrChannel, n)) {
            throw new WCMException(CMyString.format(I18NMessage.get(ChannelRightHostImpl.class, "ChannelRightHostImpl.label7", "\u7528\u6237[{0}]\u5bf9\u4e8e\u6307\u5b9a\u7684\u9891\u9053[{1}][ID={2}]\u4e0d\u80fd\u8bbe\u7f6e\u6743\u9650\uff01"), new String[]{user.getName(), this.m_oCurrChannel.getName(), String.valueOf(this.m_oCurrChannel.getId())}));
        }
    }

    public IRightHost[] getChildren() throws WCMException {
        List list = this.m_oCurrChannel.getChildren(null);
        if (list == null || list.isEmpty()) {
            return null;
        }
        IRightHost[] iRightHostArray = new IRightHost[list.size()];
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Channel channel = (Channel)list.get(i);
            iRightHostArray[i] = channel == null ? null : new ChannelRightHostImpl(channel);
        }
        return iRightHostArray;
    }

    public String[] getRightTypeIds() {
        return RIGHT_TYPE_IDS;
    }

    public String[] getRightTypeNames() {
        return RIGHT_TYPE_NAMES;
    }

    public IRightHost getParent() throws WCMException {
        return RightHostFactory.makeRightHostFrom(this.m_oCurrChannel.getHost());
    }
}

