/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.domain;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.components.wcm.content.domain.SiteMemberMgr;
import com.trs.components.wcm.content.persistent.SiteMember;
import com.trs.components.wcm.content.persistent.SiteMembers;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.BaseIdsMan;
import com.trs.infra.common.WCMException;

public class SiteMemberIdsMan
extends BaseIdsMan {
    private SiteMembers m_oSiteMembers;
    private WebSite m_site;
    private SiteMemberMgr m_siteMemberMgr;
    private int m_nMemberType;

    protected SiteMemberIdsMan() {
    }

    public SiteMemberIdsMan(WebSite webSite, int n) throws WCMException {
        if (webSite == null) {
            throw new WCMException(10, I18NMessage.get(SiteMemberIdsMan.class, "SiteMemberIdsMan.label1", "\u65e0\u6548\u7684\u7ad9\u70b9!"));
        }
        this.m_site = webSite;
        this.m_siteMemberMgr = (SiteMemberMgr)DreamFactory.createObjectById("SiteMemberMgr");
        this.m_nMemberType = n;
        this.m_oSiteMembers = this.m_siteMemberMgr.getSiteMembers(webSite.getId(), n);
    }

    protected int getExistsSize() {
        return this.m_oSiteMembers.size();
    }

    protected int getExistsIdAt(int n) {
        SiteMember siteMember = (SiteMember)this.m_oSiteMembers.getAt(n);
        if (siteMember == null) {
            return -1;
        }
        return siteMember.getObjId();
    }

    protected void deleteExists(int n) throws WCMException {
        this.m_oSiteMembers.removeAt(n, true);
    }

    protected void addRelation(int n) throws WCMException {
        SiteMember siteMember = new SiteMember();
        siteMember.setSiteId(this.m_site.getId());
        siteMember.setObjId(n);
        siteMember.setObjType(this.m_nMemberType);
        siteMember.save(ContextHelper.getLoginUser());
    }
}

