/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.advisor;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.advisor.Step;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.db.DBManager;

public class OptionGroup
extends CMSObj {
    public static final int OBJ_TYPE = 266112697;
    public static final String DB_TABLE_NAME = "XWCMOPTIONGROUP";
    public static final String DB_ID_NAME = "OPTIONGROUPID";
    private static final int DIRECTION_MOVE_FORWARD = 1;
    private static final int DIRECTION_MOVE_BACK = -1;
    private static final int DIRECTION_MOVE_NO = 0;

    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    public int getWCMType() {
        return 266112697;
    }

    public String getOptionGroupName() {
        return this.getPropertyAsString("OPTIONGROUPNAME");
    }

    public boolean setOptionGroupName(String string) throws WCMException {
        return this.setProperty("OPTIONGROUPNAME", string);
    }

    public String getOptionGroupDesc() {
        return this.getPropertyAsString("OPTIONGROUPDESC");
    }

    public boolean setOptionGroupDesc(String string) throws WCMException {
        return this.setProperty("OPTIONGROUPDESC", string);
    }

    public String getLastOptions() {
        return this.getPropertyAsString("LASTOPTIONS");
    }

    public boolean setLastOptions(String string) throws WCMException {
        return this.setProperty("LASTOPTIONS", string);
    }

    public int getStepId() {
        return this.getPropertyAsInt("STEPID", 0);
    }

    public boolean setStepId(int n) throws WCMException {
        return this.setProperty("STEPID", n);
    }

    public int getOrder() {
        return this.getPropertyAsInt("AORDER", 0);
    }

    public boolean setOrder(int n) throws WCMException {
        return this.setProperty("AORDER", n);
    }

    public boolean isValid() throws WCMException {
        if (this.isAddMode()) {
            if (this.getProperty("OPTIONGROUPNAME") == null) {
                throw new WCMException(1106, I18NMessage.get(OptionGroup.class, "OptionGroup.label1", "\u5c5e\u6027OptionGroupName\u6ca1\u6709\u8bbe\u7f6e(OptionGroup.isValid)"));
            }
            if (this.getProperty("STEPID") == null) {
                throw new WCMException(1106, I18NMessage.get(OptionGroup.class, "OptionGroup.label2", "\u5c5e\u6027StepId\u6ca1\u6709\u8bbe\u7f6e(OptionGroup.isValid)"));
            }
        } else if (!this.isModified()) {
            throw new WCMException(1107, I18NMessage.get(OptionGroup.class, "OptionGroup.label3", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(OptionGroup.isValid)"));
        }
        this.changeOrder();
        return true;
    }

    public void insert(User user) throws WCMException {
        if (this.isAddMode() && this.isModified()) {
            super.insert(user);
        }
    }

    private void changeOrder() throws WCMException {
        int n;
        int n2;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        if (this.isAddMode()) {
            n2 = this.getOrder();
            n = this.getMaxOrder();
            if (n2 == -1) {
                n2 = n + 1;
                this.setOrder(n2);
                return;
            }
            n5 = 1;
            n4 = n;
            n3 = n2;
        } else {
            if (!this.isChangeProperty("AORDER")) {
                return;
            }
            n2 = this.getNewPropertyAsInt("AORDER", -1);
            if (n2 == -1) {
                n = this.getMaxOrder();
                if (n == this.getOrder()) {
                    n2 = this.getOrder();
                } else {
                    n5 = -1;
                    n4 = n;
                    n3 = this.getOrder() + 1;
                    n2 = n;
                }
            } else if (n2 > this.getOrder()) {
                n5 = -1;
                n4 = n2;
                n3 = this.getOrder() + 1;
            } else {
                n5 = 1;
                n4 = this.getOrder() - 1;
                n3 = n2;
            }
        }
        String string = "AORDER>=" + n3 + " AND AORDER <= " + n4 + " and STEPID=" + this.getStepId();
        String string2 = "UPDATE XWCMOPTIONGROUP SET AORDER = AORDER+(" + n5 + ") WHERE " + string;
        DBManager.getDBManager().sqlExecuteUpdate(string2);
        this.setOrder(n2);
    }

    private int getMaxOrder() throws WCMException {
        return DBManager.getDBManager().sqlExecuteIntQuery("select max(AORDER) from XWCMOPTIONGROUP where STEPID=?", new int[]{this.getStepId()});
    }

    public static final OptionGroup findById(int n) throws WCMException {
        if (n <= 0) {
            return null;
        }
        return (OptionGroup)BaseObj.findById(OptionGroup.class, n);
    }

    public static final OptionGroup createNewInstance() throws WCMException {
        return (OptionGroup)BaseObj.createNewInstance(OptionGroup.class);
    }

    public static final OptionGroup findByKey(Object object) throws WCMException {
        return (OptionGroup)BaseObj.findByKey(OptionGroup.class, object);
    }

    public Step getStep() throws WCMException {
        return Step.findById(this.getStepId());
    }
}

