/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.advisor;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.advisor.Advisor;
import com.trs.components.wcm.advisor.AdvisorMgr;
import com.trs.components.wcm.advisor.AdvisorXmlToObjConverter;
import com.trs.components.wcm.advisor.Option;
import com.trs.components.wcm.advisor.OptionGroup;
import com.trs.components.wcm.advisor.Options;
import com.trs.components.wcm.advisor.Step;
import com.trs.components.wcm.advisor.Steps;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.persistent.XmlObject;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CMyUnZipFile;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class AdvisorImporter {
    private static Logger logger = Logger.getLogger(AdvisorImporter.class);
    private String m_sImportFile;
    private Channel m_oCurrChannel;
    private boolean m_bToCurrChnl = false;
    private AdvisorXmlToObjConverter m_converter = null;
    private Map m_mOptionIdMapping = new HashMap();
    private AdvisorMgr m_oAdvisorMgr = null;

    public AdvisorImporter(int n, Channel channel) throws WCMException {
        this.m_oCurrChannel = channel;
        this.m_converter = new AdvisorXmlToObjConverter(n, channel);
        this.m_oAdvisorMgr = (AdvisorMgr)DreamFactory.createObjectById("AdvisorMgr");
    }

    public void setImportToCurrChnl(boolean bl) {
        this.m_bToCurrChnl = bl;
    }

    public void importFromZip(String string) throws WCMException {
        Object object;
        if (!CMyFile.fileExists(string)) {
            object = FilesMan.getFilesMan();
            string = ((FilesMan)object).mapFilePath(string, 0) + CMyFile.extractFileName(string);
        }
        object = CMyFile.extractFilePath(string);
        this.m_sImportFile = object = (String)object + CMyFile.extractMainFileName(string) + File.separator;
        CMyUnZipFile cMyUnZipFile = new CMyUnZipFile(string, (String)object);
        try {
            cMyUnZipFile.addFileExtFilters("xml");
            cMyUnZipFile.doUnZipAnd();
            CMyFile.deleteFile(string);
        }
        catch (CMyException cMyException) {
            throw new WCMException(200, "Zip\u6587\u4ef6\u89e3\u538b\u5931\u8d25!", cMyException);
        }
        ArrayList arrayList = cMyUnZipFile.getFilteredFiles();
        XmlObject[] xmlObjectArray = null;
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            String string2 = (String)arrayList.get(i);
            xmlObjectArray = this.m_converter.convertXml(string2, null, null);
            this.importAdvisors(xmlObjectArray, this.m_oCurrChannel);
        }
        CMyFile.deleteDir(this.m_sImportFile);
    }

    private void importAdvisors(XmlObject[] xmlObjectArray, Channel channel) throws WCMException {
        for (int i = 0; i < xmlObjectArray.length; ++i) {
            this.importAdvisor(xmlObjectArray[i], channel);
        }
    }

    private Advisor importAdvisor(XmlObject xmlObject, Channel channel) throws WCMException {
        XmlObject[] xmlObjectArray;
        String string;
        Advisor advisor = (Advisor)xmlObject.getCurrentObj();
        if (this.m_bToCurrChnl) {
            advisor.setChannelId(channel.getId());
        }
        if (!CMyString.isEmpty(string = advisor.getAppendixFileName())) {
            xmlObjectArray = FilesMan.getFilesMan();
            String string2 = xmlObjectArray.getNextFilePathName("P0", CMyFile.extractFileExt(string));
            try {
                CMyFile.copyFile(this.m_sImportFile + string, string2);
            }
            catch (CMyException cMyException) {
                throw new WCMException("\u590d\u5236\u6587\u4ef6\u5931\u8d25", cMyException);
            }
            advisor.setAppendixFileName(CMyFile.extractFileName(string2));
        }
        advisor.save(ContextHelper.getLoginUser());
        xmlObjectArray = xmlObject.getChild("XWCMSTEPS");
        this.importSteps(xmlObjectArray, advisor);
        this.afterAdvisorSave(advisor);
        return advisor;
    }

    private void afterAdvisorSave(Advisor advisor) throws WCMException {
        String string;
        Object object;
        int n;
        Object object2;
        Steps steps = this.m_oAdvisorMgr.queryStepsByAdvisor(advisor, null);
        int n2 = steps.size();
        for (int i = 0; i < n2; ++i) {
            Step step = (Step)steps.getAt(i);
            if (step == null) continue;
            object2 = this.m_oAdvisorMgr.queryOptionGroupsByStep(step, null);
            int n3 = ((BaseObjs)object2).size();
            for (n = 0; n < n3; ++n) {
                object = (OptionGroup)((BaseObjs)object2).getAt(n);
                if (object == null || CMyString.isEmpty(string = ((OptionGroup)object).getLastOptions())) continue;
                String string2 = this.getNewOptionIds(string);
                ((OptionGroup)object).setLastOptions(string2);
                ((CMSObj)object).save(ContextHelper.getLoginUser());
            }
        }
        Options options = this.m_oAdvisorMgr.queryOptionsByAdvisor(advisor, null);
        int n4 = options.size();
        for (n2 = 0; n2 < n4; ++n2) {
            object2 = (Option)options.getAt(n2);
            if (object2 == null) continue;
            n = 0;
            String string3 = ((Option)object2).getLastOptions();
            if (!CMyString.isEmpty(string3)) {
                object = this.getNewOptionIds(string3);
                ((Option)object2).setLastOptions((String)object);
                n = 1;
            }
            if (!CMyString.isEmpty((String)(object = ((Option)object2).getNotAllowedSelectOptions()))) {
                string = this.getNewOptionIds((String)object);
                ((Option)object2).setNotAllowedSelectOptions(string);
                n = 1;
            }
            if (n == 0) continue;
            ((CMSObj)object2).save(ContextHelper.getLoginUser());
        }
    }

    private String getNewOptionIds(String string) {
        if (CMyString.isEmpty(string)) {
            return "";
        }
        int[] nArray = CMyString.splitToInt(string, ",");
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < nArray.length; ++i) {
            Integer n = (Integer)this.m_mOptionIdMapping.get(new Integer(nArray[i]));
            if (n == null) continue;
            stringBuffer.append(n).append(",");
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }

    private void importSteps(XmlObject[] xmlObjectArray, Advisor advisor) throws WCMException {
        for (int i = 0; i < xmlObjectArray.length; ++i) {
            this.importStep(xmlObjectArray[i], advisor);
        }
    }

    private Step importStep(XmlObject xmlObject, Advisor advisor) throws WCMException {
        Step step = (Step)xmlObject.getCurrentObj();
        step.setAdvisorId(advisor.getId());
        step.save(ContextHelper.getLoginUser());
        XmlObject[] xmlObjectArray = xmlObject.getChild("XWCMOPTIONGROUPS");
        this.importOptionGroups(xmlObjectArray, step);
        return step;
    }

    private void importOptionGroups(XmlObject[] xmlObjectArray, Step step) throws WCMException {
        for (int i = 0; i < xmlObjectArray.length; ++i) {
            this.importOptionGroup(xmlObjectArray[i], step);
        }
    }

    private OptionGroup importOptionGroup(XmlObject xmlObject, Step step) throws WCMException {
        OptionGroup optionGroup = (OptionGroup)xmlObject.getCurrentObj();
        optionGroup.setStepId(step.getId());
        optionGroup.save(ContextHelper.getLoginUser());
        XmlObject[] xmlObjectArray = xmlObject.getChild("XWCMOPTIONS");
        this.importOptions(xmlObjectArray, optionGroup);
        return optionGroup;
    }

    private void importOptions(XmlObject[] xmlObjectArray, OptionGroup optionGroup) throws WCMException {
        for (int i = 0; i < xmlObjectArray.length; ++i) {
            this.importOption(xmlObjectArray[i], optionGroup);
        }
    }

    private Option importOption(XmlObject xmlObject, OptionGroup optionGroup) throws WCMException {
        Option option = (Option)xmlObject.getCurrentObj();
        option.setGroupId(optionGroup.getId());
        String[] stringArray = new String[]{"PICTRUE"};
        for (int i = 0; i < stringArray.length; ++i) {
            String string = option.getPropertyAsString(stringArray[i]);
            if (CMyString.isEmpty(string)) continue;
            if (!CMyFile.fileExists(this.m_sImportFile + string)) {
                logger.error((Object)CMyString.format("\u5bfc\u5165\u987e\u95ee\u56fe\u7247\u65f6\u56fe\u7247\u4e0d\u5b58\u5728[{0}]", new String[]{this.m_sImportFile + string}));
                continue;
            }
            FilesMan filesMan = FilesMan.getFilesMan();
            String string2 = filesMan.getNextFilePathName("P0", CMyFile.extractFileExt(string));
            try {
                CMyFile.copyFile(this.m_sImportFile + string, string2);
            }
            catch (CMyException cMyException) {
                throw new WCMException("\u590d\u5236\u6587\u4ef6\u5931\u8d25", cMyException);
            }
            option.setPropertyWithString(stringArray[i], CMyFile.extractFileName(string2));
        }
        Integer n = (Integer)this.m_converter.getObjIdMapping().get(option);
        option.save(ContextHelper.getLoginUser());
        this.m_mOptionIdMapping.put(n, option.getKey());
        return option;
    }
}

