/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.advisor;

import com.trs.DreamFactory;
import com.trs.ajaxservice.WCMAJAXServiceHelper;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.domain.publisher.PublishPageContext;
import com.trs.components.common.publish.domain.publisher.PublishPathCompass;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.publisher.PublishTaskContext;
import com.trs.components.common.publish.domain.tagparser.TagDocument;
import com.trs.components.common.publish.domain.tagparser.TagDocumentReader;
import com.trs.components.common.publish.domain.tagparser.TagParseHelper;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.wcm.advisor.Advisor;
import com.trs.components.wcm.advisor.AdvisorExporter;
import com.trs.components.wcm.advisor.AdvisorImporter;
import com.trs.components.wcm.advisor.AdvisorMgr;
import com.trs.components.wcm.advisor.Advisors;
import com.trs.components.wcm.advisor.Option;
import com.trs.components.wcm.advisor.OptionGroup;
import com.trs.components.wcm.advisor.OptionGroups;
import com.trs.components.wcm.advisor.Options;
import com.trs.components.wcm.advisor.Step;
import com.trs.components.wcm.advisor.Steps;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.common.WCMTypes;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.IGlueServiceProvider;

public class AdvisorCenterServiceProvider
implements IGlueServiceProvider {
    private AdvisorMgr m_oAdvisorMgr = (AdvisorMgr)DreamFactory.createObjectById("AdvisorMgr");

    public Steps queryStepsByAdvisor(MethodContext methodContext) throws Throwable {
        int n = methodContext.getObjectId();
        User user = this.getLoginUser();
        Advisor advisor = Advisor.findById(n);
        this.validRight(advisor, user, 14);
        return this.m_oAdvisorMgr.queryStepsByAdvisor(advisor, null);
    }

    public OptionGroups queryOptionGroupsByStep(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        int n = methodContext.getObjectId();
        Step step = Step.findById(n);
        if (step == null) {
            throw new WCMException(200006, I18NMessage.makeObjectNotFound(new String[]{String.valueOf(n), WCMTypes.getLowerObjName(78549201)}));
        }
        this.validStep(step, 0, user, 14);
        return this.m_oAdvisorMgr.queryOptionGroupsByStep(step, null);
    }

    public Options queryOptionsByGroup(MethodContext methodContext) throws Throwable {
        int n = methodContext.getObjectId();
        OptionGroup optionGroup = OptionGroup.findById(n);
        if (optionGroup == null) {
            throw new WCMException(200006, I18NMessage.makeObjectNotFound(new String[]{String.valueOf(n), WCMTypes.getLowerObjName(266112697)}));
        }
        this.validOptionGroup(optionGroup, 0, this.getLoginUser(), 14);
        return this.m_oAdvisorMgr.queryOptionsByOptionGroup(optionGroup, null);
    }

    public Options queryOptionsOtherSteps(MethodContext methodContext) throws WCMException {
        int n = methodContext.getValue("StepId", 0);
        Step step = Step.findById(n);
        if (step == null) {
            throw new WCMException(200006, I18NMessage.makeObjectNotFound(new String[]{String.valueOf(n), WCMTypes.getLowerObjName(78549201)}));
        }
        int n2 = step.getAdvisorId();
        this.validStep(step, 0, this.getLoginUser(), 14);
        WCMFilter wCMFilter = new WCMFilter("", "STEPID <> ? AND STEPID IN (SELECT STEPID FROM XWCMSTEP where ADVISORID=?)", "STEPID,AORDER");
        wCMFilter.addSearchValues(n);
        wCMFilter.addSearchValues(n2);
        return Options.openWCMObjs(null, wCMFilter);
    }

    public Options queryOtherOptionsInOneGroup(MethodContext methodContext) throws WCMException {
        int n = methodContext.getValue("OptionId", 0);
        Option option = Option.findById(n);
        if (option == null) {
            throw new WCMException(200006, I18NMessage.makeObjectNotFound(new String[]{String.valueOf(n), WCMTypes.getLowerObjName(1705862168)}));
        }
        int n2 = option.getGroupId();
        this.validOption(option, n2, this.getLoginUser(), 14);
        WCMFilter wCMFilter = new WCMFilter("", "GroupId = ? and optionid <> ?", "AORDER");
        wCMFilter.addSearchValues(n2);
        wCMFilter.addSearchValues(n);
        return Options.openWCMObjs(null, wCMFilter);
    }

    public int saveStep(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        int n = methodContext.getObjectId();
        int n2 = methodContext.getValue("AdvisorId", 0);
        Step step = null;
        step = n == 0 ? new Step() : Step.findById(n);
        if (n == 0 && n2 == 0) {
            throw new WCMException(I18NMessage.get(AdvisorCenterServiceProvider.class, "AdvisorCenterServiceProvider.label1", "\u5fc5\u987b\u4f20\u5165\u53c2\u6570GroupId\uff01"));
        }
        this.validStep(step, n2, user, 13);
        String[] stringArray = new String[]{"ObjectId"};
        step = (Step)WCMAJAXServiceHelper.setWCMObjectProperties(user, methodContext, step, stringArray);
        step.save(user);
        return step.getId();
    }

    public int saveOptionGroup(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        int n = methodContext.getObjectId();
        int n2 = methodContext.getValue("StepId", 0);
        OptionGroup optionGroup = null;
        optionGroup = n == 0 ? new OptionGroup() : OptionGroup.findById(n);
        if (n == 0 && n2 == 0) {
            throw new WCMException(I18NMessage.get(AdvisorCenterServiceProvider.class, "AdvisorCenterServiceProvider.label1", "\u5fc5\u987b\u4f20\u5165\u53c2\u6570GroupId\uff01"));
        }
        this.validOptionGroup(optionGroup, n2, user, 13);
        String[] stringArray = new String[]{"ObjectId"};
        optionGroup = (OptionGroup)WCMAJAXServiceHelper.setWCMObjectProperties(user, methodContext, optionGroup, stringArray);
        optionGroup.save(user);
        return optionGroup.getId();
    }

    public int saveOption(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        int n = methodContext.getObjectId();
        int n2 = methodContext.getValue("GroupId", 0);
        Option option = null;
        option = n == 0 ? new Option() : Option.findById(n);
        if (n == 0 && n2 == 0) {
            throw new WCMException(I18NMessage.get(AdvisorCenterServiceProvider.class, "AdvisorCenterServiceProvider.label1", "\u5fc5\u987b\u4f20\u5165\u53c2\u6570GroupId\uff01"));
        }
        this.validOption(option, n2, user, 13);
        String[] stringArray = new String[]{"ObjectId"};
        option = (Option)WCMAJAXServiceHelper.setWCMObjectProperties(user, methodContext, option, stringArray);
        option.save(user);
        return option.getId();
    }

    public void deleteAdvisor(MethodContext methodContext) throws WCMException {
        User user = this.getLoginUser();
        String string = methodContext.getValue("AdvisorIds");
        Advisors advisors = Advisors.findByIds(user, string);
        for (int i = advisors.size() - 1; i >= 0; --i) {
            Advisor advisor = (Advisor)advisors.getAt(i);
            if (advisor == null) continue;
            this.validRight(advisor, user, 13);
            this.m_oAdvisorMgr.deleteAdvisor(advisor);
        }
    }

    public void deleteStep(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        int n = methodContext.getObjectId();
        Step step = Step.findById(n);
        if (step == null) {
            throw new WCMException(200006, I18NMessage.makeObjectNotFound(new String[]{String.valueOf(n), WCMTypes.getLowerObjName(78549201)}));
        }
        this.validStep(step, 0, user, 13);
        this.m_oAdvisorMgr.deleteStep(step);
    }

    public void deleteOptionGroup(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        int n = methodContext.getObjectId();
        OptionGroup optionGroup = OptionGroup.findById(n);
        if (optionGroup == null) {
            throw new WCMException(200006, I18NMessage.makeObjectNotFound(new String[]{String.valueOf(n), WCMTypes.getLowerObjName(266112697)}));
        }
        this.validOptionGroup(optionGroup, 0, user, 13);
        this.m_oAdvisorMgr.deleteOptionGroup(optionGroup);
    }

    public void deleteOption(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        int n = methodContext.getObjectId();
        Option option = Option.findById(n);
        if (option == null) {
            throw new WCMException(200006, I18NMessage.makeObjectNotFound(new String[]{String.valueOf(n), WCMTypes.getLowerObjName(1705862168)}));
        }
        this.validOption(option, 0, user, 13);
        this.m_oAdvisorMgr.deleteOption(option);
    }

    public void createXMLForAdvisor(MethodContext methodContext) throws Throwable {
        int n = methodContext.getValue("ChannelId", 0);
        Channel channel = Channel.findById(n);
        if (channel == null) {
            throw new WCMException(200006, I18NMessage.makeObjectNotFound(new String[]{String.valueOf(n), WCMTypes.getLowerObjName(101)}));
        }
        boolean bl = AuthServer.hasRight(this.getLoginUser(), (CMSObj)channel, 13);
        if (!bl) {
            throw new WCMException(I18NMessage.get(AdvisorCenterServiceProvider.class, "AdvisorCenterServiceProvider.label2", "\u60a8\u6ca1\u6709\u6743\u9650\u5728\u680f\u76ee\u3010id=") + n + I18NMessage.get(AdvisorCenterServiceProvider.class, "AdvisorCenterServiceProvider.label3", "\u3011\u4e0b\u7684\u64cd\u4f5c\u987e\u95ee\u4fe1\u606f\uff01 "));
        }
        String string = methodContext.getValue("AdvisorIds");
        if (CMyString.isEmpty(string)) {
            this.createAdvisorXML(null, n, methodContext);
            return;
        }
        int[] nArray = CMyString.splitToInt(string, ",");
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = nArray[i];
            Advisor advisor = Advisor.findById(n2);
            this.createAdvisorXML(advisor, n, methodContext);
        }
    }

    public void copy(MethodContext methodContext) throws Throwable {
        CMSObj cMSObj;
        User user = this.getLoginUser();
        String string = methodContext.getValue("AdvisorIds");
        String string2 = methodContext.getValue("ChannelIds");
        Channels channels = Channels.findByIds(user, string2);
        int n = channels.size();
        for (int i = 0; i < n; ++i) {
            cMSObj = (Channel)channels.getAt(i);
            if (cMSObj == null) continue;
            this.validateRight((Channel)cMSObj, user, 13);
        }
        Advisors advisors = Advisors.findByIds(user, string);
        for (n = advisors.size() - 1; n >= 0; --n) {
            cMSObj = (Advisor)advisors.getAt(n);
            if (cMSObj == null) continue;
            this.validRight((Advisor)cMSObj, user, 13);
            this.m_oAdvisorMgr.copy((Advisor)cMSObj, channels, user);
        }
    }

    public String export(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        String string = methodContext.getValue("AdvisorIds");
        Advisors advisors = Advisors.findByIds(user, string);
        int n = advisors.size();
        for (int i = 0; i < n; ++i) {
            Advisor advisor = (Advisor)advisors.getAt(i);
            if (advisor == null) continue;
            this.validRight(advisor, user, 14);
        }
        AdvisorExporter advisorExporter = new AdvisorExporter();
        return advisorExporter.export(advisors);
    }

    public void importAdvisors(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        int n = methodContext.getValue("ImportType", 1);
        int n2 = methodContext.getValue("ChannelId", 0);
        Channel channel = Channel.findById(n2);
        if (channel == null) {
            throw new WCMException("\u4f20\u5165\u7684\u680f\u76eeId[" + n2 + "]\u4e0d\u5b58\u5728");
        }
        this.validateRight(channel, user, 13);
        String string = methodContext.getValue("ImportFile");
        AdvisorImporter advisorImporter = new AdvisorImporter(n, channel);
        advisorImporter.setImportToCurrChnl(methodContext.getValue("ImportToCurrChnl", true));
        advisorImporter.importFromZip(string);
    }

    public void delete(MethodContext methodContext) throws Throwable {
    }

    public Object query(MethodContext methodContext) throws Throwable {
        return null;
    }

    public int save(MethodContext methodContext) throws Throwable {
        return 0;
    }

    public Object findById(MethodContext methodContext) throws Throwable {
        return null;
    }

    public Object findByIds(MethodContext methodContext) throws Throwable {
        return null;
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    private void validOption(Option option, int n, User user, int n2) throws WCMException {
        int n3 = n;
        OptionGroup optionGroup = null;
        if (n3 == 0) {
            n3 = option.getGroupId();
        }
        if ((optionGroup = OptionGroup.findById(n3)) == null) {
            throw new WCMException(200006, I18NMessage.makeObjectNotFound(new String[]{String.valueOf(n3), WCMTypes.getLowerObjName(266112697)}));
        }
        this.validOptionGroup(optionGroup, 0, user, n2);
    }

    private void validOptionGroup(OptionGroup optionGroup, int n, User user, int n2) throws WCMException {
        int n3 = n;
        Step step = null;
        if (n3 == 0) {
            n3 = optionGroup.getStepId();
        }
        if ((step = Step.findById(n3)) == null) {
            throw new WCMException(200006, I18NMessage.makeObjectNotFound(new String[]{String.valueOf(n3), WCMTypes.getLowerObjName(78549201)}));
        }
        this.validStep(step, 0, user, n2);
    }

    private void validStep(Step step, int n, User user, int n2) throws WCMException {
        int n3 = n;
        Advisor advisor = null;
        if (n3 == 0) {
            n3 = step.getAdvisorId();
        }
        if ((advisor = Advisor.findById(n3)) == null) {
            throw new WCMException(200006, I18NMessage.makeObjectNotFound(new String[]{String.valueOf(n3), WCMTypes.getLowerObjName(1460271229)}));
        }
        this.validRight(advisor, user, n2);
    }

    private void validRight(Advisor advisor, User user, int n) throws WCMException {
        int n2 = advisor.getChannelId();
        Channel channel = Channel.findById(n2);
        if (channel == null) {
            throw new WCMException(200006, I18NMessage.makeObjectNotFound(new String[]{String.valueOf(n2), WCMTypes.getLowerObjName(101)}));
        }
        boolean bl = AuthServer.hasRight(this.getLoginUser(), (CMSObj)channel, n);
        if (!bl) {
            throw new WCMException(I18NMessage.get(AdvisorCenterServiceProvider.class, "AdvisorCenterServiceProvider.label2", "\u60a8\u6ca1\u6709\u6743\u9650\u5728\u680f\u76ee\u3010id=") + n2 + I18NMessage.get(AdvisorCenterServiceProvider.class, "AdvisorCenterServiceProvider.label3", "\u3011\u4e0b\u7684\u64cd\u4f5c\u987e\u95ee\u4fe1\u606f\uff01 "));
        }
    }

    private void validateRight(Channel channel, User user, int n) throws WCMException {
        boolean bl = AuthServer.hasRight(this.getLoginUser(), (CMSObj)channel, n);
        if (!bl) {
            throw new WCMException(I18NMessage.get(AdvisorCenterServiceProvider.class, "AdvisorCenterServiceProvider.label2", "\u60a8\u6ca1\u6709\u6743\u9650\u5728\u680f\u76ee\u3010id=") + channel.getId() + I18NMessage.get(AdvisorCenterServiceProvider.class, "AdvisorCenterServiceProvider.label3", "\u3011\u4e0b\u7684\u64cd\u4f5c\u987e\u95ee\u4fe1\u606f\uff01 "));
        }
    }

    private void createAdvisorXML(Advisor advisor, int n, MethodContext methodContext) throws CMyException {
        Object object;
        Object object2;
        String string = "<?xml version=\"1.0\" encoding=\"utf-8\" ?>";
        String string2 = "";
        if (advisor == null) {
            string = string + "<TRS_WIZARD FIELD=\"XML\" disFile=\"true\"/>";
        } else {
            string2 = advisor.getAdvisorName();
            string = string + "<TRS_WIZARD FIELD=\"XML\" name=\"" + string2 + "\" DisFile=\"true\"/>";
        }
        String string3 = null;
        PublishTaskContext publishTaskContext = new PublishTaskContext(null, null);
        IPublishElement iPublishElement = this.makeElement(n);
        PublishPageContext publishPageContext = new PublishPageContext(iPublishElement, publishTaskContext);
        PublishTagContext publishTagContext = new PublishTagContext(publishPageContext);
        PublishPathCompass publishPathCompass = new PublishPathCompass();
        String string4 = publishPathCompass.getLocalPath(iPublishElement, methodContext.getValue("isPreview", true));
        try {
            object2 = TagDocumentReader.read(string);
            if (object2 == null) {
                throw new WCMException(I18NMessage.get(AdvisorCenterServiceProvider.class, "AdvisorCenterServiceProvider.label4", "\u5c06\u6a21\u677f\u5185\u5bb9\u8f6c\u6362\u4e3aTagDocument\u5931\u8d25\uff01"));
            }
            object = TagParseHelper.parseItems(((TagDocument)object2).getItems(), publishTagContext);
            string3 = object[0];
        }
        catch (Exception exception) {
            throw new WCMException(I18NMessage.get(AdvisorCenterServiceProvider.class, "AdvisorCenterServiceProvider.label5", "\u89e3\u6790\u7f6e\u6807\u3010TRS_WIZARD\u3011\u5931\u8d25\uff01"), exception);
        }
        object2 = "wizard";
        object = string4 + (String)object2 + ".xml";
        CMyFile.writeFile((String)object, string3, CMyString.GET_ENCODING_DEFAULT);
        publishTagContext.getFileDistributeShip().distributeFile((String)object, iPublishElement, null, false);
    }

    private IPublishElement makeElement(int n) throws WCMException {
        IPublishElement iPublishElement = null;
        iPublishElement = PublishElementFactory.lookupElement(101, n);
        if (iPublishElement == null) {
            throw new WCMException(I18NMessage.get(AdvisorCenterServiceProvider.class, "AdvisorCenterServiceProvider.label6", "\u6307\u5b9a\u7684\u680f\u76ee[Id=") + n + I18NMessage.get(AdvisorCenterServiceProvider.class, "AdvisorCenterServiceProvider.label7", "]\u4e0d\u5b58\u5728\uff01"));
        }
        return iPublishElement;
    }
}

