/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm;

import com.trs.infra.I18NMessage;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.key.CKeyUtil;
import com.trs.license.License;
import com.trs.license.LicenseException;
import com.trs.license.LicenseUtil;

public class MyDB
implements License {
    private static final String LICENSE = "license/LICENSE.trswcm";
    private int m_nMaxSiteNum = -1;

    public int getMaxSiteNum() {
        if (this.m_nMaxSiteNum < 0) {
            this.validate();
        }
        return this.m_nMaxSiteNum;
    }

    public int getMaxUserNum() {
        return 0;
    }

    public int getPluginCode() {
        return 0;
    }

    public String validate() {
        try {
            String string = MyDB.getProductKey();
            if (string.toUpperCase().indexOf("TRSWCM6.0") != 0) {
                return I18NMessage.get(MyDB.class, "MyDB.label1", "\u4e0d\u662fTRSWCM6.0\u6ce8\u518c\u7801\uff01");
            }
            String string2 = MyDB.loadLicenseFile();
            String string3 = CKeyUtil.DecodeKey(string2 = LicenseUtil.decodeRadix64(string2)).substring(12, 14);
            int n = CKeyUtil.getKeyNum(string3);
            if (n == 99) {
                return I18NMessage.get(MyDB.class, "MyDB.label2", "Platform\u7684License");
            }
            this.m_nMaxSiteNum = n;
        }
        catch (Throwable throwable) {
            return "Validate Exception\uff01DB";
        }
        return null;
    }

    private static String getProductKey() {
        String string = MyDB.loadLicenseFile();
        String[] stringArray = (string = LicenseUtil.decodeRadix64(string)).split("-");
        if (stringArray.length <= 6) {
            throw new Error(I18NMessage.get(MyDB.class, "MyDB.label3", "\u4e0d\u662f\u6700\u65b0\u7684\u6ce8\u518c\u7801\uff01"));
        }
        return stringArray[6];
    }

    private static String loadLicenseFile() {
        String string = "";
        Class<MyDB> clazz = MyDB.class;
        String string2 = clazz.getClassLoader().getResource(LICENSE).getFile();
        try {
            string = CMyFile.readFile(string2).trim();
        }
        catch (CMyException cMyException) {
            int n = cMyException.getErrNo();
            if (55 == n) {
                throw new LicenseException(I18NMessage.get(MyDB.class, "MyDB.label4", "\u975e\u6cd5\u4f7f\u7528!\u6ca1\u6709\u627e\u5230\u5408\u6cd5\u7684License."));
            }
            throw new LicenseException(I18NMessage.get(MyDB.class, "MyDB.label5", "\u7cfb\u7edf\u542f\u52a8\u5f02\u5e38!\u6821\u9a8c\u4f7f\u7528\u8bb8\u53ef\u5931\u8d25"));
        }
        String string3 = LicenseUtil.decodeRadix64(string);
        return string3;
    }
}

