/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.stat;

import com.trs.components.stat.DefaultStatHandler;
import com.trs.components.stat.IStatHandler;
import com.trs.components.stat.IStatResult;
import com.trs.components.stat.IStatResults;
import com.trs.components.stat.StatResults;
import com.trs.components.stat.TimeRange;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.DebugTimer;
import com.trs.infra.util.database.DBType;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class StatAnalysisTool {
    private static Logger logger = Logger.getLogger(StatAnalysisTool.class);
    private IStatHandler m_Handler;
    private String[] m_StatSQLs;

    public StatAnalysisTool(String[] stringArray) {
        this.m_StatSQLs = stringArray;
        this.m_Handler = new DefaultStatHandler();
    }

    public StatAnalysisTool(String[] stringArray, IStatHandler iStatHandler) {
        this.m_StatSQLs = stringArray;
        this.m_Handler = iStatHandler;
    }

    public IStatResult stat(String string, String string2) throws WCMException {
        CMyDateTime cMyDateTime = new CMyDateTime();
        CMyDateTime cMyDateTime2 = new CMyDateTime();
        try {
            cMyDateTime.setDateTimeWithString(string);
            cMyDateTime2.setDateTimeWithString(string2);
        }
        catch (Exception exception) {
            logger.error((Object)"\u89e3\u6790\u7edf\u8ba1\u65f6\u95f4\u51fa\u73b0\u5f02\u5e38", (Throwable)exception);
            throw new WCMException("\u89e3\u6790\u7edf\u8ba1\u65f6\u95f4\u51fa\u73b0\u5f02\u5e38", exception);
        }
        return this.stat(cMyDateTime, cMyDateTime2);
    }

    public IStatResult stat(CMyDateTime cMyDateTime, CMyDateTime cMyDateTime2) throws WCMException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("\u7edf\u8ba1\u65f6\u95f4\u8303\u56f4:[" + cMyDateTime + "--" + cMyDateTime2 + "]"));
        }
        DBType dBType = DBManager.getDBManager().getDBType();
        String string = dBType.sqlDate(cMyDateTime.toString());
        String string2 = dBType.sqlDate(cMyDateTime2.toString());
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("STARTTIME", string);
        hashMap.put("ENDTIME", string2);
        this.m_Handler.initState();
        for (int i = 0; i < this.m_StatSQLs.length; ++i) {
            String string3 = CMyString.parsePageVariables(this.m_StatSQLs[i], hashMap);
            this.stat0(string3, i + 1);
        }
        return this.m_Handler.getResult();
    }

    public IStatResults stat(CMyDateTime cMyDateTime, CMyDateTime cMyDateTime2, int n) throws WCMException {
        StatResults statResults = new StatResults();
        TimeRange timeRange = new TimeRange(cMyDateTime, cMyDateTime2, n);
        try {
            while (timeRange.next()) {
                CMyDateTime cMyDateTime3 = timeRange.getRangeStart();
                CMyDateTime cMyDateTime4 = timeRange.getRangeEnd();
                statResults.addResult(this.stat(cMyDateTime3, cMyDateTime4));
                statResults.addXlabels(timeRange.getXlabel());
            }
        }
        catch (Exception exception) {
            logger.error((Object)"\u5904\u7406\u6bcf\u4e00\u4e2a\u5c0f\u6b65\u957f\u51fa\u73b0\u5f02\u5e38", (Throwable)exception);
            throw new WCMException("\u5904\u7406\u6bcf\u4e00\u4e2a\u5c0f\u6b65\u957f\u51fa\u73b0\u5f02\u5e38", exception);
        }
        return statResults;
    }

    public IStatResults stat(String string, String string2, int n) throws WCMException {
        CMyDateTime cMyDateTime = new CMyDateTime();
        CMyDateTime cMyDateTime2 = new CMyDateTime();
        try {
            cMyDateTime.setDateTimeWithString(string);
            cMyDateTime2.setDateTimeWithString(string2);
        }
        catch (Exception exception) {
            logger.error((Object)"\u89e3\u6790\u7edf\u8ba1\u65f6\u95f4\u51fa\u73b0\u5f02\u5e38", (Throwable)exception);
            throw new WCMException("\u89e3\u6790\u7edf\u8ba1\u65f6\u95f4\u51fa\u73b0\u5f02\u5e38", exception);
        }
        return this.stat(cMyDateTime, cMyDateTime2, n);
    }

    /*
     * Loose catch block
     */
    private void stat0(String string, int n) throws WCMException {
        block18: {
            Exception exception2222;
            DBManager dBManager;
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            Connection connection;
            block17: {
                connection = null;
                preparedStatement = null;
                resultSet = null;
                dBManager = DBManager.getDBManager();
                connection = dBManager.getConnection();
                preparedStatement = connection.prepareStatement(string);
                logger.debug((Object)string);
                DebugTimer debugTimer = new DebugTimer();
                debugTimer.start();
                resultSet = preparedStatement.executeQuery();
                debugTimer.stop();
                logger.debug((Object)("query use[" + debugTimer.getTime() + "]"));
                debugTimer.start();
                this.m_Handler.visitStart(resultSet, n);
                while (resultSet.next()) {
                    this.m_Handler.visitStatItem(resultSet, n);
                }
                this.m_Handler.visitEnd(n);
                debugTimer.stop();
                logger.debug((Object)("read data use[" + debugTimer.getTime() + "]"));
                Object var9_10 = null;
                if (connection != null) {
                    dBManager.freeConnection(connection);
                }
                if (preparedStatement == null) break block17;
                try {
                    preparedStatement.close();
                }
                catch (Exception exception2222) {
                    // empty catch block
                }
            }
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception2222) {}
            }
            break block18;
            {
                catch (SQLException sQLException) {
                    throw new WCMException("\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff1aSQL=" + string, sQLException);
                }
                catch (Exception exception3) {
                    throw new WCMException("\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff1aSQL=" + string, exception3);
                }
            }
            catch (Throwable throwable) {
                Exception exception42222;
                Object var9_11 = null;
                if (connection != null) {
                    dBManager.freeConnection(connection);
                }
                if (preparedStatement != null) {
                    try {
                        preparedStatement.close();
                    }
                    catch (Exception exception42222) {
                        // empty catch block
                    }
                }
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception42222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }
}

