/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.stat;

import com.trs.components.common.job.BaseStatefulScheduleWorker;
import com.trs.components.stat.IHitsCountHandler;
import com.trs.components.stat.IURLParser;
import com.trs.components.stat.URLParser;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.WCMDiscoveryFactory;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class HitsCountParserSchedule
extends BaseStatefulScheduleWorker {
    private static Logger logger = Logger.getLogger(HitsCountParserSchedule.class);
    private Date currentDate;
    private String sCurrentDate;
    private IURLParser urlParser;

    protected void execute() throws WCMException {
        int n;
        String string = this.getArgAsString("rootPath");
        File file = new File(string);
        if (!file.exists()) {
            logger.error((Object)("\u6307\u5b9a\u7684\u70b9\u51fb\u91cf\u6839\u76ee\u5f55[" + string + "]\u4e0d\u5b58\u5728"));
            return;
        }
        CMyDateTime cMyDateTime = CMyDateTime.now();
        try {
            cMyDateTime = cMyDateTime.dateAdd(3, -1);
        }
        catch (Exception exception) {
            logger.error((Object)("\u8f6c\u6362\u65e5\u671f\u5931\u8d25:" + cMyDateTime), (Throwable)exception);
        }
        this.currentDate = cMyDateTime.getDateTime();
        file = new File(file, this.getCurrentDir());
        if (!file.exists()) {
            return;
        }
        logger.debug((Object)("\u5f00\u59cb\u5206\u6790\u76ee\u5f55[" + file.getAbsolutePath() + "]\u4e0b\u7684\u70b9\u51fb\u91cf\u6587\u4ef6"));
        this.sCurrentDate = new SimpleDateFormat("yyyy-MM-dd").format(this.currentDate);
        this.urlParser = new URLParser();
        IHitsCountHandler[] iHitsCountHandlerArray = this.getHitsCountHandler();
        File[] fileArray = file.listFiles();
        for (n = 0; n < fileArray.length; ++n) {
            try {
                this.parse(fileArray[n], iHitsCountHandlerArray);
                continue;
            }
            catch (Exception exception) {
                logger.error((Object)("\u5904\u7406\u6587\u4ef6[" + fileArray[n] + "]\u70b9\u51fb\u91cf\u5931\u8d25"));
            }
        }
        for (n = 0; n < iHitsCountHandlerArray.length; ++n) {
            try {
                iHitsCountHandlerArray[n].notifyComplete();
                continue;
            }
            catch (Exception exception) {
                logger.error((Object)("\u5904\u7406\u5668notifyComplete[" + iHitsCountHandlerArray[n] + "]\u5931\u8d25"));
            }
        }
    }

    private String getCurrentDir() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        return simpleDateFormat.format(this.currentDate);
    }

    private void parse(File file, IHitsCountHandler[] iHitsCountHandlerArray) throws WCMException {
        if (!file.getName().endsWith(".xml")) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("\u5f00\u59cb\u89e3\u6790\u70b9\u51fb\u91cf\u6587\u4ef6[" + file + "]\u6210dom\u5bf9\u8c61"));
        }
        SAXReader sAXReader = new SAXReader();
        Document document = null;
        try {
            document = sAXReader.read(file);
        }
        catch (DocumentException documentException) {
            logger.error((Object)("\u89e3\u6790\u6587\u4ef6[" + file + "]\u6210document\u5bf9\u8c61\u65f6\u51fa\u73b0\u5f02\u5e38"), (Throwable)documentException);
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("\u5b8c\u6210\u89e3\u6790\u70b9\u51fb\u91cf\u6587\u4ef6[" + file + "]\u6210dom\u5bf9\u8c61"));
        }
        Iterator iterator = document.getRootElement().elementIterator("item");
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            String string = element.selectSingleNode("url").getText();
            String string2 = element.selectSingleNode("hits").getText();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("\u5904\u7406\u70b9\u51fb\u91cf[" + string + "][" + string2 + "]"));
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("hitsTime", this.sCurrentDate);
            hashMap.put("hitsCount", string2);
            try {
                BaseObj baseObj = this.urlParser.parse(string);
                this.parse(baseObj, hashMap, iHitsCountHandlerArray);
            }
            catch (Exception exception) {
                logger.error((Object)("\u5904\u7406\u70b9\u51fb\u91cf[" + string + "][" + string2 + "]\u5931\u8d25"));
            }
        }
    }

    private void parse(BaseObj baseObj, Map map, IHitsCountHandler[] iHitsCountHandlerArray) {
        for (int i = 0; i < iHitsCountHandlerArray.length; ++i) {
            try {
                iHitsCountHandlerArray[i].handle(baseObj, map);
                continue;
            }
            catch (WCMException wCMException) {
                logger.debug((Object)("\u5904\u7406\u5bf9\u8c61[" + baseObj + "]\u70b9\u51fb\u91cf\u65f6\u51fa\u73b0\u5f02\u5e38"), (Throwable)wCMException);
            }
        }
    }

    private IHitsCountHandler[] getHitsCountHandler() {
        Iterator iterator = WCMDiscoveryFactory.getDiscovery().getImplementors(IHitsCountHandler.class.getName());
        if (iterator == null) {
            return new IHitsCountHandler[0];
        }
        ArrayList arrayList = new ArrayList();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            try {
                arrayList.add(Class.forName(string).newInstance());
                logger.debug((Object)("\u52a0\u8f7d\u70b9\u51fb\u91cf\u5904\u7406\u5668:" + string));
            }
            catch (Exception exception) {
                logger.error((Object)("\u52a0\u8f7d\u70b9\u51fb\u91cf\u5904\u7406\u5668[" + string + "]\u51fa\u73b0\u9519\u8bef"), (Throwable)exception);
            }
        }
        return arrayList.toArray(new IHitsCountHandler[0]);
    }
}

