/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.service;

import com.trs.DreamFactory;
import com.trs.ajaxservice.WCMProcessServiceHelper;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.cms.content.CMSObjDefaultImpl;
import com.trs.components.filter.QueryFilterFactory;
import com.trs.components.metadata.MetaDataConstants;
import com.trs.components.metadata.center.IClassInfoViewMgr;
import com.trs.components.metadata.center.IMetaViewEmployerMgr;
import com.trs.components.metadata.center.MetaDataCenterClassInfoHelper;
import com.trs.components.metadata.center.MetaDataCenterHelper;
import com.trs.components.metadata.center.MetaViewData;
import com.trs.components.metadata.center.MetaViewDatas;
import com.trs.components.metadata.center.xml.MetaViewDataExporter;
import com.trs.components.metadata.center.xml.MetaViewDataImporter;
import com.trs.components.metadata.definition.ClassInfo;
import com.trs.components.metadata.definition.ClassInfos;
import com.trs.components.metadata.definition.IMetaDataDefCacheMgr;
import com.trs.components.metadata.definition.IMetaDataDefMgr;
import com.trs.components.metadata.definition.MetaDataDefHelper;
import com.trs.components.metadata.definition.MetaView;
import com.trs.components.metadata.definition.MetaViewField;
import com.trs.components.metadata.definition.MetaViewFields;
import com.trs.components.metadata.service.MetaViewDataExporter4MuchData;
import com.trs.components.metadata.service.ViewRangeConstants;
import com.trs.components.metadata.service.WCMFilterMakerForContainsChildren;
import com.trs.components.wcm.content.domain.AppendixMgr;
import com.trs.components.wcm.content.domain.DocumentMgr;
import com.trs.components.wcm.content.domain.auth.DocumentAuthServer;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.ChnlDoc;
import com.trs.components.wcm.content.persistent.ChnlDocs;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.resource.DocLevel;
import com.trs.components.wcm.resource.DocLevelMgr;
import com.trs.components.wcm.resource.DocLevels;
import com.trs.components.wcm.resource.Status;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.persistent.util.SynChildrenExecutorBase;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.Reports;
import com.trs.infra.util.database.FieldInfo;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.exception.ServiceInvocationException;
import com.trs.webframework.provider.ISelfDefinedServiceProvider;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class MetaDataCenterServiceProvider
implements ISelfDefinedServiceProvider {
    private IMetaViewEmployerMgr m_oMetaViewEmployerMgr = null;
    private IMetaDataDefMgr m_oMetaDataDefMgr = null;
    private IClassInfoViewMgr m_oClassInfoViewMgr = null;
    private Logger logger = Logger.getLogger(MetaDataCenterServiceProvider.class);
    private AppendixMgr m_oAppendixMgr = null;
    private IMetaDataDefCacheMgr m_oMetaDataDefCacheMgr = null;
    private static final String SQL_QUERY_CHANNELS = "exists(select 1 from XWCMMetaViewEmployer where XWCMMetaViewEmployer.ViewId=? and XWCMMetaViewEmployer.ChannelId=WCMChnlDoc.ChnlId)";

    public MetaDataCenterServiceProvider() {
        this.m_oMetaDataDefMgr = (IMetaDataDefMgr)DreamFactory.createObjectById("IMetaDataDefMgr");
        this.m_oMetaViewEmployerMgr = (IMetaViewEmployerMgr)DreamFactory.createObjectById("IMetaViewEmployerMgr");
        this.m_oClassInfoViewMgr = (IClassInfoViewMgr)DreamFactory.createObjectById("IClassInfoViewMgr");
        this.m_oAppendixMgr = (AppendixMgr)DreamFactory.createObjectById("AppendixMgr");
        this.m_oMetaDataDefCacheMgr = (IMetaDataDefCacheMgr)DreamFactory.createObjectById("IMetaDataDefCacheMgr");
    }

    public MetaViewData saveMetaViewData(MethodContext methodContext) throws Throwable {
        Object object;
        Document document;
        User user = this.getLoginUser();
        Channel channel = null;
        MetaView metaView = null;
        MetaViewData metaViewData = null;
        int n = methodContext.getObjectId();
        if (n == 0) {
            channel = this.findChannelById(methodContext.getValue("ChannelId", 0));
            if (!AuthServer.hasRight(user, (CMSObj)channel, 31)) {
                throw new WCMException(1002, I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label1", "\u6ca1\u6709\u6743\u9650\u5728\u5f53\u524d\u680f\u76ee[") + channel.getName() + "][ID=" + channel.getId() + I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label2", "]\u4e0b\u65b0\u5efa\u8bb0\u5f55\uff01"));
            }
            metaView = this.findViewByChannel(channel);
            metaViewData = new MetaViewData(metaView);
        } else {
            metaViewData = MetaViewData.findById(n);
            if (metaViewData == null) {
                throw new WCMException(200006, I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label3", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u5728\u6307\u5b9a\u89c6\u56fe\u4e0b\u63d0\u4ea4\u7684\u6570\u636e\uff01[Id=") + n + "]");
            }
            channel = metaViewData.getChannel();
            methodContext.setValue("channelId", channel.getId());
            document = metaViewData.getDocument();
            int n2 = methodContext.getValue("FlowDocId", 0);
            if (n2 > 0 && n > 0) {
                WCMProcessServiceHelper.validateWorkFlowRight(user, document, n2, 0, I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label4", "\u4fee\u6539"));
            } else if (!DocumentAuthServer.hasRight(user, (BaseChannel)channel, document, 32)) {
                throw new WCMException(1002, I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label1", "\u6ca1\u6709\u6743\u9650\u5728\u5f53\u524d\u680f\u76ee[") + channel.getName() + "][ID=" + channel.getId() + I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label5", "]\u4e0b\u4fee\u6539\u8bb0\u5f55\uff01"));
            }
            metaView = metaViewData.getMetaView();
            metaViewData.validCanEditAndLock(user);
        }
        metaViewData = MetaDataCenterServiceProvider.setViewDataProperties(methodContext, metaViewData);
        MetaDataCenterHelper.renderFields(metaViewData);
        MetaDataCenterClassInfoHelper.renderClassInfoFields(metaViewData);
        if (methodContext.getValue("DocStatus", 0) == 1028) {
            metaViewData.setSkipValid(true);
        }
        metaViewData.save(user);
        if (n > 0) {
            int n3 = methodContext.getValue("DocStatus", 0);
            Document document2 = metaViewData.getDocument();
            if (n3 == 1 && document2.getStatusId() == 1028) {
                object = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
                ((DocumentMgr)object).changeStatus(document2, document2.getChannel(), Status.findById(1));
            }
        }
        document = Document.findById(metaViewData.getId());
        try {
            WCMProcessServiceHelper.startDocumentInFlow(user, document, methodContext);
        }
        catch (Throwable throwable) {
            object = new ServiceInvocationException(I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label6", "\u867d\u7136\u5df2\u6210\u529f\u65b0\u589e\u6587\u6863[") + document.getTitle() + "-" + document.getId() + I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label7", "]\uff0c\u4f46\u5c06\u5176\u6295\u5165\u6d41\u8f6c\u5931\u8d25\uff01"), throwable);
            ((ServiceInvocationException)object).setErrorCode("17080");
            throw object;
        }
        return metaViewData;
    }

    public Reports importMetaViewDatas(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        Channel channel = null;
        MetaView metaView = null;
        channel = this.findChannelById(methodContext.getValue("ChannelId", 0));
        if (!AuthServer.hasRight(user, (CMSObj)channel, 31)) {
            throw new WCMException(1002, I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label1", "\u6ca1\u6709\u6743\u9650\u5728\u5f53\u524d\u680f\u76ee[") + channel.getName() + "][ID=" + channel.getId() + I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label8", "]\u4e0b\u65b0\u5efa\u6587\u6863\uff01"));
        }
        metaView = this.findViewById(methodContext.getValue("ViewId", 0));
        String string = null;
        string = methodContext.getValue("XMLSource", 3) == 3 ? MetaDataDefHelper.getViewApplicationPath(metaView.getId()) + "data.xsl" : methodContext.getValue("XSLFile");
        MetaViewDataImporter metaViewDataImporter = new MetaViewDataImporter(user, metaView, channel);
        metaViewDataImporter.setImportToCurrChannel(methodContext.getValue("ImportToCurrChannel", true));
        metaViewDataImporter.setImportByChnlName(methodContext.getValue("ImportByChnlName", true));
        return metaViewDataImporter.importFromFile(1, methodContext.getValue("ImportFile"), string);
    }

    public MetaViewDatas queryViewDatas(MethodContext methodContext) throws Throwable {
        WCMFilter wCMFilter;
        Object object;
        Object object2;
        int n;
        Object object3;
        int n2;
        User user = this.getLoginUser();
        Channel channel = null;
        MetaView metaView = null;
        int n3 = methodContext.getValue("ViewId", 0);
        if (n3 > 0) {
            metaView = this.findViewById(n3);
        } else {
            channel = this.findChannelById(methodContext.getValue("ChannelId", 0));
            metaView = this.findViewByChannel(channel);
        }
        Channels channels = new Channels(null, 1, 1);
        if (channel != null) {
            n2 = methodContext.getValue("_queryType_", 0);
            if (n2 == ViewRangeConstants.SAME_VIEW_CONTAIN_CHILDREN || channel.isContainsChildren()) {
                object3 = new WCMFilterMakerForContainsChildren(channel);
                ((SynChildrenExecutorBase)object3).execute(user);
                channels = ((WCMFilterMakerForContainsChildren)object3).getCurrChannels();
            } else if (n2 == ViewRangeConstants.SAME_VIEW_CONTAIN_ALL) {
                channels = this.m_oMetaViewEmployerMgr.getEmployers(metaView, null);
            } else {
                channels.addElement(channel);
            }
        } else {
            channels = this.m_oMetaViewEmployerMgr.getEmployers(metaView, null);
        }
        for (n2 = channels.size() - 1; n2 >= 0; --n2) {
            object3 = (Channel)channels.getAt(n2);
            if (object3 == null || AuthServer.hasRight(user, (CMSObj)object3, 30)) continue;
            channels.remove((BaseObj)object3, false);
        }
        MetaViewDatas metaViewDatas = new MetaViewDatas(metaView);
        metaViewDatas.setCurrUser(user);
        if (channels.isEmpty()) {
            return metaViewDatas;
        }
        object3 = this.getQueryFilter(methodContext, user, metaView);
        metaViewDatas.setSelectFields(methodContext.getValue("ChnlDocSelectFields"), ((WCMFilter)object3).getSelect());
        ((WCMFilter)object3).setSelect(null);
        String string = methodContext.getValue("_sqlWhere_");
        if (!CMyString.isEmpty(string)) {
            if (((WCMFilter)object3).getWhere().length() > 0) {
                n = methodContext.getValue("IsOr", true) ? 1 : 0;
                ((WCMFilter)object3).setWhere(((WCMFilter)object3).getWhere() + (n != 0 ? " or " : " and ") + "(" + string + ")");
            } else {
                ((WCMFilter)object3).setWhere("(" + string + ")");
            }
        }
        if ((n = methodContext.getValue("FilterType", -1)) != -1) {
            object2 = QueryFilterFactory.getInstance();
            object = object2.createQueryFilter(n);
            wCMFilter = object.getFilter(methodContext);
            ((WCMFilter)object3).mergeWith(wCMFilter);
        }
        object2 = MetaDataCenterHelper.makeFilterWithClassInfos(methodContext.getValue("ClassInfoIds"), methodContext.getValue("ContainsChildClassInfoIds", true));
        ((WCMFilter)object3).mergeWith((WCMFilter)object2);
        this.logger.debug(object3);
        metaViewDatas.setPageSize(methodContext.getPageSize());
        metaViewDatas.setCurrPage(methodContext.getPageIndex());
        metaViewDatas.setRightIndex(64);
        metaViewDatas.setNeedWithAuthFilter(user, true);
        if (channels.size() > 900) {
            object = new StringBuffer(1024);
            wCMFilter = new WCMFilter("", "", "");
            this.makeDocLevelWhere(wCMFilter, (StringBuffer)object);
            String string2 = "exists(select 1 from XWCMMetaViewEmployer where XWCMMetaViewEmployer.ViewId=" + metaView.getId() + " and XWCMMetaViewEmployer.ChannelId=WCMChnlDoc.ChnlId" + " and exists(select 1" + " from WCMChannel" + " where XWCMMetaViewEmployer.ChannelId=WCMChannel.ChannelId" + " and (WCMChannel.USEDOCLEVEL =0" + " or WCMChannel.USEDOCLEVEL is null" + " or (WCMChannel.USEDOCLEVEL =1 " + object + "))))";
            wCMFilter.setWhere(string2);
            ((WCMFilter)object3).mergeWith(wCMFilter);
            metaViewDatas.loadViewDatas((WCMFilter)object3);
        } else {
            metaViewDatas.open(channels, (WCMFilter)object3);
        }
        return metaViewDatas;
    }

    public MetaViewDatas queryViewDatasNoView(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        String string = methodContext.getValue("TABLENAME");
        MetaViewDatas metaViewDatas = new MetaViewDatas(string);
        metaViewDatas.setCurrUser(user);
        String string2 = methodContext.getValue("SELECTFIELDS");
        String string3 = this.tranFieldName(methodContext, string2);
        WCMFilter wCMFilter = this.getQueryFilter(methodContext, user);
        WCMFilter wCMFilter2 = new WCMFilter("", "", "", string3);
        wCMFilter.mergeWith(wCMFilter2);
        this.logger.debug((Object)wCMFilter);
        String string4 = wCMFilter.getWhere();
        String string5 = string + ".metadataid = WCMChnlDoc.docid";
        string4 = CMyString.isEmpty(string4) ? string5 : string5 + " and " + "(" + string4 + ")";
        wCMFilter.setWhere(string4);
        wCMFilter.setFrom(string + ",WCMChnlDoc");
        metaViewDatas.setSelectFields(methodContext.getValue("ChnlDocSelectFields"), string3);
        metaViewDatas.setPageSize(methodContext.getPageSize());
        metaViewDatas.setCurrPage(methodContext.getPageIndex());
        metaViewDatas.setRightIndex(64);
        metaViewDatas.setNeedWithAuthFilter(user, true);
        this.logger.debug((Object)wCMFilter);
        metaViewDatas.loadViewDatas(wCMFilter);
        return metaViewDatas;
    }

    private WCMFilter getQueryFilter(MethodContext methodContext, User user, MetaView metaView) throws WCMException, CMyException {
        MetaViewFields metaViewFields = this.m_oMetaDataDefMgr.getViewFields(user, metaView, new WCMFilter("", "InOutline=1 or SearchField=1", ""));
        boolean bl = metaView.isMultiTable();
        WCMFilter wCMFilter = new WCMFilter("", "", "");
        StringBuffer stringBuffer = new StringBuffer((metaViewFields.size() + 1) * 10);
        StringBuffer stringBuffer2 = new StringBuffer(metaViewFields.size() * 10);
        stringBuffer.append("MetaDataId");
        String string = metaView.getTrueTableName();
        int n = metaViewFields.size();
        for (int i = 0; i < n; ++i) {
            MetaViewField metaViewField = (MetaViewField)metaViewFields.getAt(i);
            if (metaViewField == null) continue;
            if (metaViewField.isInOutline()) {
                stringBuffer.append(",");
                if (bl || metaViewField.getDBName().equalsIgnoreCase(metaViewField.getName())) {
                    stringBuffer.append(metaViewField.getName());
                } else {
                    stringBuffer.append(metaViewField.getDBName() + " " + metaViewField.getName());
                }
            }
            if (!metaViewField.isSearchField()) continue;
            boolean bl2 = false;
            String string2 = null;
            String string3 = metaViewField.getTableName() + "." + metaViewField.getDBName();
            string2 = bl ? string + "." + metaViewField.getName() : string + "." + metaViewField.getDBName();
            String string4 = methodContext.getValue(string3);
            if (string4 == null) {
                string4 = methodContext.getValue(metaViewField.getName());
            }
            if (!methodContext.getValue("_isAdvanceSearch_", false) && !CMyString.isEmpty(string4)) {
                String string5 = string4;
                if (CMyString.isEmpty(string4 = this.getIdsFromDescs(metaViewField, string4))) {
                    string4 = string5;
                }
                if (CMyString.isEmpty(string4) && !methodContext.getValue("IsOr", true)) {
                    stringBuffer2 = new StringBuffer("1 != 1");
                }
            }
            if (metaViewField.getType() == 9 || metaViewField.getType() == 10) {
                bl2 = true;
            }
            this.makeFilter(wCMFilter, stringBuffer2, string2, metaViewField.getDBType(), string4, methodContext.getValue("IsOr", true), methodContext, bl2);
        }
        String string6 = methodContext.getValue("ViewDataSelectFields");
        if (!CMyString.isEmpty(string6)) {
            if (("," + string6 + ",").indexOf(",MetaDataId,") < 0) {
                string6 = string6 + ",MetaDataId";
            }
            wCMFilter.setSelect(string6);
        } else {
            wCMFilter.setSelect(stringBuffer.toString());
        }
        if (stringBuffer2.length() > 0) {
            wCMFilter.setWhere(stringBuffer2.toString());
        }
        wCMFilter.mergeWith(methodContext.getExtraWCMFilter());
        return wCMFilter;
    }

    private WCMFilter getQueryFilter(MethodContext methodContext, User user) throws Throwable {
        String string;
        WCMFilter wCMFilter = new WCMFilter("", "", "", "");
        String string2 = methodContext.getValue("SELECTFIELDS");
        if (string2.indexOf(string = CMyString.showNull(methodContext.getValue("CURRFIELD"))) == -1) {
            string2 = string2 + "," + string;
        }
        String[] stringArray = string2.split(",");
        String string3 = " or ";
        if (!"true".equals(methodContext.getValue("ISOR"))) {
            string3 = " and ";
        }
        int n = methodContext.getValue("VIEWID", 0);
        MetaView metaView = MetaView.findById(n);
        MetaViewFields metaViewFields = this.m_oMetaDataDefMgr.getViewFields(user, metaView, new WCMFilter("", "InOutline=1 or SearchField=1", ""));
        StringBuffer stringBuffer = new StringBuffer(metaViewFields.size() * 10);
        String string4 = methodContext.getValue("TABLENAME");
        String string52 = null;
        for (String string52 : stringArray) {
            MetaViewField metaViewField = this.m_oMetaDataDefCacheMgr.getMetaViewField(n, string52);
            if (metaViewField == null || metaViewField.isFromMainTable() || !metaViewField.isSearchField() && !metaViewField.getName().equalsIgnoreCase(string)) continue;
            boolean bl = false;
            string52 = string4 + "." + metaViewField.getDBName();
            String string6 = methodContext.getValue(metaViewField.getName());
            if (!methodContext.getValue("_isAdvanceSearch_", false) && !CMyString.isEmpty(string6)) {
                String string7 = string6;
                if (CMyString.isEmpty(string6 = this.getIdsFromDescs(metaViewField, string6))) {
                    string6 = string7;
                }
                if (CMyString.isEmpty(string6) && !methodContext.getValue("IsOr", true)) {
                    stringBuffer = new StringBuffer("1 != 1");
                }
            }
            if (metaViewField.getType() == 9 || metaViewField.getType() == 10) {
                bl = true;
            }
            this.makeFilter(wCMFilter, stringBuffer, string52, metaViewField.getDBType(), string6, methodContext.getValue("IsOr", true), methodContext, bl);
        }
        String string8 = methodContext.getValue("METADATAID");
        if (!CMyString.isEmpty(string8)) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(string3).append(' ');
            }
            stringBuffer.append("MetaDataId = ? ");
            wCMFilter.addSearchValues(Integer.parseInt(string8));
        }
        if (stringBuffer.length() > 0) {
            wCMFilter.setWhere(stringBuffer.toString());
        }
        this.logger.debug((Object)wCMFilter);
        wCMFilter.mergeWith(methodContext.getExtraWCMFilter());
        this.logger.debug((Object)wCMFilter);
        return wCMFilter;
    }

    private String tranFieldName(MethodContext methodContext, String string) throws WCMException {
        String string2 = CMyString.showNull(methodContext.getValue("CURRFIELD"));
        if (string.indexOf(string2) == -1) {
            string = string + "," + string2;
        }
        String[] stringArray = string.split(",");
        int n = methodContext.getValue("VIEWID", 0);
        String[] stringArray2 = new String[stringArray.length];
        String string32 = null;
        for (String string32 : stringArray) {
            MetaViewField metaViewField = this.m_oMetaDataDefCacheMgr.getMetaViewField(n, string32);
            if (metaViewField == null || metaViewField.isFromMainTable()) continue;
            stringArray2[var8_8] = metaViewField.getDBName();
        }
        String string4 = "";
        int n2 = 0;
        for (int i = 0; i < stringArray2.length; ++i) {
            if (CMyString.isEmpty(stringArray2[i])) continue;
            if (n2 == 0) {
                string4 = stringArray2[i];
                n2 = 1;
            }
            string4 = string4 + "," + stringArray2[i];
        }
        return string4;
    }

    private String getIdsFromDescs(MetaViewField metaViewField, String string) throws WCMException {
        if (CMyString.isEmpty(string)) {
            return string;
        }
        switch (MetaDataConstants.formatOfEnumValue(metaViewField.getType())) {
            case -1: {
                StringBuffer stringBuffer = new StringBuffer(100);
                String[] stringArray = metaViewField.getValuesFromLabel(string);
                for (int i = 0; i < stringArray.length; ++i) {
                    stringBuffer.append(stringArray[i]).append("|");
                }
                if (stringBuffer.length() > 0) {
                    stringBuffer.setLength(stringBuffer.length() - 1);
                }
                string = stringBuffer.toString();
                break;
            }
            case 10: {
                WCMFilter wCMFilter = new WCMFilter();
                StringBuffer stringBuffer = new StringBuffer(100);
                stringBuffer.append("(ClassInfoId=").append(metaViewField.getClassId());
                stringBuffer.append(" or RootId=").append(metaViewField.getClassId());
                stringBuffer.append(") and  (CName like ?) ");
                wCMFilter.addSearchValues("%" + string + "%");
                wCMFilter.setWhere(stringBuffer.toString());
                ClassInfos classInfos = ClassInfos.openWCMObjs(null, wCMFilter);
                string = classInfos.getIdListAsString('|');
                break;
            }
        }
        return string;
    }

    private void makeFilter(WCMFilter wCMFilter, StringBuffer stringBuffer, String string, int n, String string2, boolean bl, MethodContext methodContext, boolean bl2) throws CMyException {
        if (n != 93) {
            this.makeFilterForNormalField(wCMFilter, stringBuffer, string, n, string2, bl, bl2);
        } else {
            this.makeFilterForDateField(wCMFilter, stringBuffer, string, string2, methodContext);
        }
    }

    private void makeFilterForNormalField(WCMFilter wCMFilter, StringBuffer stringBuffer, String string, int n, String string2, boolean bl, boolean bl2) {
        if (CMyString.isEmpty(string2)) {
            return;
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.append(bl ? " or " : " and ");
        }
        String[] stringArray = null;
        boolean bl3 = false;
        if (string2.indexOf(124) >= 0) {
            stringArray = string2.split("\\|");
            bl3 = true;
        } else {
            stringArray = string2.split("\\s");
            bl3 = false;
        }
        stringBuffer.append("(");
        if (bl2) {
            string = DBManager.getDBManager().getDBType().sqlConcatStr("','", string, "','");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringArray[i].trim();
            if (CMyString.isEmpty(stringArray[i])) continue;
            if (bl2) {
                stringArray[i] = "," + stringArray[i] + ",";
            }
            this.setFilterOfNormalField(wCMFilter, stringBuffer, string, n, stringArray[i]);
            if (i >= stringArray.length - 1) continue;
            stringBuffer.append(bl3 ? " or " : " and ");
        }
        stringBuffer.append(")");
    }

    private void setFilterOfNormalField(WCMFilter wCMFilter, StringBuffer stringBuffer, String string, int n, String string2) {
        if (string2 == null || CMyString.isEmpty(string2)) {
            return;
        }
        switch (n) {
            case 12: 
            case 2005: {
                stringBuffer.append(string);
                if (string2.startsWith("-")) {
                    stringBuffer.append(" not");
                    string2 = string2.substring(1);
                }
                stringBuffer.append(" like ?");
                wCMFilter.addSearchValues("%" + string2 + "%");
                break;
            }
            case 4: {
                int n2;
                try {
                    n2 = Integer.parseInt(string2);
                }
                catch (Throwable throwable) {
                    n2 = 0;
                }
                stringBuffer.append(string);
                if (string2.startsWith("-")) {
                    stringBuffer.append(" !");
                    n2 = -n2;
                }
                stringBuffer.append("=?");
                wCMFilter.addSearchValues(n2);
                break;
            }
            case 6: {
                float f;
                try {
                    f = Float.parseFloat(string2);
                }
                catch (Throwable throwable) {
                    f = 0.0f;
                }
                stringBuffer.append(string);
                if (string2.startsWith("-")) {
                    stringBuffer.append(" !");
                }
                stringBuffer.append("=?");
                wCMFilter.addSearchValues(f);
                break;
            }
            case 8: {
                double d;
                try {
                    d = Double.parseDouble(string2);
                }
                catch (Throwable throwable) {
                    d = 0.0;
                }
                stringBuffer.append(string);
                if (string2.startsWith("-")) {
                    stringBuffer.append(" !");
                }
                stringBuffer.append("=?");
                wCMFilter.addSearchValues(d);
                break;
            }
        }
    }

    private void makeFilterForDateField(WCMFilter wCMFilter, StringBuffer stringBuffer, String string, String string2, MethodContext methodContext) throws CMyException {
        boolean bl = methodContext.getValue("IsOr", true);
        boolean bl2 = methodContext.getValue("_isAdvanceSearch_", false);
        CMyDateTime cMyDateTime = new CMyDateTime();
        if (bl2) {
            int n = string.indexOf("WCMMetaTable");
            String string3 = null;
            if (n == 0) {
                string3 = string.substring("WCMMetaTable".length());
            }
            String string4 = methodContext.getValue("_dateStartSuffix_");
            String string5 = methodContext.getValue(string + string4);
            if (string5 == null && n == 0) {
                string5 = methodContext.getValue(string3 + string4);
            }
            if (!cMyDateTime.testDateFormat(string5)) {
                string5 = null;
            }
            String string6 = methodContext.getValue("_dateEndSuffix_");
            String string7 = methodContext.getValue(string + string6);
            if (string7 == null && n == 0) {
                string7 = methodContext.getValue(string3 + string6);
            }
            if (!cMyDateTime.testDateFormat(string7)) {
                string7 = null;
            }
            if (CMyString.isEmpty(string5) && CMyString.isEmpty(string7)) {
                return;
            }
            if (stringBuffer.length() > 0) {
                stringBuffer.append(bl ? " or " : " and ");
            }
            stringBuffer.append("(");
            this.setFilterOfDate(wCMFilter, stringBuffer, string, string5, ">=?");
            if (!CMyString.isEmpty(string5) && !CMyString.isEmpty(string7)) {
                stringBuffer.append(" and ");
            }
            this.setFilterOfDate(wCMFilter, stringBuffer, string, string7, "<=?");
            stringBuffer.append(")");
        } else {
            if (CMyString.isEmpty(string2) || !cMyDateTime.testDateFormat(string2)) {
                return;
            }
            if (stringBuffer.length() > 0) {
                stringBuffer.append(bl ? " or " : " and ");
            }
            this.setFilterOfDate(wCMFilter, stringBuffer, string, string2, "=?");
        }
    }

    private void setFilterOfDate(WCMFilter wCMFilter, StringBuffer stringBuffer, String string, String string2, String string3) throws CMyException {
        if (!CMyString.isEmpty(string2)) {
            stringBuffer.append(string);
            stringBuffer.append(string3);
            CMyDateTime cMyDateTime = new CMyDateTime();
            cMyDateTime.setDateTimeWithString(string2);
            wCMFilter.addSearchValues(cMyDateTime);
        }
    }

    public MetaViewData findViewDataById(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        int n = methodContext.getObjectId();
        int n2 = methodContext.getValue("ViewId", 0);
        int n3 = methodContext.getValue("ChannelId", 0);
        MetaViewData metaViewData = null;
        if (n == 0) {
            MetaView metaView = null;
            if (n2 > 0) {
                metaView = this.findViewById(n2);
            } else {
                Channel channel = null;
                channel = this.findChannelById(n3);
                metaView = this.findViewByChannel(channel);
            }
            metaViewData = new MetaViewData(metaView);
        } else {
            metaViewData = MetaViewData.findById(n);
            if (metaViewData == null) {
                throw new WCMException(200006, I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label9", "\u6307\u5b9a\u7684\u89c6\u56fe\u6570\u636e\u5bf9\u8c61\u6ca1\u6709\u627e\u5230\uff01[ID=") + n + "]");
            }
            int n4 = methodContext.getValue("FlowDocId", 0);
            if (n4 > 0 && n > 0) {
                Document document = metaViewData.getDocument();
                WCMProcessServiceHelper.validateWorkFlowRight(user, document, n4, -1, I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label10", "\u67e5\u770b"));
            } else if (n3 > 0) {
                Channel channel = null;
                channel = this.findChannelById(n3);
                this.validateRight(user, metaViewData, channel, I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label10", "\u67e5\u770b"));
            } else {
                this.validateRight(user, metaViewData, metaViewData.getChannel(), I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label10", "\u67e5\u770b"));
            }
        }
        return metaViewData;
    }

    private void validateRight(User user, MetaViewData metaViewData, Channel channel, String string) throws WCMException {
        if (user.getName().equalsIgnoreCase(metaViewData.getCrUserName())) {
            return;
        }
        if (!AuthServer.hasRight(user, (CMSObj)channel, 34)) {
            throw new WCMException(1002, I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label1", "\u6ca1\u6709\u6743\u9650\u5728\u5f53\u524d\u680f\u76ee[") + channel.getName() + "][ID=" + channel.getId() + I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label11", "]\u4e0b") + string + I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label12", "\u6570\u636e\uff01"));
        }
    }

    public Reports deleteViewDatas(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        Reports reports = new Reports(I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label13", "\u5220\u9664\u89c6\u56fe\u6570\u636e"));
        String string = methodContext.getObjectIds();
        int[] nArray = CMyString.splitToInt(string, ",");
        for (int i = 0; i < nArray.length; ++i) {
            ChnlDoc chnlDoc = ChnlDoc.findById(nArray[i]);
            if (chnlDoc == null) continue;
            if (chnlDoc.isEntity()) {
                this.deleteViewDatasOfEntity(user, chnlDoc.getDocId(), reports);
                continue;
            }
            this.deleteViewDatasOfQuote(chnlDoc, reports);
        }
        return reports;
    }

    private void deleteViewDatasOfEntity(User user, int n, Reports reports) throws Throwable {
        MetaViewData metaViewData = MetaViewData.findById(n);
        if (metaViewData == null) {
            return;
        }
        try {
            this.validateRight(user, metaViewData, 33, I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label13", "\u5220\u9664\u89c6\u56fe\u6570\u636e"));
            metaViewData.deleteViewDataAndDoc(user);
            reports.addSucessedReport(I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label14", "\u5220\u9664\u89c6\u56fe\u6570\u636e[ID=") + n + I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label15", "]\u6210\u529f\uff01"));
        }
        catch (Exception exception) {
            reports.addFailedReport(I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label14", "\u5220\u9664\u89c6\u56fe\u6570\u636e[ID=") + n + I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label16", "]\u5931\u8d25\uff01"), exception);
        }
    }

    private void deleteViewDatasOfQuote(ChnlDoc chnlDoc, Reports reports) throws Throwable {
        if (chnlDoc == null) {
            return;
        }
        Channel channel = chnlDoc.getChannel();
        if (channel == null) {
            return;
        }
        Document document = chnlDoc.getDocument();
        if (document == null) {
            return;
        }
        DocumentMgr documentMgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
        try {
            documentMgr.delete(document, channel, true);
            reports.addSucessedReport(I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label14", "\u5220\u9664\u89c6\u56fe\u6570\u636e[ID=") + chnlDoc.getId() + I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label15", "]\u6210\u529f\uff01"));
        }
        catch (Exception exception) {
            reports.addFailedReport(I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label14", "\u5220\u9664\u89c6\u56fe\u6570\u636e[ID=") + chnlDoc.getId() + I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label16", "]\u5931\u8d25\uff01"), exception);
        }
    }

    public Reports copy(MethodContext methodContext) throws Throwable {
        Channel channel;
        int n;
        Reports reports = new Reports(I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label17", "\u590d\u5236\u6587\u6863"));
        User user = this.getLoginUser();
        Channels channels = Channels.findByIds(user, methodContext.getValue("ToChannelIds"));
        ChnlDocs chnlDocs = ChnlDocs.findByIds(user, methodContext.getObjectIds());
        if (!user.isAdministrator()) {
            for (n = chnlDocs.size() - 1; n >= 0; --n) {
                ChnlDoc chnlDoc = (ChnlDoc)chnlDocs.getAt(n);
                if (chnlDoc == null || AuthServer.hasRight(user, (CMSObj)(channel = chnlDoc.getChannel()), 34)) continue;
                reports.addFailedReport(I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label18", "\u590d\u5236\u5931\u8d25:\u6ca1\u6709\u6743\u9650\u67e5\u770b\u680f\u76ee[ID=") + channel.getId() + ",Name=" + channel.getDispDesc() + I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label19", "]\u4e0b\u7684\u6587\u6863"), null);
                chnlDocs.remove(n);
            }
        }
        int n2 = channels.size();
        for (n = 0; n < n2; ++n) {
            channel = (Channel)channels.getAt(n);
            if (channel == null) continue;
            if (!AuthServer.hasRight(user, (CMSObj)channel, 31)) {
                reports.addFailedReport(I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label20", "\u590d\u5236\u5931\u8d25:\u6ca1\u6709\u6743\u9650\u5728\u680f\u76ee[ID=") + channel.getId() + ",Name=" + channel.getDispDesc() + I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label21", "]\u4e0b\u521b\u5efa\u6587\u6863"), null);
                continue;
            }
            MetaView metaView = this.m_oMetaViewEmployerMgr.getViewOfEmployer(channel);
            for (int i = chnlDocs.size() - 1; i >= 0; --i) {
                ChnlDoc chnlDoc = (ChnlDoc)chnlDocs.getAt(i);
                int n3 = chnlDoc.getPropertyAsInt("docKind", 0);
                if (chnlDoc == null || n3 == 0) continue;
                if (chnlDoc.getStatusId() == 1028) {
                    reports.addFailedReport(CMyString.format(I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label100", "\u8bb0\u5f55[{0}]\u72b6\u6001\u4e3a\u8349\u7a3f\uff0c\u65e0\u6cd5\u590d\u5236\uff01"), new String[]{chnlDoc.getDocument().getTitle()}), null);
                    continue;
                }
                if (metaView.getId() != n3) {
                    reports.addFailedReport(I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label22", "\u590d\u5236\u5931\u8d25:\u680f\u76ee[ID=") + channel.getId() + ",Name=" + channel.getDispDesc() + I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label23", "]\u4f7f\u7528\u7684\u89c6\u56fe\uff3bID=") + metaView.getId() + ",Name=" + metaView.getDesc() + I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label24", "]\u548c\u5f53\u524d\u680f\u76ee\u89c6\u56fe[ID=") + n3 + I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label25", "]\u4e0d\u4e00\u81f4"), null);
                    continue;
                }
                if (chnlDoc.isEntity()) {
                    this.copy(chnlDoc, channel, reports, user);
                    continue;
                }
                this.copyQuote(chnlDoc, channel, reports);
            }
        }
        return reports;
    }

    public String exportViewDatas(MethodContext methodContext) throws Throwable {
        Object object;
        String string = methodContext.getObjectIds();
        Channel channel = null;
        MetaView metaView = null;
        int n = methodContext.getValue("ViewId", 0);
        if (n > 0) {
            metaView = this.findViewById(n);
        } else {
            channel = this.findChannelById(methodContext.getValue("ChannelId", 0));
            metaView = this.findViewByChannel(channel);
        }
        MetaViewDatas metaViewDatas = new MetaViewDatas(metaView);
        int[] nArray = CMyString.splitToInt(string, ",");
        metaViewDatas.setMaxBufferSize(nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            MetaViewData metaViewData = new MetaViewData(metaView);
            if (!metaViewData.loadById(nArray[i], "*")) continue;
            metaViewData.setMetaDataId(nArray[i]);
            object = Document.findById(nArray[i], "DocTitle,DocContent");
            metaViewData.getProperties().put("DOCTITLE", ((Document)object).getTitle());
            metaViewData.getProperties().put("DOCCONTENT", ((Document)object).getContent());
            metaViewDatas.addElement(metaViewData);
        }
        String string2 = methodContext.getValue("EXPORTFIELDS");
        boolean bl = methodContext.getValue("EXPORTAPPENDIX", true);
        object = new MetaViewDataExporter(metaView);
        if (methodContext.getValue("fileType", 1) == 1) {
            return ((MetaViewDataExporter)object).exportToZip(metaViewDatas, string2, bl);
        }
        return ((MetaViewDataExporter)object).exportToExcelZip(metaViewDatas, string2, bl);
    }

    public String exportAllViewDatas(MethodContext methodContext) throws Throwable {
        boolean bl;
        User user = ContextHelper.getLoginUser();
        Channels channels = null;
        Channel channel = null;
        MetaView metaView = null;
        int n = methodContext.getValue("ViewId", 0);
        if (n > 0) {
            metaView = this.findViewById(n);
            IMetaViewEmployerMgr iMetaViewEmployerMgr = (IMetaViewEmployerMgr)DreamFactory.createObjectById("IMetaViewEmployerMgr");
            channels = iMetaViewEmployerMgr.getEmployers(metaView, null);
        } else {
            channel = this.findChannelById(methodContext.getValue("ChannelId", 0));
            channels = Channels.createNewInstance(user);
            channels.addElement(channel);
            metaView = this.findViewByChannel(channel);
        }
        for (int i = channels.size() - 1; i >= 0; --i) {
            Channel channel2 = (Channel)channels.getAt(i);
            if (channel2 == null || AuthServer.hasRight(user, (CMSObj)channel2, 34)) continue;
            channels.remove(channel, false);
        }
        MetaViewDatas metaViewDatas = new MetaViewDatas(metaView);
        metaViewDatas.setPageSize(1);
        metaViewDatas.open(channels, null);
        int n2 = metaViewDatas.size();
        String string = methodContext.getValue("EXPORTFIELDS");
        boolean bl2 = methodContext.getValue("EXPORTAPPENDIX", true);
        boolean bl3 = bl = methodContext.getValue("fileType", 1) == 1;
        if (n2 > 500) {
            MetaViewDataExporter4MuchData metaViewDataExporter4MuchData = new MetaViewDataExporter4MuchData(n2, bl2, bl);
            return metaViewDataExporter4MuchData.exportData(channels, metaView, string);
        }
        metaViewDatas.clear();
        metaViewDatas = new MetaViewDatas(metaView);
        metaViewDatas.setPageSize(n2);
        metaViewDatas.setLoadAllDatas(true);
        metaViewDatas.open(channels, null);
        for (int i = metaViewDatas.size() - 1; i >= 0; --i) {
            MetaViewData metaViewData = (MetaViewData)metaViewDatas.getAt(i);
            if (metaViewData == null) {
                metaViewDatas.remove(metaViewData, false);
                continue;
            }
            Document document = Document.findById(metaViewData.getDocumentId(), "DocTitle,DocContent");
            if (document == null) {
                metaViewDatas.remove(metaViewData, false);
                continue;
            }
            metaViewData.getProperties().put("DOCTITLE", CMyString.showNull(document.getTitle()));
            metaViewData.getProperties().put("DOCCONTENT", CMyString.showNull(document.getContent()));
        }
        MetaViewDataExporter metaViewDataExporter = new MetaViewDataExporter(metaView);
        if (bl) {
            return metaViewDataExporter.exportToZip(metaViewDatas, string, bl2);
        }
        return metaViewDataExporter.exportToExcelZip(metaViewDatas, string, bl2);
    }

    private void copy(ChnlDoc chnlDoc, Channel channel, Reports reports, User user) throws Throwable {
        Object object;
        if (chnlDoc == null) {
            return;
        }
        int n = chnlDoc.getDocId();
        MetaViewData metaViewData = MetaViewData.findById(n);
        MetaViewData metaViewData2 = (MetaViewData)metaViewData.cloneToNewObj();
        MetaView metaView = metaViewData.getMetaView();
        metaViewData2.setMetaView(metaView);
        metaViewData2.setProperty("channelId", channel.getId());
        if (metaView.isMultiTable()) {
            Object object2;
            Object object3;
            object = "WCMMetaRelation" + metaView.getId();
            CMSObjDefaultImpl cMSObjDefaultImpl = new CMSObjDefaultImpl((String)object, "MetaDataId");
            boolean bl = cMSObjDefaultImpl.loadById(n, null);
            if (bl) {
                object3 = cMSObjDefaultImpl.getProperties().keys();
                while (object3.hasMoreElements()) {
                    object2 = (String)object3.nextElement();
                    if (!((String)object2).startsWith("WCMMetaTable".toUpperCase())) continue;
                    metaViewData2.setProperty((String)object2, cMSObjDefaultImpl.getProperty((String)object2));
                }
            }
            object3 = (IMetaDataDefCacheMgr)DreamFactory.createObjectById("IMetaDataDefCacheMgr");
            object2 = object3.getMetaViewFields(metaView.getId());
            for (MetaViewField metaViewField : ((HashMap)object2).values()) {
                if (metaViewField == null || metaViewField.isFromMainTable()) continue;
                metaViewData2.removeProperty(metaViewField.getName());
            }
        }
        metaViewData2.save(user);
        object = Document.findById(metaViewData2.getId());
        if (object != null) {
            ((Document)object).setDocLevel(chnlDoc.getDocLevleId());
            ((CMSObj)object).save();
            boolean bl = "true".equalsIgnoreCase(ConfigServer.getServer().getSysConfigValue("DOCUMENT_INFLOW_ONCOPY", "false"));
            User user2 = this.getLoginUser();
            if (bl) {
                WCMProcessServiceHelper.startDocumentInFlow(user2, (Document)object, true);
            }
        }
        if (metaViewData.getId() != metaViewData2.getId()) {
            this.m_oAppendixMgr.copyAppendixes(Document.findById(metaViewData.getId()), Document.findById(metaViewData2.getId()));
        }
        reports.addSucessedReport(I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label26", "\u6210\u529f\u590d\u5236\u8bb0\u5f55[") + metaViewData.getTitle() + I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label27", "]\u5230\u680f\u76ee[") + channel.getDispDesc() + "]\uff01");
    }

    private void copyQuote(ChnlDoc chnlDoc, Channel channel, Reports reports) throws Throwable {
        Channel channel2 = chnlDoc.getChannel();
        if (channel2 == null) {
            reports.addFailedReport(I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label28", "\u590d\u5236\u5931\u8d25:\u6587\u6863\u7684\u680f\u76ee[Id=") + chnlDoc.getChannelId() + I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label29", "]\u4e0d\u5b58\u5728!"), null);
            return;
        }
        Document document = chnlDoc.getDocument();
        if (document == null) {
            reports.addFailedReport(I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label30", "\u590d\u5236\u5931\u8d25:\u6587\u6863[Id=") + chnlDoc.getDocId() + I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label29", "]\u4e0d\u5b58\u5728!"), null);
            return;
        }
        DocumentMgr documentMgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
        Document document2 = documentMgr.copyDocument(document, channel2, channel);
        if (document2 == null) {
            reports.addFailedReport(document + I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label31", "\u5728") + channel + I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label32", "\u4e0b\u5df2\u5b58\u5728\u5f15\u7528\u5173\u7cfb!"), null);
            return;
        }
        if (document2.getId() != document.getId()) {
            this.m_oAppendixMgr.copyAppendixes(document, document2);
        }
        reports.addSucessedReport(I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label26", "\u6210\u529f\u590d\u5236\u8bb0\u5f55[") + document2.getTitle() + I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label27", "]\u5230\u680f\u76ee[") + channel.getDispDesc() + "]\uff01");
    }

    private void validateRight(User user, MetaViewData metaViewData, int n, String string) throws WCMException {
        Channel channel;
        if (user.isAdministrator() || user.getName().equalsIgnoreCase(metaViewData.getCrUserName())) {
            return;
        }
        int n2 = metaViewData.getChannelId();
        if (n2 <= 0) {
            n2 = metaViewData.getPropertyAsInt("ChannelId", 0);
        }
        if (!AuthServer.hasRight(user, (CMSObj)(channel = this.findChannelById(n2)), n)) {
            throw new WCMException(1002, I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label33", "\u60a8\u6ca1\u6709\u6743\u9650\u6267\u884c") + string + "[ID=" + metaViewData.getId() + I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label34", "]\u7684\u64cd\u4f5c\uff01"));
        }
    }

    private User getLoginUser() {
        User user = ContextHelper.getLoginUser();
        return user;
    }

    private Channel findChannelById(int n) throws WCMException {
        Channel channel = Channel.findById(n);
        if (channel == null) {
            throw new WCMException(200006, I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label35", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u680f\u76ee[ID=") + n + "]\uff01");
        }
        return channel;
    }

    private MetaView findViewById(int n) throws WCMException {
        MetaView metaView = MetaView.findById(n);
        if (metaView == null) {
            throw new WCMException(I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label36", "\u6307\u5b9a\u7684\u89c6\u56fe\u4e0d\u5b58\u5728\uff01[Id=") + n + "]");
        }
        return metaView;
    }

    private MetaView findViewByChannel(Channel channel) throws WCMException {
        MetaView metaView = this.m_oMetaViewEmployerMgr.getViewOfEmployer(channel);
        if (metaView == null) {
            throw new WCMException(I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label37", "\u6307\u5b9a\u680f\u76ee\u6ca1\u6709\u914d\u7f6e\u89c6\u56fe\uff01[\u680f\u76ee\u4fe1\u606f=") + channel + "]");
        }
        return metaView;
    }

    private static MetaViewData setViewDataProperties(MethodContext methodContext, MetaViewData metaViewData) throws WCMException {
        Map map = methodContext.getParams();
        for (String string : map.keySet()) {
            Object v = map.get(string);
            if (v instanceof String) {
                metaViewData.setProperty(string, v.toString().trim());
                continue;
            }
            if (v instanceof String[]) {
                String[] stringArray = (String[])v;
                metaViewData.setProperty(string, stringArray == null || stringArray.length == 0 ? null : stringArray[0].trim());
                continue;
            }
            metaViewData.setProperty(string, v);
        }
        return metaViewData;
    }

    public void moveViewDatas(MethodContext methodContext) throws Throwable {
        Object object;
        User user = this.getLoginUser();
        String string = methodContext.getValue("objectIds");
        MetaViewDatas metaViewDatas = MetaViewDatas.findByIds(string);
        for (int i = metaViewDatas.size() - 1; i >= 0; --i) {
            object = (MetaViewData)metaViewDatas.getAt(i);
            if (object == null) continue;
            try {
                this.validateRight(user, (MetaViewData)object, 32, I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label38", "\u79fb\u52a8\u8bb0\u5f55"));
                continue;
            }
            catch (WCMException wCMException) {
                metaViewDatas.remove((BaseObj)object, false);
            }
        }
        if (metaViewDatas.size() <= 0) {
            throw new WCMException(I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label39", "\u4f60\u6ca1\u6709\u6743\u9650\u6267\u884c\u8f6c\u6362\u8bb0\u5f55\u7684\u5206\u7c7b\u6cd5\u64cd\u4f5c"));
        }
        String string2 = methodContext.getValue("srcClassInfoIds");
        object = ClassInfos.findByIds(user, string2);
        ClassInfo classInfo = null;
        int n = methodContext.getValue("destClassInfoId", 0);
        if (n != 0) {
            classInfo = ClassInfo.findById(n);
        }
        this.m_oClassInfoViewMgr.moveViewDatasByClassInfos(metaViewDatas, (ClassInfos)object, classInfo, user);
    }

    public void copyViewDatas(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        if (!user.isAdministrator()) {
            throw new WCMException(I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label40", "\u975e\u7ba1\u7406\u5458\u6ca1\u6709\u6743\u9650\u6267\u884c\u8f6c\u6362\u8bb0\u5f55\u7684\u5206\u7c7b\u6cd5\u64cd\u4f5c"));
        }
        String string = methodContext.getValue("objectIds");
        MetaViewDatas metaViewDatas = MetaViewDatas.findByIds(string);
        String string2 = methodContext.getValue("destClassInfoIds");
        ClassInfos classInfos = ClassInfos.findByIds(user, string2);
        this.m_oClassInfoViewMgr.copyViewDatasByClassInfos(metaViewDatas, classInfos, user);
    }

    public void modifyViewDatas(MethodContext methodContext) throws WCMException {
        String string = methodContext.getValue("FieldName");
        String string2 = methodContext.getValue("FieldValue");
        int n = methodContext.getValue("VIEWID", 0);
        if (CMyString.isEmpty(string)) {
            throw new WCMException(10, I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label41", "\u53c2\u6570FieldName\u6ca1\u6709\u6307\u5b9a\u3002"));
        }
        if (CMyString.isEmpty(string2)) {
            throw new WCMException(10, I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label42", "\u53c2\u6570FieldValue\u6ca1\u6709\u6307\u5b9a\u3002"));
        }
        if (n <= 0) {
            throw new WCMException(10, I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label43", "\u53c2\u6570VIEWID\u6ca1\u6709\u6307\u5b9a\u6216\u6307\u5b9a\u65e0\u6548\u3002"));
        }
        MetaView metaView = MetaView.findById(n);
        if (metaView == null) {
            throw new WCMException(200006, I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label44", "\u6ca1\u6709\u627e\u5230 Id=") + n + I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label45", " \u7684\u8d44\u6e90\u7ed3\u6784\u5bf9\u8c61"));
        }
        DBManager dBManager = DBManager.getDBManager();
        String string3 = metaView.getTrueTableName();
        WCMFilter wCMFilter = methodContext.getExtraWCMFilter();
        String string4 = wCMFilter.getWhere();
        String string5 = "update " + string3 + " set " + string + "=? where " + string4;
        Object[] objectArray = new Object[]{string2};
        dBManager.sqlExecuteUpdate(new String[]{string5}, objectArray);
    }

    public MetaViewDatas queryViewDatasByClassinfos(MethodContext methodContext) throws WCMException {
        return null;
    }

    public Map queryRelatingViewDatas(MethodContext methodContext) throws WCMException {
        int n = methodContext.getValue("RelatingViewId", 0);
        int n2 = methodContext.getValue("RelatedViewId", 0);
        int n3 = methodContext.getValue("RelatedDocId", 0);
        MetaView metaView = MetaView.findById(n);
        if (metaView == null) {
            throw new WCMException(CMyString.format(I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label50", "\u6ca1\u6709\u627e\u5230ID\u4e3a\u3010{0}\u3011\u7684\u89c6\u56fe\uff01"), new int[]{n}));
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        WCMFilter wCMFilter = new WCMFilter("", "VIEWID=? AND FIELDTYPE=? AND RELATIONVIEWID=?", "");
        wCMFilter.addSearchValues(n);
        wCMFilter.addSearchValues(14);
        wCMFilter.addSearchValues(n2);
        MetaViewFields metaViewFields = MetaViewFields.openWCMObjs(null, wCMFilter);
        if (metaViewFields.size() == 0) {
            return hashMap;
        }
        MetaViewField metaViewField = (MetaViewField)metaViewFields.getAt(0);
        String string = metaViewField.getName();
        WCMFilter wCMFilter2 = new WCMFilter("", "", "");
        String string2 = DBManager.getDBManager().getDBType().sqlConcatStr("','", string, "','") + " like '%," + n3 + ",%'";
        wCMFilter2.setWhere(string2);
        String string3 = metaView.getTrueTableName();
        MetaViewDatas metaViewDatas = MetaViewDatas.openWCMObjs(string3, wCMFilter2);
        hashMap.put("RelationField", metaViewField);
        hashMap.put("MetaViewDatas", metaViewDatas);
        return hashMap;
    }

    public void saveRelatingViewDatas(MethodContext methodContext) throws WCMException {
        int n;
        int n2;
        User user = this.getLoginUser();
        int n3 = methodContext.getValue("RelatedDocId", 0);
        String string = methodContext.getValue("RelatingDocIds");
        int n4 = methodContext.getValue("RelatingViewId", 0);
        String string2 = methodContext.getValue("RelatingFieldName");
        MetaView metaView = MetaView.findById(n4);
        if (metaView == null) {
            throw new WCMException(CMyString.format(I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label50", "\u6ca1\u6709\u627e\u5230ID\u4e3a\u3010{0}\u3011\u7684\u89c6\u56fe\uff01"), new int[]{n4}));
        }
        if (CMyString.isEmpty(string2)) {
            throw new WCMException(I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label51", "\u5173\u8054\u7684\u89c6\u56fe\u5b57\u6bb5\u53c2\u6570RelatingFieldName\u6ca1\u6709\u4f20\u5165\uff01"));
        }
        String string3 = metaView.getTrueTableName();
        FieldInfo fieldInfo = DBManager.getDBManager().getFieldInfo(string3, string2);
        if (fieldInfo == null) {
            throw new WCMException(CMyString.format(I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label52", "\u5b57\u6bb5\u540d\u3010{0}\u3011\u4e0d\u662f\u89c6\u56fe\u3010{1}\u3011\u4e2d\u7684\u6709\u6548\u5b57\u6bb5\uff01"), new String[]{string2, metaView.getName()}));
        }
        WCMFilter wCMFilter = new WCMFilter("", "", "");
        String string4 = DBManager.getDBManager().getDBType().sqlConcatStr("','", string2, "','") + " like '%," + n3 + ",%'";
        wCMFilter.setWhere(string4);
        MetaViewDatas metaViewDatas = MetaViewDatas.openWCMObjs(string3, wCMFilter);
        int[] nArray = CMyString.splitToInt(string, ",");
        for (n2 = 0; n2 < nArray.length; ++n2) {
            MetaViewData metaViewData;
            n = nArray[n2];
            boolean bl = false;
            int n5 = metaViewDatas.size();
            for (int i = n5 - 1; i >= 0; --i) {
                MetaViewData metaViewData2 = (MetaViewData)metaViewDatas.getAt(i);
                if (metaViewData2 == null) continue;
                try {
                    this.validateRight(user, metaViewData2, 32, I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label53", "\u4fee\u6539\u8bb0\u5f55"));
                }
                catch (WCMException wCMException) {
                    continue;
                }
                int n6 = metaViewData2.getId();
                if (n != n6) continue;
                bl = true;
                metaViewDatas.remove(metaViewData2, false);
                metaViewDatas.setRecCount(metaViewDatas.size() - 1);
                break;
            }
            if (bl || (metaViewData = MetaViewData.findById(n)) == null) continue;
            metaViewData.setMetaView(metaView);
            this.saveMetaViewDataRelation(n3, metaViewData, string2);
        }
        n = metaViewDatas.size();
        for (n2 = 0; n2 < n; ++n2) {
            MetaViewData metaViewData = (MetaViewData)metaViewDatas.getAt(n2);
            if (metaViewData == null) continue;
            try {
                this.validateRight(user, metaViewData, 32, I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label53", "\u4fee\u6539\u8bb0\u5f55"));
            }
            catch (WCMException wCMException) {
                continue;
            }
            metaViewData.setMetaView(metaView);
            this.removeMetaViewDataRelation(n3, metaViewData, string2);
        }
    }

    private void removeMetaViewDataRelation(int n, MetaViewData metaViewData, String string) throws WCMException {
        int n2;
        String string2 = metaViewData.getPropertyAsString(string);
        if (CMyString.isEmpty(string2)) {
            return;
        }
        int[] nArray = CMyString.splitToInt(string2, ",");
        int n3 = 0;
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        for (n2 = 0; n2 < nArray.length; ++n2) {
            if (n == nArray[n2]) {
                bl = true;
                n3 = n2;
                break;
            }
            stringBuffer.append(nArray[n2] + ",");
        }
        if (!bl) {
            return;
        }
        for (n2 = n3 + 1; n2 < nArray.length; ++n2) {
            if (n2 < nArray.length - 1) {
                stringBuffer.append(nArray[n2] + ",");
                continue;
            }
            stringBuffer.append(nArray[n2]);
        }
        metaViewData.setProperty(string, stringBuffer.toString());
        metaViewData.update(this.getLoginUser());
    }

    private void saveMetaViewDataRelation(int n, MetaViewData metaViewData, String string) throws WCMException {
        String string2 = metaViewData.getPropertyAsString(string);
        String string3 = "";
        if (CMyString.isEmpty(string2)) {
            string3 = n + "";
        } else {
            boolean bl = false;
            int[] nArray = CMyString.splitToInt(string2, ",");
            for (int i = 0; i < nArray.length; ++i) {
                int n2 = nArray[i];
                if (n != n2) continue;
                bl = true;
                break;
            }
            if (bl) {
                return;
            }
            string3 = string2 + "," + n;
        }
        metaViewData.setPropertyWithString(string, string3);
        metaViewData.update(this.getLoginUser());
    }

    private void makeDocLevelWhere(WCMFilter wCMFilter, StringBuffer stringBuffer) throws WCMException {
        User user = this.getLoginUser();
        DocLevel docLevel = user.getDocLevel();
        int n = docLevel.getId();
        DocLevelMgr docLevelMgr = new DocLevelMgr();
        DocLevels docLevels = docLevelMgr.queryLowerDocLevels(user, docLevel);
        stringBuffer.append(" and (");
        if (docLevels.isEmpty()) {
            stringBuffer.append("WCMChnlDoc.DOCLEVEL=?");
            wCMFilter.addSearchValues(n);
        } else {
            stringBuffer.append("WCMChnlDoc.DOCLEVEL in(");
            int n2 = docLevels.size();
            for (int i = 0; i < n2; ++i) {
                DocLevel docLevel2 = (DocLevel)docLevels.getAt(i);
                if (docLevel2 == null) continue;
                stringBuffer.append(" ?,");
                wCMFilter.addSearchValues(docLevel2.getId());
            }
            stringBuffer.append(" ?)");
            wCMFilter.addSearchValues(n);
        }
        stringBuffer.append(" or WCMChnlDoc.DOCLEVEL is null");
        stringBuffer.append(" or WCMChnlDoc.DOCLEVEL=0");
        stringBuffer.append(" or WCMChnlDoc.CrUser=?");
        wCMFilter.addSearchValues(user.getName());
        stringBuffer.append(")");
    }
}

