/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.service;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.domain.PublishServer;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.metadata.definition.ClassInfo;
import com.trs.components.metadata.definition.ClassInfos;
import com.trs.components.metadata.publish.PublishFolderClassImpl;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.ISelfDefinedServiceProvider;

public class ClassInfoPublishServiceProvider
implements ISelfDefinedServiceProvider {
    public void publishClassInfo(MethodContext methodContext) throws WCMException {
        User user = this.getLoginUser();
        ClassInfos classInfos = ClassInfos.openWCMObjs(user, null);
        int n = methodContext.getValue("SiteId", 0);
        WebSite webSite = WebSite.findById(n);
        if (webSite == null) {
            throw new WCMException(I18NMessage.get(ClassInfoPublishServiceProvider.class, "ClassInfoPublishServiceProvider.label1", "\u6307\u5b9a\u7684\u7ad9\u70b9\u4e0d\u5b58\u5728\uff01[SiteId=") + n + "]");
        }
        IPublishFolder iPublishFolder = (IPublishFolder)PublishElementFactory.makeElementFrom(webSite);
        PublishServer publishServer = PublishServer.getInstance();
        ClassInfo classInfo = null;
        try {
            int n2 = classInfos.size();
            for (int i = 0; i < n2; ++i) {
                classInfo = (ClassInfo)classInfos.getAt(i);
                if (classInfo == null) continue;
                PublishFolderClassImpl publishFolderClassImpl = (PublishFolderClassImpl)PublishElementFactory.makeElementFrom(classInfo);
                publishFolderClassImpl.setRoot(iPublishFolder);
                publishServer.publishFolder(publishFolderClassImpl, 8);
            }
        }
        catch (Exception exception) {
            throw new WCMException(I18NMessage.get(ClassInfoPublishServiceProvider.class, "ClassInfoPublishServiceProvider.label2", "\u53d1\u5e03\u6307\u5b9a\u7684\u5206\u7c7b\u5931\u8d25\uff01[ClassId=") + classInfo.getId() + ", ClassName=" + classInfo.getName() + "]", exception);
        }
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }
}

