/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.publish;

import com.trs.DreamFactory;
import com.trs.cms.content.CMSBaseObjs;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.config.PublishServerConfigMapper;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.BaseTagParser4List;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.components.common.publish.domain.tagparser.TagParseHelper;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.common.publish.persistent.template.TemplateQuote;
import com.trs.components.metadata.center.IMetaViewEmployerMgr;
import com.trs.components.metadata.center.MetaViewDatas;
import com.trs.components.metadata.definition.MetaView;
import com.trs.components.wcm.content.domain.DocumentMgr;
import com.trs.components.wcm.content.domain.DocumentsGetHelper;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.components.wcm.publish.IFolderPubStatusCacheMgr;
import com.trs.components.wcm.publish.tagparser.WCMTagParserHelper;
import com.trs.components.wcm.resource.Status;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.DebugTimer;
import com.trs.infra.util.SQLUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class WCMTagParserViewDatas
extends BaseTagParser4List {
    private static final Logger LOG = Logger.getLogger(WCMTagParserViewDatas.class);
    private static ArrayList FIELDS_DEFAULT_LIST_OF_DOCUMENT = new ArrayList(16);
    private static ArrayList FIELDS_DEFAULT_LIST_OF_METADATA;
    private IMetaViewEmployerMgr m_oViewEmployerMgr = null;
    private MetaView m_oCurrView = null;
    private BaseChannel m_oChannel = null;
    private TagItem m_oTagItem = null;
    private Logger m_oLogger = Logger.getLogger(WCMTagParserViewDatas.class);

    public WCMTagParserViewDatas() {
        this.m_oViewEmployerMgr = (IMetaViewEmployerMgr)DreamFactory.createObjectById("IMetaViewEmployerMgr");
    }

    public String[] parse(PublishTagContext publishTagContext) throws WCMException {
        this.makeCurrChannel(publishTagContext);
        if (this.m_oChannel != null) {
            this.m_oCurrFolder = (IPublishFolder)PublishElementFactory.makeElementFrom(this.m_oChannel);
        }
        return super.parse(publishTagContext);
    }

    public void makeCurrChannel(PublishTagContext publishTagContext) {
        try {
            int n = publishTagContext.getAttribute("ChannelId", 0);
            this.m_oChannel = n != 0 ? Channel.findById(n) : WCMTagParserHelper.findFolderHost(publishTagContext.getTagItem(), publishTagContext, false);
        }
        catch (Exception exception) {
            this.m_oLogger.debug((Object)exception);
        }
    }

    protected CMSBaseObjs findObjects(PublishTagContext publishTagContext) throws WCMException {
        this.makeCurrView(publishTagContext);
        String string = publishTagContext.getAttribute("MetaDataIds");
        if (string != null && (string = string.trim()).length() > 0) {
            return MetaViewDatas.findByIds(this.m_oCurrView, string);
        }
        String string2 = publishTagContext.getAttribute("Where");
        String string3 = publishTagContext.getAttribute("Order");
        if (this.m_oChannel == null || publishTagContext.getAttribute("DirectFromMetaTable", false)) {
            String string4;
            WCMFilter wCMFilter = new WCMFilter(null, null, null);
            StringBuffer stringBuffer = new StringBuffer(300);
            stringBuffer.append("exists(select WCMChnlDoc.DocId from WCMChnlDoc where WCMChnlDoc.ChnlId>=1 and WCMChnlDoc.Modal>=1 and WCMChnlDoc.DocId=");
            stringBuffer.append(this.m_oCurrView.getTrueTableName() + ".MetaDataId");
            stringBuffer.append(" and WCMChnlDoc.docKind =? ");
            wCMFilter.addSearchValues(this.m_oCurrView.getId());
            int[] nArray = Status.getStatusCanDoPubInOutline();
            if (publishTagContext.isPreview() && this.m_oChannel != null) {
                IPublishFolder iPublishFolder = (IPublishFolder)PublishElementFactory.makeElementFrom(this.m_oChannel);
                nArray = this.getPreviewStatus(iPublishFolder);
            }
            stringBuffer.append(" and WCMChnlDoc.DOCSTATUS in(");
            for (int i = 0; i < nArray.length; ++i) {
                stringBuffer.append("?,");
                wCMFilter.addSearchValues(nArray[i]);
            }
            if (nArray.length > 0) {
                stringBuffer.setLength(stringBuffer.length() - 1);
            }
            stringBuffer.append(")");
            if (this.m_oChannel != null && !publishTagContext.getAttribute("IgnoreChannel", false)) {
                if (this.m_oChannel.isSite()) {
                    stringBuffer.append(" and WCMChnlDoc.ChnlId in(select WCMChannel.ChannelId from WCMChannel where WCMChannel.SiteId=?)");
                    wCMFilter.addSearchValues(this.m_oChannel.getId());
                } else {
                    Channel channel = (Channel)this.m_oChannel;
                    if (!channel.isOnlySearch()) {
                        stringBuffer.append(" and WCMChnlDoc.ChnlId=?");
                        wCMFilter.addSearchValues(this.m_oChannel.getId());
                    }
                    if ((string4 = channel.getQuery()) != null && string4.length() > 0) {
                        stringBuffer.append(stringBuffer.length() > 0 ? " and (" : "(");
                        stringBuffer.append(string4);
                        stringBuffer.append(')');
                    }
                }
            }
            stringBuffer.append(")");
            if (!CMyString.isEmpty(string2)) {
                stringBuffer.append(" and (" + string2 + ")");
            }
            wCMFilter.setWhere(stringBuffer.toString());
            if (CMyString.isEmpty(string3) || !SQLUtil.isValidOrder(this.m_oCurrView.getTrueTableName(), string3)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Invalid order by:" + string3));
                }
                string3 = "MetaDataId desc";
            }
            wCMFilter.setOrder(string3);
            MetaViewDatas metaViewDatas = new MetaViewDatas(this.m_oCurrView);
            string4 = this.getSelectFields(this.m_oCurrView.getTrueTableName().toUpperCase(), "TRS_VIEWDATA", publishTagContext);
            metaViewDatas.setSelectFieldsOfMetaTable(string4);
            int n = publishTagContext.getAttribute("NUM", -1);
            if (n == -1) {
                n = 300;
                publishTagContext.getTagItem().setAttribute("NUM", n);
            }
            metaViewDatas.setPageSize(n);
            metaViewDatas.setMaxBufferSize(n);
            metaViewDatas.open(wCMFilter);
            return metaViewDatas;
        }
        WCMFilter wCMFilter = new WCMFilter(null, null, string3);
        string2 = !CMyString.isEmpty(string2) ? "exists(select " + this.m_oCurrView.getTrueTableName() + ".MetaDataId from " + this.m_oCurrView.getTrueTableName() + " where (" + string2 + ") and WCMChnlDoc.DocId=" + this.m_oCurrView.getTrueTableName() + ".MetaDataId)" : "exists(select " + this.m_oCurrView.getTrueTableName() + ".MetaDataId from " + this.m_oCurrView.getTrueTableName() + " where  WCMChnlDoc.DocId=" + this.m_oCurrView.getTrueTableName() + ".MetaDataId)";
        wCMFilter.setWhere(string2);
        WCMFilter wCMFilter2 = new WCMFilter("WCMChnlDoc", "WCMChnlDoc.DocKind=?", "", this.getSelectFields("WCMDOCUMENT", "TRS_DOCUMENT", publishTagContext));
        wCMFilter2.mergeWith(wCMFilter);
        wCMFilter2.addSearchValues(this.m_oCurrView.getId());
        IPublishFolder iPublishFolder = (IPublishFolder)PublishElementFactory.makeElementFrom(this.m_oChannel);
        if (publishTagContext.isPreview()) {
            return this.getPreviewContents(iPublishFolder, wCMFilter2);
        }
        return this.getPublishedContents(wCMFilter2);
    }

    protected boolean isValidate(PublishTagContext publishTagContext) throws WCMException {
        this.makeCurrView(publishTagContext);
        return true;
    }

    private void makeCurrView(PublishTagContext publishTagContext) throws WCMException {
        Object object;
        if (this.m_oCurrView != null) {
            return;
        }
        int n = publishTagContext.getAttribute("ViewId", 0);
        if (n > 0) {
            this.m_oCurrView = MetaView.findById(n);
        } else {
            object = publishTagContext.getUpperHost();
            CMSObj cMSObj = object.getSubstance();
            if (cMSObj instanceof MetaView) {
                this.m_oCurrView = (MetaView)cMSObj;
            } else {
                if (this.m_oChannel == null || !(this.m_oChannel instanceof Channel)) {
                    throw new WCMException(I18NMessage.get(WCMTagParserViewDatas.class, "WCMTagParserViewDatas.label1", "\u7f6e\u6807\u4f7f\u7528\u573a\u666f\u4e0d\u5bf9\uff0c\u53ea\u80fd\u7528\u5728\u5143\u6570\u636e\u89c6\u56fe\u3001\u6307\u5b9a\u680f\u76ee\u6216\u8005\u6307\u5b9a\u6587\u6863\u4e0a\uff01\u5f53\u524d\u5bf9\u8c61\u662f[") + cMSObj.getClassName(true) + I18NMessage.get(WCMTagParserViewDatas.class, "WCMTagParserViewDatas.label2", "]\u7684\u5b9e\u4f8b"));
                }
                this.m_oCurrView = this.m_oViewEmployerMgr.getViewOfEmployer((Channel)this.m_oChannel);
            }
        }
        if (this.m_oCurrView == null) {
            throw new WCMException(I18NMessage.get(WCMTagParserViewDatas.class, "WCMTagParserViewDatas.label3", "\u6ca1\u6709\u5173\u8054\u7684\u89c6\u56fe\uff01"));
        }
        object = publishTagContext.getExtraAttributes();
        if (object == null) {
            object = new HashMap<String, MetaView>(1);
            publishTagContext.setExtraAttributes((Map)object);
        }
        object.put("Curr.View", this.m_oCurrView);
    }

    private int[] getPreviewStatus(IPublishFolder iPublishFolder) throws WCMException {
        IPublishFolder iPublishFolder2 = iPublishFolder.getRoot();
        IFolderPubStatusCacheMgr iFolderPubStatusCacheMgr = (IFolderPubStatusCacheMgr)DreamFactory.createObjectById("IFolderPubStatusCacheMgr");
        int[] nArray = iFolderPubStatusCacheMgr.findStatusesCanDoIncreasePub(iPublishFolder2.getType(), iPublishFolder2.getId());
        int[] nArray2 = Status.getStatusCanDoPubInOutline();
        if (nArray == null) {
            return nArray2;
        }
        int[] nArray3 = new int[nArray.length + nArray2.length];
        System.arraycopy(nArray, 0, nArray3, 0, nArray.length);
        System.arraycopy(nArray2, 0, nArray3, nArray.length, nArray2.length);
        return nArray3;
    }

    private int[] getPublishStatus() throws WCMException {
        return Status.getStatusCanDoPubInOutline();
    }

    private CMSBaseObjs getPreviewContents(IPublishFolder iPublishFolder, WCMFilter wCMFilter) throws WCMException {
        return this.getContents(this.getPreviewStatus(iPublishFolder), wCMFilter);
    }

    private CMSBaseObjs getPublishedContents(WCMFilter wCMFilter) throws WCMException {
        return this.getContents(this.getPublishStatus(), wCMFilter);
    }

    private CMSBaseObjs getContents(int[] nArray, WCMFilter wCMFilter) throws WCMException {
        if (nArray == null || nArray.length <= 0) {
            return null;
        }
        DebugTimer debugTimer = new DebugTimer();
        debugTimer.start();
        WCMFilter wCMFilter2 = new WCMFilter("", "", "");
        wCMFilter2.setMaxRowNumber(PublishServerConfigMapper.getTemplateParseConfig().getWcmOutlineContentsMaxNum());
        String string = "WCMCHNLDOC.DOCSTATUS in(?";
        wCMFilter2.addSearchValues(0, nArray[0]);
        int n = nArray.length;
        for (int i = 1; i < n; ++i) {
            string = string + ",?";
            wCMFilter2.addSearchValues(i, nArray[i]);
        }
        string = string + ")";
        wCMFilter2.setWhere(string);
        if (wCMFilter != null) {
            wCMFilter2.mergeWith(wCMFilter);
        }
        this.m_oLogger.debug((Object)wCMFilter2);
        Documents documents = null;
        if (Document.DOCUMENTS_GET_OPTIMIZE) {
            if (this.m_oChannel == null || !(this.m_oChannel instanceof Channel)) {
                throw new WCMException(I18NMessage.get(WCMTagParserViewDatas.class, "WCMTagParserViewDatas.label4", "\u7f6e\u6807\u4f7f\u7528\u573a\u666f\u4e0d\u5bf9\uff0c\u53ea\u80fd\u7528\u5728\u5143\u6570\u636e\u89c6\u56fe\u6216\u6307\u5b9a\u680f\u76ee\u4e0a\uff01\u5f53\u524d\u5bf9\u8c61\u662f[") + this.m_oChannel + I18NMessage.get(WCMTagParserViewDatas.class, "WCMTagParserViewDatas.label2", "]\u7684\u5b9e\u4f8b"));
            }
            documents = DocumentsGetHelper.getDocuments((Channel)this.m_oChannel, wCMFilter2);
        } else {
            DocumentMgr documentMgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
            documents = documentMgr.getDocuments(this.m_oChannel, wCMFilter2);
        }
        debugTimer.stop();
        return documents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getSelectFields(String string, String string2, PublishTagContext publishTagContext) {
        String string3 = (string + ".SELECT").toUpperCase();
        String string4 = publishTagContext.getTagItem().getExtraAttributeValue(string3);
        if (string4 == null) {
            TagItem tagItem = publishTagContext.getTagItem();
            synchronized (tagItem) {
                string4 = publishTagContext.getTagItem().getExtraAttributeValue(string3);
                if (string4 == null) {
                    string4 = this.makeSelectFields(string, string2, publishTagContext);
                    publishTagContext.getTagItem().setExtraAttribute(string3, string4);
                }
            }
        }
        return string4;
    }

    private String makeSelectFields(String string, String string2, PublishTagContext publishTagContext) {
        ArrayList arrayList = null;
        arrayList = string.equalsIgnoreCase("WCMDOCUMENT") ? FIELDS_DEFAULT_LIST_OF_DOCUMENT : FIELDS_DEFAULT_LIST_OF_METADATA;
        String string3 = (String)arrayList.get(0);
        int n = arrayList.size();
        for (int i = 1; i < n; ++i) {
            string3 = string3 + "," + arrayList.get(i);
        }
        ArrayList arrayList2 = TagParseHelper.makeSelectFields(publishTagContext.getTagItem(), string2);
        DBManager dBManager = DBManager.getDBManager();
        int n2 = arrayList2.size();
        for (int i = 0; i < n2; ++i) {
            String string4 = (String)arrayList2.get(i);
            if (arrayList.indexOf(string4) >= 0) continue;
            try {
                if (dBManager.getFieldInfo(string, string4) == null) {
                    publishTagContext.addWarning(I18NMessage.get(WCMTagParserViewDatas.class, "WCMTagParserViewDatas.label5", "TRS_DOCUMENT\u7f6e\u6807\u6307\u5b9a\u7684Field[") + string4 + I18NMessage.get(WCMTagParserViewDatas.class, "WCMTagParserViewDatas.label6", "]\u5728WCMDocument\u8868\u4e2d\u4e0d\u5b58\u5728\uff01"));
                    continue;
                }
            }
            catch (WCMException wCMException) {
                wCMException.printStackTrace();
                try {
                    publishTagContext.addWarning(I18NMessage.get(WCMTagParserViewDatas.class, "WCMTagParserViewDatas.label7", "\u83b7\u53d6\u6307\u5b9a\u7684Field[") + string4 + I18NMessage.get(WCMTagParserViewDatas.class, "WCMTagParserViewDatas.label8", "]\u4eceWCMDocument\u8868\u4e2d\u53d1\u751f\u5f02\u5e38\uff01") + CMyException.getStackTraceText(wCMException));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            string3 = string3 + "," + string4;
        }
        if (!string.equalsIgnoreCase("WCMDOCUMENT")) {
            ArrayList arrayList3 = TagParseHelper.makeSelectFields(publishTagContext.getTagItem(), "TRS_RELNEWS");
            int n3 = arrayList3.size();
            for (n2 = 0; n2 < n3; ++n2) {
                String string5 = (String)arrayList3.get(n2);
                if (arrayList.indexOf(string5) >= 0 || arrayList2.indexOf(string5) >= 0) continue;
                try {
                    if (dBManager.getFieldInfo(string, string5) == null) {
                        publishTagContext.addWarning(I18NMessage.get(WCMTagParserViewDatas.class, "WCMTagParserViewDatas.label5", "TRS_DOCUMENT\u7f6e\u6807\u6307\u5b9a\u7684Field[") + string5 + I18NMessage.get(WCMTagParserViewDatas.class, "WCMTagParserViewDatas.label6", "]\u5728WCMDocument\u8868\u4e2d\u4e0d\u5b58\u5728\uff01"));
                        continue;
                    }
                }
                catch (WCMException wCMException) {
                    wCMException.printStackTrace();
                    try {
                        publishTagContext.addWarning(I18NMessage.get(WCMTagParserViewDatas.class, "WCMTagParserViewDatas.label7", "\u83b7\u53d6\u6307\u5b9a\u7684Field[") + string5 + I18NMessage.get(WCMTagParserViewDatas.class, "WCMTagParserViewDatas.label8", "]\u4eceWCMDocument\u8868\u4e2d\u53d1\u751f\u5f02\u5e38\uff01") + CMyException.getStackTraceText(wCMException));
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                string3 = string3 + "," + string5;
            }
        }
        return string3;
    }

    public void setTagItem(TagItem tagItem) {
        this.m_oTagItem = tagItem;
    }

    public TemplateQuote[] analyzeQuotes(IPublishFolder iPublishFolder) throws WCMException {
        TemplateQuote[] templateQuoteArray;
        Object object;
        String string = this.m_oTagItem.getAttributeTrim("triggerChannelIds");
        if (CMyString.isEmpty(string)) {
            string = this.m_oTagItem.getAttribute("ChannelId");
        }
        if (CMyString.isEmpty(string)) {
            object = this.m_oTagItem.getAttributeTrim("ID");
            try {
                templateQuoteArray = Channel.findByName(iPublishFolder.getId(), (String)object);
                string = String.valueOf(templateQuoteArray.getId());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (CMyString.isEmpty(string)) {
            return null;
        }
        object = Channels.findByIds(null, string);
        templateQuoteArray = new TemplateQuote[((BaseObjs)object).size()];
        int n = ((BaseObjs)object).size();
        for (int i = 0; i < n; ++i) {
            Channel channel = (Channel)((BaseObjs)object).getAt(i);
            if (channel == null) continue;
            TemplateQuote templateQuote = new TemplateQuote();
            templateQuote.setQuoteType(1);
            templateQuote.setQuotedFolder(channel.getWCMType(), channel.getId(), -1);
            templateQuoteArray[i] = templateQuote;
        }
        return templateQuoteArray;
    }

    static {
        FIELDS_DEFAULT_LIST_OF_DOCUMENT.add("DOCID");
        FIELDS_DEFAULT_LIST_OF_DOCUMENT.add("DOCCHANNEL");
        FIELDS_DEFAULT_LIST_OF_DOCUMENT.add("DOCSTATUS");
        FIELDS_DEFAULT_LIST_OF_DOCUMENT.add("DOCTITLE");
        FIELDS_DEFAULT_LIST_OF_DOCUMENT.add("DOCKIND");
        FIELDS_DEFAULT_LIST_OF_DOCUMENT.add("DOCVERSION");
        FIELDS_DEFAULT_LIST_OF_DOCUMENT.add("DOCRELTIME");
        FIELDS_DEFAULT_LIST_OF_DOCUMENT.add("DOCPUBTIME");
        FIELDS_DEFAULT_LIST_OF_DOCUMENT.add("CRTIME");
        FIELDS_DEFAULT_LIST_OF_METADATA = new ArrayList(4);
        FIELDS_DEFAULT_LIST_OF_METADATA.add("MetaDataId");
        FIELDS_DEFAULT_LIST_OF_METADATA.add("ChannelId");
        FIELDS_DEFAULT_LIST_OF_METADATA.add("CRTIME");
    }
}

