/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.definition.xml;

import com.trs.DreamFactory;
import com.trs.cms.auth.persistent.User;
import com.trs.components.metadata.definition.IMetaDataDefMgr;
import com.trs.components.metadata.definition.MetaDBField;
import com.trs.components.metadata.definition.MetaDBFields;
import com.trs.components.metadata.definition.MetaDBTable;
import com.trs.components.metadata.definition.MetaDBTables;
import com.trs.components.metadata.definition.MetaDataDefMgr;
import com.trs.components.metadata.definition.MetaView;
import com.trs.components.metadata.definition.MetaViewField;
import com.trs.components.metadata.definition.MetaViewFields;
import com.trs.components.metadata.definition.MetaViews;
import com.trs.components.metadata.definition.xml.XMLToMetaDBTablesConvertor;
import com.trs.components.metadata.service.MetaDataDefServiceProvider;
import com.trs.components.wcm.util.INameGenerator;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.AbstractXmlToObjConverter;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.XmlObject;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.Reports;
import java.util.HashMap;

public class MetaDataDDLImporter {
    private User m_oCurrUser = null;
    private IMetaDataDefMgr m_oMetaDataDefMgr = (IMetaDataDefMgr)DreamFactory.createObjectById("IMetaDataDefMgr");
    private HashMap m_hCurrDBFields = new HashMap();
    private MetaViews m_oMetaViews = MetaViews.createNewInstance(null);

    public MetaDataDDLImporter(User user) {
        this.m_oCurrUser = user;
    }

    private void processMetaDB(XmlObject xmlObject) throws WCMException {
        MetaDBTable metaDBTable = this.processMetaDBTable(xmlObject);
        XmlObject[] xmlObjectArray = xmlObject.getChild("XWCMDBFIELDINFOS");
        for (int i = 0; i < xmlObjectArray.length; ++i) {
            MetaDBField metaDBField = this.processDBField(metaDBTable, xmlObjectArray[i]);
            this.m_hCurrDBFields.put(metaDBField.getName().trim().toUpperCase(), metaDBField);
        }
    }

    private void processRSMetaDB(XmlObject xmlObject, int n, Reports reports) throws WCMException {
        MetaDBTable metaDBTable = this.processRSMetaDBTable(xmlObject, n, reports);
        XmlObject[] xmlObjectArray = xmlObject.getChild("XWCMDBFIELDINFOS");
        for (int i = 0; i < xmlObjectArray.length; ++i) {
            MetaDBField metaDBField = this.processDBField(metaDBTable, xmlObjectArray[i]);
            this.m_hCurrDBFields.put(metaDBField.getName().trim().toUpperCase(), metaDBField);
        }
    }

    private MetaDBTable processRSMetaDBTable(XmlObject xmlObject, int n, Reports reports) throws WCMException {
        MetaDBTable metaDBTable = (MetaDBTable)xmlObject.getCurrentObj();
        if (metaDBTable == null) {
            throw new WCMException(I18NMessage.get(MetaDataDefMgr.class, "MetaDataDefMgr.label14", "\u5bfc\u5165\u7684\u6570\u636e\u4e0d\u6b63\u786e,XML\u6587\u4ef6\u4e0d\u662f\u4e00\u4e2a\u6709\u6548\u7684\u89c6\u56fe\u6587\u4ef6."));
        }
        metaDBTable.removeProperty("TABLEINFOID");
        metaDBTable.removeProperty("CRUSER");
        metaDBTable.removeProperty("CRTIME");
        metaDBTable.removeProperty("OWNERTYPE");
        metaDBTable.removeProperty("OWNERID");
        String string = metaDBTable.getName();
        MetaDBTable metaDBTable2 = this.findMetaDBTableByName(string);
        if (metaDBTable2 == null) {
            metaDBTable = this.m_oMetaDataDefMgr.save(this.m_oCurrUser, metaDBTable);
        } else {
            if (n == 0) {
                throw new WCMException(I18NMessage.get(MetaDataDDLImporter.class, "MetaDataDDLImporter.label18", "\u5df2\u7ecf\u5b58\u5728\u76f8\u540c\u540d\u79f0\u7684\u5143\u6570\u636e."));
            }
            if (n == 1) {
                try {
                    metaDBTable2.setProperty("CRUSER", this.m_oCurrUser.getName());
                    metaDBTable2.setProperty("CRTIME", CMyDateTime.now());
                    metaDBTable2.save(this.m_oCurrUser);
                    metaDBTable = metaDBTable2;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else {
                INameGenerator iNameGenerator = (INameGenerator)DreamFactory.createObjectById("INameGenerator");
                String string2 = iNameGenerator.generate(metaDBTable, "TABLENAME", metaDBTable.getName());
                metaDBTable.setName(string2);
                metaDBTable = this.m_oMetaDataDefMgr.save(this.m_oCurrUser, metaDBTable);
            }
            metaDBTable = metaDBTable2;
        }
        return metaDBTable;
    }

    private String processMetaView(XmlObject xmlObject, int n, Reports reports) throws WCMException {
        XmlObject[] xmlObjectArray = xmlObject.getChild("XWCMVIEWINFOS");
        MetaDBTable metaDBTable = this.processMetaDBTable(xmlObject);
        String string = "";
        for (int i = 0; i < xmlObjectArray.length; ++i) {
            boolean bl = false;
            try {
                MetaView metaView = this.processView(metaDBTable, xmlObjectArray[i], n);
                if (metaView != null) {
                    string = CMyString.isEmpty(string) ? metaView.getId() + "" : string + "," + metaView.getId();
                }
            }
            catch (WCMException wCMException) {
                bl = true;
                if (wCMException.getErrNo() == 0) {
                    reports.addWarnedReport(I18NMessage.get(MetaDataDDLImporter.class, "MetaDataDDLImporter.label15", "\u5904\u7406\u89c6\u56fe\u5931\u8d25\uff01"), wCMException);
                }
                reports.addFailedReport(I18NMessage.get(MetaDataDDLImporter.class, "MetaDataDDLImporter.label15", "\u5904\u7406\u89c6\u56fe\u5931\u8d25\uff01"), wCMException);
            }
            if (bl) continue;
            reports.addSucessedReport(I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDDLImporter.label17", "\u89c6\u56fe\u5bfc\u5165\u6210\u529f\uff01"));
        }
        return string;
    }

    public void importRSFromXML(String string, int n, Reports reports) throws WCMException {
        Object object;
        String string2 = string;
        if (!CMyFile.fileExists(string2)) {
            object = FilesMan.getFilesMan();
            string2 = ((FilesMan)object).mapFilePath(string, 0) + string;
        }
        if (!CMyFile.fileExists(string2)) {
            reports.addFailedReport(I18NMessage.get(MetaDataDDLImporter.class, "MetaDataDDLImporter.label14", "\u5b9a\u4e49\u5143\u6570\u636e\u7ed3\u6784\u7684XML\u6587\u4ef6\u4e0d\u5b58\u5728\uff01[") + string + "][" + string2 + "]", null);
        }
        object = new XMLToMetaDBTablesConvertor(1);
        XmlObject[] xmlObjectArray = ((AbstractXmlToObjConverter)object).convertXml(string2, null, null);
        for (int i = 0; i < xmlObjectArray.length; ++i) {
            XmlObject xmlObject = xmlObjectArray[i];
            this.processRSMetaDB(xmlObject, n, reports);
            String string3 = this.processMetaView(xmlObject, n, reports);
            String[] stringArray = string3.split(",");
            int[] nArray = new int[stringArray.length];
            for (int j = 0; j < stringArray.length; ++j) {
                if (CMyString.isEmpty(stringArray[j])) {
                    stringArray[j] = "0";
                }
                nArray[j] = Integer.parseInt(stringArray[j]);
            }
            reports.setResultIds(nArray);
            this.m_hCurrDBFields.clear();
        }
    }

    public void importFromXML(String string, int n, Reports reports) throws WCMException {
        Object object;
        String string2 = string;
        if (!CMyFile.fileExists(string2)) {
            object = FilesMan.getFilesMan();
            string2 = ((FilesMan)object).mapFilePath(string, 0) + string;
        }
        if (!CMyFile.fileExists(string2)) {
            reports.addFailedReport(I18NMessage.get(MetaDataDDLImporter.class, "MetaDataDDLImporter.label14", "\u5b9a\u4e49\u5143\u6570\u636e\u7ed3\u6784\u7684XML\u6587\u4ef6\u4e0d\u5b58\u5728\uff01[") + string + "][" + string2 + "]", null);
        }
        object = new XMLToMetaDBTablesConvertor(1);
        XmlObject[] xmlObjectArray = ((AbstractXmlToObjConverter)object).convertXml(string2, null, null);
        for (int i = 0; i < xmlObjectArray.length; ++i) {
            XmlObject xmlObject = xmlObjectArray[i];
            this.processMetaDB(xmlObject);
            String string3 = this.processMetaView(xmlObject, n, reports);
            String[] stringArray = string3.split(",");
            int[] nArray = new int[stringArray.length];
            for (int j = 0; j < stringArray.length; ++j) {
                if (CMyString.isEmpty(stringArray[j])) {
                    stringArray[j] = "0";
                }
                nArray[j] = Integer.parseInt(stringArray[j]);
            }
            reports.setResultIds(nArray);
            this.m_hCurrDBFields.clear();
        }
    }

    private MetaView processView(MetaDBTable metaDBTable, XmlObject xmlObject, int n) throws WCMException {
        XmlObject[] xmlObjectArray;
        MetaView metaView = (MetaView)xmlObject.getCurrentObj();
        metaView.removeProperty("VIEWINFOID");
        metaView.removeProperty("MainTableId");
        metaView.removeProperty("CRUSER");
        metaView.removeProperty("CRTIME");
        metaView.removeProperty("OWNERTYPE");
        metaView.removeProperty("OWNERID");
        MetaView metaView2 = this.findViewByName(metaView.getMainTableName(), metaView.getName());
        if (metaView2 == null) {
            metaView.setMainTable(metaDBTable);
            metaView = this.m_oMetaDataDefMgr.save(this.m_oCurrUser, metaView);
        } else {
            if (n == 0) {
                throw new WCMException(0, I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDDLImporter.label16", "\u5df2\u7ecf\u5b58\u5728\u76f8\u540c\u7684\u82f1\u6587\u540d\u79f0\u7684\u89c6\u56fe."));
            }
            if (n == 1) {
                try {
                    metaView2.setProperty("CRUSER", this.m_oCurrUser.getName());
                    metaView2.setProperty("CRTIME", CMyDateTime.now());
                    metaView2.save(this.m_oCurrUser);
                    metaView = metaView2;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else {
                xmlObjectArray = (XmlObject[])DreamFactory.createObjectById("INameGenerator");
                String string = xmlObjectArray.generate(metaView, "VIEWNAME", metaView.getName());
                String string2 = xmlObjectArray.generate(metaView, "VIEWDESC", metaView.getDesc());
                metaView.setName(string);
                metaView.setDesc(string2);
                metaView.setMainTable(metaDBTable);
                metaView = this.m_oMetaDataDefMgr.save(this.m_oCurrUser, metaView);
            }
        }
        this.m_oMetaViews.addElement(metaView);
        xmlObjectArray = xmlObject.getChild("XWCMVIEWFIELDINFOS");
        for (int i = 0; i < xmlObjectArray.length; ++i) {
            this.processViewField(metaView, xmlObjectArray[i]);
        }
        this.m_oMetaDataDefMgr.createViewApplication(metaView);
        return metaView;
    }

    private void processViewField(MetaView metaView, XmlObject xmlObject) throws WCMException {
        MetaViewField metaViewField = (MetaViewField)xmlObject.getCurrentObj();
        metaViewField.removeProperty("VIEWFIELDINFOID");
        metaViewField.removeProperty("CRUSER");
        metaViewField.removeProperty("CRTIME");
        metaViewField.removeProperty("TABLEID");
        metaViewField.removeProperty("ViewId");
        metaViewField.removeProperty("DBFIELD");
        metaViewField.removeProperty("FIELDGROUPID");
        String string = metaViewField.getName();
        MetaViewField metaViewField2 = this.findMetaViewFieldByName(metaView.getId(), string);
        if (metaViewField2 == null) {
            MetaDBField metaDBField = (MetaDBField)this.m_hCurrDBFields.get(metaViewField.getDBName().trim().toUpperCase());
            if (metaDBField == null) {
                throw new WCMException(I18NMessage.get(MetaDataDDLImporter.class, "MetaDataDDLImporter.label19", "\u6307\u5b9a\u7684\u7269\u7406\u5b57\u6bb5\u4e0d\u5b58\u5728\uff01[") + metaViewField.getDBName() + "]");
            }
            metaViewField.setDBField(metaDBField.getId());
            metaViewField.setTableId(metaDBField.getTableId());
            metaViewField = this.m_oMetaDataDefMgr.save(this.m_oCurrUser, metaView, metaViewField);
        } else {
            metaViewField = metaViewField2;
        }
    }

    private MetaDBField processDBField(MetaDBTable metaDBTable, XmlObject xmlObject) throws WCMException {
        MetaDBField metaDBField = (MetaDBField)xmlObject.getCurrentObj();
        metaDBField.removeProperty("DBFIELDINFOID");
        metaDBField.removeProperty("CRUSER");
        metaDBField.removeProperty("CRTIME");
        metaDBField.removeProperty("TABLEID");
        String string = metaDBField.getName();
        MetaDBField metaDBField2 = this.findMetaDBFieldByName(metaDBTable.getId(), string);
        if (metaDBField2 == null) {
            return this.m_oMetaDataDefMgr.save(this.m_oCurrUser, metaDBTable, metaDBField);
        }
        return metaDBField2;
    }

    private MetaDBTable processMetaDBTable(XmlObject xmlObject) throws WCMException {
        MetaDBTable metaDBTable = (MetaDBTable)xmlObject.getCurrentObj();
        if (metaDBTable == null) {
            throw new WCMException(I18NMessage.get(MetaDataDefMgr.class, "MetaDataDefMgr.label14", "\u5bfc\u5165\u7684\u6570\u636e\u4e0d\u6b63\u786e,XML\u6587\u4ef6\u4e0d\u662f\u4e00\u4e2a\u6709\u6548\u7684\u89c6\u56fe\u6587\u4ef6."));
        }
        metaDBTable.removeProperty("TABLEINFOID");
        metaDBTable.removeProperty("CRUSER");
        metaDBTable.removeProperty("CRTIME");
        metaDBTable.removeProperty("OWNERTYPE");
        metaDBTable.removeProperty("OWNERID");
        String string = metaDBTable.getName();
        MetaDBTable metaDBTable2 = this.findMetaDBTableByName(string);
        metaDBTable = metaDBTable2 == null ? this.m_oMetaDataDefMgr.save(this.m_oCurrUser, metaDBTable) : metaDBTable2;
        return metaDBTable;
    }

    private MetaDBTable findMetaDBTableByName(String string) throws WCMException {
        String string2 = "TableName=?";
        WCMFilter wCMFilter = new WCMFilter("", string2, "");
        wCMFilter.addSearchValues(string);
        MetaDBTables metaDBTables = MetaDBTables.openWCMObjs(this.m_oCurrUser, wCMFilter);
        if (metaDBTables != null && !metaDBTables.isEmpty()) {
            return (MetaDBTable)metaDBTables.getAt(0);
        }
        return null;
    }

    private MetaDBField findMetaDBFieldByName(int n, String string) throws WCMException {
        String string2 = "TableId=? and FieldName=?";
        WCMFilter wCMFilter = new WCMFilter("", string2, "");
        wCMFilter.addSearchValues(n);
        wCMFilter.addSearchValues(string);
        MetaDBFields metaDBFields = MetaDBFields.openWCMObjs(this.m_oCurrUser, wCMFilter);
        if (metaDBFields != null && !metaDBFields.isEmpty()) {
            return (MetaDBField)metaDBFields.getAt(0);
        }
        return null;
    }

    private MetaViewField findMetaViewFieldByName(int n, String string) throws WCMException {
        String string2 = "ViewId=? and FieldName=?";
        WCMFilter wCMFilter = new WCMFilter("", string2, "");
        wCMFilter.addSearchValues(n);
        wCMFilter.addSearchValues(string);
        MetaViewFields metaViewFields = MetaViewFields.openWCMObjs(this.m_oCurrUser, wCMFilter);
        if (metaViewFields != null && !metaViewFields.isEmpty()) {
            return (MetaViewField)metaViewFields.getAt(0);
        }
        return null;
    }

    private MetaView findViewByName(String string, String string2) throws WCMException {
        String string3 = "MainTableName=? and ViewName=?";
        WCMFilter wCMFilter = new WCMFilter("", string3, "");
        wCMFilter.addSearchValues(string);
        wCMFilter.addSearchValues(string2);
        MetaViews metaViews = MetaViews.openWCMObjs(this.m_oCurrUser, wCMFilter);
        if (metaViews != null && !metaViews.isEmpty()) {
            return (MetaView)metaViews.getAt(0);
        }
        return null;
    }
}

