/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.definition;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.cms.content.WCMSystemObject;
import com.trs.components.metadata.MetaDataConstants;
import com.trs.components.metadata.definition.MetaDBTable;
import com.trs.components.metadata.definition.MetaDBTables;
import com.trs.components.metadata.definition.MetaViewField;
import com.trs.components.metadata.definition.MetaViewFields;
import com.trs.components.metadata.definition.MetaViews;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyString;

public class MetaView
extends CMSObj {
    public static final int OBJ_TYPE = 1874605631;
    public static final String DB_TABLE_NAME = "XWCMVIEWINFO";
    public static final String DB_ID_NAME = "VIEWINFOID";
    private MetaDBTable m_oMainTable = null;
    public static final int SPECIAL_VIEW = 1;
    private String m_sOtherTableIds = null;
    private static final String SQL_DELETE_OTHERTABLES = "delete from XWCMVIEWOtherTables where ViewId=?";
    private static final String SQL_INSERT_OTHERTABLES = "insert into XWCMVIEWOtherTables(ViewId, TableId) values(?, ?)";
    private static final String WHERE_QUERY_TABLEINFOS = "exists(select XWCMVIEWOtherTables.TableId from XWCMVIEWOtherTables where XWCMVIEWOtherTables.ViewId=? and XWCMVIEWOtherTables.TableId=XWCMTABLEINFO.TABLEINFOID)";

    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    public int getWCMType() {
        return 1874605631;
    }

    public String getName() {
        return this.getPropertyAsString("VIEWNAME");
    }

    public boolean setName(String string) throws WCMException {
        return this.setProperty("VIEWNAME", string);
    }

    public String getDesc() {
        return this.getPropertyAsString("VIEWDESC");
    }

    public boolean setDesc(String string) throws WCMException {
        return this.setProperty("VIEWDESC", string);
    }

    public String getMainTableName() {
        return this.getPropertyAsString("MAINTABLENAME");
    }

    private boolean setMainTableName(String string) throws WCMException {
        return this.setProperty("MAINTABLENAME", string);
    }

    public int getMainTableId() {
        return this.getPropertyAsInt("MAINTABLEID", 0);
    }

    public MetaDBTable getMainTable() throws WCMException {
        if (this.m_oMainTable == null) {
            this.m_oMainTable = MetaDBTable.findById(this.getMainTableId());
            if (this.m_oMainTable == null) {
                throw new WCMException(I18NMessage.get(MetaView.class, "MetaView.label1", "\u76f8\u5173\u7684\u7269\u7406\u8868\u4e0d\u5b58\u5728![ID=") + this.getMainTableId() + "]");
            }
        }
        return this.m_oMainTable;
    }

    private boolean setMainTableId(int n) throws WCMException {
        return this.setProperty("MAINTABLEID", n);
    }

    public boolean setMainTableId(int n, String string) throws WCMException {
        return this.setMainTableId(n) && this.setMainTableName(string);
    }

    public boolean setMainTable(MetaDBTable metaDBTable) throws WCMException {
        this.m_oMainTable = metaDBTable;
        return this.setMainTableId(metaDBTable.getId()) && this.setMainTableName(metaDBTable.getName());
    }

    public MetaDBTable getMainDBTableInfo() throws WCMException {
        return MetaDBTable.findById(this.getMainTableId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getOtherTableIds() throws WCMException {
        if (this.id > 0 && this.isAddMode() && this.m_sOtherTableIds == null) {
            MetaView metaView = this;
            synchronized (metaView) {
                this.m_sOtherTableIds = this.getOtherTables(null, new WCMFilter("", "", "", "TableId")).getIdListAsString();
                if (this.m_sOtherTableIds == null) {
                    this.m_sOtherTableIds = "";
                }
            }
        }
        return this.m_sOtherTableIds;
    }

    public MetaDBTables getOtherTables(User user, WCMFilter wCMFilter) throws WCMException {
        WCMFilter wCMFilter2 = new WCMFilter("", WHERE_QUERY_TABLEINFOS, "");
        wCMFilter2.addSearchValues(this.getId());
        wCMFilter2.mergeWith(wCMFilter);
        return MetaDBTables.openWCMObjs(user, wCMFilter2);
    }

    public void setOtherTableIds(String string) {
        this.m_sOtherTableIds = string;
        if (this.m_sOtherTableIds != null) {
            this.m_sOtherTableIds = this.m_sOtherTableIds.trim();
        }
    }

    public CMSObj getOwner() throws WCMException {
        switch (this.getOwnerType()) {
            case 1: {
                return new WCMSystemObject(this.getOwnerId());
            }
        }
        return (CMSObj)BaseObj.findById(this.getOwnerType(), this.getOwnerId());
    }

    public int getOwnerId() {
        return this.getPropertyAsInt("OWNERID", 0);
    }

    public int getOwnerType() {
        return this.getPropertyAsInt("OWNERTYPE", 0);
    }

    public boolean setOwner(int n, int n2) throws WCMException {
        return this.setProperty("OwnerType", n) && this.setProperty("OwnerId", n2);
    }

    public int getViewClassId() {
        return this.getPropertyAsInt("VIEWCLASSID", 0);
    }

    public boolean setRootId(int n) throws WCMException {
        return this.setProperty("VIEWCLASSID", n);
    }

    public int getSpecialValue() {
        return this.getPropertyAsInt("ISSPECIAL", 0);
    }

    public boolean setSpecialValue(int n) throws WCMException {
        return this.setProperty("ISSPECIAL", n);
    }

    public boolean isSpecialView() {
        return this.getSpecialValue() == 1;
    }

    public String getViewDescCon() {
        return this.getPropertyAsString("VIEWDESCCON");
    }

    public boolean setViewDescCon(String string) throws WCMException {
        return this.setProperty("VIEWDESCCON", string);
    }

    public String getTemplatePath() {
        return this.getPropertyAsString("TEMPLATEPATH");
    }

    public boolean setTemplatePath(String string) throws WCMException {
        return this.setProperty("TEMPLATEPATH", string);
    }

    public boolean isValid() throws WCMException {
        if (this.isAddMode()) {
            if (this.getProperty("VIEWNAME") == null) {
                throw new WCMException(1106, I18NMessage.get(MetaView.class, "MetaView.label2", "\u5c5e\u6027Name\u6ca1\u6709\u8bbe\u7f6e(ViewInfo.isValid)"));
            }
            if (this.getProperty("MAINTABLEID") == null) {
                throw new WCMException(1106, I18NMessage.get(MetaView.class, "MetaView.label3", "\u5c5e\u6027MAINTABLEID\u6ca1\u6709\u8bbe\u7f6e(ViewInfo.isValid)"));
            }
            if (this.getProperty("OWNERTYPE") == null) {
                this.setOwner(1, 1);
            }
        } else if (!this.isModified()) {
            throw new WCMException(1107, I18NMessage.get(MetaView.class, "MetaView.label4", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(ViewInfo.isValid)"));
        }
        return true;
    }

    public void insert(User user) throws WCMException {
        if (this.isAddMode() && this.isModified()) {
            super.insert(user);
        }
    }

    public MetaViewFields getViewFields(User user, WCMFilter wCMFilter) throws WCMException {
        WCMFilter wCMFilter2 = new WCMFilter("", "viewId = ?", "");
        wCMFilter2.addSearchValues(this.getId());
        wCMFilter2.mergeWith(wCMFilter);
        return MetaViewFields.openWCMObjs(user, wCMFilter2);
    }

    public MetaViewField getTitleField() throws WCMException {
        MetaViewFields metaViewFields = this.getViewFields(null, null);
        int n = metaViewFields.size();
        for (int i = 0; i < n; ++i) {
            MetaViewField metaViewField = (MetaViewField)metaViewFields.getAt(i);
            if (metaViewField == null || !metaViewField.isTitleField()) continue;
            return metaViewField;
        }
        return null;
    }

    public static final MetaView findById(int n) throws WCMException {
        if (n <= 0) {
            return null;
        }
        return (MetaView)BaseObj.findById(MetaView.class, n);
    }

    public static final MetaView findByIdentity(String string, String string2) throws WCMException {
        WCMFilter wCMFilter = new WCMFilter();
        wCMFilter.setWhere(string + "=?");
        wCMFilter.addSearchValues(string2);
        MetaViews metaViews = MetaViews.openWCMObjs(null, wCMFilter);
        if (metaViews == null || metaViews.size() <= 0) {
            return null;
        }
        int n = metaViews.size();
        for (int i = 0; i < n; ++i) {
            MetaView metaView = (MetaView)metaViews.getAt(i);
            if (metaView == null) continue;
            return metaView;
        }
        return null;
    }

    public static final MetaView createNewInstance() throws WCMException {
        return (MetaView)BaseObj.createNewInstance(MetaView.class);
    }

    public static final MetaView findByKey(Object object) throws WCMException {
        return (MetaView)BaseObj.findByKey(MetaView.class, object);
    }

    public void save(User user) throws WCMException {
        boolean bl = !this.isAddMode();
        super.save(user);
        if (bl) {
            if (this.m_sOtherTableIds == null) {
                return;
            }
            if (this.m_sOtherTableIds != null && this.m_sOtherTableIds.length() > 0) {
                DBManager.getDBManager().sqlExecuteUpdate(new String[]{"delete from XWCMVIEWOtherTables where ViewId=? and TableId not in(" + this.m_sOtherTableIds + ")"}, new int[]{this.getId()});
                this.maintenaceOtherTables(this.getOtherTables(user, null));
            } else {
                DBManager.getDBManager().sqlExecuteUpdate(new String[]{SQL_DELETE_OTHERTABLES}, new int[]{this.getId()});
            }
        } else if (this.m_sOtherTableIds != null && this.m_sOtherTableIds.length() > 0) {
            this.maintenaceOtherTables(null);
        }
    }

    private void maintenaceOtherTables(MetaDBTables metaDBTables) throws WCMException {
        int[] nArray = CMyString.splitToInt(this.m_sOtherTableIds, ",");
        int[] nArray2 = new int[2];
        nArray2[0] = this.getId();
        DBManager dBManager = DBManager.getDBManager();
        for (int i = 0; i < nArray.length; ++i) {
            if (metaDBTables != null && metaDBTables.indexOf(nArray[i]) >= 0) continue;
            nArray2[1] = nArray[i];
            dBManager.sqlExecuteUpdate(new String[]{SQL_INSERT_OTHERTABLES}, nArray2);
        }
    }

    public boolean isModified(boolean bl) {
        if (this.isAddMode()) {
            return super.isModified(bl);
        }
        return this.m_sOtherTableIds != null || super.isModified(bl);
    }

    public String getTrueTableName() {
        if (!this.isMultiTable()) {
            return MetaDataConstants.makeTrueTableName(this.getName());
        }
        return this.getName();
    }

    public boolean isMultiTable() {
        return !this.getName().trim().equalsIgnoreCase(this.getMainTableName().trim());
    }

    public boolean isHiddenAppendix() {
        return this.getPropertyAsBoolean("HIDDENAPPENDIX", false);
    }

    public boolean setHiddenAppendix(boolean bl) throws WCMException {
        return this.setProperty("HIDDENAPPENDIX", bl);
    }
}

