/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.definition;

import com.trs.cms.content.CMSObj;
import com.trs.components.metadata.MetaDataConstants;
import com.trs.components.metadata.definition.ClassInfo;
import com.trs.components.metadata.definition.MetaDBTable;
import com.trs.components.metadata.definition.MetaDataType;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import java.util.HashMap;

public class MetaDBField
extends CMSObj {
    public static final int OBJ_TYPE = 1269981572;
    public static final String DB_TABLE_NAME = "XWCMDBFIELDINFO";
    public static final String DB_ID_NAME = "DBFIELDINFOID";
    public static final String DB_FIELD_DBNAME_NAME = "FIELDNAME";
    public static final String DB_FIELD_DBTYPE_NAME = "DBTYPE";
    private MetaDataType m_oMetaDataType = null;
    private MetaDataType m_oMetaDBDataType = null;

    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    public int getWCMType() {
        return 1269981572;
    }

    public String getTableName() {
        return this.getPropertyAsString("TABLENAME");
    }

    public boolean setTableName(String string) throws WCMException {
        return this.setProperty("TABLENAME", string);
    }

    public int getTableId() {
        return this.getPropertyAsInt("TABLEID", 0);
    }

    public boolean setTableId(int n) throws WCMException {
        return this.setProperty("TABLEID", n);
    }

    public String getName() {
        return this.getPropertyAsString(DB_FIELD_DBNAME_NAME);
    }

    public boolean setName(String string) throws WCMException {
        return this.setProperty(DB_FIELD_DBNAME_NAME, string);
    }

    public String getAnotherName() {
        return this.getPropertyAsString("ANOTHERNAME");
    }

    public boolean setAnotherName(String string) throws WCMException {
        return this.setProperty("ANOTHERNAME", string);
    }

    public int getType() {
        return this.getPropertyAsInt("FIELDTYPE", 0);
    }

    public boolean setType(int n) throws WCMException {
        return this.setProperty("FIELDTYPE", n);
    }

    public int getDBType() {
        return this.getPropertyAsInt(DB_FIELD_DBTYPE_NAME, 0);
    }

    public boolean setDBType(int n) throws WCMException {
        return this.setProperty(DB_FIELD_DBTYPE_NAME, n);
    }

    public int getLength() {
        return this.getPropertyAsInt("DBLENGTH", 0);
    }

    public boolean setLength(int n) throws WCMException {
        return this.setProperty("DBLENGTH", n);
    }

    public int getScale() {
        return this.getPropertyAsInt("DBSCALE", 3);
    }

    public boolean setScale(int n) throws WCMException {
        return this.setProperty("DBSCALE", n);
    }

    public String getDefaultValue() {
        return this.getPropertyAsString("DEFAULTVALUE");
    }

    public boolean setDefaultValue(String string) throws WCMException {
        return this.setProperty("DEFAULTVALUE", string);
    }

    public String getValidator() {
        return this.getPropertyAsString("Validator");
    }

    public boolean setValidator(String string) throws WCMException {
        return this.setProperty("Validator", string);
    }

    public String getEnmValue() {
        return this.getPropertyAsString("ENMVALUE");
    }

    public boolean setEnmValue(String string) throws WCMException {
        return this.setProperty("ENMVALUE", string);
    }

    public boolean isNotNull() {
        return this.getPropertyAsBoolean("NOTNULL", false);
    }

    public boolean setNotNull(boolean bl) throws WCMException {
        return this.setProperty("NOTNULL", bl);
    }

    public boolean isRadioOrCheck() {
        return this.getPropertyAsBoolean("Radorchk", false);
    }

    public boolean setRadioOrCheck(boolean bl) throws WCMException {
        return this.setProperty("Radorchk", bl);
    }

    public int getClassId() {
        return this.getPropertyAsInt("CLASSID", 0);
    }

    public boolean setClassId(int n) throws WCMException {
        return this.setProperty("CLASSID", n);
    }

    public boolean isValid() throws WCMException {
        int n = 0;
        if (this.isAddMode()) {
            if (this.getProperty("TABLENAME") == null) {
                throw new WCMException(1106, I18NMessage.get(MetaDBField.class, "MetaDBField.label1", "\u5c5e\u6027TableName\u6ca1\u6709\u8bbe\u7f6e(DBFieldInfo.isValid)"));
            }
            if (this.getProperty("TABLEID") == null) {
                throw new WCMException(1106, I18NMessage.get(MetaDBField.class, "MetaDBField.label2", "\u5c5e\u6027TableId\u6ca1\u6709\u8bbe\u7f6e(DBFieldInfo.isValid)"));
            }
            if (this.getProperty(DB_FIELD_DBNAME_NAME) == null) {
                throw new WCMException(1106, I18NMessage.get(MetaDBField.class, "MetaDBField.label3", "\u5c5e\u6027Name\u6ca1\u6709\u8bbe\u7f6e(DBFieldInfo.isValid)"));
            }
            if (this.getProperty("ANOTHERNAME") == null) {
                throw new WCMException(1106, I18NMessage.get(MetaDBField.class, "MetaDBField.label4", "\u5c5e\u6027AnotherName\u6ca1\u6709\u8bbe\u7f6e(DBFieldInfo.isValid)"));
            }
            if (this.getProperty("FIELDTYPE") == null) {
                throw new WCMException(1106, I18NMessage.get(MetaDBField.class, "MetaDBField.label5", "\u5c5e\u6027Type\u6ca1\u6709\u8bbe\u7f6e(DBFieldInfo.isValid)"));
            }
            if (this.getProperty(DB_FIELD_DBTYPE_NAME) == null) {
                throw new WCMException(1106, I18NMessage.get(MetaDBField.class, "MetaDBField.label6", "\u5c5e\u6027DBType\u6ca1\u6709\u8bbe\u7f6e(DBFieldInfo.isValid)"));
            }
            if (this.getProperty("DBSCALE") == null) {
                this.setScale(0);
            }
            if (this.getProperty("CLASSID") == null) {
                this.setClassId(0);
            }
            if (this.getProperty("NotNull") == null) {
                this.setNotNull(false);
            }
            n = this.getType();
        } else {
            if (!this.isModified()) {
                throw new WCMException(1107, I18NMessage.get(MetaDBField.class, "MetaDBField.label7", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(DBFieldInfo.isValid)"));
            }
            n = this.getNewPropertyAsInt("FIELDTYPE", 0);
        }
        if (n != 0) {
            MetaDataType metaDataType = null;
            metaDataType = n == 1 ? MetaDataConstants.DB_DATA_TYPES.getDataTypeById(this.getDBType()) : MetaDataConstants.DATA_TYPES.getDataTypeById(n);
            if (this.isAddMode() && this.getProperty("DBLENGTH") == null) {
                this.setLength(metaDataType.getMaxLength());
            } else if (!this.isAddMode() && this.getType() != n && this.getNewProperty("DBLENGTH") == null) {
                this.setLength(metaDataType.getMaxLength());
            }
            if (this.getDBType() == 2005 || this.getDBType() == 93 || this.getDBType() == 4) {
                this.setLength(0);
            }
        }
        return true;
    }

    public String getClassName() {
        int n = this.getClassId();
        if (n == 0) {
            return "";
        }
        try {
            ClassInfo classInfo = ClassInfo.findById(this.getClassId());
            if (classInfo != null) {
                return classInfo.getName();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return "";
    }

    public String getTypeDesc() {
        if (this.m_oMetaDataType == null) {
            this.m_oMetaDataType = MetaDataConstants.DATA_TYPES.getDataTypeById(this.getType());
        }
        return this.m_oMetaDataType.getDataTypeDesc();
    }

    public String getDBTypeDesc() {
        if (this.m_oMetaDBDataType == null) {
            this.m_oMetaDBDataType = MetaDataConstants.DB_DATA_TYPES.getDataTypeById(this.getDBType());
        }
        return this.m_oMetaDBDataType.getDataTypeDesc();
    }

    public int getSqlType() {
        if (this.m_oMetaDBDataType == null) {
            this.m_oMetaDBDataType = MetaDataConstants.DB_DATA_TYPES.getDataTypeById(this.getDBType());
        }
        return this.m_oMetaDBDataType.getSqlDataType();
    }

    public boolean isStringField() {
        if (this.m_oMetaDBDataType == null) {
            this.m_oMetaDBDataType = MetaDataConstants.DB_DATA_TYPES.getDataTypeById(this.getDBType());
        }
        return this.m_oMetaDBDataType.isString();
    }

    public boolean isModifyColumnProperties(boolean bl) {
        if (!this.isModified()) {
            return false;
        }
        String[] stringArray = new String[]{"DBLength", "DBSCALE"};
        if (bl) {
            stringArray = new String[]{"NotNull", "DBLength", "DBSCALE"};
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!this.isChangeProperty(stringArray[i])) continue;
            return true;
        }
        if (!this.isAddMode()) {
            if (this.getType() == 12) {
                return false;
            }
            if (this.getType() == 1 && this.getDBType() == 2005) {
                return false;
            }
            if (this.getType() != this.getNewPropertyAsInt("fieldType", 0) && this.getNewProperty("DBLENGTH") == null) {
                return true;
            }
        }
        return false;
    }

    public HashMap getEnmValueMap(boolean bl) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string = this.getEnmValue();
        String[] stringArray = string.split("~");
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i].split("`");
            if (bl) {
                hashMap.put(stringArray2.length > 1 ? stringArray2[1] : stringArray2[0], stringArray2[0]);
                continue;
            }
            hashMap.put(stringArray2[0], stringArray2.length > 1 ? stringArray2[1] : stringArray2[0]);
        }
        return hashMap;
    }

    public MetaDBTable getMetaDBTable() throws WCMException {
        return MetaDBTable.findById(this.getTableId());
    }

    public static final MetaDBField findById(int n) throws WCMException {
        if (n <= 0) {
            return null;
        }
        return (MetaDBField)BaseObj.findById(MetaDBField.class, n);
    }

    public static final MetaDBField createNewInstance() throws WCMException {
        return (MetaDBField)BaseObj.createNewInstance(MetaDBField.class);
    }

    public static final MetaDBField findByKey(Object object) throws WCMException {
        return (MetaDBField)BaseObj.findByKey(MetaDBField.class, object);
    }
}

