/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.definition;

import com.trs.cms.auth.persistent.User;
import com.trs.components.metadata.definition.ClassInfo;
import com.trs.components.metadata.definition.ClassInfos;
import com.trs.components.metadata.definition.IClassInfoCacheMgr;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyMemory;
import java.util.Hashtable;
import org.apache.log4j.Logger;

public class ClassInfoCacheMgr
implements IClassInfoCacheMgr {
    private static Logger logger = Logger.getLogger(ClassInfoCacheMgr.class);
    private Hashtable m_hChildrenCache = null;
    private Hashtable m_hRootNameCache = null;
    private Hashtable m_hOtherNameCache = null;

    public ClassInfos getChildren(int n) throws WCMException {
        return this.getChildren(n, false);
    }

    public ClassInfo findClassInfoByName(String string) throws WCMException {
        String string2;
        ClassInfo classInfo;
        if (this.m_hRootNameCache == null) {
            this.init();
        }
        if ((classInfo = (ClassInfo)this.m_hRootNameCache.get(string2 = string.toUpperCase())) == null) {
            classInfo = (ClassInfo)this.m_hOtherNameCache.get(string2);
        }
        return classInfo;
    }

    public void clear() {
        if (this.m_hChildrenCache != null) {
            this.m_hChildrenCache.clear();
            this.m_hChildrenCache = null;
        }
        if (this.m_hRootNameCache != null) {
            this.m_hRootNameCache.clear();
            this.m_hRootNameCache = null;
        }
        if (this.m_hOtherNameCache != null) {
            this.m_hOtherNameCache.clear();
            this.m_hOtherNameCache = null;
        }
    }

    public synchronized boolean init() throws WCMException {
        if (this.m_hChildrenCache != null) {
            return false;
        }
        logger.info((Object)I18NMessage.get(ClassInfoCacheMgr.class, "ClassInfoCacheMgr.label1", "\u5206\u7c7b\u6cd5\u7f13\u51b2\u521d\u59cb\u5316\u5f00\u59cb..."));
        logger.info((Object)(I18NMessage.get(ClassInfoCacheMgr.class, "ClassInfoCacheMgr.label2", "\u5206\u7c7b\u6cd5\u7f13\u51b2\u521d\u59cb\u5316\u524d\u5185\u5b58\u4f7f\u7528\u60c5\u51b5[") + CMyMemory.toMemoryInfo() + "]"));
        this.m_hChildrenCache = new Hashtable();
        this.m_hRootNameCache = new Hashtable(20);
        this.m_hOtherNameCache = new Hashtable(100);
        WCMFilter wCMFilter = new WCMFilter("", "", "ClassOrder desc,RootId,ParentId");
        ClassInfos classInfos = ClassInfos.openWCMObjs(null, wCMFilter);
        int n = classInfos.size();
        for (int i = 0; i < n; ++i) {
            ClassInfo classInfo = (ClassInfo)classInfos.getAt(i);
            if (classInfo == null) continue;
            this.putToChildCache(classInfo);
            this.putToNameCache(classInfo);
        }
        classInfos.clear();
        logger.info((Object)I18NMessage.get(ClassInfoCacheMgr.class, "ClassInfoCacheMgr.label3", "\u5206\u7c7b\u6cd5\u7f13\u51b2\u521d\u59cb\u5316\u5b8c\u6210\uff01"));
        logger.info((Object)(I18NMessage.get(ClassInfoCacheMgr.class, "ClassInfoCacheMgr.label4", "\u5206\u7c7b\u6cd5\u7f13\u51b2\u521d\u59cb\u5316\u540e\u5185\u5b58\u4f7f\u7528\u60c5\u51b5[") + CMyMemory.toMemoryInfo() + "]"));
        return true;
    }

    private void putToNameCache(ClassInfo classInfo) {
        if (classInfo.isRoot()) {
            this.m_hRootNameCache.put(classInfo.getName().toUpperCase(), classInfo);
        } else {
            this.m_hOtherNameCache.put(classInfo.getName().toUpperCase(), classInfo);
        }
    }

    private void removeFromNameCache(ClassInfo classInfo) {
        if (classInfo.isRoot()) {
            this.m_hRootNameCache.remove(classInfo.getName().toUpperCase());
        } else {
            this.m_hOtherNameCache.put(classInfo.getName().toUpperCase(), classInfo);
        }
    }

    private void putToChildCache(ClassInfo classInfo) throws WCMException {
        Integer n = new Integer(classInfo.getParentId());
        ClassInfos classInfos = (ClassInfos)this.m_hChildrenCache.get(n);
        if (classInfos == null) {
            classInfos = new ClassInfos(null);
            this.m_hChildrenCache.put(n, classInfos);
        }
        classInfos.setMaxBufferSize(classInfos.size() + 1);
        classInfos.addElement(classInfo);
    }

    private void removeFromChildCache(ClassInfo classInfo) throws WCMException {
        ClassInfos classInfos = (ClassInfos)this.m_hChildrenCache.get(new Integer(classInfo.getParentId()));
        if (classInfos != null) {
            classInfos.remove(classInfo.getId(), false);
        }
    }

    public boolean reinit() throws WCMException {
        this.clear();
        return this.init();
    }

    public void notifyOnAddObj(BaseObj baseObj) throws WCMException {
        if (baseObj.getWCMType() != 694710472) {
            return;
        }
        ClassInfo classInfo = (ClassInfo)baseObj;
        this.reloadChildren(classInfo.getParentId());
    }

    public void notifyOnDelObj(BaseObj baseObj, int n) throws WCMException {
        if (!(baseObj instanceof ClassInfo)) {
            logger.error((Object)("Listener[" + this.getClass() + I18NMessage.get(ClassInfoCacheMgr.class, "ClassInfoCacheMgr.label5", "]\u4e0d\u80fd\u76d1\u542c\u5bf9\u8c61[") + baseObj.getClass() + I18NMessage.get(ClassInfoCacheMgr.class, "ClassInfoCacheMgr.label6", "]\u7684\u5220\u9664\uff01")));
            return;
        }
        ClassInfo classInfo = (ClassInfo)baseObj;
        this.removeFromChildCache(classInfo);
        this.removeFromNameCache(classInfo);
    }

    public void notifyOnModifyObj(BaseObj baseObj, int n) throws WCMException {
        if (baseObj.getWCMType() != 694710472) {
            return;
        }
        ClassInfo classInfo = (ClassInfo)baseObj;
        if (classInfo.isChangeProperty("ParentId")) {
            int n2 = classInfo.getParentId();
            this.reloadChildren(n2);
            int n3 = classInfo.getNewPropertyAsInt("ParentId", 0);
            this.reloadChildren(n3);
            return;
        }
        if (classInfo.isChangeProperty("ClassOrder")) {
            this.reloadChildren(classInfo.getParentId());
            return;
        }
    }

    private void reloadChildren(int n) throws WCMException {
        WCMFilter wCMFilter = new WCMFilter("", "ParentId=?", "ClassOrder desc");
        wCMFilter.addSearchValues(n);
        ClassInfos classInfos = ClassInfos.openWCMObjs(User.getSystem(), wCMFilter);
        Integer n2 = new Integer(n);
        ClassInfos classInfos2 = (ClassInfos)this.m_hChildrenCache.get(n2);
        this.m_hChildrenCache.put(n2, classInfos);
        if (classInfos2 != null) {
            classInfos2.clear();
            classInfos2 = null;
        }
    }

    public ClassInfos getChildren(int n, boolean bl) throws WCMException {
        if (this.m_hChildrenCache == null) {
            this.init();
        }
        ClassInfos classInfos = (ClassInfos)this.m_hChildrenCache.get(new Integer(n));
        if (bl) {
            if (classInfos == null) {
                return new ClassInfos(null);
            }
            return classInfos;
        }
        ClassInfos classInfos2 = new ClassInfos(null);
        if (classInfos != null) {
            classInfos2.addWith(classInfos);
        }
        return classInfos2;
    }
}

