/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.definition;

import com.trs.DreamFactory;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.metadata.definition.ClassInfos;
import com.trs.components.metadata.definition.IClassInfoCacheMgr;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyString;

public class ClassInfo
extends CMSObj {
    public static final int OBJ_TYPE = 694710472;
    public static final String DB_TABLE_NAME = "XWCMCLASSINFO";
    public static final String DB_ID_NAME = "CLASSINFOID";
    private static final String QUERY_HAS_CHILDREN = "select 1 from XWCMClassInfo where ParentId=?";
    private static final int DIRECTION_MOVE_FORWARD = 1;
    private static final int DIRECTION_MOVE_BACK = -1;
    private static final int DIRECTION_MOVE_NO = 0;

    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    public int getWCMType() {
        return 694710472;
    }

    public String getName() {
        return this.getPropertyAsString("CNAME");
    }

    public boolean setName(String string) throws WCMException {
        return this.setProperty("CNAME", string);
    }

    public String getDesc() {
        return this.getPropertyAsString("CDESC");
    }

    public boolean setDesc(String string) throws WCMException {
        return this.setProperty("CDESC", string);
    }

    public int getParentId() {
        return this.getPropertyAsInt("PARENTID", 0);
    }

    public ClassInfo getParent() throws WCMException {
        return ClassInfo.findById(this.getParentId());
    }

    public boolean setParentId(int n) throws WCMException {
        return this.setProperty("PARENTID", n);
    }

    public int getRootId() {
        if (this.isRoot()) {
            return this.getId();
        }
        return this.getPropertyAsInt("ROOTID", 0);
    }

    public boolean setOrder(int n) throws WCMException {
        return this.setProperty("ClassOrder", n);
    }

    public int getOrder() {
        return this.getPropertyAsInt("ClassOrder", 0);
    }

    public boolean setRootId(int n) throws WCMException {
        return this.setProperty("ROOTID", n);
    }

    public String getCode() {
        return this.getPropertyAsString("CCODE");
    }

    public boolean setCode(String string) throws WCMException {
        return this.setProperty("CCODE", string);
    }

    public boolean isValid() throws WCMException {
        if (this.isAddMode()) {
            if (this.getProperty("CNAME") == null) {
                throw new WCMException(1106, I18NMessage.get(ClassInfo.class, "ClassInfo.label1", "\u5c5e\u6027Name\u6ca1\u6709\u8bbe\u7f6e(ClassInfo.isValid)"));
            }
            if (this.getProperty("ROOTID") == null) {
                throw new WCMException(1106, I18NMessage.get(ClassInfo.class, "ClassInfo.label2", "\u5c5e\u6027RootId\u6ca1\u6709\u8bbe\u7f6e(ClassInfo.isValid)"));
            }
        } else if (!this.isModified()) {
            throw new WCMException(1107, I18NMessage.get(ClassInfo.class, "ClassInfo.label3", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(ClassInfo.isValid)"));
        }
        this.changeOrder();
        return true;
    }

    public void insert(User user) throws WCMException {
        if (this.isAddMode() && this.isModified()) {
            if (this.getProperty("ParentId") == null) {
                this.setParentId(0);
            }
            super.insert(user);
        }
    }

    public boolean isRoot() {
        return this.getParentId() == 0;
    }

    public boolean isLeaf() throws WCMException {
        int n = DBManager.getDBManager().sqlExecuteIntQuery(QUERY_HAS_CHILDREN, new int[]{this.getId()});
        return n != 1;
    }

    private void changeOrder() throws WCMException {
        int n;
        int n2;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        if (this.isAddMode()) {
            n2 = this.getOrder();
            n = this.getMaxOrder();
            if (n2 == -1) {
                n2 = n + 1;
                this.setOrder(n2);
                return;
            }
            n5 = 1;
            n4 = n;
            n3 = n2;
        } else {
            if (!this.isChangeProperty("ClassOrder")) {
                return;
            }
            n2 = this.getNewPropertyAsInt("ClassOrder", -1);
            if (n2 == -1) {
                n = this.getMaxOrder();
                if (this.isChangeProperty("PARENTID")) {
                    n2 = n + 1;
                } else if (n == this.getOrder()) {
                    n2 = this.getOrder();
                } else {
                    n5 = -1;
                    n4 = n;
                    n3 = this.getOrder() + 1;
                    n2 = n;
                }
            } else if (n2 > this.getOrder()) {
                n5 = -1;
                n4 = --n2;
                n3 = this.getOrder() + 1;
            } else {
                n5 = 1;
                n4 = this.getOrder() - 1;
                n3 = n2;
            }
        }
        String string = "ClassOrder>=" + n3 + " AND ClassOrder <= " + n4 + " and ParentId=" + this.getNewParentId();
        String string2 = "UPDATE XWCMCLASSINFO SET ClassOrder = ClassOrder+(" + n5 + ") WHERE " + string;
        ClassInfos classInfos = null;
        if (this.isCached()) {
            WCMFilter wCMFilter = new WCMFilter("", string, "ClassOrder desc");
            classInfos = ClassInfos.openWCMObjs(null, wCMFilter);
        }
        DBManager.getDBManager().sqlExecuteUpdate(string2);
        if (this.isCached() && classInfos != null) {
            for (int i = 0; i < classInfos.size(); ++i) {
                ClassInfo classInfo = (ClassInfo)classInfos.getAt(i);
                if (classInfo == null) continue;
                classInfo.refreshProperty("ClassOrder", classInfo.getOrder() + n5);
            }
        }
        this.setOrder(n2);
    }

    private int getMaxOrder() throws WCMException {
        int n = this.getNewParentId();
        return DBManager.getDBManager().sqlExecuteIntQuery("select max(ClassOrder) from XWCMCLASSINFO where ParentId=?", new int[]{n});
    }

    public static int getMaxOrder(int n) throws WCMException {
        return DBManager.getDBManager().sqlExecuteIntQuery("select max(ClassOrder) from XWCMCLASSINFO where ParentId=?", new int[]{n});
    }

    private int getNewParentId() {
        int n = this.getParentId();
        if (this.isChangeProperty("PARENTID")) {
            n = this.getNewPropertyAsInt("PARENTID", 0);
        }
        return n;
    }

    public static final ClassInfo findById(int n) throws WCMException {
        if (n <= 0) {
            return null;
        }
        return (ClassInfo)BaseObj.findById(ClassInfo.class, n);
    }

    public static final ClassInfo createNewInstance() throws WCMException {
        return (ClassInfo)BaseObj.createNewInstance(ClassInfo.class);
    }

    public static final ClassInfo findByKey(Object object) throws WCMException {
        return (ClassInfo)BaseObj.findByKey(ClassInfo.class, object);
    }

    public String toString() {
        return this.getName() + "[ID=" + this.getId() + "]";
    }

    public ClassInfos getChildren() throws WCMException {
        return this.getChildren(false);
    }

    public ClassInfos getChildren(boolean bl) throws WCMException {
        IClassInfoCacheMgr iClassInfoCacheMgr = (IClassInfoCacheMgr)DreamFactory.createObjectById("IClassInfoCacheMgr");
        return iClassInfoCacheMgr.getChildren(this.getId(), bl);
    }

    public static ClassInfos findRootClassInfos() throws WCMException {
        return ClassInfo.findRootClassInfos(false);
    }

    public static ClassInfos findRootClassInfos(boolean bl) throws WCMException {
        IClassInfoCacheMgr iClassInfoCacheMgr = (IClassInfoCacheMgr)DreamFactory.createObjectById("IClassInfoCacheMgr");
        return iClassInfoCacheMgr.getChildren(0, bl);
    }

    public static ClassInfo findByName(String string) throws WCMException {
        if (CMyString.isEmpty(string)) {
            return null;
        }
        IClassInfoCacheMgr iClassInfoCacheMgr = (IClassInfoCacheMgr)DreamFactory.createObjectById("IClassInfoCacheMgr");
        ClassInfo classInfo = iClassInfoCacheMgr.findClassInfoByName(string);
        if (classInfo != null) {
            return classInfo;
        }
        WCMFilter wCMFilter = new WCMFilter("", "CName=?", "");
        wCMFilter.setMaxRowNumber(1);
        wCMFilter.addSearchValues(string);
        ClassInfos classInfos = ClassInfos.openWCMObjs(null, wCMFilter);
        if (classInfos.isEmpty()) {
            return null;
        }
        return (ClassInfo)classInfos.getAt(0);
    }
}

