/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.center.xml;

import com.trs.DreamFactory;
import com.trs.cms.content.CMSObj;
import com.trs.cms.content.HTMLContent;
import com.trs.components.metadata.center.MetaViewData;
import com.trs.components.metadata.center.xml.MetaViewDataToXML;
import com.trs.components.metadata.definition.IMetaDataDefCacheMgr;
import com.trs.components.metadata.definition.MetaView;
import com.trs.components.metadata.definition.MetaViewField;
import com.trs.components.wcm.content.domain.AppendixMgr;
import com.trs.components.wcm.content.persistent.Appendix;
import com.trs.components.wcm.content.persistent.Appendixes;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.BaseObjToXmlConverterForSpecialProperty;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.persistent.ObjToXmlConverter;
import com.trs.infra.util.CMyString;
import com.trs.webframework.xmlserver.ConvertException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class MetaViewDataToExcel
extends BaseObjToXmlConverterForSpecialProperty {
    private static Logger logger = Logger.getLogger(MetaViewDataToXML.class);
    private IMetaDataDefCacheMgr m_oCacheMgr = (IMetaDataDefCacheMgr)DreamFactory.createObjectById("IMetaDataDefCacheMgr");
    private MetaView m_oView = null;
    private ArrayList m_arAppFiles = new ArrayList();
    private Map m_FieldMap = new HashMap();

    public MetaViewDataToExcel(MetaView metaView) {
        this.m_oView = metaView;
    }

    public ArrayList getAppFiles() {
        return this.m_arAppFiles;
    }

    protected void registerHostSpecialProperties() {
        try {
            int n = 1;
            HashMap hashMap = this.m_oCacheMgr.getMetaViewFields(this.m_oView.getId());
            for (Map.Entry entry : hashMap.entrySet()) {
                MetaViewField metaViewField = (MetaViewField)entry.getValue();
                this.registerHostSpecialProperty(metaViewField.getName(), n++, metaViewField.getAnotherName());
                this.m_FieldMap.put(metaViewField.getName().toUpperCase(), metaViewField.getAnotherName());
            }
        }
        catch (WCMException wCMException) {
            wCMException.printStackTrace();
        }
    }

    protected String[][] getSpecialProperty(BaseObj baseObj, int n, String string, Object object) throws ConvertException {
        CMSObj cMSObj;
        try {
            cMSObj = this.m_oCacheMgr.getMetaViewField(this.m_oView.getId(), string);
            if (cMSObj == null) {
                return null;
            }
            switch (((MetaViewField)cMSObj).getType()) {
                case 8: {
                    this.m_arAppFiles.add(object.toString());
                    break;
                }
                case 12: 
                case 16: {
                    HTMLContent hTMLContent = new HTMLContent(object.toString());
                    this.m_arAppFiles.addAll(hTMLContent.getWCMFiles());
                    break;
                }
            }
        }
        catch (Exception exception) {
            logger.error((Object)"Exception to record files!", (Throwable)exception);
        }
        try {
            cMSObj = (MetaViewData)baseObj;
            return new String[][]{{CMyString.showNull(cMSObj.getPropertyAsString(string), "")}};
        }
        catch (Exception exception) {
            throw new ConvertException(I18NMessage.get(MetaViewDataToExcel.class, "MetaViewDataToExcel.label1", "\u8f6c\u6362[") + string + I18NMessage.get(MetaViewDataToExcel.class, "MetaViewDataToExcel.label2", "]\u5c5e\u6027\u5931\u8d25\uff01"), exception);
        }
    }

    protected Element[] getChildElement(BaseObj baseObj) throws WCMException {
        MetaViewData metaViewData = (MetaViewData)baseObj;
        Document document = Document.findById(metaViewData.getMetaDataId());
        if (document == null) {
            logger.error((Object)(I18NMessage.get(MetaViewDataToExcel.class, "MetaViewDataToExcel.label3", "\u6570\u636e\u53ef\u80fd\u6709\u8bef\uff0c\u6240\u5c5e\u6587\u6863\u4e0d\u5b58\u5728\uff01[ID=") + metaViewData.getMetaDataId() + "]"));
            return null;
        }
        AppendixMgr appendixMgr = (AppendixMgr)DreamFactory.createObjectById("AppendixMgr");
        Appendixes appendixes = appendixMgr.getAppendixes(document, -1);
        if (appendixes == null || appendixes.size() <= 0) {
            return null;
        }
        appendixes.setMaxBufferSize(appendixes.size());
        int n = appendixes.size();
        for (int i = 0; i < n; ++i) {
            Appendix appendix = (Appendix)appendixes.getAt(i);
            if (appendix == null || appendix.getFlag() == 40) continue;
            this.m_arAppFiles.add(appendix.getFile());
        }
        ObjToXmlConverter objToXmlConverter = new ObjToXmlConverter();
        return new Element[]{objToXmlConverter.toXmlElement(appendixes, null)};
    }

    public Element toXmlElement(BaseObjs baseObjs, String string) throws WCMException {
        int n;
        Element element = super.toXmlElement(baseObjs, string);
        if (baseObjs != null && baseObjs.size() >= 2) {
            return element;
        }
        BaseObj baseObj = null;
        for (n = 0; n < baseObjs.size() && (baseObj = baseObjs.getAt(n)) == null; ++n) {
        }
        if (baseObj == null) {
            return element;
        }
        for (n = 0; n < 2; ++n) {
            element.add(this.appendBlankRecord(baseObj, string));
        }
        return element;
    }

    private Element appendBlankRecord(BaseObj baseObj, String string) throws WCMException {
        StringTokenizer stringTokenizer = null;
        String string2 = null;
        Hashtable hashtable = baseObj.getAllProperty();
        Element element = DocumentHelper.createElement((String)this.getElementTag(baseObj));
        Element element2 = element.addElement("PROPERTIES");
        Element element3 = null;
        String string3 = string;
        if (string3 == null || string3.trim().length() == 0) {
            string3 = this.getFieldList(baseObj);
        }
        stringTokenizer = string3 != null && string3.trim().length() > 0 ? new StringTokenizer(string3.toUpperCase(), ",") : hashtable.keys();
        while (stringTokenizer.hasMoreElements()) {
            try {
                string2 = ((String)stringTokenizer.nextElement()).trim();
                String string4 = (String)this.m_FieldMap.get(string2);
                if (string4 == null) {
                    string4 = string2;
                }
                element3 = element2.addElement(string4);
                element3.setText("");
            }
            catch (Throwable throwable) {
                throw new WCMException(I18NMessage.get(MetaViewDataToExcel.class, "MetaViewDataToExcel.label4", "\u5904\u7406[") + string2 + I18NMessage.get(MetaViewDataToExcel.class, "MetaViewDataToExcel.label5", "]\u5b57\u6bb5\u5931\u8d25!"), throwable);
            }
        }
        return element;
    }

    public String getElementTag(BaseObj baseObj) {
        return "MetaViewData";
    }

    public String getElementTag(BaseObjs baseObjs) {
        return "MetaDataS";
    }

    public boolean isAddVersion() {
        return false;
    }
}

