/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.center;

import com.trs.cms.auth.persistent.User;
import com.trs.components.metadata.center.IMetaViewEmployerMgr;
import com.trs.components.metadata.center.MetaViewEmployer;
import com.trs.components.metadata.definition.MetaView;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;

public class MetaViewEmployerMgr
implements IMetaViewEmployerMgr {
    private static final String SQL_CLEAR_BY_CHANNEL = "delete from XWCMMetaViewEmployer where ChannelId=?";
    private static final String SQL_CLEAR_BY_VIEW = "delete from XWCMMetaViewEmployer where ViewId=?";
    private static final String SQL_QUERY_CHANNELS = "exists(select XWCMMetaViewEmployer.ChannelId from XWCMMetaViewEmployer where XWCMMetaViewEmployer.ViewId=? and XWCMMetaViewEmployer.ChannelId=WCMChannel.ChannelId)";
    private static final String SQL_QUERY_VIEWID = "select ViewId from XWCMMetaViewEmployer where XWCMMetaViewEmployer.ChannelId=?";
    private static final String SQL_UPDATE_EMPLOYER = "update XWCMMetaViewEmployer set ViewId=? where ChannelId=?";

    public void clearEmployer(User user, Channel channel) throws WCMException {
        DBManager.getDBManager().sqlExecuteUpdate(new String[]{SQL_CLEAR_BY_CHANNEL}, new int[]{channel.getId()});
        this.clearChannelViewProperties(user, channel);
    }

    private void clearChannelViewProperties(User user, Channel channel) throws WCMException {
        channel.validCanDeleteAndLock(user);
        String string = "../document/";
        channel.setProperty("ContentListPage", string + "document_list_of_channel.jsp");
        channel.setProperty("ContentAddEditPage", string + "document_addedit.jsp");
        channel.setProperty("ContentShowPage", string + "document_show.jsp");
        channel.update(user);
    }

    public void clearEmployer(User user, MetaView metaView) throws WCMException {
        Channels channels = this.getEmployers(metaView, null);
        DBManager.getDBManager().sqlExecuteUpdate(new String[]{SQL_CLEAR_BY_VIEW}, new int[]{metaView.getId()});
        int n = channels.size();
        for (int i = 0; i < n; ++i) {
            Channel channel = (Channel)channels.getAt(i);
            if (channel == null) continue;
            this.clearChannelViewProperties(user, channel);
        }
    }

    public Channels getEmployers(MetaView metaView, WCMFilter wCMFilter) throws WCMException {
        WCMFilter wCMFilter2 = new WCMFilter("WCMChannel", SQL_QUERY_CHANNELS, "");
        wCMFilter2.addSearchValues(metaView.getId());
        wCMFilter2.mergeWith(wCMFilter);
        return Channels.openWCMObjs(null, wCMFilter2);
    }

    public MetaView getViewOfEmployer(Channel channel) throws WCMException {
        int n = DBManager.getDBManager().sqlExecuteIntQuery(SQL_QUERY_VIEWID, new int[]{channel.getId()});
        return MetaView.findById(n);
    }

    public void setEmployer(User user, Channel channel, MetaView metaView) throws WCMException {
        Object object;
        int n = DBManager.getDBManager().sqlExecuteIntQuery(SQL_QUERY_VIEWID, new int[]{channel.getId()});
        if (n == metaView.getId()) {
            return;
        }
        if (n <= 0) {
            object = new MetaViewEmployer();
            ((BaseObj)object).setProperty("ChannelId", channel.getId());
            ((BaseObj)object).setProperty("ViewId", metaView.getId());
            ((BaseObj)object).save();
        } else {
            DBManager.getDBManager().sqlExecuteUpdate(new String[]{SQL_UPDATE_EMPLOYER}, new int[]{metaView.getId(), channel.getId()});
        }
        object = "../application/" + metaView.getId() + "/";
        channel.validCanDeleteAndLock(user);
        channel.setProperty("ContentListPage", (String)object + "metaviewdata_list.html");
        channel.setProperty("ContentAddEditPage", (String)object + "metaviewdata_addedit.jsp");
        channel.setProperty("ContentShowPage", (String)object + "viewdata_detail.jsp");
        channel.update(user);
    }
}

