/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.filter;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.filter.IQueryFilter;
import com.trs.components.filter.QueryFilterFactory;
import com.trs.components.metadata.service.DefaultChannelMakerCenter;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.content.persistent.WebSites;
import com.trs.components.wcm.publish.IFolderPubStatusCacheMgr;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;
import com.trs.webframework.context.MethodContext;

class PublishQueryFilter
implements IQueryFilter {
    public static final int FILTER_TYPE = 2;

    PublishQueryFilter() {
    }

    private WebSite makeWebSite(MethodContext methodContext) throws WCMException {
        User user = ContextHelper.getLoginUser();
        int n = methodContext.getValue("SiteID", 0);
        if (n != 0) {
            return WebSite.findById(n);
        }
        String string = methodContext.getValue("SiteIds");
        if (!CMyString.isEmpty(string)) {
            WebSites webSites = WebSites.findByIds(user, string);
            int n2 = webSites.size();
            for (int i = 0; i < n2; ++i) {
                WebSite webSite = (WebSite)webSites.getAt(i);
                if (webSite == null) continue;
                return webSite;
            }
            return null;
        }
        int n3 = methodContext.getValue("ChannelId", 0);
        if (n3 != 0) {
            Channel channel = Channel.findById(n3);
            return channel.getSite();
        }
        String string2 = methodContext.getValue("ChannelIds");
        if (!CMyString.isEmpty(string2)) {
            Channels channels = Channels.findByIds(user, string2);
            int n4 = channels.size();
            for (int i = 0; i < n4; ++i) {
                Channel channel = (Channel)channels.getAt(i);
                if (channel == null) continue;
                return channel.getSite();
            }
            return null;
        }
        int n5 = methodContext.getValue("ViewId", 0);
        Channel channel = DefaultChannelMakerCenter.getInstance().makeDefaultChannel(user, n5);
        if (channel != null) {
            return channel.getSite();
        }
        Channels channels = DefaultChannelMakerCenter.getInstance().getAvailableChannels(user, n5);
        int n6 = channels.size();
        for (int i = 0; i < n6; ++i) {
            channel = (Channel)channels.getAt(i);
            if (channel == null) continue;
            return channel.getSite();
        }
        return null;
    }

    public WCMFilter getFilter(MethodContext methodContext) throws WCMException {
        WebSite webSite = this.makeWebSite(methodContext);
        if (webSite == null) {
            throw new WCMException(I18NMessage.get(QueryFilterFactory.class, "QueryFilterFactory.label5", "\u65e0\u6cd5\u83b7\u53d6\u5f53\u524d\u7684\u4e0a\u4e0b\u6587ChannelId/SiteId"));
        }
        IFolderPubStatusCacheMgr iFolderPubStatusCacheMgr = (IFolderPubStatusCacheMgr)DreamFactory.createObjectById("IFolderPubStatusCacheMgr");
        int[] nArray = iFolderPubStatusCacheMgr.findStatusesCanDoIncreasePub(webSite.getWCMType(), webSite.getId());
        String string = null;
        WCMFilter wCMFilter = new WCMFilter();
        if (nArray == null) {
            nArray = new int[]{-1};
        }
        for (int i = 0; i < nArray.length; ++i) {
            string = string == null ? "WCMChnlDoc.DocStatus in(?" : string + ",?";
            wCMFilter.addSearchValues(i, nArray[i]);
        }
        string = string != null ? string + ")" : "WCMChnlDoc.DocStatus in(1,2,16,18)";
        wCMFilter.setWhere(string);
        return wCMFilter;
    }
}

