/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.widget.tagparser;

import com.trs.DreamFactory;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.domain.IObjectMemberMgr;
import com.trs.cms.auth.persistent.RightValue;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.BaseTagParser;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfo;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfoHelper;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.components.common.publish.domain.tagparser.TagParseHelper;
import com.trs.components.common.publish.domain.tagparser.TagParserCMSObjBase;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.NamesRegister;
import com.trs.infra.util.database.CDBText;

public abstract class WCMTagParserBaseOperation
extends BaseTagParser {
    protected TagItem m_tagItem;
    protected CMSObj m_host = null;
    private static NamesRegister m_hostSpecialAttributesRegister = new NamesRegister();
    private static final String sPreLoadAttribute = "RightValue";
    private static final RightValue ADMIN_RIGHTVALUE = RightValue.getAdministratorRightValue();
    private static final String NO_VALUE = "0";

    public String[] parse(PublishTagContext publishTagContext) throws WCMException {
        String string = publishTagContext.getPageContext().getExtraAttribute("_ParseMode_");
        if (!"EDIT".equals(string)) {
            String[] stringArray = TagParseHelper.parseItems(publishTagContext.getTagItem().getChildren(), publishTagContext);
            return stringArray;
        }
        this.m_host = this.findHost(publishTagContext);
        if (this.m_host == null) {
            return null;
        }
        try {
            this.m_tagItem = publishTagContext.getTagItem();
            String string2 = publishTagContext.getAttribute("ATTRIBUTES");
            if (string2 == null || (string2 = string2.trim()).length() == 0) {
                string2 = this.getDefaultField();
            }
            string2 = string2 == null || (string2 = string2.trim()).length() == 0 ? sPreLoadAttribute : string2 + ",RightValue";
            string2 = string2.toUpperCase();
            int n = 0;
            int n2 = string2.split(",").length;
            String string3 = "<div ";
            String string4 = CMyString.showNull(publishTagContext.getAttribute("extraCls"));
            string3 = string3 + "class=\"trs-data-oper " + string4 + "\" ";
            string3 = this.appendDefaultAttribute(string3, this.m_host, this.m_tagItem);
            for (int i = 0; i < n2; ++i) {
                String string5 = string2.split(",")[i];
                n = this.lookupHostSpecialAttributeId(string5);
                string3 = n > 0 ? this.appendAttribute(string3, string5, this.parseHostSpecialProperty(n, publishTagContext)) : this.appendAttribute(string3, string5, this.parseHostNormalProperty(string5, publishTagContext));
            }
            string3 = string3 + ">" + TagParseHelper.parseItems(publishTagContext.getTagItem().getChildren(), publishTagContext)[0] + "</div>";
            return new String[]{string3};
        }
        catch (Exception exception) {
            throw new WCMException(234, I18NMessage.get(TagParserCMSObjBase.class, "TagParserCMSObjBase.label1", "\u89e3\u6790\u7ec6\u89c8\u7f6e\u6807\u5931\u8d25\uff01\u7f6e\u6807\u5185\u5bb9\u4e3a: ") + this.m_tagItem.toString(), exception);
        }
    }

    private String appendDefaultAttribute(String string, CMSObj cMSObj, TagItem tagItem) {
        int n = tagItem.getName().toUpperCase().indexOf("OPERATION");
        String string2 = tagItem.getName().substring(4, n);
        string = string + "OperTYpe=\"" + string2 + "\"";
        string = string + " ObjId=\"" + cMSObj.getId() + "\"";
        string = string + " ObjType=\"" + cMSObj.getWCMType() + "\"";
        return string;
    }

    private String appendAttribute(String string, String string2, String string3) {
        string = string + " " + string2 + "=\"" + CMyString.filterForHTMLValue(string3) + "\"";
        return string;
    }

    protected String parseHostNormalProperty(String string, PublishTagContext publishTagContext) throws WCMException {
        Object object = string.charAt(0) == '#' ? this.m_host.getAttributeValue(string.substring(1)) : this.m_host.getProperty(string);
        if (object == null) {
            return null;
        }
        return this.parseProperty(object, publishTagContext);
    }

    protected String parseProperty(Object object, PublishTagContext publishTagContext) throws WCMException {
        int n;
        String string;
        Object object2;
        if (object instanceof CMyDateTime) {
            object2 = (CMyDateTime)object;
            String string2 = publishTagContext.getAttribute("LOCALE");
            String string3 = publishTagContext.getAttribute("TIMEZONE");
            String string4 = this.getDateFormat(publishTagContext);
            string = ((CMyDateTime)object2).toString(string4, string2, string3);
        } else {
            string = object instanceof String ? (String)object : object.toString();
        }
        if (string == null) {
            return null;
        }
        object2 = null;
        object2 = TagParseHelper.truncateTextIfNeeded(publishTagContext, string);
        object2 = TagParseHelper.formatTextIfNeeded(publishTagContext, (String)object2);
        object2 = TagParseHelper.addSpanStyleIfNeeded(publishTagContext, (String)object2);
        if (object instanceof CDBText && (n = publishTagContext.getAttribute("NUM", 0)) == 0) {
            if (publishTagContext.getPageElement() instanceof IPublishContent) {
                return "";
            }
            return object2;
        }
        if (publishTagContext.getAttribute("ISHTMLCONTENT", false)) {
            return "";
        }
        return object2;
    }

    protected String getDateFormat(PublishTagContext publishTagContext) {
        String string = publishTagContext.getAttribute("DATEFORMAT");
        if (string == null || (string = string.trim()).length() == 0) {
            string = "yyyy-MM-dd HH:mm:ss";
        }
        return TagParseHelper.parseDateFormat(string);
    }

    protected CMSObj findHost(PublishTagContext publishTagContext) throws WCMException {
        IPublishElement iPublishElement = publishTagContext.getUpperHost();
        if (iPublishElement == null) {
            throw new WCMException(234, "Upper host object required in tag context!");
        }
        return iPublishElement.getSubstance();
    }

    protected void registerHostSpecialAttribute(String string, int n) {
        String string2 = this.m_tagItem.getName() + '.' + string;
        m_hostSpecialAttributesRegister.register(string2, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int lookupHostSpecialAttributeId(String string) {
        String string2 = this.m_tagItem.getName() + '.';
        if (!m_hostSpecialAttributesRegister.contains(string2)) {
            NamesRegister namesRegister = m_hostSpecialAttributesRegister;
            synchronized (namesRegister) {
                if (!m_hostSpecialAttributesRegister.contains(string2)) {
                    this.registerHostSpecialAttributes();
                    m_hostSpecialAttributesRegister.register(string2, 0);
                }
            }
        }
        return m_hostSpecialAttributesRegister.lookup(string2 + string, -1);
    }

    protected abstract void registerHostSpecialAttributes();

    protected abstract String parseHostSpecialProperty(int var1, PublishTagContext var2) throws WCMException;

    protected String getDefaultField() {
        return null;
    }

    public RightValue getChannelRightValue(User user, BaseChannel baseChannel) throws WCMException {
        RightValue rightValue = new RightValue();
        IObjectMemberMgr iObjectMemberMgr = (IObjectMemberMgr)DreamFactory.createObjectById("IObjectMemberMgr");
        if (user.isAdministrator() || user.getName().equals(baseChannel.getCrUserName())) {
            return ADMIN_RIGHTVALUE;
        }
        if (iObjectMemberMgr.canOperate(user, baseChannel.getWCMType(), baseChannel.getId())) {
            rightValue = AuthServer.getRightValue((CMSObj)baseChannel, user);
        } else {
            new RightValue(NO_VALUE);
        }
        return rightValue;
    }

    public BaseChannel getDefaultChannel() throws WCMException {
        String string = ConfigServer.getServer().getSysConfigValue("SPECIAL_DEFAULT_CHANNELID", NO_VALUE);
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Channel.findById(n);
    }

    public class TBI
    extends TagBeanInfo {
        public void checkSemantic(IPublishFolder iPublishFolder, TagItem tagItem, StringBuffer stringBuffer) {
            TagBeanInfoHelper.checkChannelName(iPublishFolder, tagItem, stringBuffer);
        }
    }
}

