/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.widget;

import com.trs.DreamFactory;
import com.trs.ajaxservice.TemplateServiceProvider;
import com.trs.ajaxservice.WCMAJAXServiceHelper;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.domain.publisher.PublishPathCompass;
import com.trs.components.common.publish.domain.tagparser.TagParseHelper;
import com.trs.components.common.publish.domain.template.TemplateMgr;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.common.publish.widget.IVisualTemplateServiceProvider;
import com.trs.components.common.publish.widget.IWidgetInstParameterMgr;
import com.trs.components.common.publish.widget.IWidgetInstanceMgr;
import com.trs.components.common.publish.widget.IWidgetServer;
import com.trs.components.common.publish.widget.Master;
import com.trs.components.common.publish.widget.WidgetInstParameters;
import com.trs.components.common.publish.widget.WidgetInstance;
import com.trs.components.common.publish.widget.WidgetInstances;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.publish.WCMFolderPublishConfig;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.Reports;
import com.trs.webframework.context.MethodContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VisualTemplateServiceProvider
implements IVisualTemplateServiceProvider {
    private TemplateMgr m_oTemplateMgr = null;
    private List m_oWidgetList = new ArrayList();
    IWidgetServer m_oWidgetServer = (IWidgetServer)DreamFactory.createObjectById("IWidgetServer");
    IWidgetInstanceMgr m_oWidgetInstanceMgr;
    IWidgetInstParameterMgr m_oWidgetInstParameterMgr = (IWidgetInstParameterMgr)DreamFactory.createObjectById("IWidgetInstParameterMgr");

    public VisualTemplateServiceProvider() {
        this.m_oWidgetInstanceMgr = (IWidgetInstanceMgr)DreamFactory.createObjectById("IWidgetInstanceMgr");
        this.m_oTemplateMgr = (TemplateMgr)DreamFactory.createObjectById("TemplateMgr");
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    public String parseTemplate(MethodContext methodContext) throws Throwable {
        int n = methodContext.getValue("objectId", 0);
        int n2 = methodContext.getValue("objectType", 0);
        IPublishElement iPublishElement = PublishElementFactory.lookupElement(n2, n);
        int n3 = methodContext.getValue("TemplateId", 0);
        Template template = Template.findById(n3);
        return this.m_oWidgetServer.parseToEditContent(iPublishElement, template);
    }

    public String parseWidgetInstance(MethodContext methodContext) throws Throwable {
        int n = methodContext.getValue("objectId", 0);
        int n2 = methodContext.getValue("objectType", 0);
        IPublishElement iPublishElement = PublishElementFactory.lookupElement(n2, n);
        int n3 = methodContext.getValue("WidgetInstanceId", 0);
        WidgetInstance widgetInstance = WidgetInstance.findById(n3);
        return this.m_oWidgetServer.parseToEditContent(iPublishElement, widgetInstance);
    }

    public int saveToTemplate(MethodContext methodContext) throws Throwable {
        int n = methodContext.getValue("templateId", 0);
        String string = methodContext.getValue("html");
        String string2 = this.m_oWidgetServer.parseToTemplate(string);
        Template template = Template.findById(n);
        template.setText(string2);
        this.m_oTemplateMgr.save(template, null, true, 2);
        return n;
    }

    public void synchronizeWidgetInstances(MethodContext methodContext) throws WCMException {
        int n = methodContext.getValue("templateId", 0);
        Template template = Template.findById(n);
        if (template == null) {
            throw new WCMException("\u6ca1\u6709\u83b7\u53d6\u5230\u6709\u6548\u7684\u6a21\u677f[id=" + n + "]");
        }
        this.m_oWidgetServer.synchronizeWidgetInstances(template);
    }

    public void syncWidgetInstancesToChildChnl(MethodContext methodContext) throws WCMException {
        int n = methodContext.getValue("ChnlId", 0);
        int n2 = methodContext.getValue("WidgetInstanceId", 0);
        Channel channel = Channel.findById(n);
        if (channel == null) {
            throw new WCMException("\u6ca1\u6709\u83b7\u53d6\u5230\u680f\u76ee[id=" + n + "]");
        }
        this.m_oWidgetList.clear();
        List list = channel.getChildren(ContextHelper.getLoginUser());
        for (int i = 0; i < list.size(); ++i) {
            this.syncWidgetInstanceToChnl(WidgetInstance.findById(n2), (Channel)list.get(i));
        }
    }

    private void syncWidgetInstanceToChnl(WidgetInstance widgetInstance, Channel channel) throws WCMException {
        if (widgetInstance == null || channel == null) {
            return;
        }
        IPublishFolder iPublishFolder = (IPublishFolder)PublishElementFactory.makeElementFrom(channel);
        WCMFolderPublishConfig wCMFolderPublishConfig = new WCMFolderPublishConfig(iPublishFolder);
        String string = wCMFolderPublishConfig.getOutlineTemplateIds();
        int n = wCMFolderPublishConfig.getDetailTemplateId();
        if (CMyString.isEmpty(string)) {
            return;
        }
        String string2 = string + "," + n;
        String string3 = "TEMPLATEID in(" + string2 + ") and WIDGETID=" + widgetInstance.getWidgetId();
        WCMFilter wCMFilter = new WCMFilter("", string3, "");
        WidgetInstances widgetInstances = WidgetInstances.openWCMObjs(null, wCMFilter);
        for (int i = widgetInstances.size() - 1; i >= 0; --i) {
            if (this.m_oWidgetList.contains(new Integer(widgetInstances.getAt(i).getId()))) continue;
            this.syncWidgetInstanceToInstance(widgetInstance, (WidgetInstance)widgetInstances.getAt(i));
            this.m_oWidgetList.add(new Integer(widgetInstances.getAt(i).getId()));
        }
    }

    private void syncWidgetInstanceToInstance(WidgetInstance widgetInstance, WidgetInstance widgetInstance2) throws WCMException {
        if (widgetInstance == null || widgetInstance2 == null || widgetInstance.getWidgetId() != widgetInstance2.getWidgetId()) {
            return;
        }
        this.m_oWidgetInstParameterMgr.saveParameters(widgetInstance2, this.m_oWidgetInstParameterMgr.getParameters(widgetInstance));
        this.m_oWidgetServer.refreshWidgetForTemplate(widgetInstance2);
    }

    public String preview(MethodContext methodContext) throws Exception {
        int n = methodContext.getValue("objectId", 0);
        int n2 = methodContext.getValue("objectType", 0);
        IPublishElement iPublishElement = PublishElementFactory.lookupElement(n2, n);
        String string = methodContext.getValue("html");
        String string2 = this.m_oWidgetServer.parseToTemplate(string);
        String[] stringArray = TagParseHelper.parseContent(iPublishElement, string2);
        String string3 = "";
        if (stringArray != null && stringArray.length > 0) {
            string3 = stringArray[0];
        }
        String string4 = "visualTemplate_preview_tempFile.html";
        PublishPathCompass publishPathCompass = new PublishPathCompass();
        String string5 = publishPathCompass.getPreviewLocalPath(iPublishElement) + string4;
        CMyFile.writeFile(string5, string3, "UTF-8");
        return publishPathCompass.getPreviewHttpPath(iPublishElement) + string4;
    }

    public int saveWidgetInstance(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        int n = methodContext.getValue("WIDGETINSTANCEID", 0);
        WidgetInstance widgetInstance = null;
        widgetInstance = n > 0 ? WidgetInstance.findById(n) : new WidgetInstance();
        String[] stringArray = new String[]{"WIDGETINSTANCEID"};
        widgetInstance = (WidgetInstance)WCMAJAXServiceHelper.setWCMObjectProperties(user, methodContext, widgetInstance, stringArray);
        WidgetInstance widgetInstance2 = this.m_oWidgetInstanceMgr.save(user, widgetInstance);
        return widgetInstance2.getId();
    }

    public int saveWidgetInstParameters(MethodContext methodContext) throws Throwable {
        int n = methodContext.getValue("widgetInstanceId", 0);
        boolean bl = methodContext.getValue("bAdd", true);
        WidgetInstance widgetInstance = WidgetInstance.findById(n);
        if (widgetInstance == null) {
            throw new WCMException(200006, "\u6ca1\u6709\u4f20\u5165\u6709\u6548\u7684widgetInstanceId");
        }
        Map map = new HashMap();
        map = methodContext.getParams();
        WidgetInstParameters widgetInstParameters = null;
        widgetInstParameters = bl ? this.m_oWidgetInstParameterMgr.addParameters(widgetInstance, map) : this.m_oWidgetInstParameterMgr.saveParameters(widgetInstance, map);
        return widgetInstParameters.size();
    }

    public int save(MethodContext methodContext) throws Throwable {
        String[] stringArray;
        int n;
        User user = this.getLoginUser();
        int n2 = methodContext.getObjectId();
        int n3 = methodContext.getValue("MasterId", 0);
        int n4 = methodContext.getValue("TEMPTYPE", 0);
        Template template = null;
        IPublishFolder iPublishFolder = this.findPublishFolder(methodContext);
        if (n2 == 0) {
            this.validateRight(user, iPublishFolder, 21, "\u65b0\u5efa\u6a21\u677f");
        } else {
            template = Template.findById(n2);
            if (template == null) {
                throw new WCMException("\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u6a21\u677f\u3010ID=" + n2 + "\u3011\uff01");
            }
            iPublishFolder = template.getFolder();
            this.validateRight(user, iPublishFolder, 21, "\u4fee\u6539\u6a21\u677f");
        }
        int n5 = n = n4 == 2 ? 3 : 1;
        if (n2 == 0) {
            if (n3 == 0) {
                throw new WCMException("\u60a8\u5fc5\u987b\u4f20\u5165\u53c2\u6570\u6bcd\u7248\u7684Id\u624d\u80fd\u8fdb\u884c\u53ef\u89c6\u5316\u6a21\u677f\u7684\u4fdd\u5b58\uff01");
            }
            stringArray = Master.findById(n3);
            if (stringArray == null) {
                throw new WCMException("\u6ca1\u6709\u83b7\u53d6\u5230\u6709\u6548\u7684\u6bcd\u7248\u3010ID=" + n3 + "\u3011\u5bf9\u8c61\uff01");
            }
            IWidgetServer iWidgetServer = (IWidgetServer)DreamFactory.createObjectById("IWidgetServer");
            template = iWidgetServer.createTemplateFromMaster(iPublishFolder, (Master)stringArray, n);
        }
        stringArray = new String[]{"ObjectId", "HostType", "HostId"};
        template = (Template)WCMAJAXServiceHelper.setWCMObjectProperties(user, methodContext, template, stringArray);
        template.save(user);
        return template.getId();
    }

    public void deleteWidgetInstance(MethodContext methodContext) throws Throwable {
    }

    public void delete(MethodContext methodContext) throws Throwable {
    }

    public Object query(MethodContext methodContext) throws Throwable {
        return null;
    }

    public Object findById(MethodContext methodContext) throws Throwable {
        return null;
    }

    public Object findByIds(MethodContext methodContext) throws Throwable {
        return null;
    }

    private IPublishFolder findPublishFolder(MethodContext methodContext) throws WCMException {
        return this.findPublishFolder(methodContext, null);
    }

    private IPublishFolder findPublishFolder(MethodContext methodContext, String string) throws WCMException {
        String string2 = string == null ? "Host" : string;
        int n = methodContext.getValue(string2 + "Type", 0);
        if (n == 0) {
            throw new WCMException(1101, I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label36", "\u6ca1\u6709\u6307\u5b9a[") + string2 + "Type]!");
        }
        int n2 = methodContext.getValue(string2 + "Id", 0);
        if (n2 == 0) {
            throw new WCMException(1101, I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label36", "\u6ca1\u6709\u6307\u5b9a[") + string2 + "Id]!");
        }
        IPublishElement iPublishElement = PublishElementFactory.lookupElement(n, n2);
        if (iPublishElement == null) {
            throw new WCMException(200006, I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label37", "\u6307\u5b9a\u7684\u5bf9\u8c61\u4e0d\u5b58\u5728\uff01(Type=") + n + ", Id=" + n2 + ")");
        }
        if (!(iPublishElement instanceof IPublishFolder)) {
            throw new WCMException(10, I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label38", "\u6307\u5b9a\u7684\u5bf9\u8c61(") + iPublishElement.getInfo() + I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label39", ")\u4e0d\u662fFolder!"));
        }
        return (IPublishFolder)iPublishElement;
    }

    private void validateRight(User user, IPublishFolder iPublishFolder, int n, String string) throws WCMException {
        if (AuthServer.hasRight(user, iPublishFolder.getSubstance(), n)) {
            return;
        }
        IPublishFolder iPublishFolder2 = iPublishFolder.getParent();
        if (iPublishFolder2 == null || iPublishFolder2 == iPublishFolder) {
            throw new WCMException("\u5bf9\u4e0d\u8d77\uff0c\u60a8[" + user.getName() + "]\u6ca1\u6709\u6743\u9650\u6267\u884c " + string + " !");
        }
        this.validateRight(user, iPublishFolder2, n, string);
    }

    public String copyWidgetInstance(MethodContext methodContext) throws Exception {
        int n = methodContext.getValue("objectId", 0);
        WidgetInstance widgetInstance = WidgetInstance.findById(n);
        WidgetInstance widgetInstance2 = (WidgetInstance)widgetInstance.cloneToNewObj();
        widgetInstance2.save(this.getLoginUser());
        Map map = this.m_oWidgetInstParameterMgr.getParameters(widgetInstance);
        this.m_oWidgetInstParameterMgr.addParameters(widgetInstance2, map);
        return String.valueOf(widgetInstance2.getId());
    }

    public Reports copyVisualTemplate(MethodContext methodContext) throws Exception {
        int n;
        String string = methodContext.getValue("ToChannelIds");
        User user = this.getLoginUser();
        if (CMyString.isEmpty(string)) {
            throw new WCMException("\u6ca1\u6709\u6307\u5b9a\u7c7b\u4f3c\u521b\u5efa\u5230\u7684\u680f\u76ee");
        }
        Channels channels = Channels.findByIds(user, string);
        int n2 = methodContext.getValue("TemplateId", 0);
        if (n2 == 0) {
            throw new WCMException("\u6ca1\u6709\u6307\u5b9a\u539f\u6a21\u677f\u7684Id");
        }
        Template template = Template.findById(n2);
        if (template == null) {
            throw new WCMException("\u6ca1\u6709\u627e\u5230\u6307\u5b9aId\u4e3a[" + n2 + "]\u7684\u6a21\u677f");
        }
        Channels channels2 = Channels.createNewInstance(user);
        int n3 = channels.size();
        for (n = n3 - 1; n >= 0; --n) {
            Channel channel = (Channel)channels.getAt(n);
            if (channel == null) continue;
            IPublishElement iPublishElement = PublishElementFactory.lookupElement(101, channel.getId());
            try {
                this.validateRight(user, (IPublishFolder)iPublishElement, 21, "\u65b0\u5efa\u6a21\u677f");
                continue;
            }
            catch (WCMException wCMException) {
                channels2.addElement(channel);
                channels.remove(channel, false);
            }
        }
        Reports reports = this.m_oTemplateMgr.copyVisualTempToChnls(channels, template);
        int n4 = channels2.size();
        for (n = 0; n < n4; ++n) {
            Channel channel = (Channel)channels2.getAt(n);
            if (channel == null) continue;
            reports.addFailedReport("\u5728\u680f\u76ee\u3010" + channel + "\u3011\u4e0b\u7c7b\u4f3c\u521b\u5efa\u6a21\u677f\u5931\u8d25\uff01", new WCMException(1002, "\u7528\u6237\u5728\u680f\u76ee\u3010" + channel + "\u3011\u4e0b\u6ca1\u6709\u65b0\u5efa\u6a21\u677f\u6743\u9650"));
        }
        return reports;
    }
}

