/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.widget;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.widget.BaseStyle;
import com.trs.components.common.publish.widget.IStyleItemMgr;
import com.trs.components.common.publish.widget.PageStyle;
import com.trs.components.common.publish.widget.StyleItem;
import com.trs.components.common.publish.widget.StyleItems;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import java.util.HashMap;

public class StyleItemMgr
implements IStyleItemMgr {
    public void delete(User user, StyleItem styleItem) throws WCMException {
        if (styleItem == null) {
            return;
        }
        if (user == null) {
            user = this.getLoginUser();
        }
        styleItem.delete(user);
    }

    public StyleItems queryStyleItems(BaseStyle baseStyle, WCMFilter wCMFilter) throws WCMException {
        User user = this.getLoginUser();
        if (baseStyle == null) {
            return StyleItems.createNewInstance(user);
        }
        WCMFilter wCMFilter2 = new WCMFilter("", "STYLEOBJTYPE=? and STYLEOBJID=?", "");
        wCMFilter2.addSearchValues(baseStyle.getWCMType());
        wCMFilter2.addSearchValues(baseStyle.getId());
        if (wCMFilter != null) {
            wCMFilter2.mergeWith(wCMFilter);
        }
        return StyleItems.openWCMObjs(user, wCMFilter2);
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    public StyleItems query(WCMFilter wCMFilter) throws WCMException {
        User user = this.getLoginUser();
        return StyleItems.openWCMObjs(user, wCMFilter);
    }

    public StyleItem save(User user, BaseStyle baseStyle, StyleItem styleItem) throws WCMException {
        int n = 0;
        int n2 = 368170809;
        if (baseStyle != null) {
            n = baseStyle.getId();
            n2 = baseStyle.getWCMType();
        }
        styleItem.setStyleObjId(n);
        styleItem.setStyleObjType(n2);
        styleItem.save(user);
        return styleItem;
    }

    public void deleteUnuseStyleItems(BaseStyle baseStyle, String string) throws WCMException {
        if (string == null || string.length() == 0) {
            return;
        }
        if (baseStyle == null) {
            throw new WCMException(20, "\u98ce\u683c\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u53d6\u51fa\u98ce\u683c\u9879\uff01");
        }
        String string2 = "STYLEITEMID not in (" + string + ")";
        WCMFilter wCMFilter = new WCMFilter("", string2, "", "");
        StyleItems styleItems = this.queryStyleItems(baseStyle, wCMFilter);
        for (int i = 0; i < styleItems.size(); ++i) {
            this.delete(this.getLoginUser(), (StyleItem)styleItems.getAt(i));
        }
    }

    public void delete(User user, BaseStyle baseStyle) throws WCMException {
        if (baseStyle == null) {
            return;
        }
        StyleItems styleItems = this.queryStyleItems(baseStyle, null);
        for (int i = 0; i < styleItems.size(); ++i) {
            StyleItem styleItem = (StyleItem)styleItems.getAt(i);
            if (styleItem == null) continue;
            styleItem.delete(user);
        }
    }

    public HashMap queryStyleItemMap(BaseStyle baseStyle, WCMFilter wCMFilter) throws WCMException {
        StyleItems styleItems = this.queryStyleItems(baseStyle, wCMFilter);
        HashMap<String, StyleItem> hashMap = new HashMap<String, StyleItem>();
        for (int i = 0; i < styleItems.size(); ++i) {
            StyleItem styleItem = (StyleItem)styleItems.getAt(i);
            if (styleItem == null) continue;
            hashMap.put(styleItem.getClassName(), styleItem);
        }
        return hashMap;
    }

    public void deleteUnusePageOtherStyleItems(PageStyle pageStyle, String string) throws WCMException {
        if (string == null || string.length() == 0) {
            return;
        }
        if (pageStyle == null) {
            throw new WCMException(20, "\u98ce\u683c\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u53d6\u51fa\u98ce\u683c\u9879\uff01");
        }
        String string2 = "STYLEITEMID not in (" + string + ") and STYLEOBJTYPE=? and STYLEOBJID=?";
        WCMFilter wCMFilter = new WCMFilter("", string2, "", "");
        wCMFilter.addSearchValues(1);
        wCMFilter.addSearchValues(pageStyle.getId());
        StyleItems styleItems = StyleItems.openWCMObjs(this.getLoginUser(), wCMFilter);
        for (int i = 0; i < styleItems.size(); ++i) {
            this.delete(this.getLoginUser(), (StyleItem)styleItems.getAt(i));
        }
    }

    public StyleItem savePageOtherStyleItem(User user, PageStyle pageStyle, StyleItem styleItem) throws WCMException {
        int n = 0;
        int n2 = 1;
        if (pageStyle != null) {
            n = pageStyle.getId();
        }
        styleItem.setStyleObjId(n);
        styleItem.setStyleObjType(n2);
        styleItem.save(user);
        return styleItem;
    }

    public StyleItems queryPageOtherStyleItems(PageStyle pageStyle, WCMFilter wCMFilter) throws WCMException {
        User user = this.getLoginUser();
        if (pageStyle == null) {
            return StyleItems.createNewInstance(user);
        }
        WCMFilter wCMFilter2 = new WCMFilter("", "STYLEOBJTYPE=? and STYLEOBJID=?", "");
        wCMFilter2.addSearchValues(1);
        wCMFilter2.addSearchValues(pageStyle.getId());
        if (wCMFilter != null) {
            wCMFilter2.mergeWith(wCMFilter);
        }
        return StyleItems.openWCMObjs(user, wCMFilter2);
    }

    public HashMap queryPageOtherStyleItemMap(PageStyle pageStyle, WCMFilter wCMFilter) throws WCMException {
        StyleItems styleItems = this.queryPageOtherStyleItems(pageStyle, wCMFilter);
        HashMap<String, StyleItem> hashMap = new HashMap<String, StyleItem>();
        for (int i = 0; i < styleItems.size(); ++i) {
            StyleItem styleItem = (StyleItem)styleItems.getAt(i);
            if (styleItem == null) continue;
            hashMap.put(styleItem.getClassName(), styleItem);
        }
        return hashMap;
    }
}

