/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.widget;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.widget.ContentStyle;
import com.trs.components.common.publish.widget.ContentStyleMgr;
import com.trs.components.common.publish.widget.ContentStyles;
import com.trs.components.common.publish.widget.IContentStyleMgr;
import com.trs.components.common.publish.widget.IPageStyleMgr;
import com.trs.components.common.publish.widget.IResourceStyleMgr;
import com.trs.components.common.publish.widget.IStyleItemMgr;
import com.trs.components.common.publish.widget.PageStyle;
import com.trs.components.common.publish.widget.PageStyles;
import com.trs.components.common.publish.widget.ResourceStyle;
import com.trs.components.common.publish.widget.ResourceStyleMgr;
import com.trs.components.common.publish.widget.ResourceStyles;
import com.trs.components.common.publish.widget.StyleHelper;
import com.trs.components.common.publish.widget.StyleItem;
import com.trs.components.common.publish.widget.StyleItemMgr;
import com.trs.components.common.publish.widget.StyleItems;
import com.trs.components.common.publish.widget.StylePathHelper;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import org.apache.log4j.Logger;

public class PageStyleMgr
implements IPageStyleMgr {
    private static Logger s_logger = Logger.getLogger(PageStyleMgr.class);
    private IStyleItemMgr m_oStyleItemMgr = (StyleItemMgr)DreamFactory.createObjectById("IStyleItemMgr");
    private IResourceStyleMgr m_oResourceStyleMgr = (ResourceStyleMgr)DreamFactory.createObjectById("IResourceStyleMgr");
    private IContentStyleMgr m_oContentStyleMgr = (ContentStyleMgr)DreamFactory.createObjectById("IContentStyleMgr");

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    public PageStyle copy(User user, PageStyle pageStyle, PageStyle pageStyle2) throws WCMException {
        Object object;
        CMSObj cMSObj;
        pageStyle2.setSrcPageStyleId(pageStyle.getId());
        pageStyle2.setCustomStyle(pageStyle.getCustomStyle());
        this.save(user, pageStyle2);
        StyleItems styleItems = this.m_oStyleItemMgr.queryStyleItems(pageStyle, null);
        for (int i = 0; i < styleItems.size(); ++i) {
            StyleItem styleItem = (StyleItem)styleItems.getAt(i);
            if (styleItem == null) continue;
            cMSObj = (StyleItem)styleItem.cloneToNewObj();
            this.m_oStyleItemMgr.save(user, pageStyle2, (StyleItem)cMSObj);
        }
        ResourceStyles resourceStyles = this.m_oResourceStyleMgr.query(pageStyle, null);
        for (int i = 0; i < resourceStyles.size(); ++i) {
            cMSObj = (ResourceStyle)resourceStyles.getAt(i);
            if (cMSObj == null) continue;
            this.m_oResourceStyleMgr.copy(user, pageStyle2, (ResourceStyle)cMSObj);
        }
        ContentStyles contentStyles = this.m_oContentStyleMgr.query(pageStyle, null);
        for (int i = 0; i < contentStyles.size(); ++i) {
            object = (ContentStyle)contentStyles.getAt(i);
            if (object == null) continue;
            this.m_oContentStyleMgr.copy(user, pageStyle2, (ContentStyle)object);
        }
        String string = pageStyle.getStyleName();
        object = StylePathHelper.getStyleCssDir();
        if (!CMyFile.fileExists((String)object)) {
            CMyFile.makeDir((String)object, true);
        }
        String string2 = (String)object + string + ".css";
        String string3 = (String)object + pageStyle2.getStyleName() + ".css";
        try {
            CMyFile.copyFile(string2, string3);
        }
        catch (CMyException cMyException) {
            s_logger.error((Object)cMyException);
            cMyException.printStackTrace();
        }
        return pageStyle2;
    }

    public void delete(User user, PageStyle pageStyle) throws WCMException {
        if (pageStyle == null) {
            return;
        }
        this.deleteResourceStyleOfPageStyle(pageStyle, user);
        this.deleteContentStyleOfPageStyle(pageStyle, user);
        this.m_oStyleItemMgr.delete(user, pageStyle);
        pageStyle.delete(user);
        this.deletePageStyleCssFile(pageStyle);
    }

    public void deletePageStyleInfos(User user, PageStyle pageStyle) throws WCMException {
        if (pageStyle == null) {
            return;
        }
        this.deleteResourceStyleOfPageStyle(pageStyle, user);
        this.deleteContentStyleOfPageStyle(pageStyle, user);
        this.m_oStyleItemMgr.delete(user, pageStyle);
        this.deletePageStyleCssFile(pageStyle);
    }

    public PageStyles query(WCMFilter wCMFilter) throws WCMException {
        WCMFilter wCMFilter2 = new WCMFilter("", "PageStyleId!=?", "");
        wCMFilter2.addSearchValues(0);
        if (wCMFilter != null) {
            wCMFilter2.mergeWith(wCMFilter);
        }
        return PageStyles.openWCMObjs(this.getLoginUser(), wCMFilter2);
    }

    public PageStyle save(User user, PageStyle pageStyle) throws WCMException {
        String string;
        if (pageStyle == null) {
            throw new WCMException("\u8981\u4fdd\u5b58\u7684\u5bf9\u8c61\u4e3a\u7a7a!PageStyle=[" + pageStyle + "]");
        }
        String string2 = pageStyle.isAddMode() ? pageStyle.getPropertyAsString("StyleName") : pageStyle.getNewPropertyAsString("StyleName");
        String string3 = string = pageStyle.isAddMode() ? pageStyle.getPropertyAsString("StyleDesc") : pageStyle.getNewPropertyAsString("StyleDesc");
        if (this.checkStyleName(pageStyle)) {
            throw new WCMException(1008, "\u5df2\u7ecf\u5b58\u5728\u82f1\u6587\u540d\u79f0\u4e3a[" + string2 + "]\u7684\u9875\u9762\u98ce\u683c.");
        }
        if (this.checkStyleDesc(pageStyle)) {
            throw new WCMException(1008, "\u5df2\u7ecf\u5b58\u5728\u663e\u793a\u540d\u79f0\u4e3a[" + string + "]\u7684\u9875\u9762\u98ce\u683c.");
        }
        if (pageStyle.isAddMode()) {
            pageStyle.insert(user);
        } else {
            pageStyle.update(user);
        }
        return pageStyle;
    }

    public String makeBaseStyleContent(PageStyle pageStyle) throws WCMException {
        String string;
        String string2 = string = pageStyle == null ? "body_template_1.css" : pageStyle.getTemplate();
        if (string == null || string.equals("")) {
            string = "body_template_1.css";
        }
        String string3 = StyleHelper.getCssTemplateFilePath() + string;
        String string4 = "";
        try {
            string4 = CMyFile.readFile(string3, "UTF-8");
        }
        catch (CMyException cMyException) {
            cMyException.printStackTrace();
        }
        if (string4 == null) {
            throw new WCMException("\u83b7\u53d6\u6a21\u677f\u5931\u8d25\uff01" + string);
        }
        if (string4.trim().equals("")) {
            throw new WCMException("\u83b7\u53d6\u6a21\u677f\u5185\u5bb9\u4e3a\u7a7a\uff01" + string);
        }
        StyleItems styleItems = this.m_oStyleItemMgr.queryStyleItems(pageStyle, null);
        return StyleHelper.makeCSSContent("", string4, styleItems);
    }

    public String makePageOtherStyleContent(PageStyle pageStyle) throws WCMException {
        String string = "other_template_1.css";
        String string2 = StyleHelper.getCssTemplateFilePath() + string;
        String string3 = "";
        try {
            string3 = CMyFile.readFile(string2, "UTF-8");
        }
        catch (CMyException cMyException) {
            cMyException.printStackTrace();
        }
        if (string3 == null) {
            throw new WCMException("\u83b7\u53d6\u6a21\u677f\u5931\u8d25\uff01" + string);
        }
        if (string3.trim().equals("")) {
            throw new WCMException("\u83b7\u53d6\u6a21\u677f\u5185\u5bb9\u4e3a\u7a7a\uff01" + string);
        }
        StyleItems styleItems = this.m_oStyleItemMgr.queryPageOtherStyleItems(pageStyle, null);
        return StyleHelper.makeCSSContent("", string3, styleItems);
    }

    public String previewStyle(PageStyle pageStyle, StyleItems styleItems) throws WCMException {
        String string;
        String string2 = string = pageStyle == null ? "body_template_1.css" : pageStyle.getTemplate();
        if (string == null || string.equals("")) {
            string = "body_template_1.css";
        }
        String string3 = StyleHelper.getCssTemplateFilePath() + string;
        String string4 = "";
        try {
            string4 = CMyFile.readFile(string3, "UTF-8");
        }
        catch (CMyException cMyException) {
            cMyException.printStackTrace();
        }
        if (string4 == null) {
            throw new WCMException("\u83b7\u53d6\u6a21\u677f\u5931\u8d25\uff01" + string);
        }
        if (string4.trim().equals("")) {
            throw new WCMException("\u83b7\u53d6\u6a21\u677f\u5185\u5bb9\u4e3a\u7a7a\uff01" + string);
        }
        return StyleHelper.makeCSSContent("", string4, styleItems);
    }

    private void deleteResourceStyleOfPageStyle(PageStyle pageStyle, User user) throws WCMException {
        if (pageStyle == null) {
            return;
        }
        ResourceStyles resourceStyles = this.m_oResourceStyleMgr.getResourceStyles(pageStyle);
        for (int i = 0; i < resourceStyles.size(); ++i) {
            ResourceStyle resourceStyle = (ResourceStyle)resourceStyles.getAt(i);
            if (resourceStyle == null) continue;
            this.m_oResourceStyleMgr.delete(user, resourceStyle);
        }
    }

    private void deleteContentStyleOfPageStyle(PageStyle pageStyle, User user) throws WCMException {
        ContentStyles contentStyles = this.m_oContentStyleMgr.queryContenetStyles(pageStyle);
        for (int i = 0; i < contentStyles.size(); ++i) {
            ContentStyle contentStyle = (ContentStyle)contentStyles.getAt(i);
            if (contentStyle == null) continue;
            this.m_oContentStyleMgr.delete(user, contentStyle);
        }
    }

    private void deletePageStyleCssFile(PageStyle pageStyle) throws WCMException {
        String string = StylePathHelper.getStyleCssDir();
        String string2 = pageStyle.getStyleName();
        String string3 = string + string2 + ".css";
        if (CMyFile.fileExists(string3)) {
            CMyFile.deleteFile(string3);
        }
    }

    public boolean checkStyleName(PageStyle pageStyle) throws WCMException {
        PageStyles pageStyles;
        boolean bl = pageStyle.isAddMode();
        String string = null;
        string = bl ? pageStyle.getPropertyAsString("StyleName") : pageStyle.getNewPropertyAsString("StyleName");
        if (CMyString.isEmpty(string)) {
            return false;
        }
        String string2 = "StyleName=?";
        if (!bl) {
            string2 = string2 + " AND PageStyleId<>?";
        }
        WCMFilter wCMFilter = new WCMFilter("XWCMPAGESTYLE", string2, "", "PAGESTYLEID");
        int n = pageStyle.getId();
        wCMFilter.addSearchValues(string);
        if (!bl) {
            wCMFilter.addSearchValues(n);
        }
        return (pageStyles = PageStyles.openWCMObjs(ContextHelper.getLoginUser(), wCMFilter)).size() > 0;
    }

    public boolean checkStyleDesc(PageStyle pageStyle) throws WCMException {
        PageStyles pageStyles;
        boolean bl = pageStyle.isAddMode();
        String string = null;
        string = bl ? pageStyle.getPropertyAsString("StyleDesc") : pageStyle.getNewPropertyAsString("StyleName");
        if (CMyString.isEmpty(string)) {
            return false;
        }
        String string2 = "StyleDesc=?";
        if (!bl) {
            string2 = string2 + " AND PageStyleId<>?";
        }
        WCMFilter wCMFilter = new WCMFilter("XWCMPAGESTYLE", string2, "", "PAGESTYLEID");
        int n = pageStyle.getId();
        wCMFilter.addSearchValues(string);
        if (!bl) {
            wCMFilter.addSearchValues(n);
        }
        return (pageStyles = PageStyles.openWCMObjs(ContextHelper.getLoginUser(), wCMFilter)).size() > 0;
    }
}

